/*
 * Decompiled with CFR 0.152.
 */
package com.example.risingworld.discordadmin;

import com.example.risingworld.discordadmin.ConfigManager;
import com.example.risingworld.discordadmin.FileUtils;
import com.example.risingworld.discordadmin.PluginLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.function.BiConsumer;
import java.util.logging.Level;

public class ConfigMigrationManager {
    private final String pluginPath;
    private final PluginLogger logger;
    private ConfigManager configManager;
    private static final String CURRENT_VERSION = "3.7.2";
    private final Map<String, Map<String, BiConsumer<Properties, String>>> migrationStrategies = new HashMap<String, Map<String, BiConsumer<Properties, String>>>();
    private static final String VERSION_KEY = "config.version";

    public ConfigMigrationManager(String pluginPath, PluginLogger logger) {
        this.pluginPath = pluginPath;
        this.logger = logger;
        this.initializeMigrationStrategies();
    }

    public void setConfigManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    private void initializeMigrationStrategies() {
        HashMap<String, BiConsumer<Properties, String>> mainConfigMigrations = new HashMap<String, BiConsumer<Properties, String>>();
        mainConfigMigrations.put("1.0", (config, type) -> {
            this.migrateProperty((Properties)config, "discord.bot.token", "discord.token");
            this.migrateProperty((Properties)config, "discord.channel", "discord.admin.channel");
            this.setIfMissing((Properties)config, "discord.message.delete.delay", "300");
            this.setIfMissing((Properties)config, "chat.relay.game_to_discord", "true");
            this.setIfMissing((Properties)config, "chat.relay.discord_to_game", "true");
            this.setIfMissing((Properties)config, "restart.countdown.minutes", "30");
            this.setIfMissing((Properties)config, "status.updates.enabled", "true");
            this.setIfMissing((Properties)config, "status.updates.interval", "10");
            this.addVersion3Properties((Properties)config);
            this.addVersion31Properties((Properties)config);
            this.addVersion32Properties((Properties)config);
            this.addVersion33Properties((Properties)config);
            this.addVersion34Properties((Properties)config);
            this.addVersion35Properties((Properties)config);
            this.addVersion36Properties((Properties)config);
            this.addVersion37Properties((Properties)config);
            this.logger.info("Migrated " + type + " from v1.0 to v3.7");
        });
        mainConfigMigrations.put("2.0", (config, type) -> {
            this.addVersion3Properties((Properties)config);
            this.addVersion31Properties((Properties)config);
            this.addVersion32Properties((Properties)config);
            this.addVersion33Properties((Properties)config);
            this.addVersion34Properties((Properties)config);
            this.addVersion35Properties((Properties)config);
            this.addVersion36Properties((Properties)config);
            this.addVersion37Properties((Properties)config);
            this.logger.info("Migrated " + type + " from v2.0 to v3.7");
        });
        mainConfigMigrations.put("3.0", (config, type) -> {
            this.addVersion31Properties((Properties)config);
            this.addVersion32Properties((Properties)config);
            this.addVersion33Properties((Properties)config);
            this.addVersion34Properties((Properties)config);
            this.addVersion35Properties((Properties)config);
            this.addVersion36Properties((Properties)config);
            this.addVersion37Properties((Properties)config);
            this.logger.info("Migrated " + type + " from v3.0 to v3.7");
        });
        mainConfigMigrations.put("3.1", (config, type) -> {
            this.addVersion32Properties((Properties)config);
            this.addVersion33Properties((Properties)config);
            this.addVersion34Properties((Properties)config);
            this.addVersion35Properties((Properties)config);
            this.addVersion36Properties((Properties)config);
            this.addVersion37Properties((Properties)config);
            this.logger.info("Migrated " + type + " from v3.1 to v3.7");
        });
        mainConfigMigrations.put("3.2", (config, type) -> {
            this.addVersion33Properties((Properties)config);
            this.addVersion34Properties((Properties)config);
            this.addVersion35Properties((Properties)config);
            this.addVersion36Properties((Properties)config);
            this.addVersion37Properties((Properties)config);
            this.logger.info("Migrated " + type + " from v3.2 to v3.7");
        });
        mainConfigMigrations.put("3.3", (config, type) -> {
            this.addVersion34Properties((Properties)config);
            this.addVersion35Properties((Properties)config);
            this.addVersion36Properties((Properties)config);
            this.addVersion37Properties((Properties)config);
            this.logger.info("Migrated " + type + " from v3.3 to v3.7");
        });
        mainConfigMigrations.put("3.4", (config, type) -> {
            this.addVersion35Properties((Properties)config);
            this.addVersion36Properties((Properties)config);
            this.addVersion37Properties((Properties)config);
            this.logger.info("Migrated " + type + " from v3.4 to v3.7");
        });
        mainConfigMigrations.put("3.5", (config, type) -> {
            this.addVersion36Properties((Properties)config);
            this.addVersion37Properties((Properties)config);
            this.logger.info("Migrated " + type + " from v3.5 to v3.7");
        });
        mainConfigMigrations.put("3.6", (config, type) -> {
            this.addVersion37Properties((Properties)config);
            this.logger.info("Migrated " + type + " from v3.6 to v3.7");
        });
        this.migrationStrategies.put("main", mainConfigMigrations);
        HashMap<String, BiConsumer<Properties, String>> adminConfigMigrations = new HashMap<String, BiConsumer<Properties, String>>();
        adminConfigMigrations.put("1.0", (config, type) -> this.logger.info("Migrated " + type + " from v1.0 to v3.7"));
        adminConfigMigrations.put("2.0", (config, type) -> this.logger.info("Migrated " + type + " from v2.0 to v3.7"));
        adminConfigMigrations.put("3.0", (config, type) -> this.logger.info("Migrated " + type + " from v3.0 to v3.7"));
        adminConfigMigrations.put("3.1", (config, type) -> this.logger.info("Migrated " + type + " from v3.1 to v3.7"));
        adminConfigMigrations.put("3.2", (config, type) -> this.logger.info("Migrated " + type + " from v3.2 to v3.7"));
        adminConfigMigrations.put("3.3", (config, type) -> this.logger.info("Migrated " + type + " from v3.3 to v3.7"));
        adminConfigMigrations.put("3.4", (config, type) -> this.logger.info("Migrated " + type + " from v3.4 to v3.7"));
        adminConfigMigrations.put("3.5", (config, type) -> this.logger.info("Migrated " + type + " from v3.5 to v3.7"));
        adminConfigMigrations.put("3.6", (config, type) -> this.logger.info("Migrated " + type + " from v3.6 to v3.7"));
        this.migrationStrategies.put("admins", adminConfigMigrations);
        HashMap<String, BiConsumer<Properties, String>> mappingsConfigMigrations = new HashMap<String, BiConsumer<Properties, String>>();
        mappingsConfigMigrations.put("1.0", (config, type) -> this.logger.info("Migrated " + type + " from v1.0 to v3.7"));
        mappingsConfigMigrations.put("2.0", (config, type) -> this.logger.info("Migrated " + type + " from v2.0 to v3.7"));
        mappingsConfigMigrations.put("3.0", (config, type) -> this.logger.info("Migrated " + type + " from v3.0 to v3.7"));
        mappingsConfigMigrations.put("3.1", (config, type) -> this.logger.info("Migrated " + type + " from v3.1 to v3.7"));
        mappingsConfigMigrations.put("3.2", (config, type) -> this.logger.info("Migrated " + type + " from v3.2 to v3.7"));
        mappingsConfigMigrations.put("3.3", (config, type) -> this.logger.info("Migrated " + type + " from v3.3 to v3.7"));
        mappingsConfigMigrations.put("3.4", (config, type) -> this.logger.info("Migrated " + type + " from v3.4 to v3.7"));
        mappingsConfigMigrations.put("3.5", (config, type) -> this.logger.info("Migrated " + type + " from v3.5 to v3.7"));
        mappingsConfigMigrations.put("3.6", (config, type) -> this.logger.info("Migrated " + type + " from v3.6 to v3.7"));
        this.migrationStrategies.put("mappings", mappingsConfigMigrations);
        HashMap<String, BiConsumer<Properties, String>> invitesMigration = new HashMap<String, BiConsumer<Properties, String>>();
        invitesMigration.put("1.0", (config, type) -> this.logger.info("Migrated " + type + " from v1.0 to v3.7"));
        invitesMigration.put("2.0", (config, type) -> this.logger.info("Migrated " + type + " from v2.0 to v3.7"));
        invitesMigration.put("3.0", (config, type) -> this.logger.info("Migrated " + type + " from v3.0 to v3.7"));
        invitesMigration.put("3.1", (config, type) -> this.logger.info("Migrated " + type + " from v3.1 to v3.7"));
        invitesMigration.put("3.2", (config, type) -> this.logger.info("Migrated " + type + " from v3.2 to v3.7"));
        invitesMigration.put("3.3", (config, type) -> this.logger.info("Migrated " + type + " from v3.3 to v3.7"));
        invitesMigration.put("3.4", (config, type) -> this.logger.info("Migrated " + type + " from v3.4 to v3.7"));
        invitesMigration.put("3.5", (config, type) -> this.logger.info("Migrated " + type + " from v3.5 to v3.7"));
        invitesMigration.put("3.6", (config, type) -> this.logger.info("Migrated " + type + " from v3.6 to v3.7"));
        this.migrationStrategies.put("invites", invitesMigration);
        HashMap<String, BiConsumer<Properties, String>> connectedPlayersMigration = new HashMap<String, BiConsumer<Properties, String>>();
        connectedPlayersMigration.put("1.0", (config, type) -> this.logger.info("Migrated " + type + " from v1.0 to v3.7"));
        connectedPlayersMigration.put("2.0", (config, type) -> this.logger.info("Migrated " + type + " from v2.0 to v3.7"));
        connectedPlayersMigration.put("3.0", (config, type) -> this.logger.info("Migrated " + type + " from v3.0 to v3.7"));
        connectedPlayersMigration.put("3.1", (config, type) -> this.logger.info("Migrated " + type + " from v3.1 to v3.7"));
        connectedPlayersMigration.put("3.2", (config, type) -> this.logger.info("Migrated " + type + " from v3.2 to v3.7"));
        connectedPlayersMigration.put("3.3", (config, type) -> this.logger.info("Migrated " + type + " from v3.3 to v3.7"));
        connectedPlayersMigration.put("3.4", (config, type) -> this.logger.info("Migrated " + type + " from v3.4 to v3.7"));
        connectedPlayersMigration.put("3.5", (config, type) -> this.logger.info("Migrated " + type + " from v3.5 to v3.7"));
        connectedPlayersMigration.put("3.6", (config, type) -> this.logger.info("Migrated " + type + " from v3.6 to v3.7"));
        this.migrationStrategies.put("connected_players", connectedPlayersMigration);
    }

    private void addVersion37Properties(Properties config) {
        this.setIfMissing(config, "invite.enabled", "true");
        this.setIfMissing(config, "invite.use_dynamic", "false");
        this.setIfMissing(config, "invite.auto_send_on_join", "true");
        this.setIfMissing(config, "invite.dynamic.max_uses", "1");
        this.setIfMissing(config, "invite.dynamic.expiration_hours", "24");
        this.setIfMissing(config, "invite.dynamic.role_id", "");
        this.logger.fine("Added new v3.7 configuration properties");
    }

    private void addVersion3Properties(Properties config) {
        this.setIfMissing(config, "error.retry.max", "3");
        this.setIfMissing(config, "error.retry.delay", "1000");
        this.setIfMissing(config, "logs.max_files", "30");
        this.setIfMissing(config, "command.permissions.enabled", "true");
        this.logger.fine("Added new v3.0 configuration properties");
    }

    private void addVersion31Properties(Properties config) {
        this.setIfMissing(config, "chat.format.discord_to_game", "[Discord] %author%: %message%");
        this.setIfMissing(config, "chat.format.game_to_discord", "[Game] %player%: %message%");
        this.setIfMissing(config, "status.embed.online.color", "#00FF00");
        this.setIfMissing(config, "status.embed.offline.color", "#FF0000");
        this.setIfMissing(config, "status.embed.restart.color", "#FFA500");
        this.setIfMissing(config, "status.embed.max_players", "15");
        this.setIfMissing(config, "restart.broadcast.prefix", "\u26a0\ufe0f **SERVER RESTART**");
        this.setIfMissing(config, "restart.warning.times", "20,15,10,5,3,1");
        this.setIfMissing(config, "message.join.format", "\ud83d\udfe2 **%player% joined the server**");
        this.setIfMissing(config, "message.leave.format", "\ud83d\udd34 **%player% left the server**");
        this.setIfMissing(config, "player.connection.log.enabled", "true");
        this.setIfMissing(config, "player.connection.log.directory", "player_connections");
        this.setIfMissing(config, "invite.auto_assign_role", "true");
        this.setIfMissing(config, "invite.tracking_window", "15");
        this.setIfMissing(config, "logs.directory", "logs");
        this.logger.fine("Added new v3.1 configuration properties");
    }

    private void addVersion32Properties(Properties config) {
        this.setIfMissing(config, "discord.message.delete.mode", "always");
    }

    private void addVersion33Properties(Properties config) {
        this.setIfMissing(config, "restart.timezone", TimeZone.getDefault().getID());
        this.setIfMissing(config, "restart.daily.enabled", "true");
    }

    private void addVersion34Properties(Properties config) {
        this.setIfMissing(config, "chat.filter.enabled", "false");
        this.setIfMissing(config, "chat.filter.words", "badword1,badword2");
        this.setIfMissing(config, "player.history.enabled", "true");
        this.setIfMissing(config, "player.history.max_notes", "50");
        this.setIfMissing(config, "status.embed.show_admin", "false");
        this.setIfMissing(config, "status.embed.show_player_time", "false");
        this.setIfMissing(config, "discord.error.notification.enabled", "true");
        this.setIfMissing(config, "discord.bot.activity", "Watching Rising World");
        this.setIfMissing(config, "discord.startup.notification", "true");
        this.setIfMissing(config, "player.welcome.message.enabled", "true");
        this.setIfMissing(config, "player.welcome.message", "Welcome to the server, %player%!");
        this.setIfMissing(config, "restart.immediate_action", "lock");
        this.setIfMissing(config, "restart.pre_shutdown.backup", "true");
        this.logger.fine("Added new v3.4 configuration properties");
    }

    private void addVersion35Properties(Properties config) {
        this.setIfMissing(config, "logs.level", "INFO");
        this.setIfMissing(config, "logs.console.debug", "false");
        this.logger.fine("Added new v3.5 configuration properties");
    }

    private void addVersion36Properties(Properties config) {
        this.setIfMissing(config, "status.embed.recreate_on_startup", "false");
        this.logger.fine("Added new v3.6 configuration properties");
    }

    public Properties loadAndMigrateConfig(String filename, String configType, boolean createDefaultIfMissing, BiConsumer<Properties, File> defaultCreator) {
        Properties config = new Properties();
        File configFile = new File(this.pluginPath + File.separator + filename);
        if (configFile.exists()) {
            try (FileInputStream fis = new FileInputStream(configFile);){
                config.load(fis);
                String version = config.getProperty(VERSION_KEY, "1.0");
                if (!version.equals(CURRENT_VERSION)) {
                    this.migrateConfiguration(config, version, configFile, configType);
                    this.logger.info("Configuration upgraded from v" + version + " to v3.7.2: " + filename);
                } else {
                    this.logger.info("Configuration loaded successfully: " + filename);
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error loading configuration: " + filename, e);
            }
        } else if (createDefaultIfMissing && defaultCreator != null) {
            if (FileUtils.ensureParentDirectoryExists(configFile)) {
                defaultCreator.accept(config, configFile);
                config.setProperty(VERSION_KEY, CURRENT_VERSION);
            } else {
                this.logger.severe("Failed to create parent directories for: " + configFile.getAbsolutePath());
            }
        }
        return config;
    }

    private void migrateConfiguration(Properties config, String oldVersion, File configFile, String configType) {
        this.logger.info("Migrating " + configType + " configuration from version " + oldVersion + " to 3.7.2");
        File backupFile = new File(configFile.getParentFile(), configFile.getName().replace(".properties", "") + "_backup_v" + oldVersion + ".properties");
        try {
            if (FileUtils.ensureParentDirectoryExists(backupFile)) {
                Files.copy(configFile.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.logger.info("Created backup of old configuration at: " + backupFile.getAbsolutePath());
            } else {
                this.logger.warning("Could not create parent directory for backup file: " + backupFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Could not create backup of configuration file", e);
        }
        config.setProperty(VERSION_KEY, CURRENT_VERSION);
        Map<String, BiConsumer<Properties, String>> strategies = this.migrationStrategies.get(configType);
        if (strategies == null) {
            this.logger.warning("No migration strategies found for config type: " + configType);
            return;
        }
        BiConsumer<Properties, String> migrationFunction = strategies.get(oldVersion);
        if (migrationFunction == null) {
            this.logger.warning("No migration function found for version " + oldVersion + " of " + configType);
            List<String> versions = Arrays.asList("1.0", "2.0", "3.0", "3.1", "3.2", "3.3", "3.4", "3.5", "3.6");
            for (String version : versions) {
                if (this.compareVersions(version, oldVersion) >= 0 || !strategies.containsKey(version)) continue;
                migrationFunction = strategies.get(version);
                this.logger.info("Using closest available migration: v" + version + " for v" + oldVersion);
                break;
            }
            if (migrationFunction == null) {
                this.logger.warning("Could not find suitable migration function. Making minimal changes.");
                return;
            }
        }
        migrationFunction.accept(config, configType);
        this.saveConfigDirect(config, configFile, configType + " Configuration (Upgraded from v" + oldVersion + " to v3.7.2)");
        if ("main".equals(configType) && this.configManager != null) {
            try {
                if (this.configManager.checkAndFixConfigFormatting(config)) {
                    this.logger.info("Fixed formatting in config file after migration");
                }
            }
            catch (Exception e) {
                this.logger.warning("Error checking config formatting after migration: " + e.getMessage());
            }
        }
    }

    private int compareVersions(String v1, String v2) {
        String[] parts1 = v1.split("\\.");
        String[] parts2 = v2.split("\\.");
        int length = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < length; ++i) {
            int p2;
            int p1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
            int n = p2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
            if (p1 == p2) continue;
            return p1 - p2;
        }
        return 0;
    }

    private void saveConfigDirect(Properties config, File configFile, String comment) {
        config.setProperty(VERSION_KEY, CURRENT_VERSION);
        try (FileOutputStream fos = new FileOutputStream(configFile);){
            config.store(fos, comment);
            this.logger.info("Configuration saved directly: " + configFile.getName());
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Error directly saving configuration: " + configFile.getName(), e);
        }
    }

    public void saveConfig(Properties config, String filename, String comment) {
        config.setProperty(VERSION_KEY, CURRENT_VERSION);
        if (this.configManager != null) {
            try {
                this.configManager.saveConfig(config, filename, comment);
            }
            catch (Exception e) {
                this.logger.warning("Error using ConfigManager to save, falling back to direct save: " + e.getMessage());
                File configFile = new File(this.pluginPath + File.separator + filename);
                this.saveConfigDirect(config, configFile, comment);
            }
        } else {
            File configFile = new File(this.pluginPath + File.separator + filename);
            if (FileUtils.ensureParentDirectoryExists(configFile)) {
                this.saveConfigDirect(config, configFile, comment);
            } else {
                this.logger.severe("Failed to create parent directory for: " + configFile.getAbsolutePath());
            }
        }
    }

    private void migrateProperty(Properties config, String oldKey, String newKey) {
        if (config.containsKey(oldKey)) {
            config.setProperty(newKey, config.getProperty(oldKey));
            config.remove(oldKey);
            this.logger.fine("Migrated property from " + oldKey + " to " + newKey);
        }
    }

    private void setIfMissing(Properties config, String key, String value) {
        if (!config.containsKey(key)) {
            config.setProperty(key, value);
        }
    }
}

