/*
 * Decompiled with CFR 0.152.
 */
package com.example.risingworld.discordadmin;

import com.example.risingworld.discordadmin.ChatFilter;
import com.example.risingworld.discordadmin.ConfigManager;
import com.example.risingworld.discordadmin.DiscordService;
import com.example.risingworld.discordadmin.InviteManager;
import com.example.risingworld.discordadmin.PlayerHistoryManager;
import com.example.risingworld.discordadmin.PlayerManager;
import com.example.risingworld.discordadmin.PluginLogger;
import com.example.risingworld.discordadmin.RestartManager;
import com.example.risingworld.discordadmin.StatusManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.DefaultMemberPermissions;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.dv8tion.jda.api.interactions.commands.build.OptionData;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import net.dv8tion.jda.api.requests.RestAction;
import net.risingworld.api.Server;
import net.risingworld.api.objects.Player;

public class CommandManager
extends ListenerAdapter {
    private final PluginLogger logger;
    private final DiscordService discordService;
    private final PlayerManager playerManager;
    private final RestartManager restartManager;
    private final StatusManager statusManager;
    private final ConfigManager configManager;
    private final InviteManager inviteManager;
    private ScheduledExecutorService commandScheduler = Executors.newSingleThreadScheduledExecutor();
    private int commandRegistrationRetries = 0;
    private static final int MAX_REGISTRATION_RETRIES = 5;
    private final Properties authorizedAdmins;
    private Properties commandPermissions;
    private static final String PERMISSIONS_FILENAME = "command_permissions.properties";
    private final String pluginPath;
    private PlayerHistoryManager playerHistoryManager;
    private boolean relayDiscordToGame = true;
    private ChatFilter chatFilter;
    private String discordToGameFormat;
    private Properties config;
    private static final Map<String, DefaultMemberPermissions> DEFAULT_COMMAND_PERMISSIONS = new HashMap<String, DefaultMemberPermissions>(){
        {
            this.put("players", DefaultMemberPermissions.ENABLED);
            this.put("link", DefaultMemberPermissions.ENABLED);
            this.put("kick", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.KICK_MEMBERS, Permission.ADMINISTRATOR}));
            this.put("ban", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.BAN_MEMBERS, Permission.ADMINISTRATOR}));
            this.put("unban", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.BAN_MEMBERS, Permission.ADMINISTRATOR}));
            this.put("teleport", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.ADMINISTRATOR}));
            this.put("broadcast", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.MANAGE_SERVER, Permission.ADMINISTRATOR}));
            this.put("promote", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.MANAGE_ROLES, Permission.ADMINISTRATOR}));
            this.put("demote", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.MANAGE_ROLES, Permission.ADMINISTRATOR}));
            this.put("restart", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.MANAGE_SERVER, Permission.ADMINISTRATOR}));
            this.put("refresh_status", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.MANAGE_SERVER, Permission.ADMINISTRATOR}));
            this.put("reload_config", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.ADMINISTRATOR}));
            this.put("reset_discord_connection", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.ADMINISTRATOR}));
            this.put("send_discord_invite", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.ADMINISTRATOR}));
            this.put("create_invite", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.CREATE_INSTANT_INVITE, Permission.ADMINISTRATOR}));
            this.put("link_invite", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.MANAGE_CHANNEL, Permission.ADMINISTRATOR}));
            this.put("delete_invite", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.MANAGE_CHANNEL, Permission.ADMINISTRATOR}));
            this.put("list_invites", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.MANAGE_CHANNEL, Permission.ADMINISTRATOR}));
            this.put("set_default_invite", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.ADMINISTRATOR}));
        }
    };

    public void setChatFilter(ChatFilter chatFilter) {
        this.chatFilter = chatFilter;
    }

    public void setDiscordToGameFormat(String format) {
        this.discordToGameFormat = format;
    }

    public CommandManager(PluginLogger logger, DiscordService discordService, PlayerManager playerManager, RestartManager restartManager, StatusManager statusManager, ConfigManager configManager, Properties authorizedAdmins, String pluginPath, InviteManager inviteManager, PlayerHistoryManager playerHistoryManager) {
        this.logger = logger;
        this.discordService = discordService;
        this.playerManager = playerManager;
        this.restartManager = restartManager;
        this.statusManager = statusManager;
        this.configManager = configManager;
        this.authorizedAdmins = authorizedAdmins;
        this.pluginPath = pluginPath;
        this.inviteManager = inviteManager;
        this.playerHistoryManager = playerHistoryManager;
        this.config = configManager.loadMainConfig();
        this.loadCommandPermissions();
        new Thread(() -> {
            try {
                Thread.sleep(2000L);
                this.registerCommands();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warning("Initial command registration was interrupted");
            }
        }, "CommandRegistration-Initial").start();
    }

    private void loadCommandPermissions() {
        this.commandPermissions = new Properties();
        File permissionsFile = new File(this.pluginPath, PERMISSIONS_FILENAME);
        if (permissionsFile.exists()) {
            try (FileInputStream fis = new FileInputStream(permissionsFile);){
                this.commandPermissions.load(fis);
                this.logger.info("Loaded command permissions configuration");
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Failed to load command permissions", e);
            }
        } else {
            this.createDefaultCommandPermissions(permissionsFile);
        }
    }

    private void createDefaultCommandPermissions(File file) {
        try {
            file.getParentFile().mkdirs();
            this.commandPermissions = new Properties();
            this.commandPermissions.setProperty("kick.enabled", "true");
            this.commandPermissions.setProperty("kick.roles", "ADMINISTRATOR,KICK_MEMBERS");
            this.commandPermissions.setProperty("ban.enabled", "true");
            this.commandPermissions.setProperty("ban.roles", "ADMINISTRATOR,BAN_MEMBERS");
            this.commandPermissions.setProperty("players.enabled", "true");
            this.commandPermissions.setProperty("players.roles", "");
            try (FileOutputStream fos = new FileOutputStream(file);){
                this.commandPermissions.store(fos, "Discord Command Permissions Configuration");
                this.logger.info("Created default command permissions configuration");
            }
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Failed to create command permissions file", e);
        }
    }

    public void saveCommandPermissions() {
        File permissionsFile = new File(this.pluginPath, PERMISSIONS_FILENAME);
        try (FileOutputStream fos = new FileOutputStream(permissionsFile);){
            this.commandPermissions.store(fos, "Discord Command Permissions Configuration");
            this.logger.info("Saved command permissions configuration");
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Failed to save command permissions", e);
        }
    }

    private void registerCommands() {
        try {
            JDA jda = this.discordService.getJDA();
            if (jda == null) {
                this.logger.warning("Cannot register commands: JDA is null");
                this.retryCommandRegistration();
                return;
            }
            if (jda.getStatus() != JDA.Status.CONNECTED) {
                this.logger.warning("JDA not fully connected yet, scheduling command registration for later");
                this.retryCommandRegistration();
                return;
            }
            this.commandRegistrationRetries = 0;
            List<Command.Choice> timeChoices = this.createTimeChoices();
            Properties config = this.configManager.loadMainConfig();
            boolean invitesEnabled = this.configManager.getConfigBoolean(config, "invite.enabled", true);
            ArrayList<SlashCommandData> commandsToRegister = new ArrayList<SlashCommandData>();
            commandsToRegister.add(this.createCommand("players", "List all online players", DefaultMemberPermissions.ENABLED));
            commandsToRegister.add(this.createCommand("refresh_status", "Refresh the server status message", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.ADMINISTRATOR})));
            commandsToRegister.add(this.createCommand("kick", "Kick a player from the server", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.KICK_MEMBERS, Permission.ADMINISTRATOR})).addOption(OptionType.STRING, "player", "Player name", true).addOption(OptionType.STRING, "reason", "Reason for kick", false));
            commandsToRegister.add(this.createCommand("ban", "Ban a player from the server", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.BAN_MEMBERS, Permission.ADMINISTRATOR})).addOption(OptionType.STRING, "player", "Player name", true).addOption(OptionType.STRING, "reason", "Reason for ban", false).addOptions(new OptionData[]{new OptionData(OptionType.INTEGER, "time", "Ban duration in minutes (-1 for permanent)").addChoices(timeChoices).setRequired(false)}));
            commandsToRegister.add(this.createCommand("unban", "Unban a player from the server", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.BAN_MEMBERS, Permission.ADMINISTRATOR})).addOption(OptionType.STRING, "player", "Player name", true));
            commandsToRegister.add(this.createCommand("teleport", "Teleport a player", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.ADMINISTRATOR})).addOption(OptionType.STRING, "player", "Player name", true).addOption(OptionType.NUMBER, "x", "X coordinate", false).addOption(OptionType.NUMBER, "y", "Y coordinate", false).addOption(OptionType.NUMBER, "z", "Z coordinate", false).addOption(OptionType.STRING, "target", "Target player", false));
            commandsToRegister.add(this.createCommand("broadcast", "Broadcast a message to all players", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.MANAGE_SERVER, Permission.ADMINISTRATOR})).addOption(OptionType.STRING, "message", "Message to broadcast", true));
            commandsToRegister.add(this.createCommand("restart", "Schedule server restart", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.MANAGE_SERVER, Permission.ADMINISTRATOR})));
            commandsToRegister.add(this.createCommand("reload_config", "Reload plugin configuration files", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.ADMINISTRATOR})));
            commandsToRegister.add(this.createCommand("toggle_discord_invites", "Enable or disable Discord invites completely", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.ADMINISTRATOR})).addOption(OptionType.BOOLEAN, "enabled", "Whether Discord invites should be enabled", true));
            commandsToRegister.add(this.createCommand("promote", "Promote a player to admin", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.ADMINISTRATOR})).addOption(OptionType.STRING, "player", "Player name", true));
            commandsToRegister.add(this.createCommand("demote", "Demote a player from admin", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.ADMINISTRATOR})).addOption(OptionType.STRING, "player", "Player name", true));
            commandsToRegister.add(this.createCommand("restart_enable", "Enable or disable automatic server restarts", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.ADMINISTRATOR})).addOption(OptionType.BOOLEAN, "enabled", "Whether restarts should be enabled", true));
            commandsToRegister.add(this.createCommand("restart_time", "Set the daily restart time", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.ADMINISTRATOR})).addOption(OptionType.STRING, "time", "Time in HH:MM format (24-hour)", true));
            commandsToRegister.add(this.createCommand("restart_timezone", "Set the timezone for restarts", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.ADMINISTRATOR})).addOption(OptionType.STRING, "timezone", "Timezone ID", true));
            commandsToRegister.add(this.createCommand("list_timezones", "List available timezones", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.ADMINISTRATOR})).addOption(OptionType.BOOLEAN, "common_only", "Show only common timezones", false));
            commandsToRegister.add(this.createCommand("warn", "Add a warning to a player", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.KICK_MEMBERS, Permission.ADMINISTRATOR})).addOption(OptionType.STRING, "player", "Player name", true).addOption(OptionType.STRING, "reason", "Warning reason", true));
            commandsToRegister.add(this.createCommand("note", "Add a note to a player's history", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.KICK_MEMBERS, Permission.ADMINISTRATOR})).addOption(OptionType.STRING, "player", "Player name", true).addOption(OptionType.STRING, "note", "Note text", true));
            commandsToRegister.add(this.createCommand("history", "View a player's history", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.KICK_MEMBERS, Permission.ADMINISTRATOR})).addOption(OptionType.STRING, "player", "Player name", true));
            commandsToRegister.add(this.createCommand("delete_note", "Delete a note from a player's history", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.ADMINISTRATOR})).addOption(OptionType.STRING, "player", "Player name", true).addOption(OptionType.STRING, "note_id", "Note ID to delete", true));
            if (invitesEnabled) {
                this.logger.debug("Registering Discord invite commands (enabled in config)");
                commandsToRegister.add(this.createCommand("link", "Link your Discord account to your game account", DefaultMemberPermissions.ENABLED).addOption(OptionType.STRING, "username", "Your in-game username", true));
                commandsToRegister.add(this.createCommand("reset_discord_connection", "Reset Discord connection status for a player", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.ADMINISTRATOR})).addOption(OptionType.STRING, "player", "Player name", true));
                commandsToRegister.add(this.createCommand("send_discord_invite", "Send Discord invite to a specific player", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.ADMINISTRATOR})).addOption(OptionType.STRING, "player", "Player name", true).addOption(OptionType.STRING, "invite_code", "Discord invite code (without discord.gg/)", false).addOption(OptionType.BOOLEAN, "dynamic", "Create a dynamic invite", false).addOption(OptionType.STRING, "role", "Role ID to assign for dynamic invite", false).addOption(OptionType.INTEGER, "max_uses", "Maximum uses for dynamic invite", false).addOption(OptionType.INTEGER, "expiration_hours", "Hours until expiration for dynamic invite", false));
                commandsToRegister.add(this.createCommand("create_invite", "Create an invite link that assigns a role", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.CREATE_INSTANT_INVITE, Permission.ADMINISTRATOR})).addOption(OptionType.STRING, "channel", "Channel ID to create invite for", true).addOption(OptionType.STRING, "role", "Role ID to assign", true).addOption(OptionType.INTEGER, "max_uses", "Maximum number of uses (0 for unlimited)", false).addOption(OptionType.INTEGER, "expiration_hours", "Hours until expiration (0 for never)", false));
                commandsToRegister.add(this.createCommand("create_dynamic_invite", "Create a dynamic invite with expiry", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.CREATE_INSTANT_INVITE, Permission.ADMINISTRATOR})).addOption(OptionType.STRING, "channel", "Channel ID to create invite for", true).addOption(OptionType.STRING, "role", "Role ID to assign", true).addOption(OptionType.INTEGER, "max_uses", "Maximum number of uses (0 for unlimited)", false).addOption(OptionType.INTEGER, "expiration_hours", "Hours until expiration (0 for never)", false));
                commandsToRegister.add(this.createCommand("link_invite", "Link an existing invite with a role", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.MANAGE_CHANNEL, Permission.ADMINISTRATOR})).addOption(OptionType.STRING, "channel", "Channel ID where the invite exists", true).addOption(OptionType.STRING, "code", "Invite code to link", true).addOption(OptionType.STRING, "role", "Role ID to assign", true));
                commandsToRegister.add(this.createCommand("delete_invite", "Delete a role invite", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.MANAGE_CHANNEL, Permission.ADMINISTRATOR})).addOption(OptionType.STRING, "code", "Invite code to delete", true));
                commandsToRegister.add(this.createCommand("list_invites", "List all role invites", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.MANAGE_CHANNEL, Permission.ADMINISTRATOR})));
                commandsToRegister.add(this.createCommand("set_default_invite", "Set the default Discord invite for automatic player invites", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.ADMINISTRATOR})).addOption(OptionType.STRING, "invite_code", "Discord invite code (without discord.gg/)", true));
                commandsToRegister.add(this.createCommand("set_invite_type", "Set whether to use dynamic or permanent invites", DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.ADMINISTRATOR})).addOption(OptionType.STRING, "type", "Invite type: dynamic or permanent", true));
            } else {
                this.logger.debug("Discord invite commands not registered (disabled in config)");
            }
            jda.updateCommands().addCommands(commandsToRegister).queue(success -> this.logger.info("Successfully registered " + commandsToRegister.size() + " slash commands"), error -> {
                this.logger.log(Level.SEVERE, "Failed to register slash commands: " + error.getMessage(), (Throwable)error);
                this.retryCommandRegistration();
            });
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error registering commands", e);
            this.retryCommandRegistration();
        }
    }

    private boolean handleCreateDynamicInviteCommand(SlashCommandInteractionEvent event) {
        int expirationHours;
        int maxUses;
        String roleId;
        String channelId = event.getOption("channel").getAsString();
        RestAction<String> action = this.inviteManager.createDynamicInvite(channelId, roleId = event.getOption("role").getAsString(), maxUses = event.getOption("max_uses") != null ? event.getOption("max_uses").getAsInt() : 0, expirationHours = event.getOption("expiration_hours") != null ? event.getOption("expiration_hours").getAsInt() : 24);
        if (action != null) {
            action.queue(inviteCode -> {
                String inviteUrl = "https://discord.gg/" + inviteCode;
                String message = "Created dynamic invite: " + inviteUrl;
                Guild guild = this.discordService.getJDA().getTextChannelById(channelId).getGuild();
                Role role = guild.getRoleById(roleId);
                message = role != null ? message + "\nRole assignment: " + role.getName() : message + "\nRole assignment: ID " + roleId;
                message = maxUses > 0 ? message + "\nMaximum uses: " + maxUses : message + "\nMaximum uses: unlimited";
                message = expirationHours > 0 ? message + "\nExpires in: " + expirationHours + " hours" : message + "\nExpiration: never";
                event.getHook().sendMessage(message).setEphemeral(true).queue();
            }, error -> {
                event.getHook().sendMessage("Failed to create invite: " + error.getMessage()).setEphemeral(true).queue();
                this.logger.warning("Error creating dynamic invite: " + error.getMessage());
            });
            return true;
        }
        event.getHook().sendMessage("Failed to create invite. Check channel ID and role ID.").setEphemeral(true).queue();
        return false;
    }

    private boolean handleSetInviteTypeCommand(SlashCommandInteractionEvent event) {
        String type = event.getOption("type").getAsString().toLowerCase();
        if (!type.equals("dynamic") && !type.equals("permanent")) {
            event.getHook().sendMessage("Invalid invite type. Use 'dynamic' or 'permanent'.").setEphemeral(true).queue();
            return false;
        }
        boolean useDynamic = type.equals("dynamic");
        this.inviteManager.setUseDynamicInvites(useDynamic);
        Properties config = this.configManager.loadMainConfig();
        config.setProperty("invite.use_dynamic", String.valueOf(useDynamic));
        this.configManager.getMigrationManager().saveConfig(config, "config.properties", "Discord Admin Plugin Configuration - Updated invite type");
        String message = "Invite type set to " + type + ". " + (useDynamic ? "Dynamic invites with expiry will be used." : "Permanent invites will be used.");
        event.getHook().sendMessage(message).setEphemeral(true).queue();
        return true;
    }

    private boolean handleToggleDiscordInvitesCommand(SlashCommandInteractionEvent event) {
        boolean enabled = event.getOption("enabled").getAsBoolean();
        Properties config = this.configManager.loadMainConfig();
        config.setProperty("invite.enabled", String.valueOf(enabled));
        this.configManager.getMigrationManager().saveConfig(config, "config.properties", "Discord Admin Plugin Configuration - Updated invite enabled state");
        String message = enabled ? "Discord invites have been enabled." : "Discord invites have been disabled. Players will no longer receive invites.";
        event.getHook().sendMessage(message).setEphemeral(true).queue();
        return true;
    }

    private void retryCommandRegistration() {
        if (this.commandRegistrationRetries >= 5) {
            this.logger.severe("Failed to register commands after 5 attempts. Giving up.");
            if (this.discordService != null && this.discordService.getAdminChannel() != null) {
                this.discordService.sendAdminMessage("\u274c **ERROR**: Failed to register Discord commands after multiple attempts. Please check bot permissions and try restarting the server or using `/reload_config`.").exceptionally(e -> {
                    this.logger.warning("Could not send command registration failure notification: " + e.getMessage());
                    return null;
                });
            }
            return;
        }
        ++this.commandRegistrationRetries;
        int baseDelay = (int)Math.pow(2.0, this.commandRegistrationRetries);
        int jitter = (int)(Math.random() * (double)Math.min(30, baseDelay));
        int delaySeconds = baseDelay + jitter;
        delaySeconds = Math.min(delaySeconds, 120);
        this.logger.info("Will retry command registration in " + delaySeconds + " seconds (attempt " + this.commandRegistrationRetries + " of 5)");
        ScheduledExecutorService retryScheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "CommandRegistration-Retry-" + this.commandRegistrationRetries);
            t.setDaemon(true);
            return t;
        });
        retryScheduler.schedule(() -> {
            try {
                this.registerCommands();
            }
            catch (Exception e) {
                this.logger.warning("Command registration retry " + this.commandRegistrationRetries + " failed: " + e.getMessage());
                this.retryCommandRegistration();
            }
            finally {
                retryScheduler.shutdown();
            }
        }, (long)delaySeconds, TimeUnit.SECONDS);
    }

    private List<Command.Choice> createTimeChoices() {
        ArrayList<Command.Choice> timeChoices = new ArrayList<Command.Choice>();
        timeChoices.add(new Command.Choice("1 minute", 1L));
        timeChoices.add(new Command.Choice("5 minutes", 5L));
        timeChoices.add(new Command.Choice("15 minutes", 15L));
        timeChoices.add(new Command.Choice("30 minutes", 30L));
        timeChoices.add(new Command.Choice("1 hour", 60L));
        timeChoices.add(new Command.Choice("6 hours", 360L));
        timeChoices.add(new Command.Choice("12 hours", 720L));
        timeChoices.add(new Command.Choice("1 day", 1440L));
        timeChoices.add(new Command.Choice("1 week", 10080L));
        timeChoices.add(new Command.Choice("Permanent", -1L));
        return timeChoices;
    }

    private SlashCommandData createCommand(String name, String description, DefaultMemberPermissions defaultPermissions) {
        String enabledKey = name + ".enabled";
        String rolesKey = name + ".roles";
        if (!DEFAULT_COMMAND_PERMISSIONS.containsKey(name) && defaultPermissions == null) {
            defaultPermissions = DefaultMemberPermissions.DISABLED;
        } else if (defaultPermissions == null) {
            defaultPermissions = DEFAULT_COMMAND_PERMISSIONS.get(name);
        }
        if (this.commandPermissions.containsKey(enabledKey)) {
            boolean isEnabled = Boolean.parseBoolean(this.commandPermissions.getProperty(enabledKey, "false"));
            if (!isEnabled) {
                defaultPermissions = DefaultMemberPermissions.DISABLED;
                this.logger.info("Command disabled by configuration: " + name);
                return Commands.slash((String)name, (String)description).setDefaultPermissions(defaultPermissions);
            }
            if (this.commandPermissions.containsKey(rolesKey)) {
                String rolesString = this.commandPermissions.getProperty(rolesKey, "");
                String[] roles = rolesString.split(",");
                if (rolesString.isEmpty()) {
                    defaultPermissions = DefaultMemberPermissions.ENABLED;
                    this.logger.info("Command enabled for everyone: " + name);
                    return Commands.slash((String)name, (String)description).setDefaultPermissions(defaultPermissions);
                }
                ArrayList<Permission> parsedPermissions = new ArrayList<Permission>();
                for (String role : roles) {
                    if ((role = role.trim()).isEmpty()) continue;
                    try {
                        Permission permission = Permission.valueOf((String)role);
                        parsedPermissions.add(permission);
                        this.logger.fine("Added permission " + String.valueOf(permission) + " for command: " + name);
                    }
                    catch (IllegalArgumentException e) {
                        this.logger.warning("Invalid permission '" + role + "' for command: " + name);
                    }
                }
                if (!parsedPermissions.isEmpty()) {
                    defaultPermissions = DefaultMemberPermissions.enabledFor((Permission[])parsedPermissions.toArray(new Permission[0]));
                    this.logger.info("Applied custom permissions for command: " + name);
                } else {
                    defaultPermissions = DefaultMemberPermissions.DISABLED;
                    this.logger.warning("No valid permissions for command: " + name + ", defaulting to DISABLED");
                }
            }
        }
        return Commands.slash((String)name, (String)description).setDefaultPermissions(defaultPermissions);
    }

    public void onMessageReceived(MessageReceivedEvent event) {
        if (event.getAuthor().isBot() || this.discordService.getAdminChannel() == null || !event.getChannel().getId().equals(this.discordService.getAdminChannel().getId())) {
            return;
        }
        if (this.relayDiscordToGame && !event.getMessage().getContentRaw().startsWith("/")) {
            String author = event.getAuthor().getName();
            String content = event.getMessage().getContentRaw();
            if (this.chatFilter != null && this.chatFilter.isEnabled()) {
                content = this.chatFilter.filterMessage(content);
            }
            String formattedMessage = this.discordToGameFormat.replace("%author%", author).replace("%message%", content);
            Server.broadcastTextMessage(formattedMessage);
        }
    }

    public void onSlashCommandInteraction(SlashCommandInteractionEvent event) {
        event.deferReply(true).queue();
        try {
            String commandName = event.getName();
            this.logger.fine("Received slash command: " + commandName);
            if (!this.isAuthorized(event.getUser().getId())) {
                event.getHook().sendMessage("You are not authorized to use this command.").setEphemeral(true).queue();
                this.logger.warning("Unauthorized command attempt: " + commandName + " by " + event.getUser().getName());
                return;
            }
            boolean success = false;
            switch (commandName) {
                case "players": {
                    success = this.handlePlayersCommand(event);
                    break;
                }
                case "refresh_status": {
                    success = this.handleRefreshStatusCommand(event);
                    break;
                }
                case "kick": {
                    success = this.handleKickCommand(event);
                    break;
                }
                case "ban": {
                    success = this.handleBanCommand(event);
                    break;
                }
                case "unban": {
                    success = this.handleUnbanCommand(event);
                    break;
                }
                case "teleport": {
                    success = this.handleTeleportCommand(event);
                    break;
                }
                case "broadcast": {
                    success = this.handleBroadcastCommand(event);
                    break;
                }
                case "restart": {
                    success = this.handleRestartCommand(event);
                    break;
                }
                case "reload_config": {
                    success = this.handleReloadConfigCommand(event);
                    break;
                }
                case "link": {
                    success = this.handleLinkCommand(event);
                    break;
                }
                case "promote": {
                    success = this.handlePromoteCommand(event);
                    break;
                }
                case "create_dynamic_invite": {
                    success = this.handleCreateDynamicInviteCommand(event);
                    break;
                }
                case "set_invite_type": {
                    success = this.handleSetInviteTypeCommand(event);
                    break;
                }
                case "toggle_discord_invites": {
                    success = this.handleToggleDiscordInvitesCommand(event);
                    break;
                }
                case "demote": {
                    success = this.handleDemoteCommand(event);
                    break;
                }
                case "reset_discord_connection": {
                    success = this.handleResetDiscordConnectionCommand(event);
                    break;
                }
                case "send_discord_invite": {
                    success = this.handleSendDiscordInviteCommand(event);
                    break;
                }
                case "create_invite": {
                    success = this.handleCreateInviteCommand(event);
                    break;
                }
                case "link_invite": {
                    success = this.handleLinkInviteCommand(event);
                    break;
                }
                case "delete_invite": {
                    success = this.handleDeleteInviteCommand(event);
                    break;
                }
                case "list_invites": {
                    success = this.handleListInvitesCommand(event);
                    break;
                }
                case "set_default_invite": {
                    success = this.handleSetDefaultInviteCommand(event);
                    break;
                }
                case "restart_enable": {
                    success = this.handleRestartEnableCommand(event);
                    break;
                }
                case "restart_time": {
                    success = this.handleRestartTimeCommand(event);
                    break;
                }
                case "restart_timezone": {
                    success = this.handleRestartTimezoneCommand(event);
                    break;
                }
                case "list_timezones": {
                    success = this.handleListTimezonesCommand(event);
                    break;
                }
                case "warn": {
                    success = this.handleWarnCommand(event);
                    break;
                }
                case "note": {
                    success = this.handleNoteCommand(event);
                    break;
                }
                case "history": {
                    success = this.handleHistoryCommand(event);
                    break;
                }
                case "delete_note": {
                    success = this.handleDeleteNoteCommand(event);
                    break;
                }
                default: {
                    event.getHook().sendMessage("Unknown command: " + commandName).setEphemeral(true).queue();
                }
            }
            if (success) {
                this.logger.info("User " + event.getUser().getName() + " executed command: " + commandName);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error processing command: " + event.getName(), e);
            try {
                event.getHook().sendMessage("An error occurred: " + e.getMessage()).setEphemeral(true).queue();
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, "Failed to send error message", ex);
            }
        }
    }

    private boolean handleRestartEnableCommand(SlashCommandInteractionEvent event) {
        boolean enabled = event.getOption("enabled").getAsBoolean();
        this.restartManager.setRestartEnabled(enabled);
        String status = enabled ? "enabled" : "disabled";
        event.getHook().sendMessage("Automatic server restarts have been " + status + ".").setEphemeral(true).queue();
        return true;
    }

    private boolean handleRestartTimeCommand(SlashCommandInteractionEvent event) {
        String time = event.getOption("time").getAsString();
        if (!time.matches("^([0-1]?[0-9]|2[0-3]):[0-5][0-9]$")) {
            event.getHook().sendMessage("Invalid time format. Please use HH:MM format (24-hour).").setEphemeral(true).queue();
            return false;
        }
        boolean success = this.restartManager.setRestartTime(time);
        if (success) {
            TimeZone tz = this.restartManager.getTimeZone();
            event.getHook().sendMessage("Daily restart time set to: " + time + " " + tz.getID() + " (" + tz.getDisplayName() + ")").setEphemeral(true).queue();
            if (!this.restartManager.isRestartEnabled()) {
                event.getHook().sendMessage("Note: Automatic restarts are currently disabled. Use `/restart_enable enabled:true` to enable them.").setEphemeral(true).queue();
            }
        } else {
            event.getHook().sendMessage("Failed to set restart time.").setEphemeral(true).queue();
        }
        return success;
    }

    private boolean handleRestartTimezoneCommand(SlashCommandInteractionEvent event) {
        String timezoneId = event.getOption("timezone").getAsString();
        boolean success = this.restartManager.setRestartTimezone(timezoneId);
        if (success) {
            TimeZone tz = this.restartManager.getTimeZone();
            event.getHook().sendMessage("Restart timezone set to: " + tz.getID() + " (" + tz.getDisplayName() + ")").setEphemeral(true).queue();
            if (!this.restartManager.isRestartEnabled()) {
                event.getHook().sendMessage("Note: Automatic restarts are currently disabled. Use `/restart_enable enabled:true` to enable them.").setEphemeral(true).queue();
            }
        } else {
            event.getHook().sendMessage("Invalid timezone ID: " + timezoneId + "\nUse `/list_timezones` to see available timezones.").setEphemeral(true).queue();
        }
        return success;
    }

    private boolean handleWarnCommand(SlashCommandInteractionEvent event) {
        String playerName = event.getOption("player").getAsString();
        String reason = event.getOption("reason").getAsString();
        String staffName = event.getUser().getName();
        boolean success = this.playerHistoryManager.addPlayerWarning(playerName, staffName, reason);
        if (success) {
            Player player = Server.getPlayerByName(playerName);
            if (player != null) {
                player.sendTextMessage("\u00a7c[WARNING] \u00a7f" + reason);
            }
            event.getHook().sendMessage("Warning added to " + playerName + "'s history.").setEphemeral(true).queue();
        } else {
            event.getHook().sendMessage("Failed to add warning to player: " + playerName).setEphemeral(true).queue();
        }
        return success;
    }

    private boolean handleNoteCommand(SlashCommandInteractionEvent event) {
        String playerName = event.getOption("player").getAsString();
        String note = event.getOption("note").getAsString();
        String staffName = event.getUser().getName();
        boolean success = this.playerHistoryManager.addPlayerNote(playerName, staffName, note, "note");
        if (success) {
            event.getHook().sendMessage("Note added to " + playerName + "'s history.").setEphemeral(true).queue();
        } else {
            event.getHook().sendMessage("Failed to add note to player: " + playerName).setEphemeral(true).queue();
        }
        return success;
    }

    private boolean handleHistoryCommand(SlashCommandInteractionEvent event) {
        String playerName = event.getOption("player").getAsString();
        String report = this.playerHistoryManager.generateModerationReport(playerName);
        event.getHook().sendMessage(report).setEphemeral(true).queue();
        return true;
    }

    private boolean handleDeleteNoteCommand(SlashCommandInteractionEvent event) {
        String staffName;
        String noteId;
        String playerName = event.getOption("player").getAsString();
        boolean success = this.playerHistoryManager.deleteNote(playerName, noteId = event.getOption("note_id").getAsString(), staffName = event.getUser().getName());
        if (success) {
            event.getHook().sendMessage("Note deleted from " + playerName + "'s history.").setEphemeral(true).queue();
        } else {
            event.getHook().sendMessage("Failed to delete note. Make sure the note ID exists.").setEphemeral(true).queue();
        }
        return success;
    }

    private boolean handleListTimezonesCommand(SlashCommandInteractionEvent event) {
        boolean commonOnly = event.getOption("common_only") != null && event.getOption("common_only").getAsBoolean();
        String[] timezones = commonOnly ? this.restartManager.getCommonTimezones() : this.restartManager.getAvailableTimezones();
        StringBuilder sb = new StringBuilder();
        sb.append("**Available Timezones");
        if (commonOnly) {
            sb.append(" (Common)**");
        } else {
            sb.append("**");
        }
        sb.append("\n");
        TimeZone currentTz = this.restartManager.getTimeZone();
        String currentTime = new SimpleDateFormat("HH:mm").format(new Date());
        if (commonOnly) {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
            sb.append("Current timezone: ").append(currentTz.getID());
            sb.append(" (").append(currentTz.getDisplayName()).append(")");
            sb.append(" - Current time: ").append(currentTime).append("\n\n");
            for (String string : timezones) {
                TimeZone tz = TimeZone.getTimeZone(string);
                sdf.setTimeZone(tz);
                String tzTime = sdf.format(new Date());
                sb.append("\u2022 `").append(string).append("` - ");
                sb.append(tz.getDisplayName()).append(" - ");
                sb.append("Current time: ").append(tzTime);
                if (string.equals(currentTz.getID())) {
                    sb.append(" (current)");
                }
                sb.append("\n");
            }
            sb.append("\nUse `/restart_timezone timezone:\"timezone_id\"` to set timezone.");
        } else {
            sb.append("Current timezone: ").append(currentTz.getID());
            sb.append(" - Current time: ").append(currentTime).append("\n\n");
            HashMap<String, List> regionMap = new HashMap<String, List>();
            for (String string : timezones) {
                String region = string.contains("/") ? string.substring(0, string.indexOf(47)) : "Other";
                regionMap.computeIfAbsent(region, k -> new ArrayList()).add(string);
            }
            for (String region : regionMap.keySet()) {
                sb.append("**").append(region).append("**:\n");
                int count = 0;
                for (String tzId : (List)regionMap.get(region)) {
                    sb.append("`").append(tzId).append("` ");
                    if (++count % 3 != 0) continue;
                    sb.append("\n");
                }
                if (count % 3 != 0) {
                    sb.append("\n");
                }
                sb.append("\n");
            }
            sb.append("For a shorter list, use `/list_timezones common_only:true`\n");
            sb.append("Use `/restart_timezone timezone:\"timezone_id\"` to set timezone.");
        }
        String fullMessage = sb.toString();
        int maxLength = 2000;
        if (fullMessage.length() <= maxLength) {
            event.getHook().sendMessage(fullMessage).setEphemeral(true).queue();
        } else {
            int totalParts = (fullMessage.length() + maxLength - 1) / maxLength;
            for (int i = 0; i < totalParts; ++i) {
                int n = i * maxLength;
                int endIdx = Math.min(n + maxLength, fullMessage.length());
                Object part = fullMessage.substring(n, endIdx);
                if (totalParts > 1) {
                    part = "**Part " + (i + 1) + " of " + totalParts + "**\n\n" + (String)part;
                }
                event.getHook().sendMessage((String)part).setEphemeral(true).queue();
            }
        }
        return true;
    }

    private boolean isAuthorized(String discordId) {
        String value;
        if (discordId == null || discordId.trim().isEmpty()) {
            return false;
        }
        if (this.authorizedAdmins.containsKey(discordId) && (value = this.authorizedAdmins.getProperty(discordId)) != null && value.equalsIgnoreCase("true")) {
            return true;
        }
        try {
            Guild guild;
            Member member;
            if (this.discordService != null && this.discordService.getJDA() != null && this.discordService.getAdminChannel() != null && (member = (guild = this.discordService.getAdminChannel().getGuild()).getMemberById(discordId)) != null && (member.hasPermission(new Permission[]{Permission.ADMINISTRATOR}) || member.hasPermission(new Permission[]{Permission.MANAGE_SERVER}))) {
                this.logger.fine("User " + member.getUser().getName() + " authorized via Discord server permissions");
                return true;
            }
        }
        catch (Exception e) {
            this.logger.fine("Error checking Discord permissions: " + e.getMessage());
        }
        String gameUsername = this.playerManager.getLinkedGameAccount(discordId);
        if (gameUsername == null || gameUsername.trim().isEmpty()) {
            return false;
        }
        Player player = Server.getPlayerByName(gameUsername);
        if (player != null) {
            return player.isAdmin();
        }
        return Server.isPlayerAdmin(gameUsername);
    }

    private boolean handlePlayersCommand(SlashCommandInteractionEvent event) {
        StringBuilder playerList = new StringBuilder("**Online players:**\n");
        int count = 0;
        for (Player player : this.playerManager.getOnlinePlayers()) {
            playerList.append("- ").append(player.getName()).append("\n");
            ++count;
        }
        playerList.append("**Total: ").append(count).append(" players**");
        event.getHook().sendMessage(playerList.toString()).setEphemeral(true).queue();
        return true;
    }

    private boolean handleRefreshStatusCommand(SlashCommandInteractionEvent event) {
        if (this.statusManager != null) {
            this.statusManager.initialize();
            event.getHook().sendMessage("Server status message refreshed.").setEphemeral(true).queue();
            return true;
        }
        event.getHook().sendMessage("Status manager is not initialized.").setEphemeral(true).queue();
        return false;
    }

    private boolean handleKickCommand(SlashCommandInteractionEvent event) {
        String reason;
        String playerName = event.getOption("player").getAsString();
        boolean success = this.playerManager.kickPlayer(playerName, reason = event.getOption("reason") != null ? event.getOption("reason").getAsString() : "Kicked by admin");
        if (success) {
            event.getHook().sendMessage("Kicked player: " + playerName + " for: " + reason).setEphemeral(true).queue();
        } else {
            event.getHook().sendMessage("Player not found: " + playerName).setEphemeral(true).queue();
        }
        return success;
    }

    private boolean handleBanCommand(SlashCommandInteractionEvent event) {
        int banTime;
        String reason;
        String playerName = event.getOption("player").getAsString();
        boolean success = this.playerManager.banPlayer(playerName, reason = event.getOption("reason") != null ? event.getOption("reason").getAsString() : "Banned by admin", banTime = event.getOption("time") != null ? event.getOption("time").getAsInt() : -1);
        if (success) {
            if (banTime > 0) {
                event.getHook().sendMessage("Banned player: " + playerName + " for " + banTime + " minutes. Reason: " + reason).setEphemeral(true).queue();
            } else {
                event.getHook().sendMessage("Permanently banned player: " + playerName + ". Reason: " + reason).setEphemeral(true).queue();
            }
        } else {
            event.getHook().sendMessage("Player not found: " + playerName + ". They need to have connected at least once while this plugin was active.").setEphemeral(true).queue();
        }
        return success;
    }

    private boolean handleUnbanCommand(SlashCommandInteractionEvent event) {
        String playerName = event.getOption("player").getAsString();
        boolean success = this.playerManager.unbanPlayer(playerName);
        if (success) {
            event.getHook().sendMessage("Unbanned player: " + playerName).setEphemeral(true).queue();
        } else {
            event.getHook().sendMessage("Player not found in UID mapping: " + playerName + ". They need to have connected at least once while this plugin was active.").setEphemeral(true).queue();
        }
        return success;
    }

    private boolean handleTeleportCommand(SlashCommandInteractionEvent event) {
        String playerName = event.getOption("player").getAsString();
        Player player = this.playerManager.getPlayer(playerName);
        if (player == null) {
            event.getHook().sendMessage("Player not found: " + playerName).setEphemeral(true).queue();
            return false;
        }
        OptionMapping xOption = event.getOption("x");
        OptionMapping yOption = event.getOption("y");
        OptionMapping zOption = event.getOption("z");
        OptionMapping targetOption = event.getOption("target");
        if (xOption != null && yOption != null && zOption != null) {
            float x = (float)xOption.getAsDouble();
            float y = (float)yOption.getAsDouble();
            float z = (float)zOption.getAsDouble();
            player.setPosition(x, y, z);
            event.getHook().sendMessage("Teleported " + playerName + " to coordinates: " + x + ", " + y + ", " + z).setEphemeral(true).queue();
            return true;
        }
        if (targetOption != null) {
            String targetName = targetOption.getAsString();
            Player target = this.playerManager.getPlayer(targetName);
            if (target == null) {
                event.getHook().sendMessage("Target player not found: " + targetName).setEphemeral(true).queue();
                return false;
            }
            player.setPosition(target.getPosition());
            event.getHook().sendMessage("Teleported " + playerName + " to " + targetName).setEphemeral(true).queue();
            return true;
        }
        event.getHook().sendMessage("Please provide either coordinates (x, y, z) or a target player.").setEphemeral(true).queue();
        return false;
    }

    private boolean handleBroadcastCommand(SlashCommandInteractionEvent event) {
        String message = event.getOption("message").getAsString();
        Server.broadcastTextMessage("[Admin] " + message);
        event.getHook().sendMessage("Broadcast message sent to all players.").setEphemeral(true).queue();
        return true;
    }

    private boolean handleRestartCommand(SlashCommandInteractionEvent event) {
        if (this.restartManager != null) {
            this.restartManager.scheduleRestart();
            event.getHook().sendMessage("Server restart sequence initiated.").setEphemeral(true).queue();
            return true;
        }
        event.getHook().sendMessage("Restart manager is not initialized.").setEphemeral(true).queue();
        return false;
    }

    private boolean handleReloadConfigCommand(SlashCommandInteractionEvent event) {
        try {
            Server.sendInputCommand("reloadplugins");
            event.getHook().sendMessage("Configuration reloaded successfully.").setEphemeral(true).queue();
            return true;
        }
        catch (Exception e) {
            event.getHook().sendMessage("Error reloading configuration: " + e.getMessage()).setEphemeral(true).queue();
            this.logger.log(Level.SEVERE, "Error reloading configuration", e);
            return false;
        }
    }

    private boolean handleLinkCommand(SlashCommandInteractionEvent event) {
        String username = event.getOption("username").getAsString();
        String discordId = event.getUser().getId();
        this.playerManager.linkDiscordAccount(discordId, username);
        event.getHook().sendMessage("Linked Discord account to game username: " + username).setEphemeral(true).queue();
        return true;
    }

    private boolean handlePromoteCommand(SlashCommandInteractionEvent event) {
        String playerName = event.getOption("player").getAsString();
        boolean success = this.playerManager.setPlayerAdmin(playerName, true);
        if (success) {
            event.getHook().sendMessage("Promoted " + playerName + " to admin").setEphemeral(true).queue();
            for (Map.Entry<String, String> entry : this.playerManager.getDiscordToGameMappings().entrySet()) {
                if (!entry.getValue().equalsIgnoreCase(playerName)) continue;
                this.authorizedAdmins.setProperty(entry.getKey(), "true");
                this.configManager.saveAuthorizedAdmins(this.authorizedAdmins);
                break;
            }
            return true;
        }
        event.getHook().sendMessage("Player not found: " + playerName).setEphemeral(true).queue();
        return false;
    }

    private boolean handleDemoteCommand(SlashCommandInteractionEvent event) {
        String playerName = event.getOption("player").getAsString();
        boolean success = this.playerManager.setPlayerAdmin(playerName, false);
        if (success) {
            event.getHook().sendMessage("Demoted " + playerName + " from admin").setEphemeral(true).queue();
            for (Map.Entry<String, String> entry : this.playerManager.getDiscordToGameMappings().entrySet()) {
                if (!entry.getValue().equalsIgnoreCase(playerName)) continue;
                this.authorizedAdmins.remove(entry.getKey());
                this.configManager.saveAuthorizedAdmins(this.authorizedAdmins);
                break;
            }
            return true;
        }
        event.getHook().sendMessage("Player not found: " + playerName).setEphemeral(true).queue();
        return false;
    }

    private boolean handleResetDiscordConnectionCommand(SlashCommandInteractionEvent event) {
        String playerName = event.getOption("player").getAsString();
        boolean success = this.playerManager.resetDiscordConnection(playerName);
        if (success) {
            event.getHook().sendMessage("Reset Discord connection status for player: " + playerName + ". They will receive an invite next time they connect.").setEphemeral(true).queue();
        } else {
            event.getHook().sendMessage("Player not found in Discord connection records: " + playerName).setEphemeral(true).queue();
        }
        return success;
    }

    private boolean handleSendDiscordInviteCommand(SlashCommandInteractionEvent event) {
        boolean useDynamic;
        if (!this.configManager.getConfigBoolean(this.config, "invite.enabled", true)) {
            event.getHook().sendMessage("Discord invites are currently disabled in the configuration.").setEphemeral(true).queue();
            return false;
        }
        String playerName = event.getOption("player").getAsString();
        Player player = this.playerManager.getPlayer(playerName);
        if (player == null) {
            event.getHook().sendMessage("Player not found: " + playerName).setEphemeral(true).queue();
            return false;
        }
        String inviteCode = event.getOption("invite_code") != null ? event.getOption("invite_code").getAsString() : null;
        boolean bl = useDynamic = event.getOption("dynamic") != null && event.getOption("dynamic").getAsBoolean();
        if (useDynamic) {
            String roleId;
            String string = roleId = event.getOption("role") != null ? event.getOption("role").getAsString() : null;
            if (roleId == null || roleId.isEmpty()) {
                event.getHook().sendMessage("Role ID is required for dynamic invites. Please provide a role ID.").setEphemeral(true).queue();
                return false;
            }
            int maxUses = event.getOption("max_uses") != null ? event.getOption("max_uses").getAsInt() : 1;
            int expirationHours = event.getOption("expiration_hours") != null ? event.getOption("expiration_hours").getAsInt() : 24;
            TextChannel channel = this.discordService.getAdminChannel();
            if (channel == null) {
                event.getHook().sendMessage("No Discord channel available for creating invite.").setEphemeral(true).queue();
                return false;
            }
            Role role = channel.getGuild().getRoleById(roleId);
            if (role == null) {
                event.getHook().sendMessage("Invalid Role ID: " + roleId + ". Role not found.").setEphemeral(true).queue();
                return false;
            }
            this.inviteManager.createDynamicInvite(channel.getId(), roleId, maxUses, expirationHours).queue(dynamicCode -> {
                boolean success = this.discordService.sendDiscordInvite(player, (String)dynamicCode);
                if (success) {
                    this.playerManager.markDiscordConnected(playerName);
                    String message = "Dynamic Discord invite sent to player: " + playerName;
                    message = message + " with role: " + role.getName();
                    if (maxUses > 0) {
                        message = message + " (max uses: " + maxUses + ")";
                    }
                    if (expirationHours > 0) {
                        message = message + " (expires in: " + expirationHours + " hours)";
                    }
                    event.getHook().sendMessage(message).setEphemeral(true).queue();
                } else {
                    event.getHook().sendMessage("Failed to send Discord invite to player: " + playerName).setEphemeral(true).queue();
                }
            }, error -> {
                event.getHook().sendMessage("Failed to create dynamic invite: " + error.getMessage()).setEphemeral(true).queue();
                this.logger.warning("Error creating dynamic invite: " + error.getMessage());
            });
            return true;
        }
        String inviteUrl = this.inviteManager.getDiscordInviteUrl(inviteCode);
        if (inviteUrl == null) {
            event.getHook().sendMessage("No valid invite available. Please create an invite first.").setEphemeral(true).queue();
            return false;
        }
        boolean success = this.discordService.sendDiscordInvite(player, inviteUrl);
        if (success) {
            this.playerManager.markDiscordConnected(playerName);
            event.getHook().sendMessage("Discord invite sent to player: " + playerName).setEphemeral(true).queue();
            return true;
        }
        event.getHook().sendMessage("Failed to send Discord invite to player: " + playerName).setEphemeral(true).queue();
        return false;
    }

    private boolean handleCreateInviteCommand(SlashCommandInteractionEvent event) {
        int expirationHours;
        int maxUses;
        String roleId;
        String channelId = event.getOption("channel").getAsString();
        RestAction<String> action = this.inviteManager.createRoleInvite(channelId, roleId = event.getOption("role").getAsString(), maxUses = event.getOption("max_uses") != null ? event.getOption("max_uses").getAsInt() : 0, expirationHours = event.getOption("expiration_hours") != null ? event.getOption("expiration_hours").getAsInt() : 0);
        if (action != null) {
            action.queue(inviteCode -> {
                String inviteUrl = "https://discord.gg/" + inviteCode;
                event.getHook().sendMessage("Created role invite: " + inviteUrl).setEphemeral(true).queue();
            }, error -> {
                event.getHook().sendMessage("Failed to create invite: " + error.getMessage()).setEphemeral(true).queue();
                this.logger.warning("Error creating invite: " + error.getMessage());
            });
            return true;
        }
        event.getHook().sendMessage("Failed to create invite. Check channel and role IDs.").setEphemeral(true).queue();
        return false;
    }

    private boolean handleLinkInviteCommand(SlashCommandInteractionEvent event) {
        String roleId;
        String inviteCode;
        String channelId = event.getOption("channel").getAsString();
        boolean success = this.inviteManager.linkExistingInvite(channelId, inviteCode = event.getOption("code").getAsString(), roleId = event.getOption("role").getAsString());
        if (success) {
            event.getHook().sendMessage("Linked existing invite `" + inviteCode + "` with specified role. Users joining with this invite will now receive the role.").setEphemeral(true).queue();
            return true;
        }
        event.getHook().sendMessage("Failed to link invite. Please check that the channel ID, invite code, and role ID are all valid.").setEphemeral(true).queue();
        return false;
    }

    private boolean handleDeleteInviteCommand(SlashCommandInteractionEvent event) {
        String inviteCode = event.getOption("code").getAsString();
        boolean success = this.inviteManager.deleteRoleInvite(inviteCode);
        if (success) {
            event.getHook().sendMessage("Deleted invite: " + inviteCode).setEphemeral(true).queue();
            return true;
        }
        event.getHook().sendMessage("Failed to delete invite. Check the invite code.").setEphemeral(true).queue();
        return false;
    }

    private boolean handleListInvitesCommand(SlashCommandInteractionEvent event) {
        Map<String, String> invites = this.inviteManager.listRoleInvites();
        if (invites.isEmpty()) {
            event.getHook().sendMessage("No role invites found.").setEphemeral(true).queue();
            return true;
        }
        StringBuilder response = new StringBuilder("**Role Invites:**\n");
        for (Map.Entry<String, String> entry : invites.entrySet()) {
            response.append("- https://discord.gg/").append(entry.getKey()).append(" \u2192 ").append(entry.getValue()).append("\n");
        }
        String defaultInvite = this.inviteManager.getDefaultInviteCode();
        if (defaultInvite != null && !defaultInvite.isEmpty()) {
            response.append("\nDefault invite for automatic player invites: **").append(defaultInvite).append("**");
        } else {
            response.append("\nNo default invite set.");
        }
        event.getHook().sendMessage(response.toString()).setEphemeral(true).queue();
        return true;
    }

    private boolean handleSetDefaultInviteCommand(SlashCommandInteractionEvent event) {
        String inviteCode = event.getOption("invite_code").getAsString();
        if (inviteCode.startsWith("https://discord.gg/")) {
            inviteCode = inviteCode.substring(19);
        } else if (inviteCode.startsWith("discord.gg/")) {
            inviteCode = inviteCode.substring(11);
        }
        boolean success = this.inviteManager.setDefaultInviteCode(inviteCode);
        if (success) {
            event.getHook().sendMessage("Default Discord invite set to: " + inviteCode + " (https://discord.gg/" + inviteCode + ")").setEphemeral(true).queue();
            return true;
        }
        event.getHook().sendMessage("Failed to set default invite. Make sure the invite exists in managed invites (check with /list_invites).").setEphemeral(true).queue();
        return false;
    }
}

