/*
 * Decompiled with CFR 0.152.
 */
package com.example.risingworld.discordadmin;

import com.example.risingworld.discordadmin.PluginLogger;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;

public class EnhancedErrorHandler {
    private final PluginLogger logger;
    private static final int DEFAULT_MAX_RETRIES = 3;
    private static final long DEFAULT_RETRY_DELAY_MS = 1000L;
    private static final long DEFAULT_TIMEOUT_MS = 10000L;

    public EnhancedErrorHandler(PluginLogger logger) {
        this.logger = logger;
    }

    public <T> CompletableFuture<T> withRetry(String operationName, Supplier<CompletableFuture<T>> operation) {
        return this.withRetry(operationName, operation, null, 3, 1000L);
    }

    public <T> CompletableFuture<T> withRetry(String operationName, Supplier<CompletableFuture<T>> operation, Consumer<T> onSuccess, int maxRetries, long retryDelayMs) {
        CompletableFuture result = new CompletableFuture();
        this.executeWithRetry(operationName, operation, onSuccess, result, maxRetries, 0, retryDelayMs);
        return result;
    }

    private <T> void executeWithRetry(String operationName, Supplier<CompletableFuture<T>> operation, Consumer<T> onSuccess, CompletableFuture<T> result, int maxRetries, int currentRetry, long retryDelayMs) {
        long startTimeMs = System.currentTimeMillis();
        operation.get().whenComplete((response, error) -> {
            long durationMs = System.currentTimeMillis() - startTimeMs;
            if (error != null) {
                Throwable cause;
                Throwable throwable = cause = error.getCause() != null ? error.getCause() : error;
                if (currentRetry < maxRetries) {
                    this.logger.warning(String.format("%s failed after %dms (attempt %d/%d): %s - Retrying in %dms...", operationName, durationMs, currentRetry + 1, maxRetries + 1, cause.getMessage(), retryDelayMs));
                    long nextRetryDelay = retryDelayMs * (long)Math.pow(1.5, currentRetry);
                    CompletableFuture.delayedExecutor(nextRetryDelay, TimeUnit.MILLISECONDS).execute(() -> this.lambda$executeWithRetry$0(operationName, (Supplier)operation, onSuccess, result, maxRetries, currentRetry, retryDelayMs));
                } else {
                    this.logger.severe(String.format("%s failed after %d attempts (total duration: %dms): %s", operationName, maxRetries + 1, durationMs + retryDelayMs * (long)maxRetries, cause.getMessage()));
                    if (this.isSevereError(cause)) {
                        this.logger.log(Level.SEVERE, "Detailed error trace:", cause);
                    }
                    result.completeExceptionally(cause);
                }
            } else {
                try {
                    this.logger.fine(String.format("%s completed successfully in %dms after %d attempts", operationName, durationMs, currentRetry + 1));
                    if (onSuccess != null) {
                        onSuccess.accept(response);
                    }
                    result.complete(response);
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "Error in success handler for " + operationName, e);
                    result.completeExceptionally(e);
                }
            }
        });
    }

    public <T> CompletableFuture<T> withTimeout(String operationName, Supplier<CompletableFuture<T>> operation) {
        return this.withTimeout(operationName, operation, 10000L);
    }

    public <T> CompletableFuture<T> withTimeout(String operationName, Supplier<CompletableFuture<T>> operation, long timeoutMs) {
        CompletableFuture result = new CompletableFuture();
        long startTimeMs = System.currentTimeMillis();
        CompletableFuture timeout = new CompletableFuture();
        CompletableFuture.delayedExecutor(timeoutMs, TimeUnit.MILLISECONDS).execute(() -> timeout.completeExceptionally(new TimeoutException("Operation timed out after " + timeoutMs + "ms: " + operationName)));
        CompletableFuture operationFuture = operation.get();
        operationFuture.whenComplete((response, error) -> {
            long durationMs = System.currentTimeMillis() - startTimeMs;
            if (error != null) {
                this.logger.warning(String.format("%s failed after %dms: %s", operationName, durationMs, error.getMessage()));
                result.completeExceptionally((Throwable)error);
            } else {
                this.logger.fine(String.format("%s completed successfully in %dms", operationName, durationMs));
                result.complete(response);
            }
        });
        timeout.whenComplete((unused, error) -> {
            if (error != null && error instanceof TimeoutException) {
                long durationMs = System.currentTimeMillis() - startTimeMs;
                this.logger.warning(String.format("%s timed out after %dms (timeout was %dms)", operationName, durationMs, timeoutMs));
                operationFuture.cancel(true);
                result.completeExceptionally((Throwable)error);
            }
        });
        return result;
    }

    public <T> CompletableFuture<T> withRetryAndTimeout(String operationName, Supplier<CompletableFuture<T>> operation, Consumer<T> onSuccess) {
        return this.withTimeout(operationName, () -> this.withRetry(operationName, operation, onSuccess, 3, 1000L), 10000L);
    }

    public <T> T tryOrDefault(String context, Supplier<T> operation, T defaultValue) {
        try {
            return operation.get();
        }
        catch (Exception e) {
            this.handleException(context, e);
            return defaultValue;
        }
    }

    public boolean tryRun(String context, Runnable runnable) {
        try {
            runnable.run();
            return true;
        }
        catch (Exception e) {
            this.handleException(context, e);
            return false;
        }
    }

    public void handleException(String context, Throwable exception) {
        if (exception instanceof InterruptedException) {
            this.logger.warning("Thread interrupted during: " + context);
            Thread.currentThread().interrupt();
        } else if (this.isSevereError(exception)) {
            this.logger.severe(context + ": " + exception.getMessage());
            this.logger.log(Level.SEVERE, "Stack trace:", exception);
        } else {
            this.logger.warning(context + ": " + exception.getMessage());
            this.logger.log(Level.FINE, "Stack trace for non-severe error:", exception);
        }
    }

    private boolean isSevereError(Throwable exception) {
        if (exception == null) {
            return false;
        }
        return exception instanceof RuntimeException || exception instanceof Error || exception instanceof NullPointerException || exception instanceof IllegalStateException || exception.getCause() instanceof Error || exception.getMessage() != null && (exception.getMessage().contains("server error") || exception.getMessage().contains("critical") || exception.getMessage().contains("fatal"));
    }

    private /* synthetic */ void lambda$executeWithRetry$0(String operationName, Supplier operation, Consumer onSuccess, CompletableFuture result, int maxRetries, int currentRetry, long retryDelayMs) {
        this.executeWithRetry(operationName, operation, onSuccess, result, maxRetries, currentRetry + 1, retryDelayMs);
    }
}

