/*
 * Decompiled with CFR 0.152.
 */
package com.example.risingworld.discordadmin;

import com.example.risingworld.discordadmin.ChatFilter;
import com.example.risingworld.discordadmin.CommandManager;
import com.example.risingworld.discordadmin.ConfigManager;
import com.example.risingworld.discordadmin.DiscordMessagePersistence;
import com.example.risingworld.discordadmin.DiscordService;
import com.example.risingworld.discordadmin.EnhancedErrorHandler;
import com.example.risingworld.discordadmin.EnhancedScheduler;
import com.example.risingworld.discordadmin.FileUtilsTester;
import com.example.risingworld.discordadmin.InviteManager;
import com.example.risingworld.discordadmin.LibraryLoader;
import com.example.risingworld.discordadmin.PlayerConnectionLogger;
import com.example.risingworld.discordadmin.PlayerHistoryManager;
import com.example.risingworld.discordadmin.PlayerManager;
import com.example.risingworld.discordadmin.PluginLogger;
import com.example.risingworld.discordadmin.RestartManager;
import com.example.risingworld.discordadmin.StatusManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.exceptions.ErrorResponseException;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.general.ShutdownEvent;
import net.risingworld.api.events.player.PlayerChatEvent;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerDisconnectEvent;
import net.risingworld.api.objects.Player;

public class DiscordAdminPluginImpl
extends Plugin
implements Listener {
    public final String Version = "3.7.2";
    private PluginLogger logger;
    private ConfigManager configManager;
    private DiscordService discordService;
    private CommandManager commandManager;
    private PlayerManager playerManager;
    private StatusManager statusManager;
    private RestartManager restartManager;
    private InviteManager inviteManager;
    private LibraryLoader libraryLoader;
    private DiscordMessagePersistence messagePersistence;
    private EnhancedErrorHandler errorHandler;
    private EnhancedScheduler enhancedScheduler;
    private PlayerConnectionLogger connectionLogger;
    private Properties config;
    private Properties authorizedAdmins;
    private final ConcurrentHashMap<String, List<Message>> playerJoinMessages = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, List<Message>> playerLeaveMessages = new ConcurrentHashMap();
    private final ArrayList<ScheduledFuture<?>> pendingMessageDeletions = new ArrayList();
    private final AtomicBoolean isShuttingDown = new AtomicBoolean(false);
    private final AtomicBoolean messagesDeleted = new AtomicBoolean(false);
    private int messageDeleteDelay;
    private boolean relayGameChatToDiscord;
    private boolean relayDiscordToGame;
    private String playerJoinFormat;
    private String playerLeaveFormat;
    private String gameToDiscordFormat;
    private String discordToGameFormat;
    private String messageDeleteMode;
    private PlayerHistoryManager playerHistoryManager;
    private ChatFilter chatFilter;
    private String pluginPath;

    public DiscordAdminPluginImpl() {
    }

    public DiscordAdminPluginImpl(File pluginDirectory) {
        if (pluginDirectory != null) {
            this.pluginPath = pluginDirectory.getAbsolutePath();
        }
    }

    public void setPluginPath(String path) {
        this.pluginPath = path;
    }

    public void scheduleMessageCleanup() {
        if (this.enhancedScheduler != null) {
            this.enhancedScheduler.scheduleDelayedTask(this::cleanupOldMessages, 24L, TimeUnit.HOURS);
        }
    }

    public boolean verifyConfigFileFormatting() {
        if (this.configManager != null && this.config != null) {
            return this.configManager.checkAndFixConfigFormatting(this.config);
        }
        return false;
    }

    private void cleanupOldMessages() {
        long ONE_DAY_MS = 86400000L;
        long now = System.currentTimeMillis();
        if ("never".equals(this.messageDeleteMode)) {
            return;
        }
        try {
            ArrayList<Message> messagesToRemove;
            List<Message> messages2;
            String playerName;
            for (Map.Entry<String, List<Message>> entry : this.playerJoinMessages.entrySet()) {
                playerName = entry.getKey();
                messages2 = entry.getValue();
                messagesToRemove = new ArrayList<Message>();
                for (Message message : messages2) {
                    if (message == null || now - message.getTimeCreated().toInstant().toEpochMilli() <= 86400000L) continue;
                    try {
                        message.delete().queue();
                        messagesToRemove.add(message);
                        if (this.messagePersistence == null) continue;
                        this.messagePersistence.removeSpecificMessage("join", playerName, message.getId());
                    }
                    catch (Exception e) {
                        this.logger.debug("Failed to delete old join message: " + e.getMessage());
                        messagesToRemove.add(message);
                    }
                }
                if (messagesToRemove.isEmpty()) continue;
                messages2.removeAll(messagesToRemove);
                if (!messages2.isEmpty()) continue;
                this.playerJoinMessages.remove(playerName);
            }
            for (Map.Entry<String, List<Message>> entry : this.playerLeaveMessages.entrySet()) {
                playerName = entry.getKey();
                messages2 = entry.getValue();
                messagesToRemove = new ArrayList();
                for (Message message : messages2) {
                    if (message == null || now - message.getTimeCreated().toInstant().toEpochMilli() <= 86400000L) continue;
                    try {
                        message.delete().queue();
                        messagesToRemove.add(message);
                        if (this.messagePersistence == null) continue;
                        this.messagePersistence.removeSpecificMessage("leave", playerName, message.getId());
                    }
                    catch (Exception e) {
                        this.logger.debug("Failed to delete old leave message: " + e.getMessage());
                        messagesToRemove.add(message);
                    }
                }
                if (messagesToRemove.isEmpty()) continue;
                messages2.removeAll(messagesToRemove);
                if (!messages2.isEmpty()) continue;
                this.playerLeaveMessages.remove(playerName);
            }
            int joinCount = 0;
            int leaveCount = 0;
            for (List<Message> messages2 : this.playerJoinMessages.values()) {
                joinCount += messages2.size();
            }
            for (List<Message> messages2 : this.playerLeaveMessages.values()) {
                leaveCount += messages2.size();
            }
            this.logger.debug("Message cleanup complete. Remaining: " + joinCount + " join messages and " + leaveCount + " leave messages");
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Error during message cleanup", e);
        }
    }

    public void enableFullFeatures() {
        this.logger.debug("Enabling full plugin features now that dependencies are available");
        try {
            if (this.discordService == null || !this.discordService.isConnected()) {
                this.discordService = new DiscordService(this.pluginPath, this.logger, this.config);
                boolean connected = this.discordService.initialize();
                if (connected) {
                    this.initializeDiscordDependentComponents();
                } else {
                    this.logger.warning("Discord connection still unavailable even after dependencies were loaded");
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error enabling full features", e);
        }
    }

    private void initializeDiscordDependentComponents() {
        try {
            boolean startupNotify;
            if (this.enhancedScheduler == null) {
                this.enhancedScheduler = new EnhancedScheduler(this.logger, null);
            }
            if (this.inviteManager == null) {
                this.inviteManager = new InviteManager(this.discordService.getJDA(), this.pluginPath, this.logger, this.configManager);
                this.discordService.addEventListener(this.inviteManager);
            }
            if (this.statusManager == null) {
                this.statusManager = new StatusManager(this.discordService, this.logger, this.config);
                this.enhancedScheduler = new EnhancedScheduler(this.logger, this.statusManager);
                this.discordService.setStatusManager(this.statusManager);
                if (this.configManager.getConfigBoolean(this.config, "status.updates.enabled", true)) {
                    int interval = this.configManager.getConfigInt(this.config, "status.updates.interval", 10);
                    this.enhancedScheduler.scheduleStatusUpdates(interval);
                }
            }
            if (this.restartManager == null) {
                this.restartManager = new RestartManager(this.logger, this.statusManager, this.configManager, this.config, this.pluginPath);
                if (this.configManager.getConfigBoolean(this.config, "restart.daily.enabled", true)) {
                    String time = this.configManager.getConfigString(this.config, "restart.daily.time", "04:00");
                    this.restartManager.scheduleDailyRestart(time);
                }
            }
            this.scheduleMessageCleanup();
            if (this.commandManager == null) {
                this.commandManager = new CommandManager(this.logger, this.discordService, this.playerManager, this.restartManager, this.statusManager, this.configManager, this.authorizedAdmins, this.pluginPath, this.inviteManager, this.playerHistoryManager);
                this.commandManager.setChatFilter(this.chatFilter);
                this.commandManager.setDiscordToGameFormat(this.discordToGameFormat);
                this.discordService.addEventListener(this.commandManager);
            }
            if (startupNotify = this.configManager.getConfigBoolean(this.config, "discord.startup.notification", true)) {
                this.discordService.sendAdminMessage("\ud83d\udfe2 **Server plugin started**: Discord Admin Plugin 3.7.2 is now online.").exceptionally(e -> {
                    this.logger.warning("Could not send startup notification: " + e.getMessage());
                    return null;
                });
            }
            this.logger.debug("Discord-dependent components fully initialized");
        }
        catch (Exception e2) {
            this.logger.log(Level.SEVERE, "Error initializing Discord-dependent components", e2);
        }
    }

    @Override
    public void onEnable() {
        this.logger = new PluginLogger(this.getName());
        this.logger.info("Loading Discord Admin Plugin 3.7.2...");
        try {
            this.errorHandler = new EnhancedErrorHandler(this.logger);
            this.errorHandler.tryRun("Plugin initialization", () -> {
                this.registerEventListener(this);
                if (this.getPath() == null || this.getPath().isEmpty()) {
                    if (this.pluginPath != null && !this.pluginPath.isEmpty()) {
                        this.logger.debug("Using manually set plugin path: " + this.pluginPath);
                    } else {
                        this.logger.severe("Plugin path not available. Some features may not work properly.");
                        this.pluginPath = ".";
                    }
                } else {
                    this.pluginPath = this.getPath();
                }
                this.configManager = new ConfigManager(this.pluginPath, this.logger);
                this.loadAllConfigurations();
                if (this.config != null) {
                    this.logger.configure(this.config);
                    this.logger.debug("Logger configured with level: " + this.logger.getLogLevelString());
                }
                this.messageDeleteDelay = this.configManager.getConfigInt(this.config, "discord.message.delete.delay", 300);
                this.relayGameChatToDiscord = this.configManager.getConfigBoolean(this.config, "chat.relay.game_to_discord", true);
                this.relayDiscordToGame = this.configManager.getConfigBoolean(this.config, "chat.relay.discord_to_game", true);
                this.playerJoinFormat = this.configManager.getConfigString(this.config, "message.join.format", "\ud83d\udfe2 **%player% joined the server**");
                this.playerLeaveFormat = this.configManager.getConfigString(this.config, "message.leave.format", "\ud83d\udd34 **%player% left the server**");
                this.gameToDiscordFormat = this.configManager.getConfigString(this.config, "chat.format.game_to_discord", "[Game] %player%: %message%");
                this.discordToGameFormat = this.configManager.getConfigString(this.config, "chat.format.discord_to_game", "[Discord] %author%: %message%");
                this.messageDeleteMode = this.configManager.getConfigString(this.config, "discord.message.delete.mode", "always");
                this.chatFilter = new ChatFilter(this.logger);
                boolean filterEnabled = this.configManager.getConfigBoolean(this.config, "chat.filter.enabled", false);
                String filteredWords = this.configManager.getConfigString(this.config, "chat.filter.words", "");
                this.chatFilter.initialize(filteredWords, filterEnabled);
                this.playerHistoryManager = new PlayerHistoryManager(this.pluginPath, this.logger);
                String connectionLogDir = this.configManager.getConfigString(this.config, "player.connection.log.directory", "player_connections");
                boolean logEnabled = this.configManager.getConfigBoolean(this.config, "player.connection.log.enabled", true);
                if (logEnabled) {
                    this.connectionLogger = new PlayerConnectionLogger(this.pluginPath + "/" + connectionLogDir, this.logger);
                    this.logger.debug("Player connection logging enabled in: " + connectionLogDir);
                } else {
                    this.logger.debug("Player connection logging is disabled.");
                }
                this.playerManager = new PlayerManager(this.pluginPath, this.logger, this.configManager);
                this.discordService = new DiscordService(this.pluginPath, this.logger, this.config);
                boolean connected = this.discordService.initialize();
                if (connected) {
                    this.enhancedScheduler = new EnhancedScheduler(this.logger, null);
                    this.inviteManager = new InviteManager(this.discordService.getJDA(), this.pluginPath, this.logger, this.configManager);
                    this.discordService.addEventListener(this.inviteManager);
                    this.statusManager = new StatusManager(this.discordService, this.logger, this.config);
                    this.enhancedScheduler = new EnhancedScheduler(this.logger, this.statusManager);
                    this.discordService.setStatusManager(this.statusManager);
                    if (this.configManager.getConfigBoolean(this.config, "status.updates.enabled", true)) {
                        int interval = this.configManager.getConfigInt(this.config, "status.updates.interval", 10);
                        this.enhancedScheduler.scheduleStatusUpdates(interval);
                    }
                    this.restartManager = new RestartManager(this.logger, this.statusManager, this.configManager, this.config, this.pluginPath);
                    this.messagePersistence = new DiscordMessagePersistence(this.logger, this.pluginPath);
                    if (this.discordService != null && this.discordService.isConnected()) {
                        this.logger.info("Attempting to clean up persisted Discord messages from previous sessions...");
                        int count = this.messagePersistence.getMessageCount();
                        if (count > 0) {
                            Map<String, Boolean> results = this.messagePersistence.deleteAllPersistedMessages(this.discordService, this.messageDeleteMode);
                            int successCount = (int)results.values().stream().filter(success -> success).count();
                            this.logger.info("Cleaned up " + successCount + " of " + count + " persisted Discord messages");
                        } else {
                            this.logger.debug("No persisted Discord messages to clean up");
                        }
                    }
                    if (this.configManager.getConfigBoolean(this.config, "restart.daily.enabled", true)) {
                        String time = this.configManager.getConfigString(this.config, "restart.daily.time", "04:00");
                        this.restartManager.scheduleDailyRestart(time);
                    }
                    this.scheduleMessageCleanup();
                    this.commandManager = new CommandManager(this.logger, this.discordService, this.playerManager, this.restartManager, this.statusManager, this.configManager, this.authorizedAdmins, this.pluginPath, this.inviteManager, this.playerHistoryManager);
                    this.commandManager.setChatFilter(this.chatFilter);
                    this.commandManager.setDiscordToGameFormat(this.discordToGameFormat);
                    this.discordService.addEventListener(this.commandManager);
                    boolean startupNotify = this.configManager.getConfigBoolean(this.config, "discord.startup.notification", true);
                    if (startupNotify) {
                        this.discordService.sendAdminMessage("\ud83d\udfe2 **Server plugin started**: Discord Admin Plugin v3.5.0 is now online.").exceptionally(e -> {
                            this.logger.warning("Could not send startup notification: " + e.getMessage());
                            return null;
                        });
                    }
                }
                this.logger.info("Discord Admin Plugin fully loaded and enabled.");
                boolean runTests = this.configManager.getConfigBoolean(this.config, "debug.run_file_tests", false);
                if (runTests) {
                    FileUtilsTester tester = new FileUtilsTester(this.logger, this.pluginPath);
                    boolean testsPassed = tester.runTests();
                    this.logger.info("FileUtils tests " + (testsPassed ? "passed" : "failed"));
                    if (!testsPassed) {
                        this.logger.warning("Some FileUtils tests failed - check test results file for details");
                    }
                }
            });
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error during plugin initialization", e);
        }
    }

    @Override
    public void onDisable() {
        this.logger.info("Disabling Discord Admin Plugin...");
        this.isShuttingDown.set(true);
        try {
            if (this.playerManager != null) {
                this.playerManager.saveAll();
            }
            if (!this.messagesDeleted.get()) {
                this.deleteRemainingDiscordMessages();
            }
            if (this.statusManager != null) {
                try {
                    this.statusManager.setServerOffline();
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    this.logger.warning("Error updating server status to offline: " + e.getMessage());
                }
            }
            if (this.restartManager != null) {
                this.restartManager.shutdown();
            }
            if (this.enhancedScheduler != null) {
                this.enhancedScheduler.shutdown();
            }
            if (this.inviteManager != null) {
                this.inviteManager.saveInviteMappings();
            }
            if (this.discordService != null) {
                try {
                    Thread.sleep(2000L);
                    this.discordService.shutdown();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.logger.warning("Interrupted while waiting for Discord shutdown");
                }
                catch (Exception e) {
                    this.logger.warning("Error during Discord service shutdown: " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error during plugin disable", e);
        }
        this.logger.info("Discord Admin Plugin disabled.");
    }

    private void loadAllConfigurations() {
        this.config = this.configManager.loadMainConfig();
        if (this.configManager.checkAndFixConfigFormatting(this.config)) {
            this.logger.info("Restored config.properties formatting during startup");
        }
        this.authorizedAdmins = this.configManager.loadAuthorizedAdmins();
    }

    private void deleteRemainingDiscordMessages() {
        if (!this.messagesDeleted.compareAndSet(false, true)) {
            this.logger.debug("Attempted to delete Discord messages multiple times. Skipping.");
            return;
        }
        this.logger.debug("Cleaning up Discord messages during shutdown...");
        try {
            if ("always".equals(this.messageDeleteMode) || "on_restart".equals(this.messageDeleteMode)) {
                ArrayList<Object> messagesToDelete;
                for (Map.Entry<String, List<Message>> entry : this.playerJoinMessages.entrySet()) {
                    playerName = entry.getKey();
                    messages = entry.getValue();
                    messagesToDelete = new ArrayList<Message>(messages);
                    for (Message message : messagesToDelete) {
                        if (message == null) continue;
                        try {
                            message.delete().complete();
                            this.logger.debug("Deleted join message for: " + playerName);
                            messages.remove(message);
                            if (this.messagePersistence == null) continue;
                            this.messagePersistence.removeSpecificMessage("join", playerName, message.getId());
                        }
                        catch (Exception e) {
                            this.logger.debug("Failed to delete join message for " + playerName + ": " + e.getMessage());
                            if (this.messagePersistence == null) continue;
                            this.messagePersistence.saveMessage("join", playerName, message);
                        }
                    }
                    if (!messages.isEmpty()) continue;
                    this.playerJoinMessages.remove(playerName);
                }
                for (Map.Entry entry : this.playerLeaveMessages.entrySet()) {
                    playerName = (String)entry.getKey();
                    messages = (List)entry.getValue();
                    messagesToDelete = new ArrayList(messages);
                    for (Message message : messagesToDelete) {
                        if (message == null) continue;
                        try {
                            message.delete().complete();
                            this.logger.debug("Deleted leave message for: " + playerName);
                            messages.remove(message);
                            if (this.messagePersistence == null) continue;
                            this.messagePersistence.removeSpecificMessage("leave", playerName, message.getId());
                        }
                        catch (Exception e) {
                            this.logger.debug("Failed to delete leave message for " + playerName + ": " + e.getMessage());
                            if (this.messagePersistence == null) continue;
                            this.messagePersistence.saveMessage("leave", playerName, message);
                        }
                    }
                    if (!messages.isEmpty()) continue;
                    this.playerLeaveMessages.remove(playerName);
                }
            } else {
                this.logger.debug("Message deletion is disabled (mode: never). Skipping message cleanup.");
                if (this.messagePersistence != null) {
                    for (Map.Entry entry : this.playerJoinMessages.entrySet()) {
                        playerName = (String)entry.getKey();
                        messages = (List)entry.getValue();
                        for (Message message : messages) {
                            this.messagePersistence.saveMessage("join", playerName, message);
                        }
                    }
                    for (Map.Entry entry : this.playerLeaveMessages.entrySet()) {
                        playerName = (String)entry.getKey();
                        messages = (List)entry.getValue();
                        for (Message message : messages) {
                            this.messagePersistence.saveMessage("leave", playerName, message);
                        }
                    }
                }
            }
            for (ScheduledFuture scheduledFuture : this.pendingMessageDeletions) {
                if (scheduledFuture == null || scheduledFuture.isDone() || scheduledFuture.isCancelled()) continue;
                scheduledFuture.cancel(false);
            }
            this.pendingMessageDeletions.clear();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error during Discord message cleanup", e);
        }
        this.logger.debug("Discord message cleanup completed.");
    }

    @EventMethod
    public void onServerShutdown(ShutdownEvent event) {
        this.logger.info("Server shutdown initiated.");
        this.isShuttingDown.set(true);
        if (!this.messagesDeleted.get()) {
            this.deleteRemainingDiscordMessages();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (this.statusManager != null) {
            this.statusManager.setServerOffline();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void sendPlayerJoinMessage(String playerName, String playerNameLower) {
        int playerCount = Server.getPlayerCount();
        int totalPlayers = Server.getTotalPlayerCount();
        String joinMessage = this.playerJoinFormat.replace("%player%", playerName);
        joinMessage = joinMessage.replace("%playercount%", String.valueOf(playerCount));
        joinMessage = joinMessage.replace("%totalplayers%", String.valueOf(totalPlayers));
        this.discordService.getAdminChannel().sendMessage((CharSequence)joinMessage).queue(message -> {
            List playerMessages = this.playerJoinMessages.computeIfAbsent(playerNameLower, k -> new ArrayList());
            playerMessages.add(message);
            this.logger.debug("Successfully sent join message for " + playerName);
            if (this.messagePersistence != null) {
                this.messagePersistence.saveMessage("join", playerName, (Message)message);
                this.logger.debug("Persisted join message for " + playerName);
            }
        }, error -> {
            this.logger.warning("Failed to send player join message for " + playerName + ": " + error.getMessage());
            if (error instanceof ErrorResponseException) {
                ErrorResponseException ere = (ErrorResponseException)error;
                this.logger.warning("Discord error code: " + ere.getErrorCode() + " - " + ere.getMeaning());
            }
        });
    }

    private boolean handleinvites(PlayerConnectEvent event) {
        Player player = event.getPlayer();
        String playerName = player.getName();
        boolean invitesEnabled = this.configManager.getConfigBoolean(this.config, "invite.enabled", true);
        if (!invitesEnabled) {
            this.logger.debug("Discord invites are completely disabled. No invite sent to: " + playerName);
            return false;
        }
        boolean autoSendInvites = this.configManager.getConfigBoolean(this.config, "invite.auto_send_on_join", true);
        if (autoSendInvites && !this.playerManager.hasDiscordConnection(playerName) && this.inviteManager != null) {
            boolean useDynamicInvite = this.configManager.getConfigBoolean(this.config, "invite.use_dynamic", false);
            if (useDynamicInvite) {
                int maxUses = this.configManager.getConfigInt(this.config, "invite.dynamic.max_uses", 1);
                int expirationHours = this.configManager.getConfigInt(this.config, "invite.dynamic.expiration_hours", 24);
                String roleId = this.configManager.getConfigString(this.config, "invite.dynamic.role_id", "");
                if (roleId.isEmpty()) {
                    boolean sent;
                    this.logger.warning("Cannot create dynamic invite: Role ID is required but not configured. Please set 'invite.dynamic.role_id' in the configuration.");
                    String fallbackInvite = this.inviteManager.getDiscordInviteUrl(null);
                    if (fallbackInvite != null && (sent = this.discordService.sendDiscordInvite(player, fallbackInvite))) {
                        this.playerManager.markDiscordConnected(playerName);
                        this.logger.debug("Sent fallback permanent invite to: " + playerName);
                    }
                    return true;
                }
                TextChannel channel = this.discordService.getAdminChannel();
                if (channel == null) {
                    boolean sent;
                    this.logger.warning("Cannot create dynamic invite: No admin channel available");
                    String fallbackInvite = this.inviteManager.getDiscordInviteUrl(null);
                    if (fallbackInvite != null && (sent = this.discordService.sendDiscordInvite(player, fallbackInvite))) {
                        this.playerManager.markDiscordConnected(playerName);
                        this.logger.debug("Sent fallback permanent invite to: " + playerName);
                    }
                } else {
                    Role role = channel.getGuild().getRoleById(roleId);
                    if (role == null) {
                        boolean sent;
                        this.logger.warning("Cannot create dynamic invite: Role ID " + roleId + " configured in 'invite.dynamic.role_id' does not exist");
                        String fallbackInvite = this.inviteManager.getDiscordInviteUrl(null);
                        if (fallbackInvite != null && (sent = this.discordService.sendDiscordInvite(player, fallbackInvite))) {
                            this.playerManager.markDiscordConnected(playerName);
                            this.logger.debug("Sent fallback permanent invite to: " + playerName);
                        }
                        return true;
                    }
                    this.inviteManager.createDynamicInvite(channel.getId(), roleId, maxUses, expirationHours).queue(inviteCode -> {
                        boolean sent = this.discordService.sendDiscordInvite(player, (String)inviteCode);
                        if (sent) {
                            this.playerManager.markDiscordConnected(playerName);
                            this.logger.debug("Sent dynamic invite to: " + playerName + " with role " + role.getName() + " (max uses: " + maxUses + ", expires in: " + expirationHours + " hours)");
                        }
                    }, error -> {
                        boolean sent;
                        this.logger.warning("Failed to create dynamic invite for " + playerName + ": " + error.getMessage());
                        String fallbackInvite = this.inviteManager.getDiscordInviteUrl(null);
                        if (fallbackInvite != null && (sent = this.discordService.sendDiscordInvite(player, fallbackInvite))) {
                            this.playerManager.markDiscordConnected(playerName);
                            this.logger.debug("Sent fallback permanent invite to: " + playerName);
                        }
                    });
                }
            } else {
                boolean sent;
                String inviteUrl = this.inviteManager.getDiscordInviteUrl(null);
                if (inviteUrl != null && (sent = this.discordService.sendDiscordInvite(player, inviteUrl))) {
                    this.playerManager.markDiscordConnected(playerName);
                    this.logger.debug("Sent permanent invite to: " + playerName);
                }
            }
        } else if (!autoSendInvites) {
            this.logger.debug("Automatic Discord invites are disabled. No invite sent to: " + playerName);
        }
        return true;
    }

    @EventMethod
    public void onPlayerConnect(PlayerConnectEvent event) {
        if (this.isShuttingDown.get()) {
            return;
        }
        Player player = event.getPlayer();
        String playerName = player.getName();
        String playerNameLower = playerName.toLowerCase();
        String uid = player.getUID().toString();
        if (this.connectionLogger != null) {
            this.connectionLogger.logPlayerConnect(playerName, uid);
        }
        this.playerManager.handlePlayerConnect(player);
        boolean welcomeEnabled = this.configManager.getConfigBoolean(this.config, "player.welcome.message.enabled", true);
        if (welcomeEnabled) {
            String welcomeMessage = this.configManager.getConfigString(this.config, "player.welcome.message", "Welcome to the server, %player%!");
            welcomeMessage = welcomeMessage.replace("%player%", playerName);
            player.sendTextMessage(welcomeMessage);
        }
        int warningCount = 0;
        if (this.playerHistoryManager != null && (warningCount = this.playerHistoryManager.getWarningCount(playerName)) > 0) {
            player.sendTextMessage("\u00a7cNote: You have " + warningCount + " warning(s) on record.");
        }
        this.handleinvites(event);
        this.delayedStatusUpdate();
        if (this.discordService != null && this.discordService.getAdminChannel() != null && !this.isShuttingDown.get()) {
            try {
                this.sendPlayerJoinMessage(playerName, playerNameLower);
            }
            catch (Exception e) {
                this.logger.severe("Error sending player join message: " + e.getMessage(), e);
            }
        }
    }

    @EventMethod
    public void onPlayerDisconnect(PlayerDisconnectEvent event) {
        if (this.isShuttingDown.get()) {
            return;
        }
        Player player = event.getPlayer();
        String playerName = player.getName();
        String playerNameLower = playerName.toLowerCase();
        String uid = player.getUID().toString();
        if (this.connectionLogger != null) {
            this.connectionLogger.logPlayerDisconnect(playerName, uid);
        }
        this.playerManager.handlePlayerDisconnect(player);
        this.delayedStatusUpdate();
        if (!this.isShuttingDown.get() && this.discordService != null && this.discordService.getAdminChannel() != null) {
            this.sendPlayerLeaveMessage(playerName, playerNameLower);
        }
    }

    private void sendPlayerLeaveMessage(String playerName, String playerNameLower) {
        String leaveMessage = this.playerLeaveFormat.replace("%player%", playerName);
        leaveMessage = leaveMessage.replace("%playercount%", String.valueOf(Server.getPlayerCount() - 1));
        leaveMessage = leaveMessage.replace("%totalplayers%", String.valueOf(Server.getTotalPlayerCount()));
        this.discordService.getAdminChannel().sendMessage((CharSequence)leaveMessage).queue(leaveMsg -> {
            List leaveMessages = this.playerLeaveMessages.computeIfAbsent(playerNameLower, k -> new ArrayList());
            leaveMessages.add(leaveMsg);
            if (this.messagePersistence != null) {
                this.messagePersistence.saveMessage("leave", playerName, (Message)leaveMsg);
                this.logger.debug("Persisted leave message for " + playerName);
            }
            try {
                List<Message> joinMessages;
                if ("always".equals(this.messageDeleteMode) && (joinMessages = this.playerJoinMessages.get(playerNameLower)) != null && !joinMessages.isEmpty()) {
                    ArrayList<Message> messagesToDelete = new ArrayList<Message>(joinMessages);
                    for (Message joinMessage : messagesToDelete) {
                        joinMessage.delete().queue(success -> {
                            this.logger.debug("Deleted join message for: " + playerName);
                            joinMessages.remove(joinMessage);
                            if (this.messagePersistence != null) {
                                this.messagePersistence.removeSpecificMessage("join", playerName, joinMessage.getId());
                            }
                        }, error -> {
                            ErrorResponseException ere;
                            this.logger.debug("Failed to delete join message for " + playerName + ": " + error.getMessage());
                            if (error instanceof ErrorResponseException && (ere = (ErrorResponseException)error).getErrorCode() == 10008) {
                                joinMessages.remove(joinMessage);
                                if (this.messagePersistence != null) {
                                    this.messagePersistence.removeSpecificMessage("join", playerName, joinMessage.getId());
                                }
                            }
                        });
                    }
                    if (joinMessages.isEmpty()) {
                        this.playerJoinMessages.remove(playerNameLower);
                    }
                }
            }
            catch (Exception e) {
                this.logger.debug("Failed to delete join messages for " + playerName + ": " + e.getMessage());
            }
            if ("always".equals(this.messageDeleteMode) && this.enhancedScheduler != null && this.messageDeleteDelay > 0) {
                ScheduledFuture<?> deletionTask = this.enhancedScheduler.scheduleDelayedTask(() -> {
                    try {
                        leaveMsg.delete().queue(success -> {
                            this.logger.debug("Successfully deleted scheduled leave message for " + playerName);
                            List<Message> messages = this.playerLeaveMessages.get(playerNameLower);
                            if (messages != null) {
                                messages.remove(leaveMsg);
                                if (messages.isEmpty()) {
                                    this.playerLeaveMessages.remove(playerNameLower);
                                }
                            }
                            if (this.messagePersistence != null) {
                                this.messagePersistence.removeSpecificMessage("leave", playerName, leaveMsg.getId());
                            }
                        }, error -> {
                            ErrorResponseException ere;
                            this.logger.debug("Failed to delete leave message for " + playerName + ": " + error.getMessage());
                            if (error instanceof ErrorResponseException && (ere = (ErrorResponseException)error).getErrorCode() == 10008) {
                                List<Message> messages = this.playerLeaveMessages.get(playerNameLower);
                                if (messages != null) {
                                    messages.remove(leaveMsg);
                                    if (messages.isEmpty()) {
                                        this.playerLeaveMessages.remove(playerNameLower);
                                    }
                                }
                                if (this.messagePersistence != null) {
                                    this.messagePersistence.removeSpecificMessage("leave", playerName, leaveMsg.getId());
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        this.logger.debug("Failed to schedule deletion of leave message for " + playerName + ": " + e.getMessage());
                    }
                }, this.messageDeleteDelay, TimeUnit.SECONDS);
                this.pendingMessageDeletions.add(deletionTask);
            }
        }, error -> this.logger.warning("Failed to send leave message for " + playerName + ": " + error.getMessage()));
    }

    @EventMethod
    public void onMessageReceived(MessageReceivedEvent event) {
        if (event.getAuthor().isBot() || this.discordService.getAdminChannel() == null || !event.getChannel().getId().equals(this.discordService.getAdminChannel().getId())) {
            return;
        }
        if (this.relayDiscordToGame && !event.getMessage().getContentRaw().startsWith("/")) {
            String author = event.getAuthor().getName();
            String content = event.getMessage().getContentRaw();
            if (this.chatFilter != null && this.chatFilter.isEnabled()) {
                content = this.chatFilter.filterMessage(content);
            }
            String formattedMessage = this.discordToGameFormat.replace("%author%", author).replace("%message%", content);
            Server.broadcastTextMessage(formattedMessage);
        }
    }

    @EventMethod
    public void onPlayerChat(PlayerChatEvent event) {
        if (this.discordService == null || !this.relayGameChatToDiscord) {
            return;
        }
        Player player = event.getPlayer();
        String message = event.getChatMessage();
        String formattedMessage = this.gameToDiscordFormat.replace("%player%", player.getName()).replace("%message%", message);
        this.discordService.sendChatMessage(formattedMessage);
    }

    @EventMethod
    public void onPlayerCommand(PlayerCommandEvent event) {
        if (this.discordService == null) {
            return;
        }
        Player player = event.getPlayer();
    }

    private void delayedStatusUpdate() {
        if (this.isShuttingDown.get() || this.statusManager == null) {
            return;
        }
        if (this.enhancedScheduler != null) {
            this.enhancedScheduler.scheduleDelayedTask(() -> this.statusManager.updatePlayerStatus(), 1L, TimeUnit.SECONDS);
        } else {
            new Thread(() -> {
                try {
                    Thread.sleep(1000L);
                    this.statusManager.updatePlayerStatus();
                }
                catch (Exception e) {
                    this.logger.log(Level.WARNING, "Error in delayed status update", e);
                }
            }).start();
        }
    }

    public boolean checkRequiredDependencies() {
        try {
            Class.forName("gnu.trove.map.TLongObjectMap");
            Class.forName("net.dv8tion.jda.api.JDA");
            return true;
        }
        catch (ClassNotFoundException e) {
            this.logger.warning("Missing required dependency: " + e.getMessage());
            return false;
        }
    }

    @Override
    public String getName() {
        return "Discord Admin Integration";
    }

    public String getVersion() {
        return "3.7.2";
    }

    public String getDescription() {
        return "Integrates Rising World admin commands with Discord";
    }

    public String getAuthor() {
        return "Devyn";
    }
}

