/*
 * Decompiled with CFR 0.152.
 */
package com.example.risingworld.discordadmin;

import com.example.risingworld.discordadmin.ConfigManager;
import com.example.risingworld.discordadmin.PluginLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import net.dv8tion.jda.api.entities.Message;
import net.risingworld.api.Server;
import net.risingworld.api.objects.Player;

public class PlayerManager {
    private final String pluginPath;
    private final PluginLogger logger;
    private final ConfigManager configManager;
    private final ConcurrentHashMap<String, String> discordToGameMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> playerNameToUidMap = new ConcurrentHashMap();
    private final Map<String, Boolean> playerDiscordConnected = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, Long> connectionTimes = new ConcurrentHashMap<String, Long>();
    private final ConcurrentHashMap<String, Message> playerJoinMessages = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Message> playerLeaveMessages = new ConcurrentHashMap();
    private static final String DISCORD_CONNECTED_FILENAME = "discord_connected_players.properties";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public PlayerManager(String pluginPath, PluginLogger logger, ConfigManager configManager) {
        this.pluginPath = pluginPath;
        this.logger = logger;
        this.configManager = configManager;
        this.loadPlayerData();
    }

    private void loadPlayerData() {
        this.configManager.loadDiscordMappings(this.discordToGameMap);
        this.configManager.loadPlayerUidMappings(this.playerNameToUidMap);
        this.loadDiscordConnectedPlayers();
    }

    public void loadDiscordConnectedPlayers() {
        Properties connectedPlayers = this.configManager.getMigrationManager().loadAndMigrateConfig(DISCORD_CONNECTED_FILENAME, "connected_players", true, this::createEmptyConnectedPlayersFile);
        for (String key : connectedPlayers.stringPropertyNames()) {
            if (key.equals("config.version")) continue;
            boolean connected = Boolean.parseBoolean(connectedPlayers.getProperty(key, "false"));
            this.playerDiscordConnected.put(key.toLowerCase(), connected);
        }
        this.logger.debug("Loaded " + this.playerDiscordConnected.size() + " Discord connection records.");
    }

    private void createEmptyConnectedPlayersFile(Properties properties, File file) {
        try {
            file.getParentFile().mkdirs();
            try (FileOutputStream fos = new FileOutputStream(file);){
                properties.store(fos, "Players Connected to Discord");
                this.logger.debug("Empty discord_connected_players.properties file created.");
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error creating discord_connected_players.properties file", e);
        }
    }

    public void saveDiscordConnectedPlayers() {
        Properties connectedPlayers = new Properties();
        for (String key : this.playerDiscordConnected.keySet()) {
            connectedPlayers.setProperty(key, String.valueOf(this.playerDiscordConnected.get(key)));
        }
        this.configManager.getMigrationManager().saveConfig(connectedPlayers, DISCORD_CONNECTED_FILENAME, "Players Connected to Discord");
    }

    public void handlePlayerConnect(Player player) {
        if (player == null) {
            return;
        }
        String playerName = player.getName();
        String uid = player.getUID().toString();
        String playerNameLower = playerName.toLowerCase();
        this.playerNameToUidMap.put(playerNameLower, uid);
        this.configManager.savePlayerUidMappings(this.playerNameToUidMap);
        this.connectionTimes.put(playerNameLower, System.currentTimeMillis());
        this.logger.info("Player connected: " + playerName);
        this.logger.debug("Player connected: " + playerName + " (UID: " + uid + ")");
    }

    public void handlePlayerDisconnect(Player player) {
        if (player == null) {
            return;
        }
        String playerName = player.getName();
        String uid = player.getUID().toString();
        String playerNameLower = playerName.toLowerCase();
        Long connectTime = this.connectionTimes.remove(playerNameLower);
        if (connectTime != null) {
            long sessionDuration = System.currentTimeMillis() - connectTime;
            this.logger.info("Player disconnected: " + playerName);
            this.logger.debug("Player disconnected: " + playerName + " (UID: " + uid + ") - Session duration: " + this.formatDuration(sessionDuration));
        } else {
            this.logger.info("Player disconnected: " + playerName);
            this.logger.debug("Player disconnected: " + playerName + " (UID: " + uid + ")");
        }
    }

    private String formatDuration(long milliseconds) {
        long seconds = milliseconds / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        minutes %= 60L;
        seconds %= 60L;
        StringBuilder sb = new StringBuilder();
        if (hours > 0L) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0L || hours > 0L) {
            sb.append(minutes).append("m ");
        }
        sb.append(seconds).append("s");
        return sb.toString();
    }

    public void storeJoinMessage(String playerName, Message message) {
        if (playerName != null && message != null) {
            this.playerJoinMessages.put(playerName.toLowerCase(), message);
        }
    }

    public void storeLeaveMessage(String playerName, Message message) {
        if (playerName != null && message != null) {
            this.playerLeaveMessages.put(playerName.toLowerCase(), message);
        }
    }

    public void clearDiscordMessages(String playerName) {
        Message leaveMessage;
        if (playerName == null) {
            return;
        }
        String playerNameLower = playerName.toLowerCase();
        Message joinMessage = this.playerJoinMessages.remove(playerNameLower);
        if (joinMessage != null) {
            joinMessage.delete().queue();
        }
        if ((leaveMessage = this.playerLeaveMessages.remove(playerNameLower)) != null) {
            leaveMessage.delete().queue();
        }
    }

    public void markDiscordConnected(String playerName) {
        if (playerName != null) {
            this.playerDiscordConnected.put(playerName.toLowerCase(), true);
            this.saveDiscordConnectedPlayers();
        }
    }

    public boolean resetDiscordConnection(String playerName) {
        if (playerName == null) {
            return false;
        }
        String playerNameLower = playerName.toLowerCase();
        if (this.playerDiscordConnected.containsKey(playerNameLower)) {
            this.playerDiscordConnected.put(playerNameLower, false);
            this.saveDiscordConnectedPlayers();
            return true;
        }
        return false;
    }

    public boolean hasDiscordConnection(String playerName) {
        if (playerName == null) {
            return false;
        }
        Boolean connected = this.playerDiscordConnected.get(playerName.toLowerCase());
        return connected != null && connected != false;
    }

    public Player getPlayer(String playerName) {
        if (playerName == null) {
            return null;
        }
        return Server.getPlayerByName(playerName);
    }

    public String getPlayerUid(String playerName) {
        if (playerName == null) {
            return null;
        }
        return this.playerNameToUidMap.get(playerName.toLowerCase());
    }

    public void linkDiscordAccount(String discordId, String playerName) {
        if (discordId != null && playerName != null) {
            this.discordToGameMap.put(discordId, playerName);
            this.configManager.saveDiscordMappings(this.discordToGameMap);
            this.logger.debug("Linked Discord account " + discordId + " to game username: " + playerName);
        }
    }

    public String getLinkedGameAccount(String discordId) {
        if (discordId == null) {
            return null;
        }
        return this.discordToGameMap.get(discordId);
    }

    public boolean banPlayer(String playerName, String reason, int duration) {
        if (playerName == null) {
            return false;
        }
        Player player = Server.getPlayerByName(playerName);
        if (player != null) {
            String uid = player.getUID().toString();
            this.playerNameToUidMap.put(playerName.toLowerCase(), uid);
            this.configManager.savePlayerUidMappings(this.playerNameToUidMap);
            try {
                if (duration > 0) {
                    player.ban(reason, duration * 60);
                    this.logger.info("Banned player: " + playerName + " for " + duration + " minutes. Reason: " + reason);
                } else {
                    player.ban(reason);
                    this.logger.info("Permanently banned player: " + playerName + ". Reason: " + reason);
                }
                return true;
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error banning player: " + playerName, e);
                return false;
            }
        }
        String uid = this.playerNameToUidMap.get(playerName.toLowerCase());
        if (uid != null) {
            if (!uid.matches("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}")) {
                this.logger.warning("Invalid UID format for player: " + playerName + ", UID: " + uid);
                return false;
            }
            try {
                if (duration > 0) {
                    Server.banPlayer(uid, reason, duration * 60);
                    this.logger.info("Banned offline player: " + playerName + " for " + duration + " minutes. Reason: " + reason);
                } else {
                    Server.banPlayer(uid, reason, -1);
                    this.logger.info("Permanently banned offline player: " + playerName + ". Reason: " + reason);
                }
                return true;
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error banning offline player: " + playerName, e);
                return false;
            }
        }
        this.logger.warning("Could not ban player: " + playerName + " - Player not found in mapping database");
        return false;
    }

    public boolean unbanPlayer(String playerName) {
        if (playerName == null) {
            return false;
        }
        String uid = this.playerNameToUidMap.get(playerName.toLowerCase());
        if (uid != null) {
            Server.unbanPlayer(uid);
            this.logger.info("Unbanned player: " + playerName);
            return true;
        }
        return false;
    }

    public boolean kickPlayer(String playerName, String reason) {
        if (playerName == null) {
            return false;
        }
        Player player = Server.getPlayerByName(playerName);
        if (player != null) {
            player.kick(reason);
            this.logger.info("Kicked player: " + playerName + " for: " + reason);
            return true;
        }
        return false;
    }

    public boolean setPlayerAdmin(String playerName, boolean isAdmin) {
        if (playerName == null) {
            return false;
        }
        Player player = Server.getPlayerByName(playerName);
        if (player != null) {
            player.setAdmin(isAdmin);
            player.setPermissionGroup(isAdmin ? "admin" : "default");
            this.logger.info((isAdmin ? "Promoted " : "Demoted ") + playerName + (isAdmin ? " to admin" : " from admin"));
            return true;
        }
        return false;
    }

    public void saveAll() {
        this.configManager.saveDiscordMappings(this.discordToGameMap);
        this.configManager.savePlayerUidMappings(this.playerNameToUidMap);
        this.saveDiscordConnectedPlayers();
        this.logger.debug("Saved all player data to disk");
    }

    public Player[] getOnlinePlayers() {
        return Server.getAllPlayers();
    }

    public int getOnlinePlayerCount() {
        return Server.getPlayerCount();
    }

    public Map<String, String> getDiscordToGameMappings() {
        return this.discordToGameMap;
    }
}

