/*
 * Decompiled with CFR 0.152.
 */
package com.example.risingworld.discordadmin;

import com.example.risingworld.discordadmin.FileUtils;
import com.example.risingworld.discordadmin.PluginLogger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class FileUtilsTester {
    private final PluginLogger logger;
    private final String pluginPath;
    private final List<String> results = new ArrayList<String>();

    public FileUtilsTester(PluginLogger logger, String pluginPath) {
        this.logger = logger;
        this.pluginPath = pluginPath;
    }

    public boolean runTests() {
        this.logger.info("Running FileUtils tests");
        boolean allPassed = true;
        this.results.clear();
        try {
            if (!this.testCreateDirectoryWithNullParent()) {
                allPassed = false;
            }
            if (!this.testCreateParentDirectories()) {
                allPassed = false;
            }
            if (!this.testCreateEmptyFile()) {
                allPassed = false;
            }
            if (!this.testCreateDeepDirectoryStructure()) {
                allPassed = false;
            }
            if (!this.testPathResolution()) {
                allPassed = false;
            }
            this.saveTestResults();
            return allPassed;
        }
        catch (Exception e) {
            this.logger.severe("FileUtils tests failed with exception", e);
            return false;
        }
    }

    private boolean testCreateDirectoryWithNullParent() {
        try {
            File file = new File("test_file.txt");
            boolean result = FileUtils.ensureParentDirectoryExists(file);
            if (result) {
                this.results.add("\u2713 Test 1: Handling file with null parent - PASSED");
                return true;
            }
            this.results.add("\u2717 Test 1: Handling file with null parent - FAILED (returned false)");
            return false;
        }
        catch (Exception e) {
            this.results.add("\u2717 Test 1: Handling file with null parent - FAILED (" + e.getMessage() + ")");
            return false;
        }
    }

    private boolean testCreateParentDirectories() {
        try {
            File testDir = new File(this.pluginPath, "tests/parent/child");
            boolean result = FileUtils.ensureDirectoryExists(testDir);
            if (result && testDir.exists() && testDir.isDirectory()) {
                this.results.add("\u2713 Test 2: Creating parent directories - PASSED");
                return true;
            }
            this.results.add("\u2717 Test 2: Creating parent directories - FAILED (directory not created)");
            return false;
        }
        catch (Exception e) {
            this.results.add("\u2717 Test 2: Creating parent directories - FAILED (" + e.getMessage() + ")");
            return false;
        }
    }

    private boolean testCreateEmptyFile() {
        try {
            File testFile = new File(this.pluginPath, "tests/test_file.txt");
            boolean result = FileUtils.createEmptyFile(testFile, this.logger);
            if (result && testFile.exists() && testFile.isFile()) {
                this.results.add("\u2713 Test 3: Creating empty file - PASSED");
                return true;
            }
            this.results.add("\u2717 Test 3: Creating empty file - FAILED (file not created)");
            return false;
        }
        catch (Exception e) {
            this.results.add("\u2717 Test 3: Creating empty file - FAILED (" + e.getMessage() + ")");
            return false;
        }
    }

    private boolean testCreateDeepDirectoryStructure() {
        try {
            File testFile = new File(this.pluginPath, "tests/deep/nested/directory/structure/test.txt");
            boolean parentCreated = FileUtils.ensureParentDirectoryExists(testFile);
            boolean fileCreated = false;
            if (parentCreated) {
                try (FileWriter writer = new FileWriter(testFile);){
                    writer.write("Test content");
                    fileCreated = true;
                }
                catch (IOException e) {
                    fileCreated = false;
                }
            }
            if (parentCreated && fileCreated && testFile.exists()) {
                this.results.add("\u2713 Test 4: Deep directory structure - PASSED");
                return true;
            }
            this.results.add("\u2717 Test 4: Deep directory structure - FAILED" + (parentCreated ? "" : " (parent not created)") + (fileCreated ? "" : " (file not created)"));
            return false;
        }
        catch (Exception e) {
            this.results.add("\u2717 Test 4: Deep directory structure - FAILED (" + e.getMessage() + ")");
            return false;
        }
    }

    private boolean testPathResolution() {
        try {
            File resolved = FileUtils.resolveFile(this.pluginPath, "configs/test.txt");
            String expected = new File(this.pluginPath, "configs/test.txt").getAbsolutePath();
            String actual = resolved.getAbsolutePath();
            if (expected.equals(actual)) {
                this.results.add("\u2713 Test 5: Path resolution - PASSED");
                return true;
            }
            this.results.add("\u2717 Test 5: Path resolution - FAILED (expected: " + expected + ", actual: " + actual + ")");
            return false;
        }
        catch (Exception e) {
            this.results.add("\u2717 Test 5: Path resolution - FAILED (" + e.getMessage() + ")");
            return false;
        }
    }

    private void saveTestResults() {
        try {
            File resultsFile = new File(this.pluginPath, "tests/file_utils_test_results.txt");
            FileUtils.ensureParentDirectoryExists(resultsFile);
            try (FileWriter writer = new FileWriter(resultsFile);){
                writer.write("FileUtils Test Results\n");
                writer.write("=====================\n\n");
                for (String result : this.results) {
                    writer.write(result + "\n");
                }
                writer.write("\nTests completed at: " + String.valueOf(new Date()));
            }
            this.logger.info("Test results saved to: " + resultsFile.getAbsolutePath());
        }
        catch (Exception e) {
            this.logger.warning("Failed to save test results: " + e.getMessage());
        }
    }

    public void cleanup() {
        try {
            File testDir = new File(this.pluginPath, "tests");
            if (testDir.exists()) {
                this.deleteRecursively(testDir);
                this.logger.info("Test files cleaned up");
            }
        }
        catch (Exception e) {
            this.logger.warning("Failed to clean up test files: " + e.getMessage());
        }
    }

    private boolean deleteRecursively(File file) {
        File[] children;
        if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (File child : children) {
                this.deleteRecursively(child);
            }
        }
        return file.delete();
    }
}

