/*
 * Decompiled with CFR 0.152.
 */
package com.example.risingworld.discordadmin;

import com.example.risingworld.discordadmin.PluginLogger;
import com.example.risingworld.discordadmin.StatusManager;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class EnhancedScheduler {
    private final ScheduledThreadPoolExecutor scheduler;
    private final PluginLogger logger;
    private final StatusManager statusManager;
    private static final int CORE_POOL_SIZE = 2;
    private static final long KEEP_ALIVE_TIME = 60L;
    private static final int MAX_TASK_FAILURES = 3;

    public EnhancedScheduler(final PluginLogger logger, StatusManager statusManager) {
        this.logger = logger;
        this.statusManager = statusManager;
        this.scheduler = new ScheduledThreadPoolExecutor(2, new ThreadFactory(){
            private final AtomicInteger threadCounter = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "DiscordAdmin-Scheduler-" + this.threadCounter.getAndIncrement());
                thread.setDaemon(true);
                thread.setPriority(5);
                thread.setUncaughtExceptionHandler((t, e) -> logger.log(Level.SEVERE, "Uncaught exception in scheduler thread", e));
                return thread;
            }
        });
        this.scheduler.setKeepAliveTime(60L, TimeUnit.SECONDS);
        this.scheduler.allowCoreThreadTimeOut(true);
        this.scheduler.setRemoveOnCancelPolicy(true);
        this.scheduler.setRejectedExecutionHandler((r, executor) -> logger.warning("Task submission rejected. Queue might be full."));
    }

    public ScheduledFuture<?> scheduleStatusUpdates(int intervalMinutes) {
        this.logger.info("Scheduling status updates every " + intervalMinutes + " minutes");
        if (intervalMinutes < 1) {
            intervalMinutes = 10;
            this.logger.warning("Invalid status update interval, using default of 10 minutes");
        }
        if (this.statusManager == null) {
            this.logger.severe("Cannot schedule status updates: StatusManager is null");
            return null;
        }
        int interval = intervalMinutes;
        AtomicInteger failures = new AtomicInteger(0);
        try {
            ScheduledFuture<?> future = this.scheduler.scheduleAtFixedRate(() -> {
                this.logger.fine("Executing scheduled status update");
                try {
                    this.statusManager.updatePlayerStatus();
                    failures.set(0);
                    this.logger.fine("Status update completed successfully");
                }
                catch (Exception e) {
                    int currentFailures = failures.incrementAndGet();
                    if (currentFailures >= 3) {
                        this.logger.severe("Status update failed " + currentFailures + " times in a row. Reinitializing status manager.");
                        this.statusManager.initialize();
                    }
                    this.logger.log(Level.WARNING, "Error during scheduled status update (failure " + currentFailures + " of 3)", e);
                }
            }, 1L, interval, TimeUnit.MINUTES);
            this.logger.info("Status update task scheduled successfully");
            return future;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to schedule status updates", e);
            return null;
        }
    }

    public ScheduledFuture<?> scheduleDelayedTask(Runnable task, long delay, TimeUnit unit) {
        return this.scheduler.schedule(() -> {
            try {
                task.run();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error in delayed task", e);
            }
        }, delay, unit);
    }

    public ScheduledFuture<?> scheduleWithRetry(Callable<Boolean> task, int maxRetries, long initialDelay, long retryDelay, TimeUnit unit) {
        AtomicInteger retries = new AtomicInteger(0);
        return this.scheduler.schedule(new RetryCallable(task, retries, maxRetries, retryDelay, unit), initialDelay, unit);
    }

    public <T> T executeWithTimeout(Callable<T> task, long timeout, TimeUnit unit) {
        Future<T> future = this.scheduler.submit(task);
        try {
            return future.get(timeout, unit);
        }
        catch (TimeoutException e) {
            this.logger.warning("Task timed out after " + timeout + " " + unit.toString().toLowerCase());
            future.cancel(true);
            return null;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error in task with timeout", e);
            return null;
        }
    }

    public int getActiveThreadCount() {
        return this.scheduler.getActiveCount();
    }

    public long getQueuedTaskCount() {
        return this.scheduler.getTaskCount() - this.scheduler.getCompletedTaskCount();
    }

    public void shutdown() {
        try {
            this.logger.info("Initiating scheduler shutdown...");
            this.scheduler.shutdown();
            if (!this.scheduler.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
                if (!this.scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.logger.warning("Scheduler did not terminate cleanly");
                }
            }
            this.logger.info("Scheduler shutdown completed");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.warning("Scheduler shutdown was interrupted");
            this.scheduler.shutdownNow();
        }
    }

    private class RetryCallable
    implements Callable<Void> {
        private final Callable<Boolean> task;
        private final AtomicInteger retries;
        private final int maxRetries;
        private final long retryDelay;
        private final TimeUnit unit;

        public RetryCallable(Callable<Boolean> task, AtomicInteger retries, int maxRetries, long retryDelay, TimeUnit unit) {
            this.task = task;
            this.retries = retries;
            this.maxRetries = maxRetries;
            this.retryDelay = retryDelay;
            this.unit = unit;
        }

        @Override
        public Void call() {
            block3: {
                try {
                    boolean success = this.task.call();
                    if (!success && this.retries.incrementAndGet() <= this.maxRetries) {
                        EnhancedScheduler.this.logger.info("Task failed, scheduling retry " + this.retries.get() + " of " + this.maxRetries);
                        EnhancedScheduler.this.scheduler.schedule(this, this.retryDelay, this.unit);
                    }
                }
                catch (Exception e) {
                    EnhancedScheduler.this.logger.log(Level.SEVERE, "Error in retryable task", e);
                    if (this.retries.incrementAndGet() > this.maxRetries) break block3;
                    EnhancedScheduler.this.logger.info("Scheduling retry " + this.retries.get() + " of " + this.maxRetries + " after exception");
                    EnhancedScheduler.this.scheduler.schedule(this, this.retryDelay, this.unit);
                }
            }
            return null;
        }
    }
}

