/*
 * Decompiled with CFR 0.152.
 */
package com.example.risingworld.discordadmin;

import com.example.risingworld.discordadmin.ConfigFormatVerifier;
import com.example.risingworld.discordadmin.ConfigMigrationManager;
import com.example.risingworld.discordadmin.FileUtils;
import com.example.risingworld.discordadmin.PluginLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigManager {
    private final String pluginPath;
    private final PluginLogger logger;
    private final ConfigMigrationManager migrationManager;
    private final ConfigFormatVerifier formatVerifier;
    private final Map<String, Map<String, Integer>> propertyLineMap = new LinkedHashMap<String, Map<String, Integer>>();
    private final Map<String, String[]> fileContentsCache = new LinkedHashMap<String, String[]>();

    public ConfigManager(String pluginPath, PluginLogger logger) {
        this.pluginPath = pluginPath;
        this.logger = logger;
        this.migrationManager = new ConfigMigrationManager(pluginPath, logger);
        this.migrationManager.setConfigManager(this);
        this.formatVerifier = new ConfigFormatVerifier(logger, pluginPath);
    }

    public boolean checkAndFixConfigFormatting(Properties config) {
        if (this.formatVerifier != null) {
            return this.formatVerifier.verifyAndFixConfigFormatting(config);
        }
        return false;
    }

    public Properties loadMainConfig() {
        Properties config = this.loadConfigWithStructure("config.properties", "main", true, this::createDefaultConfig);
        if (this.checkAndFixConfigFormatting(config)) {
            this.logger.info("Restored formatting in config.properties file");
        }
        return config;
    }

    public Properties loadConfigWithStructure(String filename, String configType, boolean createDefaultIfMissing, BiConsumer<Properties, File> defaultCreator) {
        Properties config = this.migrationManager.loadAndMigrateConfig(filename, configType, createDefaultIfMissing, defaultCreator);
        this.cacheFileStructure(filename);
        return config;
    }

    private void cacheFileStructure(String filename) {
        File configFile = new File(this.pluginPath, filename);
        if (!configFile.exists()) {
            return;
        }
        try {
            String content = new String(Files.readAllBytes(configFile.toPath()));
            String[] lines = content.split("\\r?\\n");
            this.fileContentsCache.put(filename, lines);
            LinkedHashMap<String, Integer> lineMap = new LinkedHashMap<String, Integer>();
            Pattern propertyPattern = Pattern.compile("^\\s*([^#=\\s][^=]*?)\\s*=\\s*(.*)$");
            for (int i = 0; i < lines.length; ++i) {
                Matcher matcher = propertyPattern.matcher(lines[i]);
                if (!matcher.matches()) continue;
                String key = matcher.group(1);
                lineMap.put(key, i);
            }
            this.propertyLineMap.put(filename, lineMap);
            this.logger.debug("Cached structure of " + filename + " with " + lineMap.size() + " properties");
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Failed to cache file structure for " + filename, e);
        }
    }

    public void saveConfigPreservingStructure(Properties config, String filename, String comment) {
        File configFile = new File(this.pluginPath + File.separator + filename);
        if (!FileUtils.ensureParentDirectoryExists(configFile)) {
            this.logger.severe("Failed to create parent directory for: " + configFile.getAbsolutePath());
            return;
        }
        if (!this.fileContentsCache.containsKey(filename) || !this.propertyLineMap.containsKey(filename)) {
            this.saveConfigSimple(config, configFile, comment);
            return;
        }
        try {
            File backupFile = new File(configFile.getParentFile(), configFile.getName() + ".bak");
            if (configFile.exists()) {
                Files.copy(configFile.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            String[] lines = this.fileContentsCache.get(filename);
            Map<String, Integer> lineMap = this.propertyLineMap.get(filename);
            String[] updatedLines = (String[])lines.clone();
            for (Map.Entry<Object, Object> entry : config.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                if (key.equals("config.version")) continue;
                if (lineMap.containsKey(key)) {
                    int lineNumber = lineMap.get(key);
                    updatedLines[lineNumber] = key + "=" + value;
                    continue;
                }
                for (int lastLine = updatedLines.length - 1; lastLine >= 0 && updatedLines[lastLine].trim().isEmpty(); --lastLine) {
                }
                String[] newLines = new String[updatedLines.length + 1];
                System.arraycopy(updatedLines, 0, newLines, 0, updatedLines.length);
                newLines[updatedLines.length] = key + "=" + value;
                updatedLines = newLines;
            }
            try (FileWriter writer = new FileWriter(configFile);){
                for (String line : updatedLines) {
                    writer.write(line + System.lineSeparator());
                }
            }
            this.logger.info("Configuration saved with preserved structure: " + filename);
            this.fileContentsCache.put(filename, updatedLines);
            this.cacheFileStructure(filename);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error saving configuration with preserved structure: " + filename, e);
            this.saveConfigSimple(config, configFile, comment);
        }
    }

    private void saveConfigSimple(Properties config, File configFile, String comment) {
        try (FileOutputStream fos = new FileOutputStream(configFile);){
            config.store(fos, comment);
            this.logger.info("Configuration saved (without structure preservation): " + configFile.getName());
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Error saving configuration: " + configFile.getName(), e);
        }
    }

    public void saveConfig(Properties config, String filename, String comment) {
        try {
            this.saveConfigPreservingStructure(config, filename, comment);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error in saveConfig", e);
            File configFile = new File(this.pluginPath, filename);
            this.saveConfigSimple(config, configFile, comment);
        }
    }

    private void createDefaultConfig(Properties config, File configFile) {
        try {
            if (!FileUtils.ensureParentDirectoryExists(configFile)) {
                this.logger.warning("Failed to create parent directories for config file. Using current directory instead.");
            }
            FileUtils.createEmptyFile(configFile, this.logger);
            try (FileWriter writer = new FileWriter(configFile);){
                writer.write("# Discord Admin Plugin Configuration v3.7\n");
                writer.write("# This file contains all configuration settings for the Discord Admin Plugin.\n");
                writer.write("# Settings are grouped by function for easier navigation.\n\n");
                writer.write("# =========================================================================\n");
                writer.write("# Discord Bot Configuration\n");
                writer.write("# =========================================================================\n");
                writer.write("# Required settings for Discord bot functionality\n");
                writer.write("# Your Discord bot token (required) - Get this from the Discord Developer Portal\n");
                writer.write("discord.token=\n\n");
                writer.write("# Discord channel ID for admin communications (required)\n");
                writer.write("discord.admin.channel=\n\n");
                writer.write("# Bot activity status shown in Discord (e.g. \"Watching Rising World\")\n");
                writer.write("discord.bot.activity=Watching Rising World\n\n");
                writer.write("# =========================================================================\n");
                writer.write("# Chat Relay Settings\n");
                writer.write("# =========================================================================\n");
                writer.write("# Configure communication between Discord and the game\n\n");
                writer.write("# Enable chat relay from game to Discord\n");
                writer.write("chat.relay.game_to_discord=true\n\n");
                writer.write("# Enable chat relay from Discord to game\n");
                writer.write("chat.relay.discord_to_game=true\n\n");
                writer.write("# Format for messages sent from Discord to game\n");
                writer.write("# Available placeholders: %author%, %message%\n");
                writer.write("chat.format.discord_to_game=[Discord] %author%: %message%\n\n");
                writer.write("# Format for messages sent from game to Discord\n");
                writer.write("# Available placeholders: %player%, %message%\n");
                writer.write("chat.format.game_to_discord=[Game] %player%: %message%\n\n");
                writer.write("# =========================================================================\n");
                writer.write("# Chat Filter Settings\n");
                writer.write("# =========================================================================\n");
                writer.write("# Configure filtering of inappropriate content in chat\n\n");
                writer.write("# Enable the chat filter (true/false)\n");
                writer.write("chat.filter.enabled=false\n\n");
                writer.write("# Comma-separated list of words to filter from chat\n");
                writer.write("chat.filter.words=badword1,badword2\n\n");
                writer.write("# =========================================================================\n");
                writer.write("# Server Status Display Settings\n");
                writer.write("# =========================================================================\n");
                writer.write("# Configure how server status is displayed in Discord\n\n");
                writer.write("# Enable automatic status updates\n");
                writer.write("status.updates.enabled=true\n\n");
                writer.write("# Status update interval in minutes\n");
                writer.write("status.updates.interval=10\n\n");
                writer.write("# Embed colors for different server states (hex format)\n");
                writer.write("status.embed.online.color=#00FF00\n");
                writer.write("status.embed.offline.color=#FF0000\n");
                writer.write("status.embed.restart.color=#FFA500\n\n");
                writer.write("# Maximum number of players to display in status message\n");
                writer.write("status.embed.max_players=15\n\n");
                writer.write("# Show admin status in player list (true/false)\n");
                writer.write("status.embed.show_admin=false\n\n");
                writer.write("# Show player connection time in player list (true/false)\n");
                writer.write("status.embed.show_player_time=false\n\n");
                writer.write("# Always recreate status message on startup instead of reusing existing one (true/false)\n");
                writer.write("status.embed.recreate_on_startup=false\n\n");
                writer.write("# =========================================================================\n");
                writer.write("# Automatic Restart Configuration\n");
                writer.write("# =========================================================================\n");
                writer.write("# Configure scheduled server restarts\n\n");
                writer.write("# Enable daily automatic restarts (true/false)\n");
                writer.write("restart.daily.enabled=true\n\n");
                writer.write("# Daily restart time in 24-hour format (HH:MM)\n");
                writer.write("restart.daily.time=04:00\n\n");
                writer.write("# Timezone for restart scheduling (e.g. UTC, America/New_York)\n");
                writer.write("restart.timezone=" + TimeZone.getDefault().getID() + "\n\n");
                writer.write("# Warning countdown in minutes before restart\n");
                writer.write("restart.countdown.minutes=30\n\n");
                writer.write("# Warning times in minutes (comma-separated)\n");
                writer.write("restart.warning.times=20,15,10,5,3,1\n\n");
                writer.write("# Prefix for restart warning messages\n");
                writer.write("restart.broadcast.prefix=\u26a0\ufe0f **SERVER RESTART**\n\n");
                writer.write("# Create backup before restart (true/false)\n");
                writer.write("restart.pre_shutdown.backup=true\n\n");
                writer.write("# Action to take when immediate restart is triggered: \"lock\" or \"kick\"\n");
                writer.write("restart.immediate_action=lock\n\n");
                writer.write("# Server restart command\n");
                String osName = System.getProperty("os.name").toLowerCase();
                if (osName.contains("windows")) {
                    writer.write("# Windows example: start cmd /c start_server.bat\n");
                    writer.write("restart.command=\n\n");
                } else {
                    writer.write("# Linux example: bash -c \"./rwserver restart > /Home/RWserver/log/command_output.log 2>&1 &\"\n");
                    writer.write("restart.command=bash -c \"./rwserver restart > /Home/RWserver/log/command_output.log 2>&1 &\"\n\n");
                }
                writer.write("# =========================================================================\n");
                writer.write("# Discord Message Management\n");
                writer.write("# =========================================================================\n");
                writer.write("# Configure how plugin messages are handled in Discord\n\n");
                writer.write("# Delay (in seconds) before deleting messages\n");
                writer.write("discord.message.delete.delay=300\n\n");
                writer.write("# Message deletion mode: \"always\", \"on_restart\", or \"never\"\n");
                writer.write("discord.message.delete.mode=always\n\n");
                writer.write("# Send notifications about errors (true/false)\n");
                writer.write("discord.error.notification.enabled=true\n\n");
                writer.write("# Send notification when plugin starts (true/false)\n");
                writer.write("discord.startup.notification=true\n\n");
                writer.write("# =========================================================================\n");
                writer.write("# Player Management\n");
                writer.write("# =========================================================================\n");
                writer.write("# Configure player connection settings\n\n");
                writer.write("# Enable logging of player connections (true/false)\n");
                writer.write("player.connection.log.enabled=true\n\n");
                writer.write("# Directory for player connection logs\n");
                writer.write("player.connection.log.directory=player_connections\n\n");
                writer.write("# Track time between player rejoins (true/false)\n");
                writer.write("player.rejoin.time.track=true\n\n");
                writer.write("# Enable player history tracking (true/false)\n");
                writer.write("player.history.enabled=true\n\n");
                writer.write("# Maximum number of notes per player\n");
                writer.write("player.history.max_notes=50\n\n");
                writer.write("# Enable welcome message for new players (true/false)\n");
                writer.write("player.welcome.message.enabled=true\n\n");
                writer.write("# Welcome message text (placeholder: %player%)\n");
                writer.write("player.welcome.message=Welcome to the server, %player%!\n\n");
                writer.write("# =========================================================================\n");
                writer.write("# Message Format Settings\n");
                writer.write("# =========================================================================\n");
                writer.write("# Format for various system messages\n\n");
                writer.write("# Player join message format (placeholder: %player%)\n");
                writer.write("message.join.format=\\uD83D\\uDFE2 **%player% joined the server**\n\n");
                writer.write("# Player leave message format (placeholder: %player%)\n");
                writer.write("message.leave.format=\\uD83D\\uDD34 **%player% left the server**\n\n");
                writer.write("# =========================================================================\n");
                writer.write("# Discord Invite Management\n");
                writer.write("# =========================================================================\n");
                writer.write("# Configure automatic role assignments and Discord invites\n\n");
                writer.write("# Automatically assign roles based on invite used\n");
                writer.write("invite.auto_assign_role=true\n\n");
                writer.write("# Tracking window (in seconds) for invite usage detection\n");
                writer.write("invite.tracking_window=15\n\n");
                writer.write("# Discord welcome message for new members (placeholder: %user%)\n");
                writer.write("invite.welcome_message=Welcome, %user%! Join our game server with /link\n\n");
                writer.write("# Master switch to enable/disable Discord invites completely\n");
                writer.write("invite.enabled=true\n\n");
                writer.write("# Use dynamic invites with expiry (true) or permanent invites (false)\n");
                writer.write("invite.use_dynamic=false\n\n");
                writer.write("# Enable automatic Discord invite on player join (true/false)\n");
                writer.write("invite.auto_send_on_join=true\n\n");
                writer.write("# Default maximum uses for dynamic invites (0 for unlimited)\n");
                writer.write("invite.dynamic.max_uses=1\n\n");
                writer.write("# Default expiration hours for dynamic invites (0 for never)\n");
                writer.write("invite.dynamic.expiration_hours=24\n\n");
                writer.write("# Role ID to assign for dynamic invites (required)\n");
                writer.write("invite.dynamic.role_id=\n\n");
                writer.write("# =========================================================================\n");
                writer.write("# Backup Configuration\n");
                writer.write("# =========================================================================\n");
                writer.write("# Configure automatic backups\n\n");
                writer.write("# Directory for backups\n");
                writer.write("backup.directory=backups\n\n");
                writer.write("# Maximum number of backups to keep\n");
                writer.write("backup.max_count=10\n\n");
                writer.write("# =========================================================================\n");
                writer.write("# Plugin Logging\n");
                writer.write("# =========================================================================\n");
                writer.write("# Configure plugin logging behavior\n\n");
                writer.write("# Maximum number of log files to keep\n");
                writer.write("logs.max_files=30\n\n");
                writer.write("# Directory for log files\n");
                writer.write("logs.directory=logs\n\n");
                writer.write("# Log level (DEBUG, INFO, WARNING, SEVERE, CRITICAL)\n");
                writer.write("logs.level=INFO\n\n");
                writer.write("# Enable console output for debug logs (true/false)\n");
                writer.write("logs.console.debug=false\n\n");
                writer.write("# =========================================================================\n");
                writer.write("# Command Cooldown Settings\n");
                writer.write("# =========================================================================\n");
                writer.write("# Configure cooldowns for commands to prevent spam\n\n");
                writer.write("# Enable command cooldowns (true/false)\n");
                writer.write("command.cooldown.enabled=false\n\n");
                writer.write("# Cooldown period in seconds\n");
                writer.write("command.cooldown.seconds=5\n\n");
                writer.write("# Enable command permissions (true/false)\n");
                writer.write("command.permissions.enabled=true\n\n");
                writer.write("# =========================================================================\n");
                writer.write("# System Information\n");
                writer.write("# =========================================================================\n");
                writer.write("# Internal version tracking (do not modify)\n");
                writer.write("config.version=3.7\n");
            }
            config.setProperty("discord.token", "");
            config.setProperty("discord.admin.channel", "");
            config.setProperty("discord.message.delete.delay", "300");
            config.setProperty("discord.message.delete.mode", "always");
            config.setProperty("discord.error.notification.enabled", "true");
            config.setProperty("discord.bot.activity", "Watching Rising World");
            config.setProperty("discord.startup.notification", "true");
            config.setProperty("chat.relay.game_to_discord", "true");
            config.setProperty("chat.relay.discord_to_game", "true");
            config.setProperty("chat.format.discord_to_game", "[Discord] %author%: %message%");
            config.setProperty("chat.format.game_to_discord", "[Game] %player%: %message%");
            config.setProperty("chat.filter.enabled", "false");
            config.setProperty("chat.filter.words", "badword1,badword2");
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.contains("windows")) {
                config.setProperty("restart.command", "");
            } else {
                config.setProperty("restart.command", "bash -c \"./rwserver restart > /Home/RWserver/log/command_output.log 2>&1 &\"");
            }
            config.setProperty("invite.enabled", "true");
            config.setProperty("invite.use_dynamic", "false");
            config.setProperty("invite.auto_send_on_join", "true");
            config.setProperty("invite.dynamic.max_uses", "1");
            config.setProperty("invite.dynamic.expiration_hours", "24");
            config.setProperty("invite.dynamic.role_id", "");
            config.setProperty("restart.daily.time", "04:00");
            config.setProperty("restart.daily.enabled", "true");
            config.setProperty("restart.countdown.minutes", "30");
            config.setProperty("restart.timezone", TimeZone.getDefault().getID());
            config.setProperty("restart.broadcast.prefix", "\u26a0\ufe0f **SERVER RESTART**");
            config.setProperty("restart.warning.times", "20,15,10,5,3,1");
            config.setProperty("restart.pre_shutdown.backup", "true");
            config.setProperty("restart.immediate_action", "lock");
            config.setProperty("backup.directory", "backups");
            config.setProperty("backup.max_count", "10");
            config.setProperty("status.updates.enabled", "true");
            config.setProperty("status.updates.interval", "10");
            config.setProperty("status.embed.online.color", "#00FF00");
            config.setProperty("status.embed.offline.color", "#FF0000");
            config.setProperty("status.embed.restart.color", "#FFA500");
            config.setProperty("status.embed.max_players", "15");
            config.setProperty("status.embed.show_admin", "false");
            config.setProperty("status.embed.show_player_time", "false");
            config.setProperty("status.embed.recreate_on_startup", "false");
            config.setProperty("error.retry.max", "3");
            config.setProperty("error.retry.delay", "1000");
            config.setProperty("error.log.verbose", "false");
            config.setProperty("logs.max_files", "30");
            config.setProperty("logs.directory", "logs");
            config.setProperty("logs.level", "INFO");
            config.setProperty("logs.console.debug", "false");
            config.setProperty("player.connection.log.enabled", "true");
            config.setProperty("player.connection.log.directory", "player_connections");
            config.setProperty("player.welcome.message.enabled", "true");
            config.setProperty("player.welcome.message", "Welcome to the server, %player%!");
            config.setProperty("player.rejoin.time.track", "true");
            config.setProperty("player.history.enabled", "true");
            config.setProperty("player.history.max_notes", "50");
            config.setProperty("command.permissions.enabled", "true");
            config.setProperty("command.cooldown.enabled", "false");
            config.setProperty("command.cooldown.seconds", "5");
            config.setProperty("invite.auto_assign_role", "true");
            config.setProperty("invite.tracking_window", "15");
            config.setProperty("invite.welcome_message", "Welcome, %user%! Join our game server with /link");
            config.setProperty("message.join.format", "\ud83d\udfe2 **%player% joined the server**");
            config.setProperty("message.leave.format", "\ud83d\udd34 **%player% left the server**");
            config.setProperty("config.version", "3.7");
            this.logger.info("Default configuration created. Please edit the config.properties file.");
            this.logger.info("Note: You MUST update the restart.command property with the correct path for your system.");
            this.cacheFileStructure("config.properties");
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error creating configuration", e);
        }
    }

    public ConfigMigrationManager getMigrationManager() {
        return this.migrationManager;
    }

    public String getConfigString(Properties props, String key, String defaultValue) {
        return props.getProperty(key, defaultValue);
    }

    public int getConfigInt(Properties props, String key, int defaultValue) {
        try {
            return Integer.parseInt(props.getProperty(key, String.valueOf(defaultValue)));
        }
        catch (NumberFormatException e) {
            this.logger.warning("Invalid integer value for " + key + " in config, using default: " + defaultValue);
            return defaultValue;
        }
    }

    public boolean getConfigBoolean(Properties props, String key, boolean defaultValue) {
        String value = props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public Properties loadAuthorizedAdmins() {
        return this.loadConfigWithStructure("admins.properties", "admins", true, this::createDefaultAdmins);
    }

    private void createDefaultAdmins(Properties authorizedAdmins, File adminsFile) {
        block9: {
            try {
                if (FileUtils.ensureParentDirectoryExists(adminsFile)) {
                    authorizedAdmins.setProperty("example_discord_id", "true");
                    try (FileWriter writer = new FileWriter(adminsFile);){
                        writer.write("# Authorized Discord Admin IDs\n");
                        writer.write("# Add Discord IDs of admins below (one per line)\n");
                        writer.write("# Format: discord_id=true\n\n");
                        writer.write("example_discord_id=true\n");
                        writer.write("config.version=3.7\n");
                    }
                    this.logger.info("Default admins file created. Please edit the admins.properties file.");
                    break block9;
                }
                this.logger.severe("Failed to create parent directories for admin file: " + adminsFile.getAbsolutePath());
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error creating admins file", e);
            }
        }
    }

    public void saveAuthorizedAdmins(Properties authorizedAdmins) {
        this.saveConfigPreservingStructure(authorizedAdmins, "admins.properties", "Authorized Discord Admin IDs");
    }

    public void loadDiscordMappings(Map<String, String> discordToGameMap) {
        Properties discordMappings = this.loadConfigWithStructure("discord_mappings.properties", "mappings", true, this::createEmptyMappingsFile);
        for (String key : discordMappings.stringPropertyNames()) {
            if (key.equals("config.version")) continue;
            discordToGameMap.put(key, discordMappings.getProperty(key));
        }
        this.logger.info("Loaded " + discordToGameMap.size() + " Discord to game account mappings.");
    }

    public void saveDiscordMappings(Map<String, String> discordToGameMap) {
        Properties mappings = new Properties();
        for (String key : discordToGameMap.keySet()) {
            mappings.setProperty(key, discordToGameMap.get(key));
        }
        this.saveConfigPreservingStructure(mappings, "discord_mappings.properties", "Discord ID to Game Username Mappings");
    }

    public void loadPlayerUidMappings(Map<String, String> playerNameToUidMap) {
        Properties playerUidMappings = this.loadConfigWithStructure("player_uid_mappings.properties", "mappings", true, this::createEmptyMappingsFile);
        for (String key : playerUidMappings.stringPropertyNames()) {
            if (key.equals("config.version")) continue;
            playerNameToUidMap.put(key, playerUidMappings.getProperty(key));
        }
        this.logger.info("Loaded " + playerNameToUidMap.size() + " player name to UID mappings.");
    }

    public void savePlayerUidMappings(Map<String, String> playerNameToUidMap) {
        Properties mappings = new Properties();
        for (String key : playerNameToUidMap.keySet()) {
            mappings.setProperty(key, playerNameToUidMap.get(key));
        }
        this.saveConfigPreservingStructure(mappings, "player_uid_mappings.properties", "Player Name to UID Mappings");
    }

    private void createEmptyMappingsFile(Properties properties, File file) {
        block9: {
            try {
                if (FileUtils.ensureParentDirectoryExists(file)) {
                    try (FileWriter writer = new FileWriter(file);){
                        writer.write("# " + file.getName() + " Mappings\n");
                        writer.write("# Created on " + String.valueOf(new Date()) + "\n\n");
                        writer.write("config.version=3.7\n");
                    }
                    this.logger.info("Empty " + file.getName() + " file created.");
                    break block9;
                }
                this.logger.severe("Failed to create parent directory for file: " + file.getAbsolutePath());
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error creating " + file.getName() + " file", e);
            }
        }
    }
}

