/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.world.batch;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import net.jiw.unity.runtime.utils.InternalUtils;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;

public class PlantPlaceBatch {
    private static final int SIZE_PER_ENTRY = 61;
    private ArrayList<Entry> entries;

    public PlantPlaceBatch() {
        this(32);
    }

    public PlantPlaceBatch(int initialCapacity) {
        this.entries = new ArrayList(initialCapacity);
    }

    public void add(int typeID, Vector3f worldPosition, Quaternion rotation, Vector3f scale) {
        int cx = Utils.ChunkUtils.getChunkPositionX(worldPosition.x);
        int cy = Utils.ChunkUtils.getChunkPositionY(worldPosition.y);
        int cz = Utils.ChunkUtils.getChunkPositionZ(worldPosition.z);
        float posx = Utils.ChunkUtils.getRelativePositionX(worldPosition.x, cx);
        float posy = Utils.ChunkUtils.getRelativePositionY(worldPosition.y, cy);
        float posz = Utils.ChunkUtils.getRelativePositionZ(worldPosition.z, cz);
        this.entries.add(new Entry(typeID, cx, cy, cz, new Vector3f(posx, posy, posz), rotation.copy(), scale, false, 0));
    }

    public int count() {
        return this.entries.size();
    }

    public void clear() {
        this.entries.clear();
    }

    private byte[] serialize() {
        ByteBuffer buffer = ByteBuffer.allocate(4 + this.entries.size() * 61);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(this.entries.size());
        int len = this.entries.size();
        for (int i = 0; i < len; ++i) {
            Entry e = this.entries.get(i);
            buffer.putInt(e.typeID);
            buffer.putInt(e.cx);
            buffer.putInt(e.cy);
            buffer.putInt(e.cz);
            InternalUtils.ByteBufferUtils.putVector3f((ByteBuffer)buffer, (Vector3f)e.pos);
            InternalUtils.ByteBufferUtils.putQuaternion((ByteBuffer)buffer, (Quaternion)e.rot);
            InternalUtils.ByteBufferUtils.putVector3f((ByteBuffer)buffer, (Vector3f)e.scale);
            buffer.put((byte)(e.isCut ? 1 : 0));
            buffer.putInt(e.flags);
        }
        return buffer.array();
    }

    record Entry(int typeID, int cx, int cy, int cz, Vector3f pos, Quaternion rot, Vector3f scale, boolean isCut, int flags) {
    }
}

