/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.utils;

import java.io.Serializable;
import java.util.Objects;
import net.risingworld.api.utils.Vector3f;

public class Bounds
implements Serializable {
    float xExtent = 0.0f;
    float yExtent = 0.0f;
    float zExtent = 0.0f;
    Vector3f center = new Vector3f();

    public Bounds() {
    }

    public Bounds(Vector3f center, float xExtent, float yExtent, float zExtent) {
        this.center.set(center);
        this.xExtent = xExtent;
        this.yExtent = yExtent;
        this.zExtent = zExtent;
    }

    public Bounds(float x, float y, float z, float xExtent, float yExtent, float zExtent) {
        this.center.set(x, y, z);
        this.xExtent = xExtent;
        this.yExtent = yExtent;
        this.zExtent = zExtent;
    }

    public float getXExtent() {
        return this.xExtent;
    }

    public float getYExtent() {
        return this.yExtent;
    }

    public float getZExtent() {
        return this.zExtent;
    }

    public Vector3f getCenter() {
        return this.center;
    }

    public boolean isPointInVolume(Vector3f point) {
        if (point == null) {
            return false;
        }
        return point.x >= this.center.x - this.xExtent && point.x <= this.center.x + this.xExtent && point.y >= this.center.y - this.yExtent && point.y <= this.center.y + this.yExtent && point.z >= this.center.z - this.zExtent && point.z <= this.center.z + this.zExtent;
    }

    public String toString() {
        return "(" + String.valueOf(this.center) + ", " + this.xExtent + ", " + this.yExtent + ", " + this.zExtent + ")";
    }

    public boolean equals(Object o) {
        if (o.getClass() != Bounds.class) {
            return false;
        }
        Bounds compare = (Bounds)o;
        return this.xExtent == compare.xExtent && this.yExtent == compare.yExtent && this.zExtent == compare.zExtent && this.center.equals(compare.center);
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Float.floatToIntBits(this.xExtent);
        hash = 59 * hash + Float.floatToIntBits(this.yExtent);
        hash = 59 * hash + Float.floatToIntBits(this.zExtent);
        hash = 59 * hash + Objects.hashCode(this.center);
        return hash;
    }
}

