/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.objects;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import net.risingworld.api.Server;
import net.risingworld.api.callbacks.Callback;
import net.risingworld.api.definitions.Definitions;
import net.risingworld.api.definitions.Npcs;
import net.risingworld.api.objects.Clothes;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Player;
import net.risingworld.api.objects.Skin;
import net.risingworld.api.utils.Layer;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;

public final class Npc {
    private final long handle;
    private Skin skin = null;
    private Clothes clothes = null;
    private ConcurrentHashMap<String, Object> attributes = null;

    private Npc(long handle) {
        this.handle = handle;
    }

    public long getGlobalID() {
        return this.handle;
    }

    public Npcs.NpcDefinition getDefinition() {
        return Definitions.getNpcDefinition(this.getTypeID(this.handle));
    }

    public short getTypeID() {
        return this.getTypeID(this.handle);
    }

    private native short getTypeID(long var1);

    public int getVariant() {
        return this.getVariant(this.handle);
    }

    private native int getVariant(long var1);

    public int getGroupID() {
        return this.getGroupID(this.handle);
    }

    private native int getGroupID(long var1);

    public void setGroupID(int groupID) {
        this.setGroupID(this.handle, groupID);
    }

    private native void setGroupID(long var1, int var3);

    public boolean isTransient() {
        return this.isTransient(this.handle);
    }

    private native boolean isTransient(long var1);

    public boolean isOnlyAliveDuringNight() {
        return this.isOnlyAliveDuringNight(this.handle);
    }

    private native boolean isOnlyAliveDuringNight(long var1);

    public String getName() {
        return this.getName(this.handle);
    }

    private native String getName(long var1);

    public void setName(String name) {
        this.setName(this.handle, name);
    }

    private native void setName(long var1, String var3);

    public int getAge() {
        return this.getAge(this.handle);
    }

    private native int getAge(long var1);

    public void setAge(int age) {
        this.setAge(this.handle, age);
    }

    private native void setAge(long var1, int var3);

    public Item getEquippedItem() {
        return this.getEquippedItem(this.handle);
    }

    private native Item getEquippedItem(long var1);

    public Item getSecondaryItem() {
        return this.getSecondaryItem(this.handle);
    }

    private native Item getSecondaryItem(long var1);

    public Player getNearestPlayer() {
        return this.getNearestPlayer(this.handle);
    }

    private native Player getNearestPlayer(long var1);

    public Player getHostilePlayer() {
        return this.getHostilePlayer(this.handle);
    }

    private native Player getHostilePlayer(long var1);

    public boolean isLocked() {
        return this.isLocked(this.handle);
    }

    private native boolean isLocked(long var1);

    public void setLocked(boolean set) {
        this.setLocked(this.handle, set);
    }

    private native void setLocked(long var1, boolean var3);

    public boolean isInvincible() {
        return this.isInvincible(this.handle);
    }

    private native boolean isInvincible(long var1);

    public void setInvincible(boolean set) {
        this.setInvincible(this.handle, set);
    }

    private native void setInvincible(long var1, boolean var3);

    public boolean isInvisible() {
        return this.isInvisible(this.handle);
    }

    private native boolean isInvisible(long var1);

    public void setInvisible(boolean set) {
        this.setInvisible(this.handle, set);
    }

    private native void setInvisible(long var1, boolean var3);

    public void setColliderEnabled(boolean set) {
        this.setColliderEnabled(this.handle, set);
    }

    private native void setColliderEnabled(long var1, boolean var3);

    public boolean isColliderEnabled() {
        return this.isColliderEnabled(this.handle);
    }

    private native boolean isColliderEnabled(long var1);

    public void setInteractable(boolean set) {
        this.setInteractable(this.handle, set);
    }

    private native void setInteractable(long var1, boolean var3);

    public boolean isInteractable() {
        return this.isInteractable(this.handle);
    }

    private native boolean isInteractable(long var1);

    public void setBehaviour(Npcs.Behaviour behaviour) {
        if (behaviour == null) {
            this.resetBehaviour();
        } else {
            this.setBehaviour(this.handle, behaviour.value);
        }
    }

    private native void setBehaviour(long var1, int var3);

    public Npcs.Behaviour getBehaviour() {
        return Npcs.Behaviour.get(this.getBehaviour(this.handle));
    }

    private native int getBehaviour(long var1);

    public boolean isBehaviourOverridden() {
        return this.isBehaviourOverridden(this.handle);
    }

    private native boolean isBehaviourOverridden(long var1);

    public void resetBehaviour() {
        this.resetBehaviour(this.handle);
    }

    private native void resetBehaviour(long var1);

    public void setAttackReaction(Npcs.AttackReaction attackReaction) {
        if (attackReaction == null) {
            this.resetAttackReaction();
        } else {
            this.setAttackReaction(this.handle, attackReaction.value);
        }
    }

    private native void setAttackReaction(long var1, int var3);

    public Npcs.AttackReaction getAttackReaction() {
        return Npcs.AttackReaction.get(this.getAttackReaction(this.handle));
    }

    private native int getAttackReaction(long var1);

    public boolean isAttackReactionOverridden() {
        return this.isAttackReactionOverridden(this.handle);
    }

    private native boolean isAttackReactionOverridden(long var1);

    public void resetAttackReaction() {
        this.resetAttackReaction(this.handle);
    }

    private native void resetAttackReaction(long var1);

    public Object getRider() {
        return this.getRider(this.handle);
    }

    private native Object getRider(long var1);

    public boolean transform(short typeID, int variant) {
        return this.transform(this.handle, typeID, variant);
    }

    private native boolean transform(long var1, short var3, int var4);

    public void setSoundsEnabled(boolean footstepSounds, boolean idleSounds, boolean alertSounds) {
        this.setSoundsEnabled(this.handle, footstepSounds, idleSounds, alertSounds);
    }

    private native void setSoundsEnabled(long var1, boolean var3, boolean var4, boolean var5);

    public boolean isFootstepSoundEnabled() {
        return this.isFootstepSoundEnabled(this.handle);
    }

    private native boolean isFootstepSoundEnabled(long var1);

    public boolean isIdleSoundEnabled() {
        return this.isIdleSoundEnabled(this.handle);
    }

    private native boolean isIdleSoundEnabled(long var1);

    public boolean isAlertSoundEnabled() {
        return this.isAlertSoundEnabled(this.handle);
    }

    private native boolean isAlertSoundEnabled(long var1);

    public void playIdleSound() {
        this.playIdleSound(this.handle);
    }

    private native void playIdleSound(long var1);

    public void playAlertSound() {
        this.playAlertSound(this.handle);
    }

    private native void playAlertSound(long var1);

    private native void playRoarSound(long var1);

    public void playDeathSound() {
        this.playDeathSound(this.handle);
    }

    private native void playDeathSound(long var1);

    private native void playFootstepSound(long var1);

    public Vector3f getPosition() {
        return this.getPosition(this.handle);
    }

    private native Vector3f getPosition(long var1);

    public void setPosition(Vector3f position) {
        this.setPosition(position.x, position.y, position.z);
    }

    public void setPosition(float x, float y, float z) {
        this.setPosition(this.handle, x, y, z);
    }

    private native void setPosition(long var1, float var3, float var4, float var5);

    public void moveTo(Vector3f position) {
        this.moveTo(position.x, position.y, position.z);
    }

    public void moveTo(float x, float y, float z) {
        this.moveTo(this.handle, x, y, z);
    }

    private native void moveTo(long var1, float var3, float var4, float var5);

    public Quaternion getRotation() {
        return this.getRotation(this.handle);
    }

    private native Quaternion getRotation(long var1);

    public void setRotation(Quaternion quaternion) {
        this.setRotation(this.handle, quaternion.x, quaternion.y, quaternion.z, quaternion.w);
    }

    private native void setRotation(long var1, float var3, float var4, float var5, float var6);

    public void setRotation(float pitch, float yaw, float roll) {
        this.setRotationEuler(this.handle, pitch, yaw, roll);
    }

    private native void setRotationEuler(long var1, float var3, float var4, float var5);

    public Vector3f getViewDirection() {
        return this.getViewDirection(this.handle);
    }

    private native Vector3f getViewDirection(long var1);

    public void setViewDirection(Vector3f direction) {
        this.setViewDirection(direction.x, direction.y, direction.z);
    }

    public void setViewDirection(float dirx, float diry, float dirz) {
        this.setViewDirection(this.handle, dirx, diry, dirz);
    }

    private native void setViewDirection(long var1, float var3, float var4, float var5);

    public Vector3f getVectorToNearestPlayer() {
        return this.getVectorToNearestPlayer(this.handle);
    }

    private native Vector3f getVectorToNearestPlayer(long var1);

    public void getPlayerInLineOfSight(float distance, Callback<Player> callback) {
        Player player = this.getNearestPlayer();
        if (player != null) {
            Npcs.NpcDefinition def = this.getDefinition();
            Vector3f position = this.getPosition(this.handle);
            Vector3f offset = new Vector3f(0.0f, def.eyeheight, def.rayoffset);
            position.addLocal(this.getRotation().multLocal(offset));
            player.raycastFromWorldPosition(position, this.getViewDirection(this.handle), distance, Layer.getBitmask(19, 20), true, result -> {
                int playerID;
                Player targetPlayer;
                if (result != null && (result.getLayer() == 19 || result.getLayer() == 20) && (targetPlayer = Server.getPlayer(playerID = (int)result.getObjectGlobalID())) != null) {
                    callback.onCall(targetPlayer);
                    return;
                }
                callback.onCall(null);
            });
        }
    }

    public boolean isInWater() {
        return this.isInWater(this.handle);
    }

    private native boolean isInWater(long var1);

    public boolean isUnderwater() {
        return this.isUnderwater(this.handle);
    }

    private native boolean isUnderwater(long var1);

    public void setAlerted(boolean set) {
        this.setAlerted(this.handle, set, 20);
    }

    public void setAlerted(boolean set, int duration) {
        this.setAlerted(this.handle, set, duration);
    }

    private native void setAlerted(long var1, boolean var3, int var4);

    public boolean isAlerted() {
        return this.isAlerted(this.handle);
    }

    private native boolean isAlerted(long var1);

    public int getHealth() {
        return this.getHealth(this.handle);
    }

    private native int getHealth(long var1);

    public void setHealth(int health) {
        this.setHealth(this.handle, health);
    }

    private native void setHealth(long var1, int var3);

    public int getHunger() {
        return this.getHunger(this.handle);
    }

    private native int getHunger(long var1);

    public void setHunger(int hunger) {
        this.setHunger(this.handle, hunger);
    }

    private native void setHunger(long var1, int var3);

    public int getThirst() {
        return this.getThirst(this.handle);
    }

    private native int getThirst(long var1);

    public void setThirst(int thirst) {
        this.setThirst(this.handle, thirst);
    }

    private native void setThirst(long var1, int var3);

    public boolean isSleeping() {
        return this.isSleeping(this.handle);
    }

    private native boolean isSleeping(long var1);

    public boolean isDead() {
        return this.isDead(this.handle);
    }

    private native boolean isDead(long var1);

    public void kill() {
        this.kill(this.handle);
    }

    private native void kill(long var1);

    public void delete() {
        this.delete(this.handle);
    }

    private native void delete(long var1);

    public Skin getSkin() {
        if (this.skin == null) {
            this.skin = new Skin(this.handle, true);
        }
        return this.skin;
    }

    public Clothes getClothes() {
        if (this.clothes == null) {
            this.clothes = new Clothes(this.handle, true);
        }
        return this.clothes;
    }

    public void setAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new ConcurrentHashMap(10, 0.9f, 1);
        }
        if (value == null) {
            this.deleteAttribute(key);
        } else {
            this.attributes.put(key, value);
        }
    }

    private void setPersistentAttribute(String key, Serializable value) {
        Class<?> component;
        Class<?> clazz = value.getClass();
        if (clazz.isArray() && !(component = clazz.getComponentType()).isPrimitive() && !Serializable.class.isAssignableFrom(component)) {
            throw new UnsupportedOperationException("You can only store primitive values or objects which implement the Serializable interface as persistent attribute!");
        }
    }

    private Object getPersistentAttribute(String key) {
        return null;
    }

    public Object getAttribute(String key) {
        if (this.attributes == null || key == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    public boolean hasAttribute(String key) {
        return this.attributes != null && this.attributes.containsKey(key);
    }

    public boolean hasAttribute(String key, Class type) {
        if (this.attributes == null) {
            return false;
        }
        Object attribute = this.attributes.get(key);
        return attribute != null && attribute.getClass() == type;
    }

    public void deleteAttribute(String key) {
        if (this.attributes != null && key != null) {
            this.attributes.remove(key);
        }
    }
}

