/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.assets;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.jiw.unity.runtime.PluginAssetManager;
import net.risingworld.api.assets.Asset;
import net.risingworld.api.assets.TextureAsset;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector2f;

public class MaterialAsset
extends Asset {
    MaterialType materialType = MaterialType.Lit;
    TextureAsset texture;
    TextureAsset normalMap;
    float normalStrength;
    Vector2f textureScale = new Vector2f(1.0f, 1.0f);
    int color = -1;
    float colorIntensity = 1.0f;
    float metallic = 0.0f;
    float smoothness = 0.5f;
    float alphaThreshold = 0.0f;
    byte flags = 0;
    private final int BYTES = 43;

    public static MaterialAsset create(String name) {
        MaterialAsset asset = new MaterialAsset(name);
        asset.source = Asset.Source.Raw;
        asset.setupFileInfo(-1, -1, null, name, "material_" + name + "_" + System.currentTimeMillis(), "mat", String.valueOf(System.currentTimeMillis()));
        return asset;
    }

    MaterialAsset(String name) {
        super(Asset.Type.Material);
    }

    public void setTexture(TextureAsset texture) {
        if (this.source != Asset.Source.Raw) {
            throw new UnsupportedOperationException("You cannot modify a loaded material instance");
        }
        this.texture = texture;
    }

    public void setNormalMap(TextureAsset normalMap) {
        if (this.source != Asset.Source.Raw) {
            throw new UnsupportedOperationException("You cannot modify a loaded material instance");
        }
        this.normalMap = normalMap;
    }

    public void setNormalMapStrength(float strength) {
        if (this.source != Asset.Source.Raw) {
            throw new UnsupportedOperationException("You cannot modify a loaded material instance");
        }
        this.normalStrength = strength;
    }

    public void setTextureScale(float sx, float sy) {
        if (this.source != Asset.Source.Raw) {
            throw new UnsupportedOperationException("You cannot modify a loaded material instance");
        }
        this.textureScale.set(sx, sy);
    }

    public Vector2f getTextureScale() {
        return this.textureScale;
    }

    public void setColor(float r, float g, float b, float a) {
        this.setColor(Utils.GeneralUtils.colorRGBAToInt(r, g, b, a));
    }

    public void setColor(int rgba) {
        if (this.source != Asset.Source.Raw) {
            throw new UnsupportedOperationException("You cannot modify a loaded material instance");
        }
        this.color = rgba;
    }

    public void setSmoothness(float smoothness) {
        if (this.source != Asset.Source.Raw) {
            throw new UnsupportedOperationException("You cannot modify a loaded material instance");
        }
        this.smoothness = smoothness;
    }

    public void setMetallic(float metallic) {
        if (this.source != Asset.Source.Raw) {
            throw new UnsupportedOperationException("You cannot modify a loaded material instance");
        }
        this.metallic = metallic;
    }

    public void setAlphaThreshold(float threshold) {
        if (this.source != Asset.Source.Raw) {
            throw new UnsupportedOperationException("You cannot modify a loaded material instance");
        }
        this.alphaThreshold = threshold;
    }

    public void setFlags(Flags ... flags) {
        if (this.source != Asset.Source.Raw) {
            throw new UnsupportedOperationException("You cannot modify a loaded material instance");
        }
        this.flags = 0;
        if (flags != null) {
            for (Flags flag : flags) {
                this.flags = (byte)(this.flags | 1 << flag.ordinal());
            }
        }
    }

    public void applyChanges() {
        if (this.source != Asset.Source.Raw) {
            throw new UnsupportedOperationException("You cannot modify a loaded material instance");
        }
        PluginAssetManager.refreshAsset((int)this.handle);
    }

    @Override
    synchronized byte[] loadData(boolean saveInCache) {
        byte[] data = this.serialize();
        if (saveInCache) {
            this.cachedData = data;
        }
        return data;
    }

    @Override
    void onInit() {
    }

    @Override
    boolean checkFileExtension(String name) {
        return true;
    }

    private byte[] serialize() {
        ByteBuffer bb = ByteBuffer.allocate(43);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.put((byte)1);
        bb.put((byte)this.materialType.ordinal());
        bb.putInt(this.texture == null ? -1 : this.texture.handle);
        bb.putInt(this.normalMap == null ? -1 : this.normalMap.handle);
        bb.putFloat(this.normalStrength);
        bb.putFloat(this.textureScale.x).putFloat(this.textureScale.y);
        bb.putInt(this.color);
        bb.putFloat(this.colorIntensity);
        bb.putFloat(this.metallic);
        bb.putFloat(this.smoothness);
        bb.putFloat(this.alphaThreshold);
        bb.put(this.flags);
        byte[] data = new byte[bb.position()];
        bb.flip();
        bb.get(data);
        return data;
    }

    public static enum MaterialType {
        Lit,
        Unlit;

    }

    public static enum Flags {
        Transparent,
        DoubleSided;

    }
}

