/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.worldelements;

import net.jiw.unity.runtime.PluginGameObjectManager;
import net.risingworld.api.assets.MaterialAsset;
import net.risingworld.api.assets.PrefabAsset;
import net.risingworld.api.assets.TextureAsset;
import net.risingworld.api.callbacks.Callback;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector2f;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.utils.Vector4f;
import net.risingworld.api.worldelements.GameObject;

public class Prefab
extends GameObject {
    PrefabAsset prefab;
    private static final int TYPE = 2;

    public Prefab() {
    }

    public Prefab(PrefabAsset prefab) {
        this.prefab = prefab;
    }

    @Override
    int getType() {
        return 2;
    }

    public void setPrefab(PrefabAsset prefab) {
        if (this.prefab != prefab) {
            this.prefab = prefab;
            this.updateObject(true);
        }
    }

    public void setActive(String path, boolean set) {
        if (path == null || path.length() == 0) {
            super.setActive(set);
        } else {
            PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.Active, (String)path, null, (boolean)set);
        }
    }

    public void setLayer(String path, int layer, boolean recursively) {
        if (path == null || path.length() == 0) {
            this.layer = layer;
        }
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.Layer, (String)path, null, (int)layer, (int)(recursively ? 1 : 0), (int)-1, (int)-1);
    }

    public void setLocalPosition(String path, Vector3f position) {
        if (path == null || path.length() == 0) {
            super.setLocalPosition(position);
        } else {
            PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.LocalPosition, (String)path, null, (Vector3f)position);
        }
    }

    public void setLocalRotation(String path, Quaternion rotation) {
        if (path == null || path.length() == 0) {
            super.setLocalRotation(rotation);
        } else {
            PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.LocalRotation, (String)path, null, (Quaternion)rotation);
        }
    }

    public void setLocalScale(String path, Vector3f scale) {
        if (path == null || path.length() == 0) {
            super.setLocalScale(scale);
        } else {
            PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.LocalScale, (String)path, null, (Vector3f)scale);
        }
    }

    public void readLocalPosition(String path, Player player, Callback<Vector3f> callback) {
        PluginGameObjectManager.readPosition((GameObject)this, (int)this.id, (int)(player == null ? -1 : player.getDbID()), (boolean)true, (String)path, callback);
    }

    public void readWorldPosition(String path, Player player, Callback<Vector3f> callback) {
        PluginGameObjectManager.readPosition((GameObject)this, (int)this.id, (int)(player == null ? -1 : player.getDbID()), (boolean)false, (String)path, callback);
    }

    public void readLocalRotation(String path, Player player, Callback<Quaternion> callback) {
        PluginGameObjectManager.readRotation((GameObject)this, (int)this.id, (int)(player == null ? -1 : player.getDbID()), (boolean)true, (String)path, callback);
    }

    public void readWorldRotation(String path, Player player, Callback<Quaternion> callback) {
        PluginGameObjectManager.readRotation((GameObject)this, (int)this.id, (int)(player == null ? -1 : player.getDbID()), (boolean)false, (String)path, callback);
    }

    public void addComponent(String path, String component) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.ComponentAddOrRemove, (String)path, (String)component, (boolean)true);
    }

    public void removeComponent(String path, String component) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.ComponentAddOrRemove, (String)path, (String)component, (boolean)false);
    }

    public void setComponentEnabled(String path, String component, boolean enabled) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.ComponentEnabled, (String)path, (String)component, (boolean)enabled);
    }

    public void setComponentProperty(String path, String component, String property, Object value) {
        PluginGameObjectManager.invokeComponentMethod((GameObject)this, (String)path, (String)component, (String)property, (boolean)true, (Object[])new Object[]{value});
    }

    public void invokeComponentMethod(String path, String component, String method, Object ... parameters) {
        if (component == null || method == null) {
            return;
        }
        PluginGameObjectManager.invokeComponentMethod((GameObject)this, (String)path, (String)component, (String)method, (boolean)false, (Object[])parameters);
    }

    public void setAnimatorParameter(String path, String parameter, float value) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.AnimatorParameterFloat, (String)path, (String)parameter, (float)value);
    }

    public void setAnimatorParameter(String path, String parameter, int value) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.AnimatorParameterInt, (String)path, (String)parameter, (int)value);
    }

    public void setAnimatorParameter(String path, String parameter, boolean value) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.AnimatorParameterBool, (String)path, (String)parameter, (boolean)value);
    }

    public void setAnimatorTrigger(String path, String trigger) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.AnimatorTrigger, (String)path, (String)trigger);
    }

    public void resetAnimatorTrigger(String path, String trigger) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.AnimatorResetTrigger, (String)path, (String)trigger);
    }

    public void startAnimatorPlayback(String path) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.AnimatorPlaybackStart, (String)path, null);
    }

    public void stopAnimatorPlayback(String path) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.AnimatorPlaybackStop, (String)path, null);
    }

    public void playAnimatorState(String path, String state, int layer, float normalizedTime) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.AnimatorPlayState, (String)path, (String)state, (int)layer, (int)Float.floatToIntBits(normalizedTime), (int)-1, (int)-1);
    }

    public void rebindAnimator(String path, boolean keepState) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.AnimatorRebind, (String)path, null, (boolean)keepState);
    }

    public void setMaterial(String path, MaterialAsset material) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.Material, (String)path, null, (int)(material == null ? -1 : material.getHandle()));
    }

    public void setMaterialParameter(String path, String parameter, float value) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.MaterialParameterFloat, (String)path, (String)parameter, (float)value);
    }

    public void setMaterialParameter(String path, String parameter, boolean value) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.MaterialParameterFloat, (String)path, (String)parameter, (float)(value ? 1.0f : 0.0f));
    }

    public void setMaterialParameter(String path, String parameter, Vector2f value) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.MaterialParameterVector2, (String)path, (String)parameter, (Vector2f)value);
    }

    public void setMaterialParameter(String path, String parameter, Vector3f value) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.MaterialParameterVector3, (String)path, (String)parameter, (Vector3f)value);
    }

    public void setMaterialParameter(String path, String parameter, Vector4f value) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.MaterialParameterVector4, (String)path, (String)parameter, (Vector4f)value);
    }

    public void setMaterialParameter(String path, String parameter, TextureAsset texture) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.MaterialParameterTexture, (String)path, (String)parameter, (int)(texture == null ? -1 : texture.getHandle()));
    }

    public void clearMaterialPropertyBlock(String path, int materialIndex) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.ClearMaterialPropertyBlock, (String)path, null, (int)materialIndex);
    }

    public void setVFXParameter(String path, String parameter, float value) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.VFXParameterFloat, (String)path, (String)parameter, (float)value);
    }

    public void setVFXParameter(String path, String parameter, int value) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.VFXParameterInt, (String)path, (String)parameter, (int)value);
    }

    public void setVFXParameter(String path, String parameter, boolean value) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.VFXParameterBool, (String)path, (String)parameter, (boolean)value);
    }

    public void setVFXParameter(String path, String parameter, Vector2f value) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.VFXParameterVector2, (String)path, (String)parameter, (Vector2f)value);
    }

    public void setVFXParameter(String path, String parameter, Vector3f value) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.VFXParameterVector3, (String)path, (String)parameter, (Vector3f)value);
    }

    public void setVFXParameter(String path, String parameter, Vector4f value) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.VFXParameterVector4, (String)path, (String)parameter, (Vector4f)value);
    }

    public void setVFXPaused(String path, boolean pause) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.VFXPaused, (String)path, null, (boolean)pause);
    }

    public void setVFXPlayRate(String path, float rate) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.VFXPlayRate, (String)path, null, (float)rate);
    }

    public void playVFX(String path) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.VFXPlay, (String)path, null);
    }

    public void stopVFX(String path) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.VFXStop, (String)path, null);
    }

    public void reinitVFX(String path) {
        PluginGameObjectManager.updatePrefab((Prefab)this, (PluginGameObjectManager.PrefabUpdateType)PluginGameObjectManager.PrefabUpdateType.VFXReinit, (String)path, null);
    }

    private void updateObject(boolean clearUpdates) {
        PluginGameObjectManager.updateObject((GameObject)this, (int)this.id, (boolean)false);
        if (clearUpdates) {
            PluginGameObjectManager.clearPrefabUpdateHistory((Prefab)this);
        }
    }
}

