/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.ui.style;

import java.nio.ByteBuffer;
import net.risingworld.api.ui.style.Pivot;
import net.risingworld.api.ui.style.StyleField;
import net.risingworld.api.ui.style.StyleKeyword;
import net.risingworld.api.ui.style.Unit;

public final class StyleTransformOrigin
extends StyleField {
    private float x;
    private Unit unitX;
    private float y;
    private Unit unitY;

    StyleTransformOrigin() {
        this(StyleKeyword.Null);
    }

    StyleTransformOrigin(float x, Unit unitX, float y, Unit unitY) {
        this.x = x;
        this.unitX = unitX;
        this.y = y;
        this.unitY = unitY;
        this.keyword = StyleKeyword.Undefined;
    }

    StyleTransformOrigin(StyleKeyword keyword) {
        this.y = 0.0f;
        this.x = 0.0f;
        this.unitX = this.unitY = Unit.Pixel;
        this.keyword = keyword;
    }

    public void refresh() {
        this.isDirty = true;
    }

    public void set(float x, float y) {
        this.set(x, Unit.Pixel, y, Unit.Pixel);
    }

    public void set(float x, Unit unitX, float y, Unit unitY) {
        if (this.x != x || this.y != y || this.unitX != unitX || this.unitY != unitY || this.keyword != StyleKeyword.Undefined) {
            this.isDirty = true;
            this.isModified = true;
            this.x = x;
            this.y = y;
            this.unitX = unitX;
            this.unitY = unitY;
            this.keyword = StyleKeyword.Undefined;
        }
    }

    public void set(Pivot pivot) {
        switch (pivot) {
            case UpperLeft: {
                this.set(0.0f, Unit.Percent, 0.0f, Unit.Percent);
                break;
            }
            case UpperCenter: {
                this.set(50.0f, Unit.Percent, 0.0f, Unit.Percent);
                break;
            }
            case UpperRight: {
                this.set(100.0f, Unit.Percent, 0.0f, Unit.Percent);
                break;
            }
            case MiddleLeft: {
                this.set(0.0f, Unit.Percent, 50.0f, Unit.Percent);
                break;
            }
            case MiddleCenter: {
                this.set(50.0f, Unit.Percent, 50.0f, Unit.Percent);
                break;
            }
            case MiddleRight: {
                this.set(100.0f, Unit.Percent, 50.0f, Unit.Percent);
                break;
            }
            case LowerLeft: {
                this.set(0.0f, Unit.Percent, 100.0f, Unit.Percent);
                break;
            }
            case LowerCenter: {
                this.set(50.0f, Unit.Percent, 100.0f, Unit.Percent);
                break;
            }
            case LowerRight: {
                this.set(100.0f, Unit.Percent, 100.0f, Unit.Percent);
                break;
            }
            default: {
                this.set(0.0f, Unit.Percent, 0.0f, Unit.Percent);
            }
        }
    }

    public void set(StyleKeyword keyword) {
        this.isDirty = true;
        this.isModified = true;
        this.keyword = keyword;
    }

    @Override
    public void reset() {
        this.set(StyleKeyword.Null);
    }

    public float getX() {
        return this.x;
    }

    public Unit getUnitX() {
        return this.unitX;
    }

    public float getY() {
        return this.y;
    }

    public Unit getUnitY() {
        return this.unitY;
    }

    public StyleKeyword getKeyword() {
        return this.keyword;
    }

    @Override
    void serialize(ByteBuffer buffer) {
        buffer.put((byte)this.keyword.ordinal());
        buffer.put((byte)this.unitX.ordinal());
        buffer.put((byte)this.unitY.ordinal());
        buffer.putFloat(this.x);
        buffer.putFloat(this.y);
    }

    @Override
    void deserialize(ByteBuffer buffer) {
        this.keyword = StyleKeyword.get(buffer.get());
        this.unitX = Unit.get(buffer.get());
        this.unitY = Unit.get(buffer.get());
        this.x = buffer.getFloat();
        this.y = buffer.getFloat();
    }
}

