/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.ui.style;

import java.nio.ByteBuffer;
import net.risingworld.api.ui.style.StyleField;
import net.risingworld.api.ui.style.StyleKeyword;
import net.risingworld.api.ui.style.Unit;

public final class StyleLength
extends StyleField {
    private float value;
    private Unit unit;

    StyleLength() {
        this(StyleKeyword.Null);
    }

    StyleLength(float value, Unit unit) {
        this.value = value;
        this.unit = unit;
        this.keyword = StyleKeyword.Undefined;
    }

    StyleLength(StyleKeyword keyword) {
        this.value = 0.0f;
        this.unit = Unit.Pixel;
        this.keyword = keyword;
    }

    public void set(float value) {
        this.set(value, Unit.Pixel);
    }

    public void set(float value, Unit unit) {
        if (this.value != value || this.unit != unit || this.keyword != StyleKeyword.Undefined) {
            this.isDirty = true;
            this.isModified = true;
            this.value = value;
            this.unit = unit;
            this.keyword = StyleKeyword.Undefined;
        }
    }

    public void set(StyleKeyword keyword) {
        this.isDirty = true;
        this.isModified = true;
        this.keyword = keyword;
    }

    @Override
    public void reset() {
        this.set(StyleKeyword.Null);
    }

    public float get() {
        return this.value;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public StyleKeyword getKeyword() {
        return this.keyword;
    }

    @Override
    void serialize(ByteBuffer buffer) {
        buffer.put((byte)this.keyword.ordinal());
        buffer.put((byte)this.unit.ordinal());
        buffer.putFloat(this.value);
    }

    @Override
    void deserialize(ByteBuffer buffer) {
        this.keyword = StyleKeyword.get(buffer.get());
        this.unit = Unit.get(buffer.get());
        this.value = buffer.getFloat();
    }
}

