/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.objects;

import net.risingworld.api.definitions.Items;
import net.risingworld.api.objects.Item;

public final class Storage {
    private final long handle;

    private Storage(long handle) {
        this.handle = handle;
    }

    public long getID() {
        return this.handle;
    }

    public int getHashCode() {
        return this.getHashCode(this.handle);
    }

    private native int getHashCode(long var1);

    public boolean isTransient() {
        return this.isTransient(this.handle);
    }

    private native boolean isTransient(long var1);

    public int getSlotCount() {
        return this.getSlotCount(this.handle);
    }

    private native int getSlotCount(long var1);

    public void setSlotCount(int slots) {
        this.setSlotCount(this.handle, slots);
    }

    private native void setSlotCount(long var1, int var3);

    public Item[] getItems() {
        return this.getItems(this.handle);
    }

    private native Item[] getItems(long var1);

    public Item getItem(int slot) {
        return this.getItem(this.handle, slot);
    }

    private native Item getItem(long var1, int var3);

    public Item addItem(short itemID, int variant, int stack) {
        return this.addItem(this.handle, itemID, variant, stack, -1, Items.Modifier.Normal.value, -1);
    }

    public Item addItemToSlot(short itemID, int variant, int stack, int slot) {
        return this.addItem(this.handle, itemID, variant, stack, -1, Items.Modifier.Normal.value, slot);
    }

    private native Item addItem(long var1, short var3, int var4, int var5, int var6, int var7, int var8);

    public Item.ObjectItem addObjectItem(short objectID, int variant, int stack) {
        return this.addObjectItem(this.handle, objectID, variant, stack, -1);
    }

    public Item.ObjectItem addObjectItemToSlot(short objectID, int variant, int stack, int slot) {
        return this.addObjectItem(this.handle, objectID, variant, stack, slot);
    }

    private native Item.ObjectItem addObjectItem(long var1, short var3, int var4, int var5, int var6);

    public Item.ConstructionItem addConstructionItem(byte constructionID, int texture, int stack, int color) {
        return this.addConstructionItem(this.handle, constructionID, texture, stack, color, -1);
    }

    public Item.ConstructionItem addConstructionItemToSlot(byte constructionID, int texture, int stack, int color, int slot) {
        return this.addConstructionItem(this.handle, constructionID, texture, stack, color, slot);
    }

    private native Item.ConstructionItem addConstructionItem(long var1, byte var3, int var4, int var5, int var6, int var7);

    public Item.ClothingItem addClothingItem(short clothingID, int variant, int stack, int color, long infoID) {
        return this.addClothingItem(this.handle, clothingID, variant, stack, color, infoID, -1);
    }

    public Item.ClothingItem addClothingItemToSlot(short clothingID, int variant, int stack, int color, long infoID, int slot) {
        return this.addClothingItem(this.handle, clothingID, variant, stack, color, infoID, slot);
    }

    private native Item.ClothingItem addClothingItem(long var1, short var3, int var4, int var5, int var6, long var7, int var9);

    public void removeItem(int slot) {
        this.removeItem(this.handle, slot, -1);
    }

    public void removeItem(int slot, int amount) {
        this.removeItem(this.handle, slot, amount);
    }

    private native void removeItem(long var1, int var3, int var4);

    public int removeItem(short itemID, int variation, int amount) {
        return this.removeItem(this.handle, itemID, variation, amount);
    }

    private native int removeItem(long var1, short var3, int var4, int var5);

    public void sort(boolean mergeStacks) {
        this.sort(this.handle, mergeStacks);
    }

    private native void sort(long var1, boolean var3);

    public void mergeStacks() {
        this.mergeStacks(this.handle);
    }

    private native void mergeStacks(long var1);

    public void clear() {
        this.clear(this.handle);
    }

    private native void clear(long var1);

    public long getCreationDate() {
        return this.getCreationDate(this.handle);
    }

    private native long getCreationDate(long var1);

    private long getLastAccess() {
        return this.getLastAccess(this.handle);
    }

    private native long getLastAccess(long var1);

    public int getLastModifyPlayerDbID() {
        return this.getLastModifyPlayerDbID(this.handle);
    }

    private native int getLastModifyPlayerDbID(long var1);

    public String getName() {
        return this.getName(this.handle);
    }

    private native String getName(long var1);

    public void setName(String name) {
        this.setName(this.handle, name);
    }

    private native void setName(long var1, String var3);
}

