/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api;

import java.io.File;
import net.risingworld.api.objects.Area;
import net.risingworld.api.objects.MetaObject;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.objects.Sign;
import net.risingworld.api.objects.Storage;
import net.risingworld.api.objects.Vehicle;
import net.risingworld.api.objects.WorldItem;
import net.risingworld.api.objects.world.Chunk;
import net.risingworld.api.objects.world.ChunkPart;
import net.risingworld.api.objects.world.ConstructionElement;
import net.risingworld.api.objects.world.ObjectElement;
import net.risingworld.api.objects.world.Plant;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.utils.Vector3i;
import net.risingworld.api.world.EditRestriction;
import net.risingworld.api.world.batch.ConstructionPlaceBatch;
import net.risingworld.api.world.batch.PlantPlaceBatch;
import net.risingworld.api.world.batch.WorldEditBatch;

public final class World {
    private World() {
    }

    public static native String getName();

    public static native String getSeed();

    public static native long getCreationDate();

    public static native String getWorldType();

    public static native int getOreAmount();

    public static native String[] getDisabledNpcs();

    public static File getWorldFolder() {
        return new File(World.getWorldFolderPath());
    }

    private static native String getWorldFolderPath();

    public static File getWorldsFolder() {
        return new File(World.getWorldsFolderPath());
    }

    private static native String getWorldsFolderPath();

    public static native boolean isInitialized();

    public static native int getTemperature(float var0, float var1, float var2);

    public static native float getDefaultGravity();

    public static native void setSkyRotation(float var0);

    public static WorldItem spawnItem(short itemID, int texture, int stack, Vector3f position, Quaternion rotation, boolean physical) {
        return World.spawnItem(itemID, texture, stack, position.x, position.y, position.z, rotation.x, rotation.y, rotation.z, rotation.w, physical);
    }

    private static native WorldItem spawnItem(short var0, int var1, int var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, boolean var10);

    public static WorldItem spawnObjectItem(short objectID, int variant, int stack, Vector3f position, Quaternion rotation, boolean physical) {
        return World.spawnObjectItem(objectID, variant, stack, position.x, position.y, position.z, rotation.x, rotation.y, rotation.z, rotation.w, physical);
    }

    private static native WorldItem spawnObjectItem(short var0, int var1, int var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, boolean var10);

    public static WorldItem spawnConstructionItem(byte constructionID, int texture, int stack, int color, Vector3f position, Quaternion rotation, boolean physical) {
        return World.spawnConstructionItem(constructionID, texture, stack, color, position.x, position.y, position.z, rotation.x, rotation.y, rotation.z, rotation.w, physical);
    }

    private static native WorldItem spawnConstructionItem(byte var0, int var1, int var2, int var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, boolean var11);

    public static WorldItem spawnClothingItem(short clothingID, int variant, int stack, int color, long infoID, Vector3f position, Quaternion rotation, boolean physical) {
        return World.spawnClothingItem(clothingID, variant, stack, color, infoID, position.x, position.y, position.z, rotation.x, rotation.y, rotation.z, rotation.w, physical);
    }

    private static native WorldItem spawnClothingItem(short var0, int var1, int var2, int var3, long var4, float var6, float var7, float var8, float var9, float var10, float var11, float var12, boolean var13);

    public static native WorldItem getItem(long var0);

    public static native WorldItem[] getAllItems();

    public static WorldItem[] getAllItemsInRange(Vector3f position, float range) {
        if (position == null) {
            position = Vector3f.ZERO;
        }
        return World.getAllItemsInRange(position.x, position.y, position.z, range);
    }

    private static native WorldItem[] getAllItemsInRange(float var0, float var1, float var2, float var3);

    public static native WorldItem[] getAllItemsInArea(Area var0);

    public static WorldItem findNearestItem(Vector3f position) {
        return World.findNearestItem(position.x, position.y, position.z, 1.0E12f);
    }

    private static native WorldItem findNearestItem(float var0, float var1, float var2, float var3);

    public static WorldItem findNearestItem(short itemID, Vector3f position) {
        return World.findNearestItem(itemID, position.x, position.y, position.z, 1.0E12f);
    }

    private static native WorldItem findNearestItem(short var0, float var1, float var2, float var3, float var4);

    public static native int getNumItems();

    public static Npc spawnNpc(short typeID, Vector3f position, Quaternion rotation) {
        return World.spawnNpc(typeID, 0, position.x, position.y, position.z, rotation.x, rotation.y, rotation.z, rotation.w, false);
    }

    public static Npc spawnNpc(short typeID, int variant, Vector3f position, Quaternion rotation) {
        return World.spawnNpc(typeID, variant, position.x, position.y, position.z, rotation.x, rotation.y, rotation.z, rotation.w, false);
    }

    public static Npc spawnNpc(short typeID, int variant, Vector3f position, Quaternion rotation, boolean temporary) {
        return World.spawnNpc(typeID, variant, position.x, position.y, position.z, rotation.x, rotation.y, rotation.z, rotation.w, temporary);
    }

    private static native Npc spawnNpc(short var0, int var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, boolean var9);

    public static native Npc getNpc(long var0);

    public static native Npc[] getAllNpcs();

    public static native Npc[] getAllNpcs(short var0);

    public static Npc[] getAllNpcsInRange(Vector3f position, float range) {
        if (position == null) {
            position = Vector3f.ZERO;
        }
        return World.getAllNpcsInRange((short)-1, position.x, position.y, position.z, range);
    }

    public static Npc[] getAllNpcsInRange(short typeID, Vector3f position, float range) {
        if (position == null) {
            position = Vector3f.ZERO;
        }
        return World.getAllNpcsInRange((short)-1, position.x, position.y, position.z, range);
    }

    private static native Npc[] getAllNpcsInRange(short var0, float var1, float var2, float var3, float var4);

    public static native Npc[] getAllNpcsInArea(Area var0);

    public static native int getNumNpcs();

    public static native int getNextNpcGroupID();

    public static Npc findNearestNpc(Vector3f position) {
        return World.findNearestNpc((short)-1, position.x, position.y, position.z);
    }

    public static Npc findNearestNpc(float x, float y, float z) {
        return World.findNearestNpc((short)-1, x, y, z);
    }

    public static Npc findNearestNpc(short typeID, Vector3f position) {
        return World.findNearestNpc(typeID, position.x, position.y, position.z);
    }

    public static native Npc findNearestNpc(short var0, float var1, float var2, float var3);

    public static native boolean isNpcDisabled(short var0);

    public static Vehicle spawnVehicle(short typeID, int constructionStage, int color, Vector3f position, Quaternion rotation) {
        return World.spawnVehicle(typeID, constructionStage, color, position.x, position.y, position.z, rotation.x, rotation.y, rotation.z, rotation.w, false);
    }

    private static native Vehicle spawnVehicle(short var0, int var1, int var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, boolean var10);

    public static native Vehicle getVehicle(long var0);

    public static native Vehicle[] getAllVehicles();

    public static Vehicle[] getAllVehiclesInRange(Vector3f position, float range) {
        if (position == null) {
            position = Vector3f.ZERO;
        }
        return World.getAllVehiclesInRange(position.x, position.y, position.z, range);
    }

    private static native Vehicle[] getAllVehiclesInRange(float var0, float var1, float var2, float var3);

    public static native Vehicle[] getAllVehiclesInArea(Area var0);

    public static native int getNumVehicles();

    public static Vehicle findNearestVehicle(Vector3f position) {
        return World.findNearestVehicle((short)-1, position.x, position.y, position.z);
    }

    public static Vehicle findNearestVehicle(float x, float y, float z) {
        return World.findNearestVehicle((short)-1, x, y, z);
    }

    public static Vehicle findNearestVehicle(short typeID, Vector3f position) {
        return World.findNearestVehicle(typeID, position.x, position.y, position.z);
    }

    public static native Vehicle findNearestVehicle(short var0, float var1, float var2, float var3);

    public static native Storage createStorage(int var0, boolean var1);

    public static native Storage getStorage(long var0);

    public static native Storage[] getAllStorages();

    public static native int getNumStorages();

    public static ObjectElement createObject(int typeID, int variant, int color, Vector3f worldPosition, Quaternion rotation, Vector3f scale) {
        int cx = Utils.ChunkUtils.getChunkPositionX(worldPosition.x);
        int cy = Utils.ChunkUtils.getChunkPositionY(worldPosition.y);
        int cz = Utils.ChunkUtils.getChunkPositionZ(worldPosition.z);
        float x = Utils.ChunkUtils.getRelativePositionX(worldPosition.x, cx);
        float y = Utils.ChunkUtils.getRelativePositionY(worldPosition.y, cy);
        float z = Utils.ChunkUtils.getRelativePositionZ(worldPosition.z, cz);
        if (rotation == null) {
            rotation = Quaternion.IDENTITY;
        }
        if (scale == null) {
            scale = Vector3f.ONE;
        }
        return World.createObject(typeID, variant, color, 0, 0, cx, cy, cz, x, y, z, rotation.x, rotation.y, rotation.z, rotation.w, scale.x, scale.y, scale.z);
    }

    private static native ObjectElement createObject(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14, float var15, float var16, float var17);

    public static ObjectElement getObject(long globalID, int cx, int cy, int cz) {
        return World.getObject(globalID, cx, cy, cz, true);
    }

    private static native ObjectElement getObject(long var0, int var2, int var3, int var4, boolean var5);

    public static native MetaObject getMetaObject(long var0);

    public static native void removeObject(long var0, int var2, int var3, int var4, boolean var5);

    public static native Sign getSign(long var0);

    public static ConstructionElement createConstructionElement(int shape, int texture, float textureScale, int color, Vector3f worldPosition, Quaternion rotation, Vector3f scale) {
        return World.createConstructionElement(shape, texture, textureScale, color, worldPosition, rotation, scale, null, null);
    }

    public static ConstructionElement createConstructionElement(int shape, int texture, float textureScale, int color, Vector3f worldPosition, Quaternion rotation, Vector3f scale, Vector3f surfaceOffset, Vector3f surfaceScale) {
        int cx = Utils.ChunkUtils.getChunkPositionX(worldPosition.x);
        int cy = Utils.ChunkUtils.getChunkPositionY(worldPosition.y);
        int cz = Utils.ChunkUtils.getChunkPositionZ(worldPosition.z);
        float x = Utils.ChunkUtils.getRelativePositionX(worldPosition.x, cx);
        float y = Utils.ChunkUtils.getRelativePositionY(worldPosition.y, cy);
        float z = Utils.ChunkUtils.getRelativePositionZ(worldPosition.z, cz);
        if (rotation == null) {
            rotation = Quaternion.IDENTITY;
        }
        if (scale == null) {
            scale = Vector3f.ONE;
        }
        if (surfaceOffset == null) {
            surfaceOffset = Vector3f.ZERO;
        }
        if (surfaceScale == null) {
            surfaceScale = Vector3f.ONE;
        }
        return World.createConstructionElement(shape, texture, textureScale, color, 0.0f, 0, cx, cy, cz, x, y, z, rotation.x, rotation.y, rotation.z, rotation.w, scale.x, scale.y, scale.z, surfaceOffset.x, surfaceOffset.y, surfaceOffset.z, surfaceScale.x, surfaceScale.y, surfaceScale.z);
    }

    public static ConstructionElement createConstructionElement(int shape, int texture, float textureScale, int color, Vector3i chunkPosition, Vector3i blockPosition, Quaternion rotation, Vector3f scale) {
        return World.createConstructionElement(shape, texture, textureScale, color, 0.0f, 0, chunkPosition.x, chunkPosition.y, chunkPosition.z, (float)blockPosition.x + 0.5f, (float)blockPosition.y + 0.5f, (float)blockPosition.z + 0.5f, rotation.x, rotation.y, rotation.z, rotation.w, scale.x, scale.y, scale.z, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    private static native ConstructionElement createConstructionElement(int var0, int var1, float var2, int var3, float var4, int var5, int var6, int var7, int var8, float var9, float var10, float var11, float var12, float var13, float var14, float var15, float var16, float var17, float var18, float var19, float var20, float var21, float var22, float var23, float var24);

    public static native void createConstructionElements(ConstructionPlaceBatch var0);

    public static ConstructionElement getConstructionElement(long globalID, int cx, int cy, int cz) {
        return World.getConstructionElement(globalID, cx, cy, cz, true);
    }

    private static native ConstructionElement getConstructionElement(long var0, int var2, int var3, int var4, boolean var5);

    public static native void removeConstructionElement(long var0, int var2, int var3, int var4, boolean var5);

    public static Plant createPlant(int typeID, Vector3f worldPosition, Quaternion rotation, Vector3f scale) {
        int cx = Utils.ChunkUtils.getChunkPositionX(worldPosition.x);
        int cy = Utils.ChunkUtils.getChunkPositionY(worldPosition.y);
        int cz = Utils.ChunkUtils.getChunkPositionZ(worldPosition.z);
        float x = Utils.ChunkUtils.getRelativePositionX(worldPosition.x, cx);
        float y = Utils.ChunkUtils.getRelativePositionY(worldPosition.y, cy);
        float z = Utils.ChunkUtils.getRelativePositionZ(worldPosition.z, cz);
        return World.createPlant(typeID, 0, false, cx, cy, cz, x, y, z, rotation.x, rotation.y, rotation.z, rotation.w, scale.x, scale.y, scale.z);
    }

    private static native Plant createPlant(int var0, int var1, boolean var2, int var3, int var4, int var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14, float var15);

    public static native void createPlants(PlantPlaceBatch var0);

    public static Plant getPlant(long globalID, int cx, int cy, int cz) {
        return World.getPlant(globalID, cx, cy, cz, true);
    }

    private static native Plant getPlant(long var0, int var2, int var3, int var4, boolean var5);

    public static native void removePlant(long var0, int var2, int var3, int var4, boolean var5, boolean var6);

    public static void setTerrainData(int terrainID, int cx, int cy, int cz, int bx, int by, int bz, EditRestriction restriction) {
        World.setTerrainDataInRadius(terrainID, cx, cy, cz, bx, by, bz, 0, restriction == null ? 0 : restriction.ordinal());
    }

    public static void setTerrainDataInArea(int terrainID, Area area, EditRestriction restriction) {
        if (area == null) {
            return;
        }
        Vector3i start = area.getStartChunkPosition();
        Vector3i startBlock = area.getStartBlockPosition();
        Vector3i end = area.getEndChunkPosition();
        Vector3i endBlock = area.getEndBlockPosition();
        World.setTerrainDataInArea(terrainID, start.x, start.y, start.z, startBlock.x, startBlock.y, startBlock.z, end.x, end.y, end.z, endBlock.x, endBlock.y, endBlock.z, restriction == null ? 0 : restriction.ordinal());
    }

    public static void setTerrainDataInArea(int terrainID, Vector3i startChunk, Vector3i startBlock, Vector3i endChunk, Vector3i endBlock, EditRestriction restriction) {
        World.setTerrainDataInArea(terrainID, startChunk.x, startChunk.y, startChunk.z, startBlock.x, startBlock.y, startBlock.z, endChunk.x, endChunk.y, endChunk.z, endBlock.x, endBlock.y, endBlock.z, restriction == null ? 0 : restriction.ordinal());
    }

    private static native void setTerrainDataInArea(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13);

    public static void setTerrainDataInRadius(int terrainID, int cx, int cy, int cz, int bx, int by, int bz, int radius, EditRestriction restriction) {
        World.setTerrainDataInRadius(terrainID, cx, cy, cz, bx, by, bz, radius, restriction == null ? 0 : restriction.ordinal());
    }

    private static native void setTerrainDataInRadius(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public static native void executeWorldEditBatch(WorldEditBatch var0);

    public static native Chunk getChunk(int var0, int var1);

    public static native ChunkPart getChunkPart(int var0, int var1, int var2);

    public static native void triggerExplosion(Vector3f var0, Quaternion var1, Vector3f var2, float var3);
}

