/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.ui.style;

import java.nio.ByteBuffer;
import net.risingworld.api.ui.style.StyleField;
import net.risingworld.api.ui.style.StyleKeyword;

public final class StyleEnum<T extends Enum>
extends StyleField {
    private T value;
    private final transient Class<T> enumClass;

    StyleEnum(T value) {
        this.value = value;
        this.keyword = StyleKeyword.Null;
        this.enumClass = ((Enum)value).getDeclaringClass();
    }

    StyleEnum(StyleKeyword keyword, Class<T> enumClass) {
        this.value = null;
        this.keyword = keyword;
        this.enumClass = enumClass;
    }

    public void set(T value) {
        if (this.value != value || this.keyword != StyleKeyword.Undefined) {
            this.isDirty = true;
            this.isModified = true;
            this.value = value;
            this.keyword = StyleKeyword.Undefined;
        }
    }

    public void set(StyleKeyword keyword) {
        this.isDirty = true;
        this.isModified = true;
        this.keyword = keyword;
    }

    @Override
    public void reset() {
        this.set(StyleKeyword.Null);
    }

    public T get() {
        return this.value;
    }

    public StyleKeyword getKeyword() {
        return this.keyword;
    }

    @Override
    void serialize(ByteBuffer buffer) {
        buffer.put((byte)this.keyword.ordinal());
        buffer.put((byte)(this.value == null ? 0 : ((Enum)this.value).ordinal()));
    }

    @Override
    void deserialize(ByteBuffer buffer) {
        this.keyword = StyleKeyword.get(buffer.get());
        Enum[] enums = (Enum[])this.enumClass.getEnumConstants();
        this.value = enums[buffer.get()];
    }
}

