/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.objects.visuals;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.jiw.unity.runtime.PluginVisualsManager;
import net.risingworld.api.objects.visuals.Blur;
import net.risingworld.api.objects.visuals.ChromaticAberration;
import net.risingworld.api.objects.visuals.ColorFilter;
import net.risingworld.api.objects.visuals.Contrast;
import net.risingworld.api.objects.visuals.DarkTones;
import net.risingworld.api.objects.visuals.Effect;
import net.risingworld.api.objects.visuals.Exposure;
import net.risingworld.api.objects.visuals.FilmGrain;
import net.risingworld.api.objects.visuals.Fog;
import net.risingworld.api.objects.visuals.Highlights;
import net.risingworld.api.objects.visuals.Hue;
import net.risingworld.api.objects.visuals.LensDistortion;
import net.risingworld.api.objects.visuals.Midtones;
import net.risingworld.api.objects.visuals.Saturation;
import net.risingworld.api.objects.visuals.Vignette;
import net.risingworld.api.objects.visuals.WhiteBalance;

public final class PostProcessing {
    private static int BYTES = 1024;
    public final Contrast contrast = new Contrast();
    public final Saturation saturation = new Saturation();
    public final Hue hue = new Hue();
    public final ColorFilter colorFilter = new ColorFilter();
    public final FilmGrain filmGrain = new FilmGrain();
    public final ChromaticAberration chromaticAberration = new ChromaticAberration();
    public final LensDistortion lensDistortion = new LensDistortion();
    public final Blur blur = new Blur();
    public final Vignette vignette = new Vignette();
    public final WhiteBalance whiteBalance = new WhiteBalance();
    public final Exposure exposure = new Exposure();
    public final Fog fog = new Fog();
    public final DarkTones darktones = new DarkTones();
    public final Midtones midtones = new Midtones();
    public final Highlights highlights = new Highlights();

    private byte[] serialize(boolean force, boolean keepDirty) {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(BYTES);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            boolean wasDirty = false;
            int len = PluginVisualsManager.EffectFields.size();
            for (int i = 0; i < len; ++i) {
                Field f = (Field)PluginVisualsManager.EffectFields.get(i);
                Object o = f.get(this);
                if (o instanceof Effect) {
                    Effect field = (Effect)o;
                    if (force || field.isDirty) {
                        if (!keepDirty) {
                            field.isDirty = false;
                        }
                        buffer.put((byte)1);
                        buffer.put(field.isOverridden ? (byte)1 : 0);
                        field.serialize(buffer);
                        wasDirty = true;
                        continue;
                    }
                    buffer.put((byte)0);
                    continue;
                }
                buffer.put((byte)0);
            }
            if (buffer.position() == 0 || !wasDirty) {
                return null;
            }
            byte[] array = new byte[buffer.position()];
            buffer.flip();
            buffer.get(array);
            return array;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static enum Target {
        Player,
        World;

    }
}

