/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.definitions;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import net.jiw.unity.runtime.utils.DefinitionField;
import net.jiw.unity.runtime.utils.DefinitionMethod;
import net.jiw.unity.runtime.utils.InternalUtils;
import net.risingworld.api.definitions.Definitions;
import net.risingworld.api.definitions.Seasons;

public final class WeatherDefs {
    @DefinitionField
    public static final Weather Default = Definitions.getWeather("Default");
    @DefinitionField
    public static final Weather Clear = Definitions.getWeather("Clear");
    @DefinitionField
    public static final Weather Overcast = Definitions.getWeather("Overcast");
    @DefinitionField
    public static final Weather Breeze = Definitions.getWeather("Breeze");
    @DefinitionField
    public static final Weather Wind = Definitions.getWeather("Wind");
    @DefinitionField
    public static final Weather Storm = Definitions.getWeather("Storm");
    @DefinitionField
    public static final Weather Fog = Definitions.getWeather("Fog");
    @DefinitionField
    public static final Weather DenseFog = Definitions.getWeather("DenseFog");
    @DefinitionField
    public static final Weather LightRain = Definitions.getWeather("LightRain");
    @DefinitionField
    public static final Weather Rain = Definitions.getWeather("Rain");
    @DefinitionField
    public static final Weather HeavyRain = Definitions.getWeather("HeavyRain");
    @DefinitionField
    public static final Weather Cold = Definitions.getWeather("Cold");
    @DefinitionField
    public static final Weather ColdFog = Definitions.getWeather("ColdFog");
    @DefinitionField
    public static final Weather Thaw = Definitions.getWeather("Thaw");
    @DefinitionField
    public static final Weather SunnySnow = Definitions.getWeather("SunnySnow");
    @DefinitionField
    public static final Weather LightSnow = Definitions.getWeather("LightSnow");
    @DefinitionField
    public static final Weather Snow = Definitions.getWeather("Snow");
    @DefinitionField
    public static final Weather HeavySnow = Definitions.getWeather("HeavySnow");
    @DefinitionField
    public static final Weather Blizzard = Definitions.getWeather("Blizzard");

    private WeatherDefs() {
    }

    public final class Weather {
        public int id;
        public String name;
        public int fogattenuation;
        public int fogheight;
        public int fogcolor;
        public float rainintensity;
        public float snowintensity;
        public float windambience;
        public float windintensity;
        public float windgustmin;
        public float windgustmax;
        public float waveamplitude;
        public float wavesteepness;
        public float wavespeed;
        public float wavelength;
        public float pollenintensity;
        public int temperaturedifference;
        public float rainsoundintensity;
        public float faunaactivity;
        public boolean isgoodweather;
        public int sunvolumetrics;
        public float clouddensity;
        public float cloudshape;
        public float cloudscale;
        public float clouderosion;
        public float clouderosionscale;
        public float cloudaltitude;
        public float cloudthickness;
        public float cloudambient;
        public float auroraintensity;
        public Seasons.Season[] seasons;
        public Weather[] nextweathers;

        private Weather(WeatherDefs this$0) {
        }

        private void deserialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.id = buffer.getInt();
            this.name = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.fogattenuation = buffer.getInt();
            this.fogheight = buffer.getInt();
            this.fogcolor = buffer.getInt();
            this.rainintensity = buffer.getFloat();
            this.snowintensity = buffer.getFloat();
            this.windambience = buffer.getFloat();
            this.windintensity = buffer.getFloat();
            this.windgustmin = buffer.getFloat();
            this.windgustmax = buffer.getFloat();
            this.waveamplitude = buffer.getFloat();
            this.wavesteepness = buffer.getFloat();
            this.wavespeed = buffer.getFloat();
            this.wavelength = buffer.getFloat();
            this.pollenintensity = buffer.getFloat();
            this.temperaturedifference = buffer.getInt();
            this.rainsoundintensity = buffer.getFloat();
            this.faunaactivity = buffer.getFloat();
            this.isgoodweather = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.sunvolumetrics = buffer.getInt();
            this.clouddensity = buffer.getFloat();
            this.cloudshape = buffer.getFloat();
            this.cloudscale = buffer.getFloat();
            this.clouderosion = buffer.getFloat();
            this.clouderosionscale = buffer.getFloat();
            this.cloudaltitude = buffer.getFloat();
            this.cloudthickness = buffer.getFloat();
            this.cloudambient = buffer.getFloat();
            this.auroraintensity = buffer.getFloat();
            int iseasons = buffer.getInt();
            if (iseasons == -1) {
                this.seasons = null;
            } else if (iseasons >= 0) {
                this.seasons = new Seasons.Season[iseasons];
                for (int i = 0; i < iseasons; ++i) {
                    this.seasons[i] = Seasons.Season.get(buffer.getInt());
                }
            }
            int inextweathers = buffer.getInt();
            if (inextweathers == -1) {
                this.nextweathers = null;
            } else if (inextweathers >= 0) {
                this.nextweathers = new Weather[inextweathers];
                for (int i = 0; i < inextweathers; ++i) {
                    int nextweathers_id = buffer.getInt();
                    this.nextweathers[i] = nextweathers_id == -1 ? null : Definitions.getWeather(nextweathers_id);
                }
            }
        }

        private ByteBuffer serialize() {
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.getSize());
            this.serialize(buffer);
            return buffer;
        }

        private void serialize(ByteBuffer buffer) {
            int i;
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(this.id);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.name);
            buffer.putInt(this.fogattenuation);
            buffer.putInt(this.fogheight);
            buffer.putInt(this.fogcolor);
            buffer.putFloat(this.rainintensity);
            buffer.putFloat(this.snowintensity);
            buffer.putFloat(this.windambience);
            buffer.putFloat(this.windintensity);
            buffer.putFloat(this.windgustmin);
            buffer.putFloat(this.windgustmax);
            buffer.putFloat(this.waveamplitude);
            buffer.putFloat(this.wavesteepness);
            buffer.putFloat(this.wavespeed);
            buffer.putFloat(this.wavelength);
            buffer.putFloat(this.pollenintensity);
            buffer.putInt(this.temperaturedifference);
            buffer.putFloat(this.rainsoundintensity);
            buffer.putFloat(this.faunaactivity);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.isgoodweather);
            buffer.putInt(this.sunvolumetrics);
            buffer.putFloat(this.clouddensity);
            buffer.putFloat(this.cloudshape);
            buffer.putFloat(this.cloudscale);
            buffer.putFloat(this.clouderosion);
            buffer.putFloat(this.clouderosionscale);
            buffer.putFloat(this.cloudaltitude);
            buffer.putFloat(this.cloudthickness);
            buffer.putFloat(this.cloudambient);
            buffer.putFloat(this.auroraintensity);
            if (this.seasons == null) {
                buffer.putInt(-1);
            } else {
                buffer.putInt(this.seasons.length);
                for (i = 0; i < this.seasons.length; ++i) {
                    if (this.seasons[i] == null) {
                        throw new IllegalArgumentException("Enumeration must not be null!");
                    }
                    buffer.putInt(this.seasons[i].value);
                }
            }
            if (this.nextweathers == null) {
                buffer.putInt(-1);
            } else {
                buffer.putInt(this.nextweathers.length);
                for (i = 0; i < this.nextweathers.length; ++i) {
                    if (this.nextweathers[i] == null) {
                        buffer.putInt(-1);
                        continue;
                    }
                    buffer.putInt(this.nextweathers[i].id);
                }
            }
        }

        private int getSize() {
            int size = 113;
            size += 2;
            if (this.name != null) {
                size += this.name.length() * 2;
            }
            size += 4;
            if (this.seasons != null) {
                size += this.seasons.length * 4;
            }
            size += 4;
            if (this.nextweathers != null) {
                size += this.nextweathers.length * 4;
            }
            return size;
        }

        public void synchronize() {
            ArrayList<Object> synchronizedObjects = new ArrayList<Object>();
            this.synchronize(synchronizedObjects);
        }

        void synchronize(ArrayList<Object> synchronizedObjects) {
            synchronizedObjects.add(this);
            Definitions.synchronizeWeather(this.serialize());
            if (this.nextweathers != null) {
                for (int i = 0; i < this.nextweathers.length; ++i) {
                    Weather obj = this.nextweathers[i];
                    if (obj == null || synchronizedObjects.contains(obj)) continue;
                    obj.synchronize(synchronizedObjects);
                }
            }
        }

        @DefinitionMethod
        private void test() {
        }
    }

    public static enum Preset {
        Off(0),
        Default(1),
        Sunny(2),
        Unsettled(3);

        public final int value;
        private static Preset[] values;

        private Preset(int i) {
            this.value = i;
        }

        public static Preset get(int value) {
            if (values == null) {
                values = Preset.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Preset.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }
}

