/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.definitions;

public enum Terrain {
    Air(0),
    Stone(1),
    Gravel1(2),
    Gravel2(3),
    Gravel3(4),
    Dirt(5),
    Mud(6),
    Farmland(7),
    FarmlandWet(8),
    Forestground1(9),
    Forestground2(10),
    Forestground3(11),
    Forestmoss(12),
    Volcanic(13),
    Obsidian(14),
    ObsidianGlow(15),
    Drydirt(16),
    Sanddesert(17),
    Sandbeach(18),
    Sandunderwater(19),
    Desertstone(20),
    Sandstone1(21),
    Sandstone2(22),
    Redclay(23),
    Rubble(24),
    Snow(25),
    Ice(26),
    Underwater(27),
    Corals(28),
    Hellstone(29),
    HellstoneGlow(30),
    Cobble(31),
    Coal(50),
    Sulfur(51),
    Iron(52),
    Aluminium(53),
    Tungsten(54),
    Gold(55),
    Grass(100),
    GrassArid(105),
    GrassDry(110),
    GrassDead(115),
    GrassFrozen(120),
    GrassForest(125),
    GrassJungle(130),
    GrassSea(135),
    GrassSeaweed(140),
    GrassAridForest(145),
    Water(200),
    WaterFlow(201),
    WaterTemp(202),
    WaterInfinite(203),
    WaterStatic(204),
    SaltWater(210),
    SaltWaterFlow(211),
    SaltWaterTemp(212),
    SaltWaterInfinite(213),
    SaltWaterStatic(214);

    public final int id;
    private static final int TERRAIN_BITS = 255;
    private static final int STRENGTH_BITS = 65280;
    private static final int STRENGTH_BITSHIFT = 8;
    private static Terrain[] values;

    private Terrain(int id) {
        this.id = id;
    }

    public static Terrain get(int id) {
        id &= 0xFF;
        if (values == null) {
            values = Terrain.values();
        }
        for (int i = 0; i < values.length; ++i) {
            if (Terrain.values[i].id != id) continue;
            return values[i];
        }
        return null;
    }

    public static boolean isAir(int id) {
        return (id &= 0xFF) == Terrain.Air.id;
    }

    public static boolean isGrass(int id) {
        return (id &= 0xFF) >= 100 && id < 200;
    }

    public static boolean isWater(int id) {
        return (id &= 0xFF) >= 200;
    }

    public static boolean isOre(int id) {
        return (id &= 0xFF) >= 50 && id < 100;
    }

    public static short getRawID(Terrain terrain, float strength) {
        short terrainBits = (short)((byte)terrain.id & 0xFF);
        short strengthBits = (short)((byte)(strength * 100.0f) << 8);
        return (short)(terrainBits | strengthBits);
    }
}

