/*
 * Decompiled with CFR 0.152.
 */
package com.example.risingworld.discordadmin;

import com.example.risingworld.discordadmin.FileUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import net.risingworld.api.Internals;

public class PluginLogger {
    private final String pluginName;
    private File logFile;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final boolean fileLoggingEnabled;
    public static final int DEBUG = 0;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int SEVERE = 3;
    public static final int CRITICAL = 4;
    private int logLevel = 1;
    private boolean consoleDebug = false;

    public PluginLogger(String pluginName) {
        this.pluginName = pluginName;
        this.fileLoggingEnabled = this.initializeFileLogging();
    }

    public PluginLogger(String pluginName, Properties config) {
        this.pluginName = pluginName;
        this.fileLoggingEnabled = this.initializeFileLogging();
        if (config != null) {
            String configLevel = config.getProperty("logs.level", "INFO");
            this.setLogLevel(configLevel);
            this.consoleDebug = Boolean.parseBoolean(config.getProperty("logs.console.debug", "false"));
        }
    }

    public void configure(Properties config) {
        if (config == null) {
            return;
        }
        String levelStr = config.getProperty("logs.level", "INFO");
        this.setLogLevel(levelStr);
        this.consoleDebug = Boolean.parseBoolean(config.getProperty("logs.console.debug", "false"));
    }

    public void setLogLevel(String levelStr) {
        if (levelStr == null) {
            return;
        }
        switch (levelStr.toUpperCase()) {
            case "DEBUG": {
                this.logLevel = 0;
                break;
            }
            case "INFO": {
                this.logLevel = 1;
                break;
            }
            case "WARNING": {
                this.logLevel = 2;
                break;
            }
            case "SEVERE": {
                this.logLevel = 3;
                break;
            }
            case "CRITICAL": {
                this.logLevel = 4;
                break;
            }
            default: {
                this.logLevel = 1;
            }
        }
    }

    public String getLogLevelString() {
        switch (this.logLevel) {
            case 0: {
                return "DEBUG";
            }
            case 1: {
                return "INFO";
            }
            case 2: {
                return "WARNING";
            }
            case 3: {
                return "SEVERE";
            }
            case 4: {
                return "CRITICAL";
            }
        }
        return "UNKNOWN";
    }

    private boolean initializeFileLogging() {
        try {
            String basePath = "Logs/Discord_Admin";
            File logsDir = new File(basePath);
            if (FileUtils.ensureDirectoryExists(logsDir)) {
                String logFileName = "discord_admin_" + new SimpleDateFormat("yyyy-MM-dd").format(new Date()) + ".log";
                this.logFile = new File(logsDir, logFileName);
                if (!FileUtils.ensureParentDirectoryExists(this.logFile)) {
                    Internals.println("[" + this.pluginName + "] WARNING: Could not create parent directory for log file: " + this.logFile.getAbsolutePath(), 14);
                    return false;
                }
                try (PrintWriter writer = new PrintWriter(new FileWriter(this.logFile, true));){
                    writer.println(this.formatLogMessage("INFO", "Logging initialized"));
                }
                return true;
            }
            Internals.println("[" + this.pluginName + "] WARNING: Could not create log directory: " + logsDir.getAbsolutePath(), 14);
            return false;
        }
        catch (IOException e) {
            Internals.println("[" + this.pluginName + "] WARNING: Could not initialize file logging: " + e.getMessage(), 14);
            return false;
        }
    }

    private String formatLogMessage(String level, String message) {
        return String.format("[%s] [%s] %s: %s", this.dateFormat.format(new Date()), this.pluginName, level, message);
    }

    private void writeToFile(String level, String message) {
        if (!this.fileLoggingEnabled || this.logFile == null) {
            return;
        }
        try (PrintWriter writer = new PrintWriter(new FileWriter(this.logFile, true));){
            writer.println(this.formatLogMessage(level, message));
        }
        catch (IOException e) {
            Internals.println("[" + this.pluginName + "] ERROR: Failed to write to log file: " + e.getMessage(), 12);
        }
    }

    public void debug(String text) {
        if (text == null) {
            return;
        }
        this.writeToFile("DEBUG", text);
        if (this.consoleDebug || this.logLevel <= 0) {
            Internals.println("[" + this.pluginName + "] DEBUG: " + text, 15);
        }
    }

    public void info(String text) {
        if (text == null) {
            return;
        }
        this.writeToFile("INFO", text);
        if (this.logLevel <= 1) {
            Internals.println("[" + this.pluginName + "] INFO: " + text, 15);
        }
    }

    public void warning(String text) {
        if (text == null) {
            return;
        }
        this.writeToFile("WARNING", text);
        if (this.logLevel <= 2) {
            Internals.println("[" + this.pluginName + "] WARNING: " + text, 14);
        }
    }

    public void severe(String text) {
        if (text == null) {
            return;
        }
        this.writeToFile("SEVERE", text);
        if (this.logLevel <= 3) {
            Internals.println("[" + this.pluginName + "] SEVERE: " + text, 12);
        }
    }

    public void critical(String text) {
        if (text == null) {
            return;
        }
        this.writeToFile("CRITICAL", text);
        Internals.println("[" + this.pluginName + "] CRITICAL: " + text, 12);
    }

    public void log(Level level, String text, Throwable e) {
        if (level == null || text == null) {
            return;
        }
        StringBuilder message = new StringBuilder(text);
        if (e != null) {
            message.append(" - ").append(e.getMessage());
            if ((level == Level.SEVERE || level.intValue() >= Level.SEVERE.intValue()) && this.fileLoggingEnabled && this.logFile != null) {
                try (PrintWriter writer = new PrintWriter(new FileWriter(this.logFile, true));){
                    writer.println(this.formatLogMessage(level.getName(), text));
                    e.printStackTrace(writer);
                }
                catch (IOException ex) {
                    this.severe("Failed to write exception to log file: " + ex.getMessage());
                }
            }
        }
        if (level.intValue() >= Level.SEVERE.intValue()) {
            this.critical(message.toString());
        } else if (level == Level.SEVERE) {
            this.severe(message.toString());
        } else if (level == Level.WARNING) {
            this.warning(message.toString());
        } else if (level == Level.INFO) {
            this.info(message.toString());
        } else {
            this.debug(message.toString());
        }
    }

    public void severe(String text, Throwable e) {
        this.log(Level.SEVERE, text, e);
    }

    public void fine(String text) {
        this.debug(text);
    }

    public boolean isDebugEnabled() {
        return this.logLevel <= 0;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(int level) {
        if (level >= 0 && level <= 4) {
            this.logLevel = level;
        }
    }
}

