/*
 * Decompiled with CFR 0.152.
 */
package com.example.risingworld.discordadmin;

import com.example.risingworld.discordadmin.FileUtils;
import com.example.risingworld.discordadmin.PluginLogger;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class PlayerHistoryManager {
    private final String pluginPath;
    private final PluginLogger logger;
    private final File historyDir;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final ConcurrentHashMap<String, Long> lastActionTimes = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, List<PlayerNote>> cachedNotes = new ConcurrentHashMap();
    private static final long NOTE_COOLDOWN_MS = 2000L;
    private static final long HISTORY_CACHE_TTL_MS = 300000L;
    private static final int MAX_NOTES_PER_PLAYER = 50;

    public PlayerHistoryManager(String pluginPath, PluginLogger logger) {
        this.pluginPath = pluginPath;
        this.logger = logger;
        this.historyDir = new File(pluginPath, "player_history");
        if (FileUtils.ensureDirectoryExists(this.historyDir)) {
            logger.debug("Player history directory available at: " + this.historyDir.getAbsolutePath());
        } else {
            logger.warning("Failed to create player history directory at: " + this.historyDir.getAbsolutePath());
        }
    }

    public boolean addPlayerNote(String playerName, String staffName, String note, String type) {
        if (playerName == null || staffName == null || note == null) {
            return false;
        }
        String rateKey = staffName + "-note";
        Long lastAction = this.lastActionTimes.get(rateKey);
        long now = System.currentTimeMillis();
        if (lastAction != null && now - lastAction < 2000L) {
            this.logger.debug("Rate limited: " + staffName + " is adding notes too quickly");
            return false;
        }
        this.lastActionTimes.put(rateKey, now);
        String playerNameLower = playerName.toLowerCase();
        PlayerNote playerNote = new PlayerNote(this, UUID.randomUUID().toString(), playerName, staffName, note, type, new Date());
        File playerFile = this.getPlayerHistoryFile(playerNameLower);
        if (!FileUtils.ensureParentDirectoryExists(playerFile)) {
            this.logger.warning("Failed to create parent directory for player history file: " + playerFile.getAbsolutePath());
            return false;
        }
        try {
            JSONObject history;
            if (playerFile.exists()) {
                try (FileReader reader = new FileReader(playerFile);){
                    JSONParser parser = new JSONParser();
                    history = (JSONObject)parser.parse((Reader)reader);
                }
            } else {
                history = new JSONObject();
                history.put((Object)"playerName", (Object)playerName);
                history.put((Object)"playerNameLower", (Object)playerNameLower);
                history.put((Object)"firstSeen", (Object)this.dateFormat.format(new Date()));
                history.put((Object)"notes", (Object)new JSONArray());
            }
            JSONArray notes = (JSONArray)history.get((Object)"notes");
            if (notes.size() >= 50) {
                this.logger.warning("Player " + playerName + " has reached the maximum number of notes (50). Consider archiving older notes.");
                return false;
            }
            JSONObject noteJson = new JSONObject();
            noteJson.put((Object)"id", (Object)playerNote.getId());
            noteJson.put((Object)"staff", (Object)playerNote.getStaffName());
            noteJson.put((Object)"note", (Object)playerNote.getNote());
            noteJson.put((Object)"type", (Object)playerNote.getType());
            noteJson.put((Object)"timestamp", (Object)this.dateFormat.format(playerNote.getTimestamp()));
            notes.add((Object)noteJson);
            history.put((Object)"lastUpdated", (Object)this.dateFormat.format(new Date()));
            List cachedPlayerNotes = this.cachedNotes.computeIfAbsent(playerNameLower, k -> new ArrayList());
            cachedPlayerNotes.add(playerNote);
            try (FileWriter writer = new FileWriter(playerFile);){
                writer.write(history.toJSONString());
            }
            this.logger.debug("Added " + type + " to " + playerName + " by " + staffName);
            return true;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error adding note to player " + playerName, e);
            return false;
        }
    }

    public List<PlayerNote> getPlayerNotes(String playerName) {
        ArrayList<PlayerNote> arrayList;
        if (playerName == null) {
            return new ArrayList<PlayerNote>();
        }
        String playerNameLower = playerName.toLowerCase();
        List<PlayerNote> cachedPlayerNotes = this.cachedNotes.get(playerNameLower);
        if (cachedPlayerNotes != null) {
            return new ArrayList<PlayerNote>(cachedPlayerNotes);
        }
        File playerFile = this.getPlayerHistoryFile(playerNameLower);
        if (!playerFile.exists()) {
            return new ArrayList<PlayerNote>();
        }
        FileReader reader = new FileReader(playerFile);
        try {
            JSONParser parser = new JSONParser();
            JSONObject history = (JSONObject)parser.parse((Reader)reader);
            JSONArray notes = (JSONArray)history.get((Object)"notes");
            ArrayList<PlayerNote> result = new ArrayList<PlayerNote>();
            for (Object obj : notes) {
                JSONObject noteJson = (JSONObject)obj;
                PlayerNote note = new PlayerNote(this, (String)noteJson.get((Object)"id"), playerName, (String)noteJson.get((Object)"staff"), (String)noteJson.get((Object)"note"), (String)noteJson.get((Object)"type"), this.dateFormat.parse((String)noteJson.get((Object)"timestamp")));
                result.add(note);
            }
            this.cachedNotes.put(playerNameLower, new ArrayList(result));
            arrayList = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Error loading notes for player " + playerName, e);
                return new ArrayList<PlayerNote>();
            }
        }
        reader.close();
        return arrayList;
    }

    public boolean deleteNote(String playerName, String noteId, String staffName) {
        if (playerName == null || noteId == null || staffName == null) {
            return false;
        }
        String playerNameLower = playerName.toLowerCase();
        File playerFile = this.getPlayerHistoryFile(playerNameLower);
        if (!playerFile.exists()) {
            return false;
        }
        try {
            JSONObject history;
            try (FileReader reader = new FileReader(playerFile);){
                JSONParser parser = new JSONParser();
                history = (JSONObject)parser.parse((Reader)reader);
            }
            JSONArray notes = (JSONArray)history.get((Object)"notes");
            boolean found = false;
            for (int i = 0; i < notes.size(); ++i) {
                JSONObject noteJson = (JSONObject)notes.get(i);
                String id = (String)noteJson.get((Object)"id");
                if (!id.equals(noteId)) continue;
                notes.remove(i);
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
            history.put((Object)"lastUpdated", (Object)this.dateFormat.format(new Date()));
            try (FileWriter writer = new FileWriter(playerFile);){
                writer.write(history.toJSONString());
            }
            List<PlayerNote> cachedPlayerNotes = this.cachedNotes.get(playerNameLower);
            if (cachedPlayerNotes != null) {
                cachedPlayerNotes.removeIf(note -> note.getId().equals(noteId));
            }
            this.logger.debug("Note " + noteId + " for " + playerName + " deleted by " + staffName);
            return true;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error deleting note for player " + playerName, e);
            return false;
        }
    }

    public boolean addPlayerWarning(String playerName, String staffName, String reason) {
        boolean success = this.addPlayerNote(playerName, staffName, reason, "warning");
        if (success) {
            this.logger.info("Warning added to " + playerName + " by " + staffName + ": " + reason);
        }
        return success;
    }

    public String generateModerationReport(String playerName) {
        if (playerName == null) {
            return "No player specified";
        }
        List<PlayerNote> notes = this.getPlayerNotes(playerName);
        if (notes.isEmpty()) {
            return "No history found for player: " + playerName;
        }
        StringBuilder report = new StringBuilder();
        report.append("**Moderation Report for ").append(playerName).append("**\n\n");
        int warnings = 0;
        int regularNotes = 0;
        int moderationActions = 0;
        block8: for (PlayerNote note : notes) {
            switch (note.getType()) {
                case "warning": {
                    ++warnings;
                    continue block8;
                }
                case "moderation": {
                    ++moderationActions;
                    continue block8;
                }
            }
            ++regularNotes;
        }
        report.append("Total entries: ").append(notes.size()).append("\n");
        report.append("Warnings: ").append(warnings).append("\n");
        report.append("Moderation actions: ").append(moderationActions).append("\n");
        report.append("Notes: ").append(regularNotes).append("\n\n");
        report.append("**Recent History**\n");
        int count = 0;
        for (int i = notes.size() - 1; i >= 0 && count < 10; --i, ++count) {
            PlayerNote note = notes.get(i);
            report.append("- [").append(this.dateFormat.format(note.getTimestamp())).append("] **").append(note.getType().toUpperCase()).append("** by ").append(note.getStaffName()).append(": ").append(note.getNote()).append("\n");
        }
        return report.toString();
    }

    private File getPlayerHistoryFile(String playerNameLower) {
        return new File(this.historyDir, playerNameLower + ".json");
    }

    public void clearCache(String playerName) {
        if (playerName != null) {
            this.cachedNotes.remove(playerName.toLowerCase());
        }
    }

    public int getWarningCount(String playerName) {
        if (playerName == null) {
            return 0;
        }
        List<PlayerNote> notes = this.getPlayerNotes(playerName);
        int count = 0;
        for (PlayerNote note : notes) {
            if (!"warning".equals(note.getType())) continue;
            ++count;
        }
        return count;
    }

    public class PlayerNote {
        private final String id;
        private final String playerName;
        private final String staffName;
        private final String note;
        private final String type;
        private final Date timestamp;

        public PlayerNote(PlayerHistoryManager this$0, String id, String playerName, String staffName, String note, String type, Date timestamp) {
            this.id = id;
            this.playerName = playerName;
            this.staffName = staffName;
            this.note = note;
            this.type = type;
            this.timestamp = timestamp;
        }

        public String getId() {
            return this.id;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public String getStaffName() {
            return this.staffName;
        }

        public String getNote() {
            return this.note;
        }

        public String getType() {
            return this.type;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }
    }
}

