/*
 * Decompiled with CFR 0.152.
 */
package com.example.risingworld.discordadmin;

import com.example.risingworld.discordadmin.ConfigManager;
import com.example.risingworld.discordadmin.PluginLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Invite;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.UserSnowflake;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.events.guild.invite.GuildInviteCreateEvent;
import net.dv8tion.jda.api.events.guild.invite.GuildInviteDeleteEvent;
import net.dv8tion.jda.api.events.guild.member.GuildMemberJoinEvent;
import net.dv8tion.jda.api.exceptions.ErrorResponseException;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.requests.RestAction;

public class InviteManager
extends ListenerAdapter {
    private final JDA jda;
    private final PluginLogger logger;
    private final String pluginPath;
    private final ConfigManager configManager;
    private boolean useDynamicInvites;
    private String defaultDynamicInviteCode;
    private final ConcurrentHashMap<String, String> inviteToRoleMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Integer> inviteUsageCount = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Long> inviteCreationTimes = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Guild> inviteGuildMap = new ConcurrentHashMap();
    private String defaultInviteCode;
    private final int inviteTrackingWindow;
    private final boolean autoAssignRole;
    private static final String MAPPINGS_FILENAME = "invite_role_mappings.properties";

    public InviteManager(JDA jda, String pluginPath, PluginLogger logger, ConfigManager configManager) {
        this.jda = jda;
        this.logger = logger;
        this.pluginPath = pluginPath;
        this.configManager = configManager;
        Properties config = configManager.loadMainConfig();
        this.useDynamicInvites = configManager.getConfigBoolean(config, "invite.use_dynamic", false);
        this.inviteTrackingWindow = configManager.getConfigInt(config, "invite.tracking_window", 15);
        this.autoAssignRole = configManager.getConfigBoolean(config, "invite.auto_assign_role", true);
        this.loadInviteMappings();
        this.cacheExistingInvites();
        this.selectDefaultInvite();
    }

    public void setUseDynamicInvites(boolean useDynamic) {
        this.useDynamicInvites = useDynamic;
    }

    public boolean useDynamicInvites() {
        return this.useDynamicInvites;
    }

    public String getDefaultDynamicInviteCode() {
        return this.defaultDynamicInviteCode;
    }

    public RestAction<String> createDynamicInvite(String channelId, String roleId, int maxUses, int expirationHours) {
        TextChannel channel = this.jda.getTextChannelById(channelId);
        if (channel == null) {
            this.logger.warning("Cannot create dynamic invite: Channel ID " + channelId + " not found");
            return null;
        }
        if (roleId == null || roleId.isEmpty()) {
            this.logger.warning("Cannot create dynamic invite: Role ID is required");
            return null;
        }
        Role role = channel.getGuild().getRoleById(roleId);
        if (role == null) {
            this.logger.warning("Cannot create dynamic invite: Role ID " + roleId + " not found");
            return null;
        }
        return channel.createInvite().setMaxUses(Integer.valueOf(maxUses)).setMaxAge(Integer.valueOf(expirationHours > 0 ? expirationHours * 60 * 60 : 0)).map(invite -> {
            String code = invite.getCode();
            this.inviteUsageCount.put(code, 0);
            this.inviteGuildMap.put(code, channel.getGuild());
            this.inviteCreationTimes.put(code, System.currentTimeMillis());
            this.inviteToRoleMap.put(code, roleId);
            this.saveInviteMappings();
            this.defaultDynamicInviteCode = code;
            this.logger.info("Created dynamic invite: " + code + " with role assignment" + (String)(maxUses > 0 ? " (max uses: " + maxUses + ")" : "") + (String)(expirationHours > 0 ? " (expires in: " + expirationHours + " hours)" : ""));
            return code;
        });
    }

    private void loadInviteMappings() {
        Properties mappings = this.configManager.getMigrationManager().loadAndMigrateConfig(MAPPINGS_FILENAME, "invites", true, this::createEmptyMappingsFile);
        for (String code : mappings.stringPropertyNames()) {
            if (code.equals("config.version")) continue;
            this.inviteToRoleMap.put(code, mappings.getProperty(code));
        }
        this.logger.info("Loaded " + this.inviteToRoleMap.size() + " invite-role mappings");
    }

    private void createEmptyMappingsFile(Properties properties, File file) {
        try {
            file.getParentFile().mkdirs();
            try (FileOutputStream fos = new FileOutputStream(file);){
                properties.store(fos, "Discord Invite to Role ID Mappings");
                this.logger.info("Created default empty invite-role mappings file");
            }
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Failed to create mappings file", e);
        }
    }

    public void saveInviteMappings() {
        Properties mappings = new Properties();
        for (Map.Entry<String, String> entry : this.inviteToRoleMap.entrySet()) {
            mappings.setProperty(entry.getKey(), entry.getValue());
        }
        this.configManager.getMigrationManager().saveConfig(mappings, MAPPINGS_FILENAME, "Discord Invite to Role ID Mappings");
    }

    private void cacheExistingInvites() {
        for (Guild guild : this.jda.getGuilds()) {
            guild.retrieveInvites().queue(invites -> {
                for (Invite invite : invites) {
                    String code = invite.getCode();
                    this.inviteUsageCount.put(code, invite.getUses());
                    this.inviteGuildMap.put(code, guild);
                    this.inviteCreationTimes.put(code, System.currentTimeMillis());
                    this.logger.fine("Cached existing invite: " + code + " with " + invite.getUses() + " uses");
                }
            }, error -> {
                if (error instanceof ErrorResponseException) {
                    ErrorResponseException ere = (ErrorResponseException)error;
                    this.logger.warning("Discord API error retrieving invites from guild " + guild.getName() + ": Code " + ere.getErrorCode() + " - " + ere.getMeaning());
                } else {
                    this.logger.log(Level.WARNING, "Failed to retrieve invites from guild " + guild.getName(), (Throwable)error);
                }
            });
        }
    }

    public RestAction<String> createRoleInvite(String channelId, String roleId, int maxUses, int expirationHours) {
        TextChannel channel = this.jda.getTextChannelById(channelId);
        if (channel == null) {
            this.logger.warning("Cannot create invite: Channel ID " + channelId + " not found");
            return null;
        }
        Role role = channel.getGuild().getRoleById(roleId);
        if (role == null) {
            this.logger.warning("Cannot create invite: Role ID " + roleId + " not found");
            return null;
        }
        return channel.createInvite().setMaxUses(Integer.valueOf(maxUses)).setMaxAge(Integer.valueOf(expirationHours > 0 ? expirationHours * 60 * 60 : 0)).map(invite -> {
            String code = invite.getCode();
            this.inviteToRoleMap.put(code, roleId);
            this.inviteUsageCount.put(code, 0);
            this.inviteGuildMap.put(code, channel.getGuild());
            this.inviteCreationTimes.put(code, System.currentTimeMillis());
            this.saveInviteMappings();
            this.logger.info("Created role invite: " + code + " for role: " + role.getName());
            return code;
        });
    }

    public boolean linkExistingInvite(String channelId, String inviteCode, String roleId) {
        TextChannel channel = this.jda.getTextChannelById(channelId);
        if (channel == null) {
            this.logger.warning("Cannot link invite: Channel ID " + channelId + " not found");
            return false;
        }
        Role role = channel.getGuild().getRoleById(roleId);
        if (role == null) {
            this.logger.warning("Cannot link invite: Role ID " + roleId + " not found");
            return false;
        }
        Guild guild = channel.getGuild();
        guild.retrieveInvites().queue(invites -> {
            boolean found = false;
            for (Invite invite : invites) {
                if (!invite.getCode().equals(inviteCode)) continue;
                found = true;
                this.inviteToRoleMap.put(inviteCode, roleId);
                this.inviteUsageCount.put(inviteCode, invite.getUses());
                this.inviteGuildMap.put(inviteCode, guild);
                this.inviteCreationTimes.put(inviteCode, System.currentTimeMillis());
                this.saveInviteMappings();
                this.logger.info("Linked existing invite: " + inviteCode + " to role: " + role.getName());
                break;
            }
            if (!found) {
                this.logger.warning("Cannot link invite: Invite code " + inviteCode + " not found");
            }
        }, error -> this.logger.warning("Failed to retrieve invites: " + error.getMessage()));
        return true;
    }

    public boolean deleteRoleInvite(String inviteCode) {
        Guild guild = this.inviteGuildMap.get(inviteCode);
        if (guild == null) {
            for (Guild g : this.jda.getGuilds()) {
                g.retrieveInvites().queue(invites -> {
                    for (Invite invite : invites) {
                        if (!invite.getCode().equals(inviteCode)) continue;
                        invite.delete().queue(success -> {
                            this.inviteToRoleMap.remove(inviteCode);
                            this.inviteUsageCount.remove(inviteCode);
                            this.inviteGuildMap.remove(inviteCode);
                            this.inviteCreationTimes.remove(inviteCode);
                            this.saveInviteMappings();
                            this.logger.info("Deleted role invite: " + inviteCode);
                        }, error -> this.logger.warning("Failed to delete invite: " + error.getMessage()));
                        return;
                    }
                }, error -> {});
            }
            if (this.inviteToRoleMap.containsKey(inviteCode)) {
                this.inviteToRoleMap.remove(inviteCode);
                this.inviteUsageCount.remove(inviteCode);
                this.inviteCreationTimes.remove(inviteCode);
                this.saveInviteMappings();
                this.logger.info("Removed tracked invite: " + inviteCode);
            }
        } else {
            guild.retrieveInvites().queue(invites -> {
                boolean found = false;
                for (Invite invite : invites) {
                    if (!invite.getCode().equals(inviteCode)) continue;
                    found = true;
                    invite.delete().queue(success -> {
                        this.inviteToRoleMap.remove(inviteCode);
                        this.inviteUsageCount.remove(inviteCode);
                        this.inviteGuildMap.remove(inviteCode);
                        this.inviteCreationTimes.remove(inviteCode);
                        this.saveInviteMappings();
                        this.logger.info("Deleted role invite: " + inviteCode);
                    }, error -> this.logger.warning("Failed to delete invite: " + error.getMessage()));
                    break;
                }
                if (!found) {
                    this.logger.warning("Could not find invite with code: " + inviteCode);
                    this.inviteToRoleMap.remove(inviteCode);
                    this.inviteUsageCount.remove(inviteCode);
                    this.inviteGuildMap.remove(inviteCode);
                    this.inviteCreationTimes.remove(inviteCode);
                    this.saveInviteMappings();
                    this.logger.info("Removed tracked invite: " + inviteCode);
                }
            }, error -> {
                this.logger.warning("Failed to retrieve invites: " + error.getMessage());
                this.inviteToRoleMap.remove(inviteCode);
                this.inviteUsageCount.remove(inviteCode);
                this.inviteGuildMap.remove(inviteCode);
                this.inviteCreationTimes.remove(inviteCode);
                this.saveInviteMappings();
                this.logger.info("Removed tracked invite: " + inviteCode);
            });
        }
        if (inviteCode.equals(this.defaultInviteCode)) {
            this.defaultInviteCode = null;
            this.selectDefaultInvite();
        }
        return true;
    }

    public Map<String, String> listRoleInvites() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.inviteToRoleMap.entrySet()) {
            String guildName;
            String roleName;
            String inviteCode;
            block3: {
                String roleId;
                block2: {
                    inviteCode = entry.getKey();
                    roleId = entry.getValue();
                    roleName = "Unknown Role";
                    guildName = "Unknown Server";
                    Guild guild = this.inviteGuildMap.get(inviteCode);
                    if (guild == null) break block2;
                    guildName = guild.getName();
                    Role role = guild.getRoleById(roleId);
                    if (role == null) break block3;
                    roleName = role.getName();
                    break block3;
                }
                for (Guild g : this.jda.getGuilds()) {
                    Role role = g.getRoleById(roleId);
                    if (role == null) continue;
                    roleName = role.getName();
                    guildName = g.getName();
                    break;
                }
            }
            result.put(inviteCode, roleName + " (" + guildName + ")");
        }
        return result;
    }

    public String getDefaultInviteCode() {
        return this.defaultInviteCode;
    }

    public boolean setDefaultInviteCode(String inviteCode) {
        if (inviteCode == null || inviteCode.isEmpty()) {
            this.defaultInviteCode = null;
            return false;
        }
        if (this.inviteToRoleMap.containsKey(inviteCode)) {
            this.defaultInviteCode = inviteCode;
            this.logger.info("Set default invite code to: " + inviteCode);
            return true;
        }
        this.logger.warning("Cannot set default invite: code not found in tracked invites");
        return false;
    }

    private String selectDefaultInvite() {
        String inviteCode;
        if (this.inviteToRoleMap.isEmpty()) {
            this.logger.warning("No role invites available to use as default");
            return null;
        }
        this.defaultInviteCode = inviteCode = (String)((ConcurrentHashMap.KeySetView)this.inviteToRoleMap.keySet()).iterator().next();
        this.logger.info("Selected default Discord invite: " + inviteCode);
        return inviteCode;
    }

    public String getDiscordInviteUrl(String specificInviteCode) {
        String inviteCode;
        if (specificInviteCode != null && !specificInviteCode.isEmpty()) {
            inviteCode = specificInviteCode;
        } else if (this.useDynamicInvites && this.defaultDynamicInviteCode != null && !this.defaultDynamicInviteCode.isEmpty()) {
            inviteCode = this.defaultDynamicInviteCode;
            this.logger.debug("Using dynamic invite: " + inviteCode);
        } else if (this.defaultInviteCode != null && !this.defaultInviteCode.isEmpty()) {
            inviteCode = this.defaultInviteCode;
        } else {
            return null;
        }
        return inviteCode;
    }

    public void onGuildMemberJoin(GuildMemberJoinEvent event) {
        if (!this.autoAssignRole) {
            this.logger.fine("Auto role assignment disabled, skipping invite tracking");
            return;
        }
        Guild guild = event.getGuild();
        Member member = event.getMember();
        long joinTime = System.currentTimeMillis();
        String[] usedInviteCode = new String[]{null};
        String[] usedRoleId = new String[]{null};
        guild.retrieveInvites().queue(currentInvites -> {
            Role role;
            String code;
            for (Invite invite : currentInvites) {
                code = invite.getCode();
                int currentUses = invite.getUses();
                Integer previousUses = this.inviteUsageCount.get(code);
                if (previousUses == null || currentUses <= previousUses) continue;
                this.inviteUsageCount.put(code, currentUses);
                usedInviteCode[0] = code;
                usedRoleId[0] = this.inviteToRoleMap.get(code);
                break;
            }
            if (usedInviteCode[0] == null) {
                for (Invite invite : currentInvites) {
                    code = invite.getCode();
                    Long creationTime = this.inviteCreationTimes.get(code);
                    if (creationTime == null || invite.getUses() <= 0 || (joinTime - creationTime) / 1000L > (long)this.inviteTrackingWindow) continue;
                    usedInviteCode[0] = code;
                    usedRoleId[0] = this.inviteToRoleMap.get(code);
                    break;
                }
            }
            if (usedRoleId[0] != null && (role = guild.getRoleById(usedRoleId[0])) != null) {
                guild.addRoleToMember((UserSnowflake)member, role).queue(success -> this.logger.info("Added role " + role.getName() + " to " + member.getUser().getName() + " via invite " + usedInviteCode[0]), error -> this.logger.warning("Failed to add role: " + error.getMessage()));
            }
            for (Invite invite : currentInvites) {
                this.inviteUsageCount.put(invite.getCode(), invite.getUses());
                this.inviteGuildMap.put(invite.getCode(), guild);
            }
        }, error -> this.logger.warning("Failed to retrieve invites on member join: " + error.getMessage()));
    }

    public void onGuildInviteCreate(GuildInviteCreateEvent event) {
        String code = event.getCode();
        this.inviteUsageCount.put(code, 0);
        this.inviteGuildMap.put(code, event.getGuild());
        this.inviteCreationTimes.put(code, System.currentTimeMillis());
        this.logger.fine("Tracked new invite: " + code);
    }

    public void onGuildInviteDelete(GuildInviteDeleteEvent event) {
        String code = event.getCode();
        this.inviteUsageCount.remove(code);
        this.inviteGuildMap.remove(code);
        this.inviteCreationTimes.remove(code);
        if (this.inviteToRoleMap.containsKey(code)) {
            this.inviteToRoleMap.remove(code);
            this.saveInviteMappings();
            this.logger.fine("Removed role mapping for deleted invite: " + code);
        }
        if (code.equals(this.defaultInviteCode)) {
            this.defaultInviteCode = null;
            this.selectDefaultInvite();
        }
        if (code.equals(this.defaultDynamicInviteCode)) {
            this.defaultDynamicInviteCode = null;
        }
    }
}

