/*
 * Decompiled with CFR 0.152.
 */
package com.example.risingworld.discordadmin;

import com.example.risingworld.discordadmin.DiscordService;
import com.example.risingworld.discordadmin.FileUtils;
import com.example.risingworld.discordadmin.PluginLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.exceptions.ErrorResponseException;

public class DiscordMessagePersistence {
    private final PluginLogger logger;
    private final String pluginPath;
    private static final String MESSAGES_FILENAME = "discord_messages.properties";
    public static final String TYPE_JOIN = "join";
    public static final String TYPE_LEAVE = "leave";
    private final ConcurrentHashMap<String, List<MessageInfo>> persistedMessages = new ConcurrentHashMap();

    public DiscordMessagePersistence(PluginLogger logger, String pluginPath) {
        this.logger = logger;
        this.pluginPath = pluginPath;
        this.loadMessages();
    }

    public void loadMessages() {
        Properties properties = new Properties();
        File messagesFile = new File(this.pluginPath, MESSAGES_FILENAME);
        if (!messagesFile.exists()) {
            this.logger.debug("Discord messages persistence file does not exist yet");
            return;
        }
        try (FileInputStream fis = new FileInputStream(messagesFile);){
            properties.load(fis);
            for (String key : properties.stringPropertyNames()) {
                String[] messageEntries;
                String[] parts;
                if (key.equals("version") || key.equals("config.version") || (parts = key.split("_", 2)).length != 2) continue;
                String type = parts[0];
                String playerName = parts[1];
                String value = properties.getProperty(key);
                List messageInfoList = this.persistedMessages.computeIfAbsent(key, k -> new ArrayList());
                for (String entry : messageEntries = value.split(";")) {
                    String[] valueParts = entry.split(":", 2);
                    if (valueParts.length != 2) continue;
                    String messageId = valueParts[0];
                    String channelId = valueParts[1];
                    messageInfoList.add(new MessageInfo(type, playerName, messageId, channelId));
                }
            }
            int totalMessages = 0;
            for (List<MessageInfo> messages : this.persistedMessages.values()) {
                totalMessages += messages.size();
            }
            this.logger.info("Loaded " + totalMessages + " persisted Discord messages for " + this.persistedMessages.size() + " player entries");
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Failed to load Discord messages", e);
        }
    }

    public void saveMessage(String type, String playerName, Message message) {
        if (message == null || playerName == null || type == null) {
            return;
        }
        String key = type + "_" + playerName.toLowerCase();
        String messageId = message.getId();
        String channelId = message.getChannel().getId();
        List messages = this.persistedMessages.computeIfAbsent(key, k -> new ArrayList());
        MessageInfo info = new MessageInfo(type, playerName, messageId, channelId);
        boolean exists = false;
        for (MessageInfo existing : messages) {
            if (!existing.messageId.equals(messageId)) continue;
            exists = true;
            break;
        }
        if (!exists) {
            messages.add(info);
            this.logger.debug("Added message " + messageId + " to persistence for " + playerName + " (" + type + ")");
        }
        this.saveToFile();
    }

    private void saveToFile() {
        Properties properties = new Properties();
        File messagesFile = new File(this.pluginPath, MESSAGES_FILENAME);
        if (!FileUtils.ensureParentDirectoryExists(messagesFile)) {
            this.logger.warning("Failed to create parent directory for discord messages file");
            return;
        }
        properties.setProperty("config.version", "3.6.1");
        for (Map.Entry<String, List<MessageInfo>> entry : this.persistedMessages.entrySet()) {
            List<MessageInfo> messageList = entry.getValue();
            if (messageList.isEmpty()) continue;
            StringBuilder valueBuilder = new StringBuilder();
            for (int i = 0; i < messageList.size(); ++i) {
                MessageInfo info = messageList.get(i);
                valueBuilder.append(info.messageId).append(":").append(info.channelId);
                if (i >= messageList.size() - 1) continue;
                valueBuilder.append(";");
            }
            properties.setProperty(entry.getKey(), valueBuilder.toString());
        }
        try (FileOutputStream fos = new FileOutputStream(messagesFile);){
            properties.store(fos, "Discord Messages for Deletion");
            int totalMessages = 0;
            for (List<MessageInfo> messages : this.persistedMessages.values()) {
                totalMessages += messages.size();
            }
            this.logger.debug("Saved " + totalMessages + " Discord messages across " + this.persistedMessages.size() + " player entries to persistence file");
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Failed to save Discord messages", e);
        }
    }

    public void removeMessage(String type, String playerName) {
        String key = type + "_" + playerName.toLowerCase();
        List<MessageInfo> removed = this.persistedMessages.remove(key);
        if (removed != null && !removed.isEmpty()) {
            this.logger.debug("Removed " + removed.size() + " persisted messages for " + playerName + " (" + type + ")");
            this.saveToFile();
        }
    }

    public void clearAllMessages() {
        this.persistedMessages.clear();
        this.logger.debug("Cleared all persisted messages without deletion");
        this.saveToFile();
    }

    public Map<String, Boolean> deleteAllPersistedMessages(DiscordService discordService, String messageDeleteMode) {
        HashMap<String, Boolean> results = new HashMap<String, Boolean>();
        if (discordService == null || !discordService.isConnected()) {
            this.logger.warning("Cannot delete persisted messages: Discord service is not connected");
            return results;
        }
        if ("never".equals(messageDeleteMode)) {
            this.logger.info("Message deletion is disabled (mode: never). Clearing message persistence without deleting messages.");
            this.clearAllMessages();
            return results;
        }
        JDA jda = discordService.getJDA();
        if (jda == null) {
            this.logger.warning("Cannot delete persisted messages: JDA is null");
            return results;
        }
        for (Map.Entry<String, List<MessageInfo>> entry : new HashMap<String, List<MessageInfo>>(this.persistedMessages).entrySet()) {
            String key = entry.getKey();
            List<MessageInfo> infoList = entry.getValue();
            if (infoList.isEmpty()) continue;
            String playerName = infoList.get((int)0).playerName;
            boolean playerSuccess = true;
            ArrayList<MessageInfo> toProcess = new ArrayList<MessageInfo>(infoList);
            for (MessageInfo info : toProcess) {
                try {
                    TextChannel channel = jda.getTextChannelById(info.channelId);
                    if (channel == null) {
                        this.logger.debug("Channel not found for message: " + info.messageId);
                        playerSuccess = false;
                        continue;
                    }
                    try {
                        ((Message)channel.retrieveMessageById(info.messageId).complete()).delete().complete();
                        this.logger.debug("Successfully deleted persisted " + info.type + " message for " + playerName + " (ID: " + info.messageId + ")");
                        this.removeSpecificMessage(info.type, playerName, info.messageId);
                    }
                    catch (Exception e) {
                        ErrorResponseException ere;
                        playerSuccess = false;
                        this.logger.debug("Failed to delete persisted " + info.type + " message for " + playerName + ": " + e.getMessage());
                        if (!(e instanceof ErrorResponseException) || (ere = (ErrorResponseException)e).getErrorCode() != 10008) continue;
                        this.removeSpecificMessage(info.type, playerName, info.messageId);
                    }
                }
                catch (Exception e) {
                    playerSuccess = false;
                    this.logger.debug("Error processing persisted message for " + playerName + ": " + e.getMessage());
                }
            }
            results.put(playerName, playerSuccess);
        }
        return results;
    }

    public List<String> getMessageIds(String type, String playerName) {
        String key = type + "_" + playerName.toLowerCase();
        List<MessageInfo> messages = this.persistedMessages.get(key);
        if (messages == null || messages.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> messageIds = new ArrayList<String>();
        for (MessageInfo info : messages) {
            messageIds.add(info.messageId);
        }
        return messageIds;
    }

    public void removeSpecificMessage(String type, String playerName, String messageId) {
        String key = type + "_" + playerName.toLowerCase();
        List<MessageInfo> messages = this.persistedMessages.get(key);
        if (messages != null) {
            ArrayList<MessageInfo> toRemove = new ArrayList<MessageInfo>();
            for (MessageInfo info : messages) {
                if (!info.messageId.equals(messageId)) continue;
                toRemove.add(info);
            }
            if (!toRemove.isEmpty()) {
                messages.removeAll(toRemove);
                this.logger.debug("Removed " + toRemove.size() + " messages with ID " + messageId + " from persistence for " + playerName + " (" + type + ")");
                if (messages.isEmpty()) {
                    this.persistedMessages.remove(key);
                }
                this.saveToFile();
            }
        }
    }

    public int getPlayerCount() {
        return this.persistedMessages.size();
    }

    public int getMessageCount() {
        int count = 0;
        for (List<MessageInfo> messages : this.persistedMessages.values()) {
            count += messages.size();
        }
        return count;
    }

    public boolean hasMessage(String type, String playerName) {
        String key = type + "_" + playerName.toLowerCase();
        List<MessageInfo> messages = this.persistedMessages.get(key);
        return messages != null && !messages.isEmpty();
    }

    private static class MessageInfo {
        final String type;
        final String playerName;
        final String messageId;
        final String channelId;

        public MessageInfo(String type, String playerName, String messageId, String channelId) {
            this.type = type;
            this.playerName = playerName;
            this.messageId = messageId;
            this.channelId = channelId;
        }
    }
}

