/*
 * Decompiled with CFR 0.152.
 */
package com.example.risingworld.discordadmin;

import com.example.risingworld.discordadmin.PluginLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class ConfigFormatVerifier {
    private final PluginLogger logger;
    private final String pluginPath;
    private static final List<String> REQUIRED_SECTIONS = Arrays.asList("Discord Bot Configuration", "Chat Relay Settings", "Server Status Display Settings", "Automatic Restart Configuration");
    private static final Pattern SECTION_HEADER_PATTERN = Pattern.compile("^#\\s*={10,}\\s*$");

    public ConfigFormatVerifier(PluginLogger logger, String pluginPath) {
        this.logger = logger;
        this.pluginPath = pluginPath;
    }

    public boolean verifyAndFixConfigFormatting(Properties config) {
        File configFile = new File(this.pluginPath, "config.properties");
        if (!configFile.exists()) {
            this.logger.warning("Config file not found, cannot check formatting");
            return false;
        }
        try {
            if (this.hasProperFormatting(configFile)) {
                this.logger.debug("Config file has proper formatting");
                return false;
            }
            this.logger.info("Config file has lost its formatting. Restoring format while preserving settings...");
            File backupFile = new File(this.pluginPath, "config.properties.unformatted.bak");
            FileUtils.copyFile(configFile, backupFile);
            this.logger.info("Created backup of unformatted config at: " + backupFile.getAbsolutePath());
            this.rewriteConfigWithProperFormatting(configFile, config);
            this.logger.info("Config file formatting has been restored");
            return true;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error verifying config formatting", e);
            return false;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasProperFormatting(File configFile) throws IOException {
        sectionHeadersFound = 0;
        reader = new BufferedReader(new FileReader(configFile));
        try {
            block6: while (true) {
                if ((line = reader.readLine()) == null) return false;
                if (!ConfigFormatVerifier.SECTION_HEADER_PATTERN.matcher(line).matches()) continue;
                ++sectionHeadersFound;
                nextLine = reader.readLine();
                if (nextLine == null) {
                    return false;
                }
                var6_8 = ConfigFormatVerifier.REQUIRED_SECTIONS.iterator();
                do {
                    if (var6_8.hasNext()) ** break;
                    continue block6;
                } while (!nextLine.contains(requiredSection = var6_8.next()));
                break;
            }
            var8_10 = true;
            return var8_10;
        }
        finally {
            reader.close();
        }
    }

    private void rewriteConfigWithProperFormatting(File configFile, Properties config) throws IOException {
        try (FileWriter writer = new FileWriter(configFile);){
            writer.write("# Discord Admin Plugin Configuration v3.7\n");
            writer.write("# This file contains all configuration settings for the Discord Admin Plugin.\n");
            writer.write("# Settings are grouped by function for easier navigation.\n\n");
            writer.write("# =========================================================================\n");
            writer.write("# Discord Bot Configuration\n");
            writer.write("# =========================================================================\n");
            writer.write("# Required settings for Discord bot functionality\n");
            writer.write("# Your Discord bot token (required) - Get this from the Discord Developer Portal\n");
            writer.write("discord.token=" + this.getProperty(config, "discord.token", "") + "\n\n");
            writer.write("# Discord channel ID for admin communications (required)\n");
            writer.write("discord.admin.channel=" + this.getProperty(config, "discord.admin.channel", "") + "\n\n");
            writer.write("# Bot activity status shown in Discord (e.g. \"Watching Rising World\")\n");
            writer.write("discord.bot.activity=" + this.getProperty(config, "discord.bot.activity", "Watching Rising World") + "\n\n");
            writer.write("# =========================================================================\n");
            writer.write("# Chat Relay Settings\n");
            writer.write("# =========================================================================\n");
            writer.write("# Configure communication between Discord and the game\n\n");
            writer.write("# Enable chat relay from game to Discord\n");
            writer.write("chat.relay.game_to_discord=" + this.getProperty(config, "chat.relay.game_to_discord", "true") + "\n\n");
            writer.write("# Enable chat relay from Discord to game\n");
            writer.write("chat.relay.discord_to_game=" + this.getProperty(config, "chat.relay.discord_to_game", "true") + "\n\n");
            writer.write("# Format for messages sent from Discord to game\n");
            writer.write("# Available placeholders: %author%, %message%\n");
            writer.write("chat.format.discord_to_game=" + this.getProperty(config, "chat.format.discord_to_game", "[Discord] %author%: %message%") + "\n\n");
            writer.write("# Format for messages sent from game to Discord\n");
            writer.write("# Available placeholders: %player%, %message%\n");
            writer.write("chat.format.game_to_discord=" + this.getProperty(config, "chat.format.game_to_discord", "[Game] %player%: %message%") + "\n\n");
            writer.write("# =========================================================================\n");
            writer.write("# Chat Filter Settings\n");
            writer.write("# =========================================================================\n");
            writer.write("# Configure filtering of inappropriate content in chat\n\n");
            writer.write("# Enable the chat filter (true/false)\n");
            writer.write("chat.filter.enabled=" + this.getProperty(config, "chat.filter.enabled", "false") + "\n\n");
            writer.write("# Comma-separated list of words to filter from chat\n");
            writer.write("chat.filter.words=" + this.getProperty(config, "chat.filter.words", "badword1,badword2") + "\n\n");
            writer.write("# =========================================================================\n");
            writer.write("# Server Status Display Settings\n");
            writer.write("# =========================================================================\n");
            writer.write("# Configure how server status is displayed in Discord\n\n");
            writer.write("# Enable automatic status updates\n");
            writer.write("status.updates.enabled=" + this.getProperty(config, "status.updates.enabled", "true") + "\n\n");
            writer.write("# Status update interval in minutes\n");
            writer.write("status.updates.interval=" + this.getProperty(config, "status.updates.interval", "10") + "\n\n");
            writer.write("# Embed colors for different server states (hex format)\n");
            writer.write("status.embed.online.color=" + this.getProperty(config, "status.embed.online.color", "#00FF00") + "\n");
            writer.write("status.embed.offline.color=" + this.getProperty(config, "status.embed.offline.color", "#FF0000") + "\n");
            writer.write("status.embed.restart.color=" + this.getProperty(config, "status.embed.restart.color", "#FFA500") + "\n\n");
            writer.write("# Maximum number of players to display in status message\n");
            writer.write("status.embed.max_players=" + this.getProperty(config, "status.embed.max_players", "15") + "\n\n");
            writer.write("# Show admin status in player list (true/false)\n");
            writer.write("status.embed.show_admin=" + this.getProperty(config, "status.embed.show_admin", "false") + "\n\n");
            writer.write("# Show player connection time in player list (true/false)\n");
            writer.write("status.embed.show_player_time=" + this.getProperty(config, "status.embed.show_player_time", "false") + "\n\n");
            writer.write("# Always recreate status message on startup instead of reusing existing one (true/false)\n");
            writer.write("status.embed.recreate_on_startup=" + this.getProperty(config, "status.embed.recreate_on_startup", "false") + "\n\n");
            writer.write("# =========================================================================\n");
            writer.write("# Automatic Restart Configuration\n");
            writer.write("# =========================================================================\n");
            writer.write("# Configure scheduled server restarts\n\n");
            writer.write("# Enable daily automatic restarts (true/false)\n");
            writer.write("restart.daily.enabled=" + this.getProperty(config, "restart.daily.enabled", "true") + "\n\n");
            writer.write("# Daily restart time in 24-hour format (HH:MM)\n");
            writer.write("restart.daily.time=" + this.getProperty(config, "restart.daily.time", "04:00") + "\n\n");
            writer.write("# Timezone for restart scheduling (e.g. UTC, America/New_York)\n");
            writer.write("restart.timezone=" + this.getProperty(config, "restart.timezone", TimeZone.getDefault().getID()) + "\n\n");
            writer.write("# Warning countdown in minutes before restart\n");
            writer.write("restart.countdown.minutes=" + this.getProperty(config, "restart.countdown.minutes", "30") + "\n\n");
            writer.write("# Warning times in minutes (comma-separated)\n");
            writer.write("restart.warning.times=" + this.getProperty(config, "restart.warning.times", "20,15,10,5,3,1") + "\n\n");
            writer.write("# Prefix for restart warning messages\n");
            writer.write("restart.broadcast.prefix=" + this.getProperty(config, "restart.broadcast.prefix", "\u26a0\ufe0f **SERVER RESTART**") + "\n\n");
            writer.write("# Create backup before restart (true/false)\n");
            writer.write("restart.pre_shutdown.backup=" + this.getProperty(config, "restart.pre_shutdown.backup", "true") + "\n\n");
            writer.write("# Action to take when immediate restart is triggered: \"lock\" or \"kick\"\n");
            writer.write("restart.immediate_action=" + this.getProperty(config, "restart.immediate_action", "lock") + "\n\n");
            writer.write("# Server restart command\n");
            writer.write("restart.command=" + this.getProperty(config, "restart.command", "") + "\n\n");
            writer.write("# =========================================================================\n");
            writer.write("# Discord Message Management\n");
            writer.write("# =========================================================================\n");
            writer.write("# Configure how plugin messages are handled in Discord\n\n");
            writer.write("# Delay (in seconds) before deleting messages\n");
            writer.write("discord.message.delete.delay=" + this.getProperty(config, "discord.message.delete.delay", "300") + "\n\n");
            writer.write("# Message deletion mode: \"always\", \"on_restart\", or \"never\"\n");
            writer.write("discord.message.delete.mode=" + this.getProperty(config, "discord.message.delete.mode", "always") + "\n\n");
            writer.write("# Send notifications about errors (true/false)\n");
            writer.write("discord.error.notification.enabled=" + this.getProperty(config, "discord.error.notification.enabled", "true") + "\n\n");
            writer.write("# Send notification when plugin starts (true/false)\n");
            writer.write("discord.startup.notification=" + this.getProperty(config, "discord.startup.notification", "true") + "\n\n");
            writer.write("# =========================================================================\n");
            writer.write("# Player Management\n");
            writer.write("# =========================================================================\n");
            writer.write("# Configure player connection settings\n\n");
            writer.write("# Enable logging of player connections (true/false)\n");
            writer.write("player.connection.log.enabled=" + this.getProperty(config, "player.connection.log.enabled", "true") + "\n\n");
            writer.write("# Directory for player connection logs\n");
            writer.write("player.connection.log.directory=" + this.getProperty(config, "player.connection.log.directory", "player_connections") + "\n\n");
            writer.write("# Track time between player rejoins (true/false)\n");
            writer.write("player.rejoin.time.track=" + this.getProperty(config, "player.rejoin.time.track", "true") + "\n\n");
            writer.write("# Enable player history tracking (true/false)\n");
            writer.write("player.history.enabled=" + this.getProperty(config, "player.history.enabled", "true") + "\n\n");
            writer.write("# Maximum number of notes per player\n");
            writer.write("player.history.max_notes=" + this.getProperty(config, "player.history.max_notes", "50") + "\n\n");
            writer.write("# Enable welcome message for new players (true/false)\n");
            writer.write("player.welcome.message.enabled=" + this.getProperty(config, "player.welcome.message.enabled", "true") + "\n\n");
            writer.write("# Welcome message text (placeholder: %player%)\n");
            writer.write("player.welcome.message=" + this.getProperty(config, "player.welcome.message", "Welcome to the server, %player%!") + "\n\n");
            writer.write("# =========================================================================\n");
            writer.write("# Message Format Settings\n");
            writer.write("# =========================================================================\n");
            writer.write("# Format for various system messages\n\n");
            writer.write("# Player join message format (placeholder: %player%)\n");
            writer.write("message.join.format=" + this.getProperty(config, "message.join.format", "\ud83d\udfe2 **%player% joined the server**") + "\n\n");
            writer.write("# Player leave message format (placeholder: %player%)\n");
            writer.write("message.leave.format=" + this.getProperty(config, "message.leave.format", "\ud83d\udd34 **%player% left the server**") + "\n\n");
            writer.write("# =========================================================================\n");
            writer.write("# Discord Invite Management\n");
            writer.write("# =========================================================================\n");
            writer.write("# Configure automatic role assignments and Discord invites\n\n");
            writer.write("# Automatically assign roles based on invite used\n");
            writer.write("invite.auto_assign_role=" + this.getProperty(config, "invite.auto_assign_role", "true") + "\n\n");
            writer.write("# Tracking window (in seconds) for invite usage detection\n");
            writer.write("invite.tracking_window=" + this.getProperty(config, "invite.tracking_window", "15") + "\n\n");
            writer.write("# Discord welcome message for new members (placeholder: %user%)\n");
            writer.write("invite.welcome_message=" + this.getProperty(config, "invite.welcome_message", "Welcome, %user%! Join our game server with /link") + "\n\n");
            writer.write("# Master switch to enable/disable Discord invites completely\n");
            writer.write("invite.enabled=" + this.getProperty(config, "invite.enabled", "true") + "\n\n");
            writer.write("# Use dynamic invites with expiry (true) or permanent invites (false)\n");
            writer.write("invite.use_dynamic=" + this.getProperty(config, "invite.use_dynamic", "false") + "\n\n");
            writer.write("# Enable automatic Discord invite on player join (true/false)\n");
            writer.write("invite.auto_send_on_join=" + this.getProperty(config, "invite.auto_send_on_join", "true") + "\n\n");
            writer.write("# Default maximum uses for dynamic invites (0 for unlimited)\n");
            writer.write("invite.dynamic.max_uses=" + this.getProperty(config, "invite.dynamic.max_uses", "1") + "\n\n");
            writer.write("# Default expiration hours for dynamic invites (0 for never)\n");
            writer.write("invite.dynamic.expiration_hours=" + this.getProperty(config, "invite.dynamic.expiration_hours", "24") + "\n\n");
            writer.write("# Role ID to assign for dynamic invites (required)\n");
            writer.write("invite.dynamic.role_id=" + this.getProperty(config, "invite.dynamic.role_id", "") + "\n\n");
            writer.write("# =========================================================================\n");
            writer.write("# Backup Configuration\n");
            writer.write("# =========================================================================\n");
            writer.write("# Configure automatic backups\n\n");
            writer.write("# Directory for backups\n");
            writer.write("backup.directory=" + this.getProperty(config, "backup.directory", "backups") + "\n\n");
            writer.write("# Maximum number of backups to keep\n");
            writer.write("backup.max_count=" + this.getProperty(config, "backup.max_count", "10") + "\n\n");
            writer.write("# =========================================================================\n");
            writer.write("# Plugin Logging\n");
            writer.write("# =========================================================================\n");
            writer.write("# Configure plugin logging behavior\n\n");
            writer.write("# Maximum number of log files to keep\n");
            writer.write("logs.max_files=" + this.getProperty(config, "logs.max_files", "30") + "\n\n");
            writer.write("# Directory for log files\n");
            writer.write("logs.directory=" + this.getProperty(config, "logs.directory", "logs") + "\n\n");
            writer.write("# Log level (DEBUG, INFO, WARNING, SEVERE, CRITICAL)\n");
            writer.write("logs.level=" + this.getProperty(config, "logs.level", "INFO") + "\n\n");
            writer.write("# Enable console output for debug logs (true/false)\n");
            writer.write("logs.console.debug=" + this.getProperty(config, "logs.console.debug", "false") + "\n\n");
            writer.write("# =========================================================================\n");
            writer.write("# Command Cooldown Settings\n");
            writer.write("# =========================================================================\n");
            writer.write("# Configure cooldowns for commands to prevent spam\n\n");
            writer.write("# Enable command cooldowns (true/false)\n");
            writer.write("command.cooldown.enabled=" + this.getProperty(config, "command.cooldown.enabled", "false") + "\n\n");
            writer.write("# Cooldown period in seconds\n");
            writer.write("command.cooldown.seconds=" + this.getProperty(config, "command.cooldown.seconds", "5") + "\n\n");
            writer.write("# Enable command permissions (true/false)\n");
            writer.write("command.permissions.enabled=" + this.getProperty(config, "command.permissions.enabled", "true") + "\n\n");
            writer.write("# =========================================================================\n");
            writer.write("# System Information\n");
            writer.write("# =========================================================================\n");
            writer.write("# Internal version tracking (do not modify)\n");
            writer.write("config.version=" + this.getProperty(config, "config.version", "3.7") + "\n");
        }
    }

    private String getProperty(Properties config, String key, String defaultValue) {
        return config.getProperty(key, defaultValue);
    }

    private static class FileUtils {
        private FileUtils() {
        }

        public static void copyFile(File source, File destination) throws IOException {
            Files.copy(source.toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

