/*
 * Decompiled with CFR 0.152.
 */
package com.example.risingworld.discordadmin;

import com.example.risingworld.discordadmin.PluginLogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class ChatFilter {
    private final PluginLogger logger;
    private final Set<String> filteredWords = new HashSet<String>();
    private final List<Pattern> regexPatterns = new ArrayList<Pattern>();
    private boolean enabled = false;

    public ChatFilter(PluginLogger logger) {
        this.logger = logger;
    }

    public void initialize(String filteredWordsStr, boolean enabled) {
        String[] words;
        this.enabled = enabled;
        this.filteredWords.clear();
        this.regexPatterns.clear();
        if (!enabled || filteredWordsStr == null || filteredWordsStr.isEmpty()) {
            this.logger.info("Chat filter is disabled or empty");
            return;
        }
        for (String word : words = filteredWordsStr.split(",")) {
            if ((word = word.trim().toLowerCase()).isEmpty()) continue;
            this.filteredWords.add(word);
            StringBuilder patternBuilder = new StringBuilder("(?i)");
            for (char c : word.toCharArray()) {
                if (Character.isLetter(c)) {
                    String replacements = this.getCommonReplacements(c);
                    patternBuilder.append("[").append(replacements).append("]");
                } else {
                    patternBuilder.append(Pattern.quote(String.valueOf(c)));
                }
                patternBuilder.append("\\s*");
            }
            try {
                Pattern pattern = Pattern.compile(patternBuilder.toString());
                this.regexPatterns.add(pattern);
            }
            catch (Exception e) {
                this.logger.warning("Invalid regex pattern for filtered word: " + word);
            }
        }
        this.logger.info("Chat filter initialized with " + this.filteredWords.size() + " filtered words");
    }

    private String getCommonReplacements(char c) {
        switch (Character.toLowerCase(c)) {
            case 'a': {
                return "aA@4";
            }
            case 'b': {
                return "bB8";
            }
            case 'e': {
                return "eE3";
            }
            case 'i': {
                return "iI!1";
            }
            case 'l': {
                return "lL1|";
            }
            case 'o': {
                return "oO0";
            }
            case 's': {
                return "sS$5";
            }
            case 't': {
                return "tT7+";
            }
        }
        return Character.toString(c) + Character.toUpperCase(c);
    }

    public String filterMessage(String message) {
        if (!this.enabled || message == null || message.isEmpty()) {
            return message;
        }
        String filteredMessage = message;
        for (String word : this.filteredWords) {
            if (!filteredMessage.toLowerCase().contains(word)) continue;
            filteredMessage = this.replaceWithStars(filteredMessage, word);
        }
        for (Pattern pattern : this.regexPatterns) {
            filteredMessage = pattern.matcher(filteredMessage).replaceAll(match -> "*".repeat(match.group().length()));
        }
        return filteredMessage;
    }

    private String replaceWithStars(String message, String word) {
        String stars = "*".repeat(word.length());
        return message.replaceAll("(?i)" + Pattern.quote(word), stars);
    }

    public boolean containsFilteredContent(String message) {
        if (!this.enabled || message == null || message.isEmpty()) {
            return false;
        }
        String messageLower = message.toLowerCase();
        for (String word : this.filteredWords) {
            if (!messageLower.contains(word)) continue;
            return true;
        }
        for (Pattern pattern : this.regexPatterns) {
            if (!pattern.matcher(message).find()) continue;
            return true;
        }
        return false;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

