/*
 * Decompiled with CFR 0.152.
 */
package waterwheel;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.Timer;
import net.risingworld.api.World;
import net.risingworld.api.assets.AssetBundle;
import net.risingworld.api.assets.PrefabAsset;
import net.risingworld.api.database.Database;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerDisconnectEvent;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.events.player.PlayerMouseButtonEvent;
import net.risingworld.api.events.player.ui.PlayerUIElementClickEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.ui.UILabel;
import net.risingworld.api.ui.UITextField;
import net.risingworld.api.ui.style.TextAnchor;
import net.risingworld.api.utils.Key;
import net.risingworld.api.utils.Layer;
import net.risingworld.api.utils.MouseButton;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.worldelements.GameObject;
import net.risingworld.api.worldelements.Prefab;

public class WaterWheel
extends Plugin
implements Listener {
    private static final Logger LOGGER = Logger.getLogger(WaterWheel.class.getName());
    private static final String BUNDLE_PATH = "/Assets/waterwheel.bundle";
    private static final String PREFAB_NAME = "WaterWheel.prefab";
    private static final int PREVIEW_TIMEOUT_SECONDS = 120;
    private static final int YELL_MESSAGE_DURATION = 2;
    private Database database;
    private Database database2;
    private final ArrayList<Prefab> previewWaterWheels = new ArrayList();
    private final ArrayList<Prefab> waterWheels = new ArrayList();
    private ExecutorService databaseExecutor;

    public void onEnable() {
        System.out.println("-- WaterWheel PLUGIN ENABLED --");
        this.databaseExecutor = Executors.newSingleThreadExecutor();
        String worldName = World.getName();
        this.database = this.getSQLiteConnection(this.getPath() + "/" + worldName + "/database.db");
        this.database2 = this.getSQLiteConnection(this.getPath() + "/" + worldName + "/database.db");
        this.database.execute("CREATE TABLE IF NOT EXISTS `WaterWheels` (`ID` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,`WaterWheelPosition` TEXT,`PlayerUID` TEXT,`WaterWheelID` INTEGER,`WaterWheelRotation` REAL);");
        this.database.execute("CREATE TABLE IF NOT EXISTS `WaterWheelAllowedPlayers` (`ID` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,`PlayerName` TEXT,`PlayerUID` TEXT);");
        try (ResultSet result = this.database.executeQuery("SELECT * FROM `WaterWheels`");){
            while (result.next()) {
                int wheelID = result.getInt("WaterWheelID");
                String position = result.getString("WaterWheelPosition");
                Vector3f pos = new Vector3f().add(Vector3f.ONE).fromString(position);
                float rotation = result.getFloat("WaterWheelRotation");
                Prefab wheel = this.createWaterWheelPrefab(pos, rotation);
                if (wheelID < 0) continue;
                int newWheelID = wheel.getID();
                this.databaseExecutor.submit(() -> this.database2.executeUpdate("UPDATE WaterWheels SET `WaterWheelID` = '" + newWheelID + "' WHERE `WaterWheelID` = '" + wheelID + "' AND `WaterWheelPosition` = '" + position + "'"));
                this.waterWheels.add(wheel);
            }
        }
        catch (SQLException ex) {
            LOGGER.log(Level.SEVERE, "Failed to load water wheels", ex);
        }
        this.registerEventListener(this);
    }

    public void onDisable() {
        if (this.databaseExecutor != null) {
            this.databaseExecutor.shutdown();
        }
    }

    private Prefab createWaterWheelPrefab(Vector3f position, float rotation) {
        AssetBundle bundle = AssetBundle.loadFromFile((String)(this.getPath() + BUNDLE_PATH));
        PrefabAsset asset = PrefabAsset.loadFromAssetBundle((AssetBundle)bundle, (String)PREFAB_NAME);
        Prefab prefab = new Prefab(asset);
        prefab.setLayer(15);
        prefab.setLocalPosition(position);
        prefab.setLocalRotation(0.0f, rotation + 180.0f, 0.0f);
        return prefab;
    }

    private boolean canPlaceWaterWheel(Player player) {
        boolean bl;
        block9: {
            if (player.isAdmin()) {
                return true;
            }
            ResultSet rs = this.database.executeQuery("SELECT * FROM `WaterWheelAllowedPlayers` WHERE PlayerUID = '" + player.getUID() + "'");
            try {
                bl = rs.next();
                if (rs == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    LOGGER.log(Level.SEVERE, "Failed to check allowed players", ex);
                    return false;
                }
            }
            rs.close();
        }
        return bl;
    }

    private void showAdminPanel(Player player) {
        UIElement panel = new UIElement();
        player.addUIElement(panel);
        panel.setSize(300.0f, 250.0f, false);
        panel.setPosition(50.0f, 50.0f, true);
        panel.setBorder(5.0f);
        panel.setBorderColor(999);
        panel.setBackgroundColor(0.1f, 0.1f, 0.1f, 0.9f);
        panel.setVisible(true);
        player.setAttribute("WaterWheel_AdminPanel", (Object)panel);
        player.setAttribute("WaterWheel_AdminPanelID", (Object)panel.getID());
        UILabel title = new UILabel();
        title.setRichTextEnabled(true);
        title.setFontSize(16.0f);
        title.setText("WaterWheel Admin Panel");
        title.setPosition(20.0f, 20.0f, false);
        panel.addChild((UIElement)title);
        UITextField playerField = new UITextField();
        playerField.setSize(260.0f, 30.0f, false);
        playerField.setPosition(20.0f, 50.0f, false);
        playerField.setBorder(2.0f);
        playerField.setBorderColor(999);
        playerField.setBackgroundColor(0.2f, 0.2f, 0.2f, 0.9f);
        playerField.setText("Select a Player");
        panel.addChild((UIElement)playerField);
        player.setAttribute("WaterWheel_AdminPlayerField", (Object)playerField);
        player.setAttribute("WaterWheel_AdminPlayerFieldID", (Object)playerField.getID());
        ArrayList<Player> onlinePlayers = new ArrayList<Player>(Arrays.asList(Server.getAllPlayers()));
        player.setAttribute("WaterWheel_OnlinePlayers", onlinePlayers);
        player.setAttribute("WaterWheel_CurrentPlayerIndex", (Object)-1);
        UILabel backButton = new UILabel();
        backButton.setClickable(true);
        backButton.setRichTextEnabled(true);
        backButton.setFontSize(14.0f);
        backButton.setText(" Back ");
        backButton.setBorder(2.0f);
        backButton.setBorderColor(999);
        backButton.style.textAlign.set((Enum)TextAnchor.MiddleCenter);
        backButton.setPosition(20.0f, 90.0f, false);
        backButton.setBackgroundColor(0.2f, 0.2f, 0.2f, 0.9f);
        backButton.hoverStyle.backgroundColor.set(0.3f, 0.3f, 0.3f, 0.9f);
        panel.addChild((UIElement)backButton);
        player.setAttribute("WaterWheel_AdminBackButton", (Object)backButton);
        player.setAttribute("WaterWheel_AdminBackButtonID", (Object)backButton.getID());
        UILabel nextButton = new UILabel();
        nextButton.setClickable(true);
        nextButton.setRichTextEnabled(true);
        nextButton.setFontSize(14.0f);
        nextButton.setText(" Next ");
        nextButton.setBorder(2.0f);
        nextButton.setBorderColor(999);
        nextButton.style.textAlign.set((Enum)TextAnchor.MiddleCenter);
        nextButton.setPosition(80.0f, 90.0f, false);
        nextButton.setBackgroundColor(0.2f, 0.2f, 0.2f, 0.9f);
        nextButton.hoverStyle.backgroundColor.set(0.3f, 0.3f, 0.3f, 0.9f);
        panel.addChild((UIElement)nextButton);
        player.setAttribute("WaterWheel_AdminNextButton", (Object)nextButton);
        player.setAttribute("WaterWheel_AdminNextButtonID", (Object)nextButton.getID());
        UILabel addButton = new UILabel();
        addButton.setClickable(true);
        addButton.setRichTextEnabled(true);
        addButton.setFontSize(14.0f);
        addButton.setText(" Add Player ");
        addButton.setBorder(2.0f);
        addButton.setBorderColor(999);
        addButton.style.textAlign.set((Enum)TextAnchor.MiddleCenter);
        addButton.setPosition(20.0f, 130.0f, false);
        addButton.setBackgroundColor(0.2f, 0.2f, 0.2f, 0.9f);
        addButton.hoverStyle.backgroundColor.set(0.3f, 0.3f, 0.3f, 0.9f);
        panel.addChild((UIElement)addButton);
        player.setAttribute("WaterWheel_AdminAddButton", (Object)addButton);
        player.setAttribute("WaterWheel_AdminAddButtonID", (Object)addButton.getID());
        UILabel removeButton = new UILabel();
        removeButton.setClickable(true);
        removeButton.setRichTextEnabled(true);
        removeButton.setFontSize(14.0f);
        removeButton.setText(" Remove Player ");
        removeButton.setBorder(2.0f);
        removeButton.setBorderColor(999);
        removeButton.style.textAlign.set((Enum)TextAnchor.MiddleCenter);
        removeButton.setPosition(110.0f, 130.0f, false);
        removeButton.setBackgroundColor(0.2f, 0.2f, 0.2f, 0.9f);
        removeButton.hoverStyle.backgroundColor.set(0.3f, 0.3f, 0.3f, 0.9f);
        panel.addChild((UIElement)removeButton);
        player.setAttribute("WaterWheel_AdminRemoveButton", (Object)removeButton);
        player.setAttribute("WaterWheel_AdminRemoveButtonID", (Object)removeButton.getID());
        UILabel closeButton = new UILabel();
        closeButton.setClickable(true);
        closeButton.setRichTextEnabled(true);
        closeButton.setFontSize(14.0f);
        closeButton.setText(" Close ");
        closeButton.setBorder(2.0f);
        closeButton.setBorderColor(999);
        closeButton.style.textAlign.set((Enum)TextAnchor.MiddleCenter);
        closeButton.setPosition(20.0f, 170.0f, false);
        closeButton.setBackgroundColor(0.2f, 0.2f, 0.2f, 0.9f);
        closeButton.hoverStyle.backgroundColor.set(0.3f, 0.3f, 0.3f, 0.9f);
        panel.addChild((UIElement)closeButton);
        player.setAttribute("WaterWheel_AdminCloseButton", (Object)closeButton);
        player.setAttribute("WaterWheel_AdminCloseButtonID", (Object)closeButton.getID());
        player.setMouseCursorVisible(true);
    }

    private void showRemovePlayerPanel(Player player) {
        UIElement panel = new UIElement();
        player.addUIElement(panel);
        panel.setSize(300.0f, 250.0f, false);
        panel.setPosition(50.0f, 50.0f, true);
        panel.setBorder(5.0f);
        panel.setBorderColor(999);
        panel.setBackgroundColor(0.1f, 0.1f, 0.1f, 0.9f);
        panel.setVisible(true);
        player.setAttribute("WaterWheel_RemovePanel", (Object)panel);
        player.setAttribute("WaterWheel_RemovePanelID", (Object)panel.getID());
        UILabel title = new UILabel();
        title.setRichTextEnabled(true);
        title.setFontSize(16.0f);
        title.setText("Remove Allowed Player");
        title.setPosition(20.0f, 20.0f, false);
        panel.addChild((UIElement)title);
        UILabel playerField = new UILabel();
        playerField.setSize(260.0f, 30.0f, false);
        playerField.setPosition(20.0f, 50.0f, false);
        playerField.setBorder(2.0f);
        playerField.setBorderColor(999);
        playerField.setBackgroundColor(0.2f, 0.2f, 0.2f, 0.9f);
        playerField.setText("Select a Player");
        panel.addChild((UIElement)playerField);
        player.setAttribute("WaterWheel_RemovePlayerField", (Object)playerField);
        player.setAttribute("WaterWheel_RemovePlayerFieldID", (Object)playerField.getID());
        List<String[]> allowedPlayers = this.getAllowedPlayers();
        player.setAttribute("WaterWheel_RemovePlayers", allowedPlayers);
        player.setAttribute("WaterWheel_RemovePlayerIndex", (Object)-1);
        UILabel backButton = new UILabel();
        backButton.setClickable(true);
        backButton.setRichTextEnabled(true);
        backButton.setFontSize(14.0f);
        backButton.setText(" Previous ");
        backButton.setBorder(2.0f);
        backButton.setBorderColor(999);
        backButton.style.textAlign.set((Enum)TextAnchor.MiddleCenter);
        backButton.setPosition(20.0f, 90.0f, false);
        backButton.setBackgroundColor(0.2f, 0.2f, 0.2f, 0.9f);
        backButton.hoverStyle.backgroundColor.set(0.3f, 0.3f, 0.3f, 0.9f);
        panel.addChild((UIElement)backButton);
        player.setAttribute("WaterWheel_RemoveBackButton", (Object)backButton);
        player.setAttribute("WaterWheel_RemoveBackButtonID", (Object)backButton.getID());
        UILabel nextButton = new UILabel();
        nextButton.setClickable(true);
        nextButton.setRichTextEnabled(true);
        nextButton.setFontSize(14.0f);
        nextButton.setText(" Next ");
        nextButton.setBorder(2.0f);
        nextButton.setBorderColor(999);
        nextButton.style.textAlign.set((Enum)TextAnchor.MiddleCenter);
        nextButton.setPosition(110.0f, 90.0f, false);
        nextButton.setBackgroundColor(0.2f, 0.2f, 0.2f, 0.9f);
        nextButton.hoverStyle.backgroundColor.set(0.3f, 0.3f, 0.3f, 0.9f);
        panel.addChild((UIElement)nextButton);
        player.setAttribute("WaterWheel_RemoveNextButton", (Object)nextButton);
        player.setAttribute("WaterWheel_RemoveNextButtonID", (Object)nextButton.getID());
        UILabel removeButton = new UILabel();
        removeButton.setClickable(true);
        removeButton.setRichTextEnabled(true);
        removeButton.setFontSize(14.0f);
        removeButton.setText(" Remove ");
        removeButton.setBorder(2.0f);
        removeButton.setBorderColor(999);
        removeButton.style.textAlign.set((Enum)TextAnchor.MiddleCenter);
        removeButton.setPosition(20.0f, 130.0f, false);
        removeButton.setBackgroundColor(0.2f, 0.2f, 0.2f, 0.9f);
        removeButton.hoverStyle.backgroundColor.set(0.3f, 0.3f, 0.3f, 0.9f);
        panel.addChild((UIElement)removeButton);
        player.setAttribute("WaterWheel_RemoveActionButton", (Object)removeButton);
        player.setAttribute("WaterWheel_RemoveActionButtonID", (Object)removeButton.getID());
        UILabel backAdminButton = new UILabel();
        backAdminButton.setClickable(true);
        backAdminButton.setRichTextEnabled(true);
        backAdminButton.setFontSize(14.0f);
        backAdminButton.setText(" Back ");
        backAdminButton.setBorder(2.0f);
        backAdminButton.setBorderColor(999);
        backAdminButton.style.textAlign.set((Enum)TextAnchor.MiddleCenter);
        backAdminButton.setPosition(110.0f, 130.0f, false);
        backAdminButton.setBackgroundColor(0.2f, 0.2f, 0.2f, 0.9f);
        backAdminButton.hoverStyle.backgroundColor.set(0.3f, 0.3f, 0.3f, 0.9f);
        panel.addChild((UIElement)backAdminButton);
        player.setAttribute("WaterWheel_RemoveBackAdminButton", (Object)backAdminButton);
        player.setAttribute("WaterWheel_RemoveBackAdminButtonID", (Object)backAdminButton.getID());
        UILabel cancelButton = new UILabel();
        cancelButton.setClickable(true);
        cancelButton.setRichTextEnabled(true);
        cancelButton.setFontSize(14.0f);
        cancelButton.setText(" Cancel ");
        cancelButton.setBorder(2.0f);
        cancelButton.setBorderColor(999);
        cancelButton.style.textAlign.set((Enum)TextAnchor.MiddleCenter);
        cancelButton.setPosition(20.0f, 170.0f, false);
        cancelButton.setBackgroundColor(0.2f, 0.2f, 0.2f, 0.9f);
        cancelButton.hoverStyle.backgroundColor.set(0.3f, 0.3f, 0.3f, 0.9f);
        panel.addChild((UIElement)cancelButton);
        player.setAttribute("WaterWheel_RemoveCancelButton", (Object)cancelButton);
        player.setAttribute("WaterWheel_RemoveCancelButtonID", (Object)cancelButton.getID());
        player.setMouseCursorVisible(true);
    }

    private List<String[]> getAllowedPlayers() {
        ArrayList<String[]> allowedPlayers = new ArrayList<String[]>();
        try (ResultSet rs = this.database.executeQuery("SELECT PlayerName, PlayerUID FROM `WaterWheelAllowedPlayers`");){
            while (rs.next()) {
                allowedPlayers.add(new String[]{rs.getString("PlayerName"), rs.getString("PlayerUID")});
            }
        }
        catch (SQLException ex) {
            LOGGER.log(Level.SEVERE, "Failed to load allowed players", ex);
        }
        return allowedPlayers;
    }

    @EventMethod
    public void onPlayerConnect(PlayerConnectEvent event) {
        Player player = event.getPlayer();
        player.registerKeys(new Key[]{Key.Escape, Key.Delete});
        player.setListenForKeyInput(true);
        player.setListenForMouseInput(true);
        player.setAttribute("WaterWheels", (Object)false);
        player.setAttribute("WaterWheel_AdminPanelID", (Object)0);
        player.setAttribute("WaterWheel_AdminPlayerFieldID", (Object)0);
        player.setAttribute("WaterWheel_AdminBackButtonID", (Object)0);
        player.setAttribute("WaterWheel_AdminNextButtonID", (Object)0);
        player.setAttribute("WaterWheel_AdminAddButtonID", (Object)0);
        player.setAttribute("WaterWheel_AdminRemoveButtonID", (Object)0);
        player.setAttribute("WaterWheel_AdminCloseButtonID", (Object)0);
        player.setAttribute("WaterWheel_OnlinePlayers", new ArrayList());
        player.setAttribute("WaterWheel_CurrentPlayerIndex", (Object)-1);
        player.setAttribute("WaterWheel_RemovePanelID", (Object)0);
        player.setAttribute("WaterWheel_RemovePlayerFieldID", (Object)0);
        player.setAttribute("WaterWheel_RemoveBackButtonID", (Object)0);
        player.setAttribute("WaterWheel_RemoveNextButtonID", (Object)0);
        player.setAttribute("WaterWheel_RemoveActionButtonID", (Object)0);
        player.setAttribute("WaterWheel_RemoveBackAdminButtonID", (Object)0);
        player.setAttribute("WaterWheel_RemoveCancelButtonID", (Object)0);
        player.setAttribute("WaterWheel_RemovePlayers", new ArrayList());
        player.setAttribute("WaterWheel_RemovePlayerIndex", (Object)-1);
        for (Prefab wheel : this.waterWheels) {
            if (wheel == null) continue;
            player.addGameObject((GameObject)wheel);
        }
    }

    @EventMethod
    public void onPlayerDisconnect(PlayerDisconnectEvent event) {
        Timer previewTimer;
        Player player = event.getPlayer();
        Timer raycastTimer = (Timer)player.getAttribute("raycastTimer");
        if (raycastTimer != null) {
            raycastTimer.kill();
        }
        if ((previewTimer = (Timer)player.getAttribute("RemovePreviewTimer")) != null) {
            previewTimer.kill();
        }
    }

    @EventMethod
    public void onPlayerKeyInput(PlayerKeyEvent event) throws SQLException {
        if (!event.isPressed()) {
            return;
        }
        Player player = event.getPlayer();
        Key key = event.getKey();
        if (key == Key.Escape && ((Boolean)player.getAttribute("WaterWheels")).booleanValue()) {
            Timer previewTimer;
            int prefabID = (Integer)player.getAttribute("PrefabID");
            Iterator<Prefab> it = this.previewWaterWheels.iterator();
            while (it.hasNext()) {
                Prefab preview = it.next();
                if (preview.getID() != prefabID) continue;
                for (Player p : Server.getAllPlayers()) {
                    p.removeGameObject((GameObject)preview);
                }
                it.remove();
            }
            Timer raycastTimer = (Timer)player.getAttribute("raycastTimer");
            if (raycastTimer != null) {
                raycastTimer.kill();
            }
            if ((previewTimer = (Timer)player.getAttribute("RemovePreviewTimer")) != null) {
                previewTimer.kill();
            }
            player.sendYellMessage("Water Wheel Cancelled", 2.0f, true);
            player.setAttribute("WaterWheels", (Object)false);
        }
        if (key == Key.Delete) {
            int layerMask = Layer.getBitmask((int[])new int[]{15});
            player.raycast(layerMask, result -> {
                if (result == null) {
                    return;
                }
                long objectID = result.getObjectGlobalID();
                for (Prefab wheel : this.waterWheels) {
                    if ((long)wheel.getID() != objectID) continue;
                    player.setAttribute("WaterWheelID", (Object)wheel.getID());
                    player.sendTextMessage("This object is a Water Wheel with id " + wheel.getID());
                    if (player.isAdmin()) {
                        this.removeWaterWheel(wheel, player);
                        continue;
                    }
                    try {
                        ResultSet rs = this.database2.executeQuery("SELECT * FROM `WaterWheels` WHERE WaterWheelID = '" + wheel.getID() + "'");
                        try {
                            if (!rs.next() || !player.getUID().equals(rs.getString("PlayerUID"))) continue;
                            this.removeWaterWheel(wheel, player);
                        }
                        finally {
                            if (rs == null) continue;
                            rs.close();
                        }
                    }
                    catch (SQLException ex) {
                        LOGGER.log(Level.SEVERE, "Failed to check water wheel ownership", ex);
                    }
                }
            });
        }
    }

    private void removeWaterWheel(Prefab wheel, Player player) {
        Iterator<Prefab> it = this.waterWheels.iterator();
        while (it.hasNext()) {
            Prefab w = it.next();
            if (w.getID() != wheel.getID()) continue;
            for (Player p : Server.getAllPlayers()) {
                p.removeGameObject((GameObject)w);
            }
            this.databaseExecutor.submit(() -> this.database.executeUpdate("DELETE FROM `WaterWheels` WHERE WaterWheelID = '" + w.getID() + "'"));
            it.remove();
        }
    }

    @EventMethod
    public void onPlayerMouseButton(PlayerMouseButtonEvent event) {
        Timer previewTimer;
        if (!event.isPressed() || event.getButton() != MouseButton.Right) {
            return;
        }
        Player player = event.getPlayer();
        if (!((Boolean)player.getAttribute("WaterWheels")).booleanValue()) {
            return;
        }
        Vector3f collisionPoint = (Vector3f)player.getAttribute("CollisionPoint");
        int prefabID = (Integer)player.getAttribute("PrefabID");
        Iterator<Prefab> it = this.previewWaterWheels.iterator();
        while (it.hasNext()) {
            Player[] preview = it.next();
            if (preview.getID() != prefabID) continue;
            Player[] playerArray = Server.getAllPlayers();
            int n = playerArray.length;
            for (int i = 0; i < n; ++i) {
                Player p = playerArray[i];
                p.removeGameObject((GameObject)preview);
            }
            it.remove();
        }
        Prefab wheel = this.createWaterWheelPrefab(collisionPoint, player.getRotation().getYaw());
        this.waterWheels.add(wheel);
        this.databaseExecutor.submit(() -> this.database.executeUpdate("INSERT INTO `WaterWheels` (PlayerUID, WaterWheelPosition, WaterWheelRotation, WaterWheelID) VALUES ('" + player.getUID() + "','" + String.valueOf(collisionPoint) + "','" + player.getRotation().getYaw() + "','" + wheel.getID() + "');"));
        for (Player p : Server.getAllPlayers()) {
            p.addGameObject((GameObject)wheel);
        }
        Timer raycastTimer = (Timer)player.getAttribute("raycastTimer");
        if (raycastTimer != null) {
            raycastTimer.kill();
        }
        if ((previewTimer = (Timer)player.getAttribute("RemovePreviewTimer")) != null) {
            previewTimer.kill();
        }
        player.sendYellMessage("Water Wheel Placed", 2.0f, true);
        player.setAttribute("WaterWheels", (Object)false);
    }

    @EventMethod
    public void onPlayerUIElementClick(PlayerUIElementClickEvent event) {
        if (event.getUIElement() == null) {
            return;
        }
        Player player = event.getPlayer();
        int eventID = event.getUIElement().getID();
        Integer adminNextButtonID = (Integer)player.getAttribute("WaterWheel_AdminNextButtonID");
        Integer adminBackButtonID = (Integer)player.getAttribute("WaterWheel_AdminBackButtonID");
        Integer adminAddButtonID = (Integer)player.getAttribute("WaterWheel_AdminAddButtonID");
        Integer adminRemoveButtonID = (Integer)player.getAttribute("WaterWheel_AdminRemoveButtonID");
        Integer adminCloseButtonID = (Integer)player.getAttribute("WaterWheel_AdminCloseButtonID");
        if (adminNextButtonID != null && adminBackButtonID != null && adminAddButtonID != null && adminRemoveButtonID != null && adminCloseButtonID != null && adminNextButtonID != 0 && adminBackButtonID != 0 && adminAddButtonID != 0 && adminRemoveButtonID != 0 && adminCloseButtonID != 0) {
            List onlinePlayers = (List)player.getAttribute("WaterWheel_OnlinePlayers");
            Integer currentPlayerIndex = (Integer)player.getAttribute("WaterWheel_CurrentPlayerIndex");
            UITextField playerField = (UITextField)player.getAttribute("WaterWheel_AdminPlayerField");
            if (eventID == adminNextButtonID) {
                if (onlinePlayers == null || onlinePlayers.isEmpty()) {
                    playerField.setText("No Players Online");
                    player.setAttribute("WaterWheel_CurrentPlayerIndex", (Object)-1);
                } else {
                    currentPlayerIndex = (currentPlayerIndex + 1) % onlinePlayers.size();
                    playerField.setText(((Player)onlinePlayers.get(currentPlayerIndex)).getName());
                    player.setAttribute("WaterWheel_CurrentPlayerIndex", (Object)currentPlayerIndex);
                }
                return;
            }
            if (eventID == adminBackButtonID) {
                if (onlinePlayers == null || onlinePlayers.isEmpty()) {
                    playerField.setText("No Players Online");
                    player.setAttribute("WaterWheel_CurrentPlayerIndex", (Object)-1);
                } else {
                    currentPlayerIndex = (currentPlayerIndex - 1 + onlinePlayers.size()) % onlinePlayers.size();
                    playerField.setText(((Player)onlinePlayers.get(currentPlayerIndex)).getName());
                    player.setAttribute("WaterWheel_CurrentPlayerIndex", (Object)currentPlayerIndex);
                }
                return;
            }
            if (eventID == adminAddButtonID) {
                playerField.getCurrentText(player, name -> {
                    if (name == null || name.trim().isEmpty()) {
                        player.sendYellMessage("No player selected", 2.0f, true);
                        return;
                    }
                    String searchName = name.trim().toLowerCase();
                    Player selectedPlayer = null;
                    for (Player p : Server.getAllPlayers()) {
                        if (!p.getName().toLowerCase().equals(searchName)) continue;
                        selectedPlayer = p;
                        break;
                    }
                    if (selectedPlayer == null) {
                        player.sendYellMessage("Player '" + name + "' not online or not found", 2.0f, true);
                        return;
                    }
                    String uid = selectedPlayer.getUID();
                    String playerName = selectedPlayer.getName();
                    this.databaseExecutor.submit(() -> {
                        try (ResultSet rs = this.database.executeQuery("SELECT * FROM `WaterWheelAllowedPlayers` WHERE PlayerUID = '" + uid + "'");){
                            if (!rs.next()) {
                                this.database.executeUpdate("INSERT INTO `WaterWheelAllowedPlayers` (PlayerName, PlayerUID) VALUES ('" + playerName + "','" + uid + "');");
                            }
                        }
                        catch (SQLException ex) {
                            LOGGER.log(Level.SEVERE, "Failed to add player to allowed list", ex);
                        }
                    });
                    player.sendYellMessage("Added " + playerName + " to allowed players", 2.0f, true);
                });
                return;
            }
            if (eventID == adminRemoveButtonID) {
                UIElement adminPanel = (UIElement)player.getAttribute("WaterWheel_AdminPanel");
                if (adminPanel != null) {
                    adminPanel.setVisible(false);
                }
                this.showRemovePlayerPanel(player);
                return;
            }
            if (eventID == adminCloseButtonID) {
                UIElement panel = (UIElement)player.getAttribute("WaterWheel_AdminPanel");
                if (panel != null) {
                    panel.setVisible(false);
                    player.setMouseCursorVisible(false);
                }
                return;
            }
        }
        Integer removeNextButtonID = (Integer)player.getAttribute("WaterWheel_RemoveNextButtonID");
        Integer removeBackButtonID = (Integer)player.getAttribute("WaterWheel_RemoveBackButtonID");
        Integer removeActionButtonID = (Integer)player.getAttribute("WaterWheel_RemoveActionButtonID");
        Integer removeBackAdminButtonID = (Integer)player.getAttribute("WaterWheel_RemoveBackAdminButtonID");
        Integer removeCancelButtonID = (Integer)player.getAttribute("WaterWheel_RemoveCancelButtonID");
        if (removeNextButtonID != null && removeBackButtonID != null && removeActionButtonID != null && removeBackAdminButtonID != null && removeCancelButtonID != null && removeNextButtonID != 0 && removeBackButtonID != 0 && removeActionButtonID != 0 && removeBackAdminButtonID != 0 && removeCancelButtonID != 0) {
            List removePlayers = (List)player.getAttribute("WaterWheel_RemovePlayers");
            Integer removePlayerIndex = (Integer)player.getAttribute("WaterWheel_RemovePlayerIndex");
            UILabel playerField = (UILabel)player.getAttribute("WaterWheel_RemovePlayerField");
            if (eventID == removeNextButtonID) {
                if (removePlayers == null || removePlayers.isEmpty()) {
                    playerField.setText("No Allowed Players");
                    player.setAttribute("WaterWheel_RemovePlayerIndex", (Object)-1);
                } else {
                    removePlayerIndex = (removePlayerIndex + 1) % removePlayers.size();
                    playerField.setText(((String[])removePlayers.get(removePlayerIndex))[0]);
                    player.setAttribute("WaterWheel_RemovePlayerIndex", (Object)removePlayerIndex);
                }
                return;
            }
            if (eventID == removeBackButtonID) {
                if (removePlayers == null || removePlayers.isEmpty()) {
                    playerField.setText("No Allowed Players");
                    player.setAttribute("WaterWheel_RemovePlayerIndex", (Object)-1);
                } else {
                    removePlayerIndex = (removePlayerIndex - 1 + removePlayers.size()) % removePlayers.size();
                    playerField.setText(((String[])removePlayers.get(removePlayerIndex))[0]);
                    player.setAttribute("WaterWheel_RemovePlayerIndex", (Object)removePlayerIndex);
                }
                return;
            }
            if (eventID == removeActionButtonID) {
                if (removePlayers == null || removePlayers.isEmpty() || removePlayerIndex < 0) {
                    player.sendYellMessage("No player selected", 2.0f, true);
                    return;
                }
                String[] playerData = (String[])removePlayers.get(removePlayerIndex);
                String playerName = playerData[0];
                String uid = playerData[1];
                this.databaseExecutor.submit(() -> this.database.executeUpdate("DELETE FROM `WaterWheelAllowedPlayers` WHERE PlayerUID = '" + uid + "'"));
                removePlayers.remove(removePlayerIndex);
                player.setAttribute("WaterWheel_RemovePlayers", (Object)removePlayers);
                if (removePlayers.isEmpty()) {
                    playerField.setText("No Allowed Players");
                    player.setAttribute("WaterWheel_RemovePlayerIndex", (Object)-1);
                } else {
                    removePlayerIndex = Math.min(removePlayerIndex, removePlayers.size() - 1);
                    playerField.setText(((String[])removePlayers.get(removePlayerIndex))[0]);
                    player.setAttribute("WaterWheel_RemovePlayerIndex", (Object)removePlayerIndex);
                }
                player.sendYellMessage("Removed " + playerName + " from allowed players", 2.0f, true);
                return;
            }
            if (eventID == removeBackAdminButtonID) {
                UIElement removePanel = (UIElement)player.getAttribute("WaterWheel_RemovePanel");
                if (removePanel != null) {
                    removePanel.setVisible(false);
                }
                this.showAdminPanel(player);
                return;
            }
            if (eventID == removeCancelButtonID) {
                UIElement panel = (UIElement)player.getAttribute("WaterWheel_RemovePanel");
                if (panel != null) {
                    panel.setVisible(false);
                    player.setMouseCursorVisible(false);
                }
                return;
            }
        }
    }

    @EventMethod
    public void onPlayerCommand(PlayerCommandEvent event) {
        String[] cmd = event.getCommand().split(" ");
        Player player = event.getPlayer();
        if (cmd[0].equalsIgnoreCase("/WaterWheelAdmin")) {
            if (!player.isAdmin()) {
                player.sendYellMessage("Only admins can use this command", 2.0f, true);
                return;
            }
            this.showAdminPanel(player);
            return;
        }
        if (!cmd[0].equalsIgnoreCase("/WaterWheel")) {
            return;
        }
        if (!this.canPlaceWaterWheel(player)) {
            player.sendYellMessage("You are not authorized to place water wheels", 2.0f, true);
            return;
        }
        if (((Boolean)player.getAttribute("WaterWheels")).booleanValue()) {
            player.sendYellMessage("Water Wheel Placing Already Running", 5.0f, true);
            return;
        }
        Timer raycastTimer = new Timer(-1.0f, 0.0f, -1, null);
        raycastTimer.setTask(() -> {
            int layerMask = Layer.getBitmask((int[])new int[]{13, 15, 8, 10, 4});
            player.raycast(layerMask, result -> {
                if (result != null) {
                    Vector3f collisionPoint = result.getCollisionPoint();
                    player.setAttribute("CollisionPoint", (Object)collisionPoint);
                    for (Prefab preview : this.previewWaterWheels) {
                        int prefabID = (Integer)player.getAttribute("PrefabID");
                        if (preview.getID() != prefabID) continue;
                        preview.moveToLocalPosition(collisionPoint.x, collisionPoint.y, collisionPoint.z, -1.0f);
                        preview.setLocalRotation(0.0f, player.getRotation().getYaw() + 180.0f, 0.0f);
                    }
                }
            });
        });
        raycastTimer.start();
        player.setAttribute("raycastTimer", (Object)raycastTimer);
        AssetBundle bundle = AssetBundle.loadFromFile((String)(this.getPath() + BUNDLE_PATH));
        PrefabAsset asset = PrefabAsset.loadFromAssetBundle((AssetBundle)bundle, (String)PREFAB_NAME);
        Prefab prefab = new Prefab(asset);
        prefab.setLayer(2);
        prefab.setLocalPosition(player.getPosition());
        this.previewWaterWheels.add(prefab);
        player.setAttribute("PrefabID", (Object)prefab.getID());
        player.sendYellMessage("Water Wheel Placing Started", 2.0f, true);
        for (Player p : Server.getAllPlayers()) {
            p.addGameObject((GameObject)prefab);
        }
        Timer previewTimer = new Timer(1.0f, 120.0f, 0, null);
        previewTimer.setTask(() -> {
            Iterator<Prefab> it = this.previewWaterWheels.iterator();
            while (it.hasNext()) {
                Prefab preview = it.next();
                if (preview.getID() != prefab.getID()) continue;
                for (Player p : Server.getAllPlayers()) {
                    p.removeGameObject((GameObject)preview);
                }
                player.setAttribute("WaterWheels", (Object)false);
                player.sendYellMessage("Water Wheel Placing Ended", 2.0f, true);
                it.remove();
            }
        });
        previewTimer.start();
        player.setAttribute("RemovePreviewTimer", (Object)previewTimer);
        player.setAttribute("WaterWheels", (Object)true);
    }
}

