/*
 * Decompiled with CFR 0.152.
 */
package elevator;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.Timer;
import net.risingworld.api.World;
import net.risingworld.api.assets.AssetBundle;
import net.risingworld.api.assets.PrefabAsset;
import net.risingworld.api.assets.SoundAsset;
import net.risingworld.api.database.Database;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.events.player.PlayerMouseButtonEvent;
import net.risingworld.api.events.player.ui.PlayerUIElementClickEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.ui.UILabel;
import net.risingworld.api.ui.UITextField;
import net.risingworld.api.ui.style.TextAnchor;
import net.risingworld.api.utils.Key;
import net.risingworld.api.utils.Layer;
import net.risingworld.api.utils.MouseButton;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.worldelements.GameObject;
import net.risingworld.api.worldelements.Prefab;

public class Elevator
extends Plugin
implements Listener {
    private Database database;
    private Database database2;
    private static final float DEFAULT_FLOOR_HEIGHT = 8.0f;
    private static final float MIN_FLOOR_HEIGHT = 5.0f;
    private static final float MAX_FLOOR_HEIGHT = 12.0f;
    private static final String DOOR_SOUND = "Doors.mp3";
    private static final String LOOP_SOUND = "Loop.mp3";
    private static final String BELL_SOUND = "Bell.wav";
    private static final int MIN_FLOORS = 2;
    private static final int MAX_FLOORS = 20;
    private static final float DOOR_ANIMATION_DELAY = 1.0f;
    private final ArrayList<Prefab> elevators = new ArrayList();
    private final Map<Integer, Map<Integer, ArrayList<Prefab>>> doorsByElevator = new HashMap<Integer, Map<Integer, ArrayList<Prefab>>>();
    private final ArrayList<Prefab> previewElevator = new ArrayList();
    private final Map<Integer, Queue<Integer>> elevatorQueues = new HashMap<Integer, Queue<Integer>>();

    public void onEnable() {
        System.out.println("-- ELEVATOR PLUGIN ENABLED --");
        String worldName = World.getName();
        this.database = this.getSQLiteConnection(this.getPath() + "/" + worldName + "/database.db");
        this.database2 = this.getSQLiteConnection(this.getPath() + "/" + worldName + "/database.db");
        this.database.execute("CREATE TABLE IF NOT EXISTS `Elevators` (`ID` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,`ElevatorBlockPosition` INTEGER,`ElevatorX` INTEGER, `ElevatorY` INTEGER, `ElevatorZ` INTEGER,`ElevatorFloorsAmount` INTEGER,`ElevatorFloorHeight` FLOAT,`Blockpos` INTEGER,`Chunkpos` INTEGER,`ElevatorID` INTEGER,`ElevatorRotation` BIGINT,`MaxFloors` INTEGER,`FloorHeight` FLOAT);");
        this.database.execute("CREATE TABLE IF NOT EXISTS `ElevatorOuterDoors` (`ID` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,`ElevatorBlockPosition` INTEGER,`ElevatorX` INTEGER, `ElevatorY` INTEGER, `ElevatorZ` INTEGER,`ElevatorFloorsAmount` INTEGER,`ElevatorFloorHeight` FLOAT,`Blockpos` INTEGER,`ElevatorID` INTEGER,`ElevatorDoorsID` INTEGER,`ElevatorOuterDoorRotation` BIGINT,`FloorHeight` FLOAT);");
        try {
            HashMap<String, Integer> blockPositionToElevatorID = new HashMap<String, Integer>();
            HashSet<String> loadedElevators = new HashSet<String>();
            try (ResultSet result = this.database.executeQuery("SELECT DISTINCT ElevatorBlockPosition, ElevatorX, ElevatorY, ElevatorZ, ElevatorRotation, MaxFloors, FloorHeight FROM `Elevators` WHERE `ElevatorFloorHeight` = 'Elevator'");){
                while (result.next()) {
                    String string = result.getString("ElevatorBlockPosition");
                    if (loadedElevators.contains(string)) continue;
                    loadedElevators.add(string);
                    float x = result.getFloat("ElevatorX");
                    float y = result.getFloat("ElevatorY");
                    float z = result.getFloat("ElevatorZ");
                    float rotation = result.getFloat("ElevatorRotation");
                    int maxFloors = result.getInt("MaxFloors");
                    float floorHeight = result.getFloat("FloorHeight");
                    if (floorHeight == 0.0f) {
                        floorHeight = 8.0f;
                    }
                    AssetBundle bundle = AssetBundle.loadFromFile((String)(this.getPath() + "/assets/elevator.bundle"));
                    PrefabAsset asset = PrefabAsset.loadFromAssetBundle((AssetBundle)bundle, (String)"Elevator.prefab");
                    Prefab elevator = new Prefab(asset);
                    elevator.setLayer(15);
                    elevator.setLocalPosition(x, y, z);
                    elevator.setLocalRotation(0.0f, rotation, 0.0f);
                    int elevatorID = elevator.getID();
                    this.elevators.add(elevator);
                    this.elevatorQueues.put(elevatorID, new LinkedList());
                    this.doorsByElevator.put(elevatorID, new HashMap());
                    for (int i = 0; i < maxFloors; ++i) {
                        this.doorsByElevator.get(elevatorID).put(i, new ArrayList());
                    }
                    blockPositionToElevatorID.put(string, elevatorID);
                    Player[] playerArray = Server.getAllPlayers();
                    int n = playerArray.length;
                    for (int i = 0; i < n; ++i) {
                        Player p = playerArray[i];
                        p.addGameObject((GameObject)elevator);
                    }
                }
                System.out.println("Loaded " + loadedElevators.size() + " unique elevators");
            }
            for (Map.Entry entry : blockPositionToElevatorID.entrySet()) {
                String blockPosition = (String)entry.getKey();
                int newElevatorID = (Integer)entry.getValue();
                this.database.executeUpdate("UPDATE Elevators SET `ElevatorID` = '" + newElevatorID + "' WHERE `ElevatorBlockPosition` = '" + blockPosition + "'");
                this.database.executeUpdate("UPDATE ElevatorOuterDoors SET `ElevatorID` = '" + newElevatorID + "' WHERE `ElevatorBlockPosition` = '" + blockPosition + "'");
            }
            int doorLoadCount = 0;
            try (ResultSet resultSet = this.database.executeQuery("SELECT * FROM `ElevatorOuterDoors`");){
                while (resultSet.next()) {
                    int elevatorID = resultSet.getInt("ElevatorID");
                    int floor = resultSet.getInt("ElevatorFloorsAmount");
                    String blockPos = resultSet.getString("Blockpos");
                    Vector3f pos = new Vector3f().add(Vector3f.ONE).fromString(blockPos);
                    float rotation = resultSet.getFloat("ElevatorOuterDoorRotation");
                    AssetBundle doorBundle = AssetBundle.loadFromFile((String)(this.getPath() + "/assets/elevatordoors.bundle"));
                    PrefabAsset doorAsset = PrefabAsset.loadFromAssetBundle((AssetBundle)doorBundle, (String)"ElevatorDoors.prefab");
                    Prefab door = new Prefab(doorAsset);
                    door.setLayer(15);
                    door.setLocalPosition(pos.x, pos.y, pos.z);
                    door.setLocalRotation(0.0f, rotation, 0.0f);
                    if (!this.doorsByElevator.containsKey(elevatorID) || !this.doorsByElevator.get(elevatorID).containsKey(floor)) continue;
                    this.doorsByElevator.get(elevatorID).get(floor).add(door);
                    int doorID = resultSet.getInt("ElevatorDoorsID");
                    if (doorID >= 0) {
                        doorID = door.getID();
                        this.database2.executeUpdate("UPDATE ElevatorOuterDoors SET `ElevatorDoorsID` = '" + doorID + "' WHERE `ElevatorID` = '" + elevatorID + "' AND `Blockpos` = '" + blockPos + "'");
                    }
                    for (Player p : Server.getAllPlayers()) {
                        p.addGameObject((GameObject)door);
                    }
                    ++doorLoadCount;
                    System.out.println("Loaded door for elevatorID: " + elevatorID + ", floor: " + floor + ", doorID: " + door.getID());
                }
                System.out.println("Loaded " + doorLoadCount + " doors");
            }
        }
        catch (Exception e) {
            System.err.println("Error loading elevators/doors: " + e.getMessage());
            e.printStackTrace();
        }
        this.registerEventListener(this);
    }

    public void onDisable() {
        System.out.println("-- ELEVATOR PLUGIN DISABLED --");
        if (this.database != null) {
            this.database.close();
        }
    }

    @EventMethod
    public void onPlayerConnect(PlayerConnectEvent event) throws SQLException {
        Player player = event.getPlayer();
        player.registerKeys(new Key[]{Key.B, Key.F, Key.K, Key.LeftShift});
        player.setAttribute("ElevatorID", (Object)0);
        player.setAttribute("CallElevator", (Object)"NotCalled");
        player.setAttribute("DoorState", (Object)"Closed");
        player.setAttribute("PlacingElevator", (Object)false);
        player.setAttribute("Tick", (Object)20);
        player.setListenForKeyInput(true);
        player.setAttribute("SoundLoop", (Object)SoundAsset.loadFromFile((String)(this.getPath() + "/assets/Loop.mp3")));
        player.setAttribute("Doorsoundfile", (Object)SoundAsset.loadFromFile((String)(this.getPath() + "/assets/Doors.mp3")));
        player.setAttribute("Bellsoundfile", (Object)SoundAsset.loadFromFile((String)(this.getPath() + "/assets/Bell.wav")));
        for (Prefab prefab : this.elevators) {
            player.addGameObject((GameObject)prefab);
        }
        int doorCount = 0;
        for (Map<Integer, ArrayList<Prefab>> map : this.doorsByElevator.values()) {
            for (ArrayList<Prefab> doorList : map.values()) {
                for (Prefab door : doorList) {
                    player.addGameObject((GameObject)door);
                    ++doorCount;
                }
            }
        }
        UIElement uIElement = new UIElement();
        player.addUIElement(uIElement);
        uIElement.setSize(75.0f, 50.0f, false);
        uIElement.setPosition(95.0f, 45.0f, true);
        uIElement.setBorder(5.0f);
        uIElement.setBorderColor(999);
        uIElement.setBackgroundColor(12222);
        uIElement.setVisible(false);
        player.setAttribute("ElevatorMainPanel", (Object)uIElement);
        player.setAttribute("ElevatorMainPanelID", (Object)uIElement.getID());
        UILabel uILabel = new UILabel();
        uILabel.setClickable(true);
        uILabel.setRichTextEnabled(true);
        uILabel.setFontSize(20.0f);
        uILabel.setFontColor(9.0f, 0.0f, 0.0f, 5.0f);
        uILabel.setText(" X ");
        uILabel.setBorder(2.0f);
        uILabel.setBorderColor(999);
        uILabel.setPosition(20.0f, 5.0f, false);
        uIElement.addChild((UIElement)uILabel);
        player.setAttribute("ElevatorExitbutton", (Object)uILabel);
        player.setAttribute("ElevatorExitbuttonID", (Object)uILabel.getID());
        UILabel deleteButton = new UILabel();
        deleteButton.setClickable(true);
        deleteButton.setRichTextEnabled(true);
        deleteButton.setFontSize(14.0f);
        deleteButton.setText(" Delete ");
        deleteButton.setFontColor(9.0f, 0.0f, 0.0f, 5.0f);
        deleteButton.style.textAlign.set((Enum)TextAnchor.MiddleCenter);
        deleteButton.setBorder(2.0f);
        deleteButton.setBorderColor(999);
        deleteButton.setPosition(6.0f, 20.0f, false);
        uIElement.addChild((UIElement)deleteButton);
        player.setAttribute("ElevatorDeletebutton", (Object)deleteButton);
        player.setAttribute("ElevatorDeletebuttonID", (Object)deleteButton.getID());
        UIElement floorInputPanel = new UIElement();
        player.addUIElement(floorInputPanel);
        floorInputPanel.setSize(250.0f, 200.0f, false);
        floorInputPanel.setPosition(50.0f, 50.0f, true);
        floorInputPanel.setBorder(5.0f);
        floorInputPanel.setBorderColor(999);
        floorInputPanel.setBackgroundColor(12222);
        floorInputPanel.setVisible(false);
        player.setAttribute("FloorInputPanel", (Object)floorInputPanel);
        player.setAttribute("FloorInputPanelID", (Object)floorInputPanel.getID());
        UILabel floorLabel = new UILabel();
        floorLabel.setRichTextEnabled(true);
        floorLabel.setFontSize(16.0f);
        floorLabel.setText("Enter Floors (2-20):");
        floorLabel.setPosition(20.0f, 20.0f, false);
        floorInputPanel.addChild((UIElement)floorLabel);
        UITextField floorTextField = new UITextField();
        floorTextField.setSize(160.0f, 30.0f, false);
        floorTextField.setPosition(20.0f, 50.0f, false);
        floorTextField.setBorder(2.0f);
        floorTextField.setBorderColor(999);
        floorInputPanel.addChild((UIElement)floorTextField);
        player.setAttribute("FloorTextField", (Object)floorTextField);
        player.setAttribute("FloorTextFieldID", (Object)floorTextField.getID());
        UILabel heightLabel = new UILabel();
        heightLabel.setRichTextEnabled(true);
        heightLabel.setFontSize(16.0f);
        heightLabel.setText("Enter Floor Height (5-12):");
        heightLabel.setPosition(20.0f, 90.0f, false);
        floorInputPanel.addChild((UIElement)heightLabel);
        UITextField heightTextField = new UITextField();
        heightTextField.setSize(160.0f, 30.0f, false);
        heightTextField.setPosition(20.0f, 120.0f, false);
        heightTextField.setBorder(2.0f);
        heightTextField.setBorderColor(999);
        floorInputPanel.addChild((UIElement)heightTextField);
        player.setAttribute("HeightTextField", (Object)heightTextField);
        player.setAttribute("HeightTextFieldID", (Object)heightTextField.getID());
        UILabel confirmButton = new UILabel();
        confirmButton.setClickable(true);
        confirmButton.setRichTextEnabled(true);
        confirmButton.setFontSize(14.0f);
        confirmButton.setText(" Confirm ");
        confirmButton.setBorder(2.0f);
        confirmButton.setBorderColor(999);
        confirmButton.setPosition(20.0f, 160.0f, false);
        floorInputPanel.addChild((UIElement)confirmButton);
        player.setAttribute("ConfirmFloorButton", (Object)confirmButton);
        player.setAttribute("ConfirmFloorButtonID", (Object)confirmButton.getID());
        UILabel cancelButton = new UILabel();
        cancelButton.setClickable(true);
        cancelButton.setRichTextEnabled(true);
        cancelButton.setFontSize(14.0f);
        cancelButton.setText(" Cancel ");
        cancelButton.setBorder(2.0f);
        cancelButton.setBorderColor(999);
        cancelButton.setPosition(100.0f, 160.0f, false);
        floorInputPanel.addChild((UIElement)cancelButton);
        player.setAttribute("CancelFloorButton", (Object)cancelButton);
        player.setAttribute("CancelFloorButtonID", (Object)cancelButton.getID());
    }

    @EventMethod
    public void onPlayerUIElementClick(PlayerUIElementClickEvent event) throws SQLException {
        block27: {
            if (event.getUIElement() == null) {
                return;
            }
            Player player = event.getPlayer();
            int eventID = event.getUIElement().getID();
            UIElement mainPanel = (UIElement)player.getAttribute("ElevatorMainPanel");
            int elevatorID = (Integer)player.getAttribute("ElevatorID");
            if (eventID == (Integer)player.getAttribute("ElevatorExitbuttonID")) {
                player.setMouseCursorVisible(false);
                mainPanel.setVisible(false);
                return;
            }
            if (eventID == (Integer)player.getAttribute("ElevatorDeletebuttonID")) {
                if (player.isAdmin()) {
                    Iterator<Prefab> iterator = this.elevators.iterator();
                    while (iterator.hasNext()) {
                        Prefab elevator = iterator.next();
                        if (elevator.getID() != elevatorID) continue;
                        for (Player p : Server.getAllPlayers()) {
                            p.removeGameObject((GameObject)elevator);
                        }
                        this.database.executeUpdate("DELETE FROM `Elevators` WHERE `ElevatorID` = '" + elevatorID + "'");
                        this.elevatorQueues.remove(elevatorID);
                        iterator.remove();
                    }
                    try (ResultSet result = this.database.executeQuery("SELECT * FROM `ElevatorOuterDoors` WHERE `ElevatorID` = '" + elevatorID + "'");){
                        while (result.next()) {
                            int doorID = result.getInt("ElevatorDoorsID");
                            int floor = result.getInt("ElevatorFloorsAmount");
                            if (!this.doorsByElevator.containsKey(elevatorID)) continue;
                            Iterator<Prefab> iterator2 = this.doorsByElevator.get(elevatorID).get(floor).iterator();
                            while (iterator2.hasNext()) {
                                Prefab door = iterator2.next();
                                if (door.getID() != doorID) continue;
                                for (Player p : Server.getAllPlayers()) {
                                    p.removeGameObject((GameObject)door);
                                }
                                this.database.executeUpdate("DELETE FROM `ElevatorOuterDoors` WHERE `ElevatorID` = '" + elevatorID + "' AND `ElevatorDoorsID` = '" + doorID + "'");
                                iterator2.remove();
                            }
                        }
                    }
                    if (this.doorsByElevator.containsKey(elevatorID)) {
                        this.doorsByElevator.remove(elevatorID);
                    }
                    player.sendYellMessage("Elevator Deleted", 3.0f, false);
                    player.setMouseCursorVisible(false);
                    mainPanel.setVisible(false);
                } else {
                    player.sendTextMessage("Only Admins Can Remove Elevators");
                }
                return;
            }
            UIElement floorInputPanel = (UIElement)player.getAttribute("FloorInputPanel");
            if (eventID == (Integer)player.getAttribute("ConfirmFloorButtonID")) {
                UITextField floorTextField = (UITextField)player.getAttribute("FloorTextField");
                UITextField heightTextField = (UITextField)player.getAttribute("HeightTextField");
                floorTextField.getCurrentText(player, floorText -> heightTextField.getCurrentText(player, heightText -> {
                    try {
                        if (floorText == null || floorText.trim().isEmpty()) {
                            player.sendTextMessage("Please enter a valid floor count");
                            return;
                        }
                        int floors = Integer.parseInt(floorText.trim());
                        if (floors < 2 || floors > 20) {
                            player.sendTextMessage("Please enter a number between 2 and 20");
                            return;
                        }
                        if (heightText == null || heightText.trim().isEmpty()) {
                            player.sendTextMessage("Please enter a valid floor height");
                            return;
                        }
                        float height = Float.parseFloat(heightText.trim());
                        if (height < 5.0f || height > 12.0f) {
                            player.sendTextMessage("Please enter a height between 5.0 and 12.0");
                            return;
                        }
                        player.setAttribute("SelectedFloors", (Object)floors);
                        player.setAttribute("SelectedFloorHeight", (Object)Float.valueOf(height));
                        player.setAttribute("PlacingElevator", (Object)true);
                        this.startPlacementPreview(player);
                        floorInputPanel.setVisible(false);
                        player.setMouseCursorVisible(false);
                    }
                    catch (NumberFormatException e) {
                        player.sendTextMessage("Invalid input. Please enter numbers for floors and height");
                    }
                }));
                return;
            }
            if (eventID == (Integer)player.getAttribute("CancelFloorButtonID")) {
                floorInputPanel.setVisible(false);
                player.setMouseCursorVisible(false);
                player.setAttribute("PlacingElevator", (Object)false);
                return;
            }
            try (ResultSet result = this.database.executeQuery("SELECT MaxFloors FROM `Elevators` WHERE `ElevatorID` = '" + elevatorID + "' LIMIT 1");){
                if (!result.next()) break block27;
                int maxFloors = result.getInt("MaxFloors");
                for (int floor = 0; floor < maxFloors; ++floor) {
                    if (eventID != (Integer)player.getAttribute("ElevatorLevel" + floor + "buttonID")) continue;
                    this.queueFloorRequest(elevatorID, floor, player, mainPanel);
                    break;
                }
            }
        }
    }

    private void startPlacementPreview(Player player) {
        Timer raycastTimer = new Timer(-1.0f, 0.0f, -1, null);
        Runnable raycastUpdate = () -> {
            int layerMask = Layer.getBitmask((int[])new int[]{13, 15, 8, 10});
            player.raycast(layerMask, result -> {
                if (result != null) {
                    Vector3f collisionPoint = result.getCollisionPoint();
                    player.setAttribute("HardwareID", (Object)result.getObjectGlobalID());
                    player.setAttribute("CollisionPoint", (Object)collisionPoint);
                    for (Prefab preview : this.previewElevator) {
                        int prefabID = (Integer)player.getAttribute("PrefabID");
                        if (preview.getID() != prefabID) continue;
                        preview.moveToLocalPosition(collisionPoint.x, collisionPoint.y, collisionPoint.z, -1.0f);
                        preview.setLocalRotation(0.0f, player.getRotation().getYaw() + 180.0f, 0.0f);
                        player.setAttribute("PreviewedPrefab", (Object)preview);
                    }
                }
            });
        };
        raycastTimer.setTask(raycastUpdate);
        raycastTimer.start();
        player.setAttribute("raycastTimer", (Object)raycastTimer);
        AssetBundle bundle = AssetBundle.loadFromFile((String)(this.getPath() + "/assets/elevatordoors.bundle"));
        PrefabAsset elevatorAsset = PrefabAsset.loadFromAssetBundle((AssetBundle)bundle, (String)"ElevatorDoors.prefab");
        Prefab prefab = new Prefab(elevatorAsset);
        prefab.setLayer(2);
        prefab.setLocalPosition(player.getPosition());
        this.previewElevator.add(prefab);
        player.setAttribute("PrefabID", (Object)prefab.getID());
        for (Player p : Server.getAllPlayers()) {
            p.addGameObject((GameObject)prefab);
        }
        Timer removePreviewTimer = new Timer(1.0f, 120.0f, 0, null);
        Runnable removePreviewUpdate = () -> {
            Iterator<Prefab> iterator = this.previewElevator.iterator();
            while (iterator.hasNext()) {
                Prefab preview = iterator.next();
                if (preview.getID() != prefab.getID()) continue;
                for (Player p : Server.getAllPlayers()) {
                    p.removeGameObject((GameObject)preview);
                }
                player.setAttribute("PlacingElevator", (Object)false);
                iterator.remove();
                player.sendYellMessage("Elevator Placing Ended", 2.0f, true);
            }
        };
        removePreviewTimer.setTask(removePreviewUpdate);
        removePreviewTimer.start();
        player.setAttribute("RemovePreviewTimer", (Object)removePreviewTimer);
    }

    @EventMethod
    public void onPlayerMouseButtonEvent(PlayerMouseButtonEvent event) throws SQLException {
        int i;
        int i2;
        Player player = event.getPlayer();
        if (!event.isPressed() || event.getButton() != MouseButton.Right || !Boolean.TRUE.equals(player.getAttribute("PlacingElevator"))) {
            return;
        }
        if (!player.isAdmin()) {
            player.sendTextMessage("Only Admins Can Place Elevators");
            return;
        }
        int prefabID = (Integer)player.getAttribute("PrefabID");
        Iterator<Prefab> iterator = this.previewElevator.iterator();
        while (iterator.hasNext()) {
            Prefab preview = iterator.next();
            if (preview.getID() != prefabID) continue;
            for (Player p : Server.getAllPlayers()) {
                p.removeGameObject((GameObject)preview);
            }
            iterator.remove();
        }
        Prefab previewedPrefab = (Prefab)player.getAttribute("PreviewedPrefab");
        Vector3f pos = previewedPrefab.getLocalPosition();
        float x = pos.x;
        float y = pos.y;
        float z = pos.z;
        int chunkPos = 0;
        float rotation = player.getRotation().getYaw() + 180.0f;
        int maxFloors = (Integer)player.getAttribute("SelectedFloors");
        float floorHeight = ((Float)player.getAttribute("SelectedFloorHeight")).floatValue();
        AssetBundle bundle = AssetBundle.loadFromFile((String)(this.getPath() + "/assets/elevator.bundle"));
        AssetBundle doorBundle = AssetBundle.loadFromFile((String)(this.getPath() + "/assets/elevatordoors.bundle"));
        PrefabAsset elevatorAsset = PrefabAsset.loadFromAssetBundle((AssetBundle)bundle, (String)"Elevator.prefab");
        PrefabAsset doorAsset = PrefabAsset.loadFromAssetBundle((AssetBundle)doorBundle, (String)"ElevatorDoors.prefab");
        Prefab elevator = new Prefab(elevatorAsset);
        Prefab[] doors = new Prefab[maxFloors];
        for (int i3 = 0; i3 < maxFloors; ++i3) {
            doors[i3] = new Prefab(doorAsset);
        }
        int elevatorID = elevator.getID();
        int[] doorIDs = new int[maxFloors];
        for (int i4 = 0; i4 < maxFloors; ++i4) {
            doorIDs[i4] = doors[i4].getID();
        }
        elevator.setLayer(15);
        for (Prefab door : doors) {
            door.setLayer(15);
        }
        for (i2 = 0; i2 < maxFloors; ++i2) {
            doors[i2].setLocalPosition(x, y + (float)i2 * floorHeight, z);
            doors[i2].setLocalRotation(0.0f, rotation, 0.0f);
        }
        elevator.setLocalPosition(x, y, z);
        elevator.setLocalRotation(0.0f, rotation, 0.0f);
        this.elevators.add(elevator);
        this.elevatorQueues.put(elevatorID, new LinkedList());
        this.doorsByElevator.put(elevatorID, new HashMap());
        for (i2 = 0; i2 < maxFloors; ++i2) {
            this.doorsByElevator.get(elevatorID).put(i2, new ArrayList());
            this.doorsByElevator.get(elevatorID).get(i2).add(doors[i2]);
        }
        for (Player p : Server.getAllPlayers()) {
            p.addGameObject((GameObject)elevator);
            for (Prefab door : doors) {
                p.addGameObject((GameObject)door);
            }
        }
        Vector3f[] levels = new Vector3f[maxFloors];
        for (i = 0; i < maxFloors; ++i) {
            levels[i] = new Vector3f(x, y + (float)i * floorHeight, z);
        }
        for (i = 0; i < maxFloors; ++i) {
            this.database.executeUpdate("INSERT INTO `Elevators` (ElevatorBlockPosition, ElevatorX, ElevatorY, ElevatorZ, ElevatorFloorsAmount, ElevatorFloorHeight, Blockpos, Chunkpos, ElevatorID, ElevatorRotation, MaxFloors, FloorHeight) VALUES ('" + String.valueOf(player.getPosition()) + "','" + x + "','" + y + "','" + z + "','" + i + "','Elevator','" + String.valueOf(levels[i]) + "','" + chunkPos + "','" + elevatorID + "','" + rotation + "','" + maxFloors + "','" + floorHeight + "');");
            this.database.executeUpdate("INSERT INTO `ElevatorOuterDoors` (ElevatorBlockPosition, ElevatorX, ElevatorY, ElevatorZ, ElevatorFloorsAmount, ElevatorFloorHeight, Blockpos, ElevatorID, ElevatorDoorsID, ElevatorOuterDoorRotation, FloorHeight) VALUES ('" + String.valueOf(player.getPosition()) + "','" + x + "','" + y + "','" + z + "','" + i + "','ElevatorDoor" + i + "','" + String.valueOf(levels[i]) + "','" + elevatorID + "','" + doorIDs[i] + "','" + rotation + "','" + floorHeight + "');");
        }
        player.setAttribute("PlacingElevator", (Object)false);
        player.setAttribute("SelectedFloors", null);
        player.setAttribute("SelectedFloorHeight", null);
        player.sendYellMessage("Elevator Placed with " + maxFloors + " Floors and " + floorHeight + " Height", 2.0f, true);
    }

    @EventMethod
    public void onPlayerKeyInputEvent(PlayerKeyEvent event) {
        Player player = event.getPlayer();
        if (event.isPressed() && event.getKey() == Key.B && player.isKeyPressed(Key.LeftShift)) {
            if (!player.isAdmin()) {
                player.sendTextMessage("Only Admins Can Place Elevators");
                return;
            }
            player.hideCrafting();
            UIElement floorInputPanel = (UIElement)player.getAttribute("FloorInputPanel");
            floorInputPanel.setVisible(true);
            player.setMouseCursorVisible(true);
        }
        if (event.isPressed() && event.getKey() == Key.F) {
            int layerMask = Layer.getBitmask((int[])new int[]{15});
            player.raycast(layerMask, result -> {
                if (result == null) {
                    return;
                }
                long hitID = result.getObjectGlobalID();
                for (Prefab elevator : this.elevators) {
                    if ((long)elevator.getID() != hitID) continue;
                    try (ResultSet rs = this.database.executeQuery("SELECT MaxFloors FROM `Elevators` WHERE `ElevatorID` = '" + elevator.getID() + "' LIMIT 1");){
                        if (rs.next()) {
                            int maxFloors = rs.getInt("MaxFloors");
                            player.setAttribute("ElevatorID", (Object)elevator.getID());
                            this.showFloorSelectionUI(player, maxFloors);
                        }
                    }
                    catch (SQLException e) {
                        System.err.println("SQL error querying MaxFloors: " + e.getMessage());
                    }
                    return;
                }
                try (ResultSet rs = this.database.executeQuery("SELECT ElevatorID, ElevatorFloorsAmount FROM `ElevatorOuterDoors` WHERE `ElevatorDoorsID` = '" + hitID + "' LIMIT 1");){
                    if (rs.next()) {
                        int elevatorID = rs.getInt("ElevatorID");
                        int floor = rs.getInt("ElevatorFloorsAmount");
                        this.queueFloorRequest(elevatorID, floor, player, null);
                    }
                }
                catch (SQLException e) {
                    System.err.println("SQL error querying door: " + e.getMessage());
                }
            });
        }
    }

    private void showFloorSelectionUI(Player player, int maxFloors) {
        UIElement mainPanel = (UIElement)player.getAttribute("ElevatorMainPanel");
        mainPanel = new UIElement();
        player.addUIElement(mainPanel);
        mainPanel.setSize(75.0f, (float)(50 + maxFloors * 35), false);
        mainPanel.setPosition(95.0f, 20.0f, true);
        mainPanel.setBorder(5.0f);
        mainPanel.setBorderColor(999);
        mainPanel.setBackgroundColor(12222);
        player.setAttribute("ElevatorMainPanel", (Object)mainPanel);
        player.setAttribute("ElevatorMainPanelID", (Object)mainPanel.getID());
        UILabel exitButton = new UILabel();
        exitButton.setClickable(true);
        exitButton.setRichTextEnabled(true);
        exitButton.setFontSize(20.0f);
        exitButton.setFontColor(9.0f, 0.0f, 0.0f, 5.0f);
        exitButton.setText(" X ");
        exitButton.setBorder(2.0f);
        exitButton.setBorderColor(999);
        exitButton.setPosition(20.0f, 5.0f, false);
        mainPanel.addChild((UIElement)exitButton);
        player.setAttribute("ElevatorExitbutton", (Object)exitButton);
        player.setAttribute("ElevatorExitbuttonID", (Object)exitButton.getID());
        for (int floor = 0; floor < maxFloors; ++floor) {
            UILabel floorButton = new UILabel();
            floorButton.setClickable(true);
            floorButton.setRichTextEnabled(true);
            floorButton.setFontSize(20.0f);
            floorButton.setText(" " + floor + " ");
            floorButton.setBorder(2.0f);
            floorButton.setBorderColor(999);
            float yPosition = 40.0f + (float)(maxFloors - 1 - floor) * 35.0f;
            floorButton.setPosition(20.0f, yPosition, false);
            mainPanel.addChild((UIElement)floorButton);
            player.setAttribute("ElevatorLevel" + floor + "button", (Object)floorButton);
            player.setAttribute("ElevatorLevel" + floor + "buttonID", (Object)floorButton.getID());
        }
        UILabel deleteButton = new UILabel();
        deleteButton.setClickable(true);
        deleteButton.setRichTextEnabled(true);
        deleteButton.setFontSize(14.0f);
        deleteButton.setText(" Delete ");
        deleteButton.setFontColor(9.0f, 0.0f, 0.0f, 5.0f);
        deleteButton.style.textAlign.set((Enum)TextAnchor.MiddleCenter);
        deleteButton.setBorder(2.0f);
        deleteButton.setBorderColor(999);
        float deleteYPosition = 40.0f + (float)maxFloors * 35.0f;
        deleteButton.setPosition(6.0f, deleteYPosition, false);
        mainPanel.addChild((UIElement)deleteButton);
        player.setAttribute("ElevatorDeletebutton", (Object)deleteButton);
        player.setAttribute("ElevatorDeletebuttonID", (Object)deleteButton.getID());
        mainPanel.setVisible(true);
        player.setMouseCursorVisible(true);
    }

    private void queueFloorRequest(int elevatorID, int floor, Player player, UIElement mainPanel) {
        Queue<Integer> queue = this.elevatorQueues.get(elevatorID);
        if (queue == null) {
            player.sendTextMessage("Invalid elevator ID");
            return;
        }
        queue.offer(floor);
        if (queue.size() == 1) {
            this.processNextFloor(elevatorID, player, mainPanel);
        }
    }

    private void processNextFloor(int elevatorID, Player player, UIElement mainPanel) {
        Queue<Integer> queue = this.elevatorQueues.get(elevatorID);
        if (queue == null || queue.isEmpty()) {
            if (mainPanel != null) {
                player.setMouseCursorVisible(false);
                mainPanel.setVisible(false);
            }
            return;
        }
        int floor = queue.peek();
        try (ResultSet result = this.database.executeQuery("SELECT Blockpos, FloorHeight FROM `Elevators` WHERE `ElevatorFloorHeight` = 'Elevator' AND `ElevatorFloorsAmount` = '" + floor + "' AND `ElevatorID` = '" + elevatorID + "'");){
            if (result.next()) {
                Vector3f targetPos = new Vector3f().add(Vector3f.ONE).fromString(result.getString("Blockpos"));
                float floorHeight = result.getFloat("FloorHeight");
                if (floorHeight == 0.0f) {
                    floorHeight = 8.0f;
                }
                for (Prefab elevator : this.elevators) {
                    if (elevator.getID() != elevatorID) continue;
                    elevator.setAnimatorParameter("LeftDoor", "OpenClose", 1);
                    elevator.setAnimatorParameter("RightDoor", "OpenClose", 1);
                    if (this.doorsByElevator.containsKey(elevatorID)) {
                        for (Map.Entry<Integer, ArrayList<Prefab>> floorEntry : this.doorsByElevator.get(elevatorID).entrySet()) {
                            for (Prefab door : floorEntry.getValue()) {
                                door.setAnimatorParameter("LeftDoor", "OpenClose", 1);
                                door.setAnimatorParameter("RightDoor", "OpenClose", 1);
                            }
                        }
                    }
                    SoundAsset doorSound = (SoundAsset)player.getAttribute("Doorsoundfile");
                    Vector3f currentPos = elevator.getLocalPosition();
                    for (Player p : Server.getAllPlayers()) {
                        p.playSound(doorSound, false, 1.0f, 1.0f, 0.0f, 15.0f, currentPos);
                    }
                    Timer delayTimer = new Timer(1.0f, 0.0f, 1, null);
                    delayTimer.setTask(() -> {
                        Timer moveTimer = new Timer(0.05f, 0.0f, -1, null);
                        Vector3f startPos = new Vector3f(currentPos.x, currentPos.y, currentPos.z);
                        float duration = currentPos.distance(targetPos) / 8.0f;
                        float[] elapsed = new float[]{0.0f};
                        Runnable moveTask = () -> {
                            elapsed[0] = elapsed[0] + 0.05f;
                            float t = Math.min(elapsed[0] / duration, 1.0f);
                            float x = startPos.x + (targetPos.x - startPos.x) * t;
                            float y = startPos.y + (targetPos.y - startPos.y) * t;
                            float z = startPos.z + (targetPos.z - startPos.z) * t;
                            Vector3f newPos = new Vector3f(x, y, z);
                            elevator.setLocalPosition(newPos);
                            if (t >= 1.0f) {
                                moveTimer.kill();
                                player.sendYellMessage("Arrived", 2.0f, false);
                                SoundAsset bellSound = (SoundAsset)player.getAttribute("Bellsoundfile");
                                for (Player p : Server.getAllPlayers()) {
                                    p.playSound(bellSound, false, 1.0f, 1.0f, 0.0f, 15.0f, targetPos);
                                }
                                elevator.setAnimatorParameter("LeftDoor", "OpenClose", 2);
                                elevator.setAnimatorParameter("RightDoor", "OpenClose", 2);
                                for (Player p : Server.getAllPlayers()) {
                                    p.playSound(doorSound, false, 1.0f, 1.0f, 0.0f, 15.0f, targetPos);
                                }
                                if (this.doorsByElevator.containsKey(elevatorID)) {
                                    for (Prefab door : this.doorsByElevator.get(elevatorID).getOrDefault(floor, new ArrayList())) {
                                        door.setAnimatorParameter("LeftDoor", "OpenClose", 2);
                                        door.setAnimatorParameter("RightDoor", "OpenClose", 2);
                                    }
                                }
                                queue.poll();
                                this.processNextFloor(elevatorID, player, mainPanel);
                            }
                        };
                        moveTimer.setTask(moveTask);
                        moveTimer.start();
                    });
                    delayTimer.start();
                }
            } else {
                queue.poll();
                this.processNextFloor(elevatorID, player, mainPanel);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(Elevator.class.getName()).log(Level.SEVERE, null, ex);
            queue.poll();
            this.processNextFloor(elevatorID, player, mainPanel);
        }
    }
}

