/*
 * Decompiled with CFR 0.152.
 */
package gun;

import net.risingworld.api.Plugin;
import net.risingworld.api.Timer;
import net.risingworld.api.World;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerMouseButtonEvent;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Layer;
import net.risingworld.api.utils.MouseButton;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;

public class Gun
extends Plugin
implements Listener {
    private Plugin plugin;
    private Timer timer;

    public void onEnable() {
        this.registerEventListener(this);
    }

    public void onDisable() {
    }

    @EventMethod
    public void onPlayerConnect(PlayerConnectEvent event) {
        Player player = event.getPlayer();
        player.setAttribute("Gun", (Object)false);
    }

    @EventMethod
    public void onPlayerMouseButtonEvent(PlayerMouseButtonEvent event) {
        Player player = event.getPlayer();
        MouseButton clicked = event.getButton();
        if (event.isPressed() && clicked == MouseButton.Right && Boolean.TRUE.equals(player.getAttribute("Gun"))) {
            int layerMask = Layer.getBitmask((int[])new int[]{13, 15, 8, 10, 21});
            player.raycast(layerMask, result -> {
                if (result != null) {
                    Vector3f collisionPoint = result.getCollisionPoint();
                    Vector3f explosionScale = new Vector3f(5.0f, 5.0f, 5.0f);
                    World.triggerExplosion((Vector3f)collisionPoint, (Quaternion)Quaternion.ZERO, (Vector3f)explosionScale, (float)5.0f);
                }
            });
        }
        if (event.isPressed() && clicked == MouseButton.Left && Boolean.TRUE.equals(player.getAttribute("Gun"))) {
            Timer raycastTimer = new Timer(-1.0f, 0.0f, -1, null);
            Runnable raycastUpdate = () -> {
                int layerMask = Layer.getBitmask((int[])new int[]{13, 15, 8, 10, 21});
                player.raycast(layerMask, result -> {
                    if (result != null) {
                        long objectID = result.getObjectGlobalID();
                        int layer = result.getLayer();
                        Vector3f collisionPoint = result.getCollisionPoint();
                        Vector3f explosionScale = new Vector3f(0.01f, 0.01f, 0.01f);
                        if (layer == 21) {
                            Npc shotNpc = World.getNpc((long)objectID);
                            int health = shotNpc.getHealth();
                            if (health >= 1) {
                                shotNpc.setHealth(health - 1);
                            } else {
                                shotNpc.kill();
                            }
                        }
                        World.triggerExplosion((Vector3f)collisionPoint, (Quaternion)Quaternion.ZERO, (Vector3f)explosionScale, (float)0.01f);
                    }
                });
            };
            raycastTimer.setTask(raycastUpdate);
            raycastTimer.start();
            this.executeDelayed(1.0f, () -> raycastTimer.kill());
        }
    }

    @EventMethod
    public void onPlayerCommandEvent(PlayerCommandEvent event) {
        String[] cmd = event.getCommand().split(" ");
        Player player = event.getPlayer();
        if (cmd[0].equalsIgnoreCase("/gun")) {
            if (Boolean.FALSE.equals(player.getAttribute("Gun"))) {
                player.setAttribute("Gun", (Object)true);
                player.sendYellMessage("Gun Enabled", 3.0f, true);
            } else {
                player.setAttribute("Gun", (Object)false);
                player.sendYellMessage("Gun disabled", 3.0f, true);
            }
        }
    }
}

