/*
 * Decompiled with CFR 0.152.
 */
package onlinemarket;

import java.sql.ResultSet;
import java.sql.SQLException;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.events.player.ui.PlayerUIElementClickEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UILabel;
import net.risingworld.api.ui.UITextField;
import onlinemarket.MarketMenuControl;
import onlinemarket.OnlineMarket;

public class MarketPurchaseControl
extends OnlineMarket {
    private final Plugin plugin;
    private final MarketMenuControl menuControl;

    public MarketPurchaseControl(Plugin plugin, MarketMenuControl menuControl) {
        this.plugin = plugin;
        this.menuControl = menuControl;
    }

    public void handlePurchaseEvent(PlayerUIElementClickEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        String PlayerName = player.getName();
        int eventID = event.getUIElement().getID();
        int BuyConfirmButtonID = (Integer)player.getAttribute("BuyConfirmButtonID");
        int BuyCancelButtonID = (Integer)player.getAttribute("BuyCancelButtonID");
        int BuyEditButtonID = (Integer)player.getAttribute("BuyEditButtonID");
        if (eventID == BuyConfirmButtonID) {
            try {
                int SaleitemID = (Integer)player.getAttribute("SelectedItemID");
                int itemPrice = (Integer)player.getAttribute("SelectedItemPrice");
                int itemQuantity = (Integer)player.getAttribute("SelectedItemQuantity");
                int isUnlimited = (Integer)player.getAttribute("SelectedItemIsUnlimited");
                String itemOwnerUID = (String)player.getAttribute("SelectedItemOwnerUID");
                String itemName = (String)player.getAttribute("SelectedItemName");
                String buyerUID = PlayerUID;
                String buyerName = PlayerName;
                float buyerMoney = this.getPlayerMoney(buyerUID, buyerName);
                if (buyerMoney >= (float)itemPrice) {
                    UILabel buyPopup;
                    this.deliverItem(player, SaleitemID);
                    this.menuControl.updatePlayerMoney(player, -itemPrice);
                    if (isUnlimited == 0) {
                        Player seller = Server.getPlayerByUID((String)itemOwnerUID);
                        if (seller != null) {
                            this.menuControl.updatePlayerMoney(seller, itemPrice);
                        } else {
                            this.updateOfflineSellerMoney(itemOwnerUID, itemPrice);
                        }
                        OnlineDataBaseAccess2.executeUpdate("DELETE FROM `MarketListings` WHERE ID = " + SaleitemID);
                    }
                    float totalAmount = itemPrice * (isUnlimited == 1 ? 1 : itemQuantity);
                    String sql = "INSERT INTO `MarketTransactions` (PlayerUID, ItemName, QuantitySold, Price, TotalAmount, TransactionType, SellerUID) VALUES ('" + buyerUID + "', '" + itemName + "', " + (isUnlimited == 1 ? 1 : itemQuantity) + ", " + itemPrice + ", " + totalAmount + ", 'Purchase', '" + itemOwnerUID + "')";
                    OnlineDataBaseAccess1.executeUpdate(sql);
                    player.sendYellMessage("Bought " + itemName + " for $" + itemPrice + "!", 3.0f, true);
                    Player seller = Server.getPlayerByUID((String)itemOwnerUID);
                    if (seller != null && !itemOwnerUID.equals("SERVER_UID")) {
                        seller.sendYellMessage(buyerName + " bought your " + itemName + " for $" + itemPrice + "!", 3.0f, true);
                    }
                    if ((buyPopup = (UILabel)player.getAttribute("BuyItemPopupPanel")) != null) {
                        buyPopup.setVisible(false);
                    }
                    this.menuControl.getOpenOnlineMarket().OpenMenu(player);
                    this.menuControl.updateWalletDisplay(player);
                    player.setMouseCursorVisible(true);
                    this.menuControl.refreshStatsUI(player);
                } else {
                    UILabel buyInfo = (UILabel)player.getAttribute("BuyItemInfo");
                    if (buyInfo != null) {
                        buyInfo.setText("<b>Item:</b> " + itemName + "\n<b>Price:</b> $" + itemPrice + " | <b>Quantity:</b> " + String.valueOf(isUnlimited == 1 ? "1" : Integer.valueOf(itemQuantity)) + "\n<b>Seller:</b> " + (isUnlimited == 1 ? "Server" : itemOwnerUID) + "\n<b>Error:</b> Insufficient funds!");
                    }
                    player.sendYellMessage("You don\u2019t have enough money to buy this item!", 3.0f, true);
                }
            }
            catch (SQLException e) {
                player.sendYellMessage("Error processing purchase or logging transaction: " + e.getMessage(), 3.0f, true);
                e.printStackTrace();
            }
        }
        if (eventID == BuyCancelButtonID) {
            UILabel buyPopup = (UILabel)player.getAttribute("BuyItemPopupPanel");
            if (buyPopup != null) {
                buyPopup.setVisible(false);
                player.setAttribute("SelectedItemID", null);
                player.setAttribute("SelectedItemPrice", null);
                player.setAttribute("SelectedItemQuantity", null);
                player.setAttribute("SelectedItemIsUnlimited", null);
                player.setAttribute("SelectedItemOwnerUID", null);
                player.setAttribute("SelectedItemName", null);
            }
            this.menuControl.getOpenOnlineMarket().OpenMenu(player);
        }
        if (eventID == BuyEditButtonID) {
            String ownerUID = (String)player.getAttribute("SelectedItemOwnerUID");
            if (!PlayerUID.equals(ownerUID) && !player.isAdmin()) {
                player.sendYellMessage("You can only edit your own items!", 3.0f, true);
                return;
            }
            UILabel buyPopup = (UILabel)player.getAttribute("BuyItemPopupPanel");
            buyPopup.setVisible(false);
            UILabel editPopup = (UILabel)player.getAttribute("EditItemPopupPanel");
            UILabel editInfo = (UILabel)player.getAttribute("EditItemInfo");
            UITextField editPriceField = (UITextField)player.getAttribute("EditItemPriceField");
            UILabel editUnlimitedToggle = (UILabel)player.getAttribute("EditItemUnlimitedToggle");
            String itemName = (String)player.getAttribute("SelectedItemName");
            int itemPrice = (Integer)player.getAttribute("SelectedItemPrice");
            int itemQuantity = (Integer)player.getAttribute("SelectedItemQuantity");
            int isUnlimited = (Integer)player.getAttribute("SelectedItemIsUnlimited");
            editInfo.setText("<b>Item:</b> " + itemName + "\n<b>Quantity:</b> " + String.valueOf(isUnlimited == 1 ? "Unlimited" : Integer.valueOf(itemQuantity)));
            editPriceField.setText(String.valueOf(itemPrice));
            editUnlimitedToggle.setText("<b>Unlimited Stock: " + (isUnlimited == 1 ? "ON" : "OFF") + "</b>");
            if (!player.isAdmin()) {
                editUnlimitedToggle.setBackgroundColor(0.5f, 0.5f, 0.5f, 0.9f);
                editUnlimitedToggle.setClickable(false);
            } else {
                editUnlimitedToggle.setBackgroundColor(isUnlimited == 1 ? 0.0f : 0.5f, isUnlimited == 1 ? 0.5f : 0.0f, 0.0f, 0.9f);
                editUnlimitedToggle.setClickable(true);
            }
            editPopup.setVisible(true);
            player.setMouseCursorVisible(true);
        }
    }

    private float getPlayerMoney(String playerUID, String playerName) throws SQLException {
        try (ResultSet buyerMoneyResult = OnlineDataBaseAccess1.executeQuery("SELECT Money FROM `PlayerMoney` WHERE PlayerUID = '" + playerUID + "'");){
            if (!buyerMoneyResult.next()) {
                OnlineDataBaseAccess2.executeUpdate("INSERT INTO `PlayerMoney` (PlayerUID, PlayerName, Money) VALUES ('" + playerUID + "', '" + playerName + "', 0)");
                Player player = Server.getPlayerByUID((String)playerUID);
                if (player != null) {
                    player.sendYellMessage("Created a new money account for you with $0 \u2014 add funds to make purchases!", 3.0f, true);
                }
                try (ResultSet newBuyerMoneyResult = OnlineDataBaseAccess1.executeQuery("SELECT Money FROM `PlayerMoney` WHERE PlayerUID = '" + playerUID + "'");){
                    if (!newBuyerMoneyResult.next()) {
                        throw new SQLException("Error creating money account for " + playerUID);
                    }
                    float f = newBuyerMoneyResult.getFloat("Money");
                    return f;
                }
            }
            float f = buyerMoneyResult.getFloat("Money");
            return f;
        }
    }

    private void deliverItem(Player player, int itemID) throws SQLException {
        block15: {
            try (ResultSet itemResult = OnlineDataBaseAccess1.executeQuery("SELECT * FROM `MarketListings` WHERE ID = " + itemID);){
                if (itemResult.next()) {
                    String product = itemResult.getString("ItemCategory");
                    Short itemId = itemResult.getShort("ItemID");
                    Short ClothingItem2 = itemResult.getShort("ItemID");
                    Short ObjectItem2 = itemResult.getShort("ItemID");
                    int quantity = itemResult.getInt("ItemQuantity");
                    int variants = itemResult.getInt("ItemVariants");
                    byte ConstructionItemID = itemResult.getByte("ItemID");
                    int color = 0;
                    long infoID = 0L;
                    if ("construction".equals(product)) {
                        player.getInventory().addConstructionItem(ConstructionItemID, variants, quantity, color);
                    } else if ("clothing".equals(product)) {
                        player.getInventory().addClothingItem(ClothingItem2.shortValue(), variants, quantity, 0, infoID);
                    } else if ("objectkit".equals(product)) {
                        player.getInventory().addObjectItem(ObjectItem2.shortValue(), variants, quantity);
                    } else if ("blueprint".equals(product)) {
                        player.getInventory().addItem(itemId.shortValue(), variants, quantity);
                    } else {
                        player.getInventory().addItem(itemId.shortValue(), variants, quantity);
                    }
                    break block15;
                }
                player.sendYellMessage("Item not found in market \u2014 please contact an admin!", 3.0f, true);
                throw new SQLException("Item ID " + itemID + " not found in MarketListings");
            }
        }
    }

    private void updateOfflineSellerMoney(String sellerUID, int amount) throws SQLException {
        try (ResultSet sellerMoneyResult = OnlineDataBaseAccess1.executeQuery("SELECT Money FROM `PlayerMoney` WHERE PlayerUID = '" + sellerUID + "'");){
            float sellerMoney = sellerMoneyResult.next() ? sellerMoneyResult.getFloat("Money") : 0.0f;
            OnlineDataBaseAccess2.executeUpdate("INSERT OR REPLACE INTO `PlayerMoney` (PlayerUID, PlayerName, Money) VALUES ('" + sellerUID + "', (SELECT PlayerName FROM `PlayerMoney` WHERE PlayerUID = '" + sellerUID + "' LIMIT 1), " + (sellerMoney + (float)amount) + ")");
        }
    }
}

