/*
 * Decompiled with CFR 0.152.
 */
package onlinemarket;

import java.sql.SQLException;
import net.risingworld.api.Plugin;
import net.risingworld.api.events.player.ui.PlayerUIElementClickEvent;
import net.risingworld.api.objects.Inventory;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UILabel;
import net.risingworld.api.ui.UITextField;
import onlinemarket.MarketMenuControl;
import onlinemarket.OnlineMarket;
import onlinemarket.OpenOnlineMarket;

public class MarketListingControl
extends OnlineMarket {
    private final Plugin plugin;
    private final MarketMenuControl menuControl;
    private final OpenOnlineMarket openOnlineMarket;

    public MarketListingControl(Plugin plugin, MarketMenuControl menuControl) {
        this.plugin = plugin;
        this.menuControl = menuControl;
        this.openOnlineMarket = new OpenOnlineMarket(plugin);
    }

    public void handleListingEvent(PlayerUIElementClickEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        String PlayerName = player.getName();
        int eventID = event.getUIElement().getID();
        int onlineMarketAddItemButtonID = (Integer)player.getAttribute("OnlineMarketAddItemButtonID");
        int addItemConfirmButtonID = (Integer)player.getAttribute("AddItemConfirmButtonID");
        int addItemUnlimitedToggleID = (Integer)player.getAttribute("AddItemUnlimitedToggleID");
        int addItemCancelButtonID = (Integer)player.getAttribute("AddItemCancelButtonID");
        if (eventID == onlineMarketAddItemButtonID) {
            String itemName;
            UILabel OnlineMarketTextField = (UILabel)player.getAttribute("OnlineMarketTextField");
            OnlineMarketTextField.setVisible(false);
            Item equippedItem = player.getEquippedItem();
            if (equippedItem == null) {
                player.sendYellMessage("Hold an item to add it to the market!", 3.0f, true);
                player.setMouseCursorVisible(false);
                return;
            }
            int stack = equippedItem.getStack();
            int variant = equippedItem.getVariant();
            if (equippedItem instanceof Item.ConstructionItem) {
                Item.ConstructionItem construction = (Item.ConstructionItem)equippedItem;
                player.setAttribute("SellItemID", (Object)construction.getConstructionID());
                byte GetItemID = construction.getConstructionDefinition().id;
                player.setAttribute("gotthisID", (Object)GetItemID);
                itemName = construction.getConstructionName();
                player.setAttribute("ItemCategorys", (Object)"construction");
            } else if (equippedItem instanceof Item.ObjectItem) {
                Item.ObjectItem object = (Item.ObjectItem)equippedItem;
                player.setAttribute("SellItemID", (Object)object.getObjectID());
                short GetItemID = object.getObjectID();
                player.setAttribute("gotthisID", (Object)GetItemID);
                itemName = object.getObjectName();
                player.setAttribute("ItemCategorys", (Object)"objectkit");
            } else if (equippedItem instanceof Item.ClothingItem) {
                Item.ClothingItem clothing = (Item.ClothingItem)equippedItem;
                player.setAttribute("SellItemID", (Object)clothing.getClothingID());
                short GetItemID = clothing.getClothingID();
                player.setAttribute("gotthisID", (Object)GetItemID);
                itemName = clothing.getClothingName();
                player.setAttribute("ItemCategorys", (Object)"clothing");
            } else if (equippedItem instanceof Item.BlueprintItem) {
                Item.BlueprintItem blueprint = (Item.BlueprintItem)equippedItem;
                player.setAttribute("SellItemID", (Object)blueprint.getBlueprintID());
                long GetItemID = blueprint.getBlueprintID();
                player.setAttribute("gotthisID", (Object)GetItemID);
                itemName = blueprint.getBlueprintName();
                player.setAttribute("ItemCategorys", (Object)"blueprint");
                if (equippedItem.getName().equalsIgnoreCase("blueprint")) {
                    player.setAttribute("Search", (Object)"SELECT count(*) FROM `MarketListings`");
                    player.setAttribute("SearchRsult", (Object)"MarketListings");
                    this.openOnlineMarket.OpenMenu(player);
                    player.showErrorMessageBox("Error", "You Cannot Sell Full Blueprints");
                    return;
                }
            } else {
                itemName = equippedItem.getName();
                short GetItemID = equippedItem.getDefinition().id;
                player.setAttribute("gotthisID", (Object)GetItemID);
                player.setAttribute("ItemCategorys", (Object)itemName);
                player.setAttribute("SellItemID", (Object)equippedItem.getDefinition().id);
            }
            player.setAttribute("SellItemName", (Object)itemName);
            player.setAttribute("SellItemAmount", (Object)stack);
            player.setAttribute("SellItemVariant", (Object)variant);
            UILabel addItemPopupPanel = (UILabel)player.getAttribute("AddItemPopupPanel");
            UILabel addItemInfo = (UILabel)player.getAttribute("AddItemInfo");
            UITextField AddItemPriceField = (UITextField)player.getAttribute("AddItemPriceField");
            UILabel addItemUnlimitedToggle = (UILabel)player.getAttribute("AddItemUnlimitedToggle");
            addItemInfo.setText("<b>Item:</b> " + itemName + "\n<b>Amount:</b> " + stack);
            AddItemPriceField.setText("");
            addItemUnlimitedToggle.setText("<b>Unlimited Stock: OFF</b>");
            addItemUnlimitedToggle.setBackgroundColor(0.5f, 0.0f, 0.0f, 0.9f);
            player.setAttribute("UnlimitedStock", (Object)false);
            addItemPopupPanel.setVisible(true);
            player.setMouseCursorVisible(true);
        }
        if (eventID == addItemConfirmButtonID) {
            UILabel addItemPopupPanel = (UILabel)player.getAttribute("AddItemPopupPanel");
            UITextField AddItemPriceField = (UITextField)player.getAttribute("AddItemPriceField");
            AddItemPriceField.getCurrentText(player, priceText -> {
                if (priceText == null || priceText.trim().isEmpty()) {
                    player.sendYellMessage("Please enter a price!", 3.0f, true);
                    return;
                }
                try {
                    int price = Integer.parseInt(priceText);
                    String itemName = (String)player.getAttribute("SellItemName");
                    int stack = (Integer)player.getAttribute("SellItemAmount");
                    String GetCategory = (String)player.getAttribute("ItemCategorys");
                    boolean unlimited = (Boolean)player.getAttribute("UnlimitedStock");
                    int variant = (Integer)player.getAttribute("SellItemVariant");
                    int itemQuantity = stack;
                    String ownerName = unlimited ? "Server" : PlayerName;
                    String ownerUID = unlimited ? "SERVER_UID" : PlayerUID;
                    OnlineDataBaseAccess2.executeUpdate("INSERT INTO `MarketListings` (ItemName, ItemPrice, ItemOwnerName, ItemOwnerUID, ItemID, ItemCategory, ItemVariants, ItemQuantity, IsUnlimited) VALUES ('" + itemName + "', '" + price + "', '" + ownerName + "', '" + ownerUID + "', '" + String.valueOf(player.getAttribute("gotthisID")) + "', '" + GetCategory + "', '" + variant + "', '" + itemQuantity + "', '" + (unlimited ? 1 : 0) + "')");
                    if (!unlimited) {
                        Item equippedItem = player.getEquippedItem();
                        player.setAttribute("itemRemoved", (Object)false);
                        if (equippedItem != null) {
                            String equippedName = this.getItemName(equippedItem);
                            player.sendTextMessage("Equipped item name: " + equippedName + ", Expected: " + itemName);
                            if (this.isItemMatch(equippedItem, itemName, stack, variant)) {
                                this.removeItemFromInventory(player, itemName, stack, variant);
                                if (Boolean.FALSE.equals(player.getAttribute("itemRemoved"))) {
                                    this.removeItemFromQuickslot(player, itemName, stack, variant);
                                }
                                if (Boolean.FALSE.equals(player.getAttribute("itemRemoved"))) {
                                    player.sendYellMessage("Couldn\u2019t find " + stack + " " + itemName + " (variant " + variant + ") to remove \u2014 contact an admin!", 3.0f, true);
                                    System.out.println("Failed to remove item " + itemName + " (stack: " + stack + ", variant: " + variant + ") for player " + PlayerName);
                                }
                            } else {
                                player.sendYellMessage("Equipped item mismatch \u2014 expected " + itemName + " (stack: " + stack + ", variant: " + variant + "). Contact an admin!", 3.0f, true);
                                System.out.println("Item mismatch for " + PlayerName + ": Expected " + itemName + " (stack: " + stack + ", variant: " + variant + "), Got: " + equippedName);
                            }
                        } else {
                            player.sendYellMessage("No item equipped \u2014 expected " + itemName + " (stack: " + stack + ", variant: " + variant + "). Contact an admin!", 3.0f, true);
                            System.out.println("No item equipped for " + PlayerName + ": Expected " + itemName + " (stack: " + stack + ", variant: " + variant + ")");
                        }
                        float totalAmount = price * stack;
                        String sql = "INSERT INTO `MarketTransactions` (PlayerUID, ItemName, QuantitySold, Price, TotalAmount, TransactionType, SellerUID) VALUES ('" + PlayerUID + "', '" + itemName + "', " + stack + ", " + price + ", " + totalAmount + ", 'StockAdded', '" + PlayerUID + "')";
                        OnlineDataBaseAccess1.executeUpdate(sql);
                    }
                    addItemPopupPanel.setVisible(false);
                    player.setMouseCursorVisible(false);
                    this.menuControl.getOpenOnlineMarket().OpenMenu(player);
                    player.sendYellMessage("Added " + (String)(unlimited ? "unlimited " : stack + " ") + itemName + " to market stock for " + price + " coins!", 5.0f, true);
                    this.menuControl.refreshStatsUI(player);
                }
                catch (NumberFormatException ex) {
                    player.sendYellMessage("Invalid price use whole numbers!", 3.0f, true);
                }
            });
        }
        if (eventID == addItemUnlimitedToggleID) {
            if (!player.isAdmin()) {
                player.sendYellMessage("Sorry, only admins can add unlimited items!", 3.0f, true);
                return;
            }
            UILabel addItemUnlimitedToggle = (UILabel)player.getAttribute("AddItemUnlimitedToggle");
            boolean currentState = (Boolean)player.getAttribute("UnlimitedStock");
            player.setAttribute("UnlimitedStock", (Object)(!currentState ? 1 : 0));
            addItemUnlimitedToggle.setText("<b>Unlimited Stock: " + (!currentState ? "ON" : "OFF") + "</b>");
            addItemUnlimitedToggle.setBackgroundColor(!currentState ? 0.0f : 0.5f, !currentState ? 0.5f : 0.0f, 0.0f, 0.9f);
        }
        if (eventID == addItemCancelButtonID) {
            UILabel addItemPopup = (UILabel)player.getAttribute("AddItemPopupPanel");
            if (addItemPopup != null) {
                addItemPopup.setVisible(false);
            }
            this.menuControl.getOpenOnlineMarket().OpenMenu(player);
            player.setMouseCursorVisible(true);
        }
    }

    private String getItemName(Item item) {
        if (item instanceof Item.ObjectItem) {
            return ((Item.ObjectItem)item).getObjectName();
        }
        if (item instanceof Item.ConstructionItem) {
            return ((Item.ConstructionItem)item).getConstructionName();
        }
        if (item instanceof Item.ClothingItem) {
            return ((Item.ClothingItem)item).getClothingName();
        }
        if (item instanceof Item.BlueprintItem) {
            return ((Item.BlueprintItem)item).getBlueprintName();
        }
        return item.getName();
    }

    private boolean isItemMatch(Item item, String expectedName, int stack, int variant) {
        String itemName = this.getItemName(item);
        return itemName.equals(expectedName) && item.getStack() == stack && item.getVariant() == variant;
    }

    private void removeItemFromInventory(Player player, String itemName, int stack, int variant) {
        for (int i = 0; i < 36; ++i) {
            String slotName;
            Item slotItem = player.getInventory().getItem(i, Inventory.SlotType.Inventory);
            if (slotItem == null || !(slotName = this.getItemName(slotItem)).equals(itemName) || slotItem.getStack() != stack || slotItem.getVariant() != variant) continue;
            player.getInventory().removeItem(i, Inventory.SlotType.Inventory, stack);
            player.setAttribute("itemRemoved", (Object)true);
            player.sendYellMessage("Removed " + stack + " " + itemName + " (variant " + variant + ") from inventory slot " + i + " for sale.", 3.0f, true);
            break;
        }
    }

    private void removeItemFromQuickslot(Player player, String itemName, int stack, int variant) {
        String quickslotName;
        int quickslotFocus = player.getInventory().getQuickslotFocus();
        Item quickslotItem = player.getInventory().getItem(quickslotFocus, Inventory.SlotType.Quickslot);
        if (quickslotItem != null && (quickslotName = this.getItemName(quickslotItem)).equals(itemName) && quickslotItem.getStack() == stack && quickslotItem.getVariant() == variant) {
            player.getInventory().removeItem(quickslotFocus, Inventory.SlotType.Quickslot, stack);
            player.setAttribute("itemRemoved", (Object)true);
            player.sendYellMessage("Removed " + stack + " " + itemName + " (variant " + variant + ") from quickslot for sale.", 3.0f, true);
        }
    }
}

