/*
 * Decompiled with CFR 0.152.
 */
package onlinemarket;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.Locale;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UILabel;
import onlinemarket.OnlineMarket;

public class Stats {
    private final Plugin plugin;

    public Stats(Plugin plugin) {
        this.plugin = plugin;
    }

    public void loadPlayerStats(Player player) {
        String playerUID = player.getUID();
        NumberFormat currencyFormatter = NumberFormat.getCurrencyInstance(Locale.US);
        try {
            ResultSet rs8;
            ResultSet rs7;
            ResultSet rs6;
            ResultSet rs5;
            ResultSet rs4;
            ResultSet rs3;
            ResultSet rs2;
            ResultSet rs = OnlineMarket.OnlineDataBaseAccess1.executeQuery("SELECT COUNT(*) as listingCount FROM MarketListings WHERE ItemOwnerUID = '" + playerUID + "'");
            if (rs.next()) {
                player.setAttribute("StatsListingCountValue", (Object)rs.getInt("listingCount"));
            }
            if ((rs2 = OnlineMarket.OnlineDataBaseAccess1.executeQuery("SELECT Money FROM PlayerMoney WHERE PlayerUID = '" + playerUID + "'")).next()) {
                player.setAttribute("StatsWalletValue", (Object)Float.valueOf(rs2.getFloat("Money")));
            }
            if ((rs3 = OnlineMarket.OnlineDataBaseAccess1.executeQuery("SELECT SUM(CASE WHEN TransactionType = 'StockAdded' THEN QuantitySold ELSE 0 END) - SUM(CASE WHEN TransactionType = 'Purchase' THEN QuantitySold ELSE 0 END) AS stock FROM MarketTransactions WHERE PlayerUID = '" + playerUID + "' OR SellerUID = '" + playerUID + "'")).next()) {
                player.setAttribute("StatsStockValue", (Object)rs3.getInt("stock"));
            }
            if ((rs4 = OnlineMarket.OnlineDataBaseAccess1.executeQuery("SELECT SUM(QuantitySold) AS itemsSold FROM MarketTransactions WHERE (TransactionType = 'Purchase' AND SellerUID = '" + playerUID + "') OR (TransactionType = 'Sale' AND PlayerUID = '" + playerUID + "')")).next()) {
                player.setAttribute("StatsItemsSoldValue", (Object)rs4.getInt("itemsSold"));
            }
            if ((rs5 = OnlineMarket.OnlineDataBaseAccess1.executeQuery("SELECT SUM(TotalAmount) AS moneySpent FROM MarketTransactions WHERE TransactionType = 'Purchase' AND PlayerUID = '" + playerUID + "'")).next()) {
                float moneySpent = rs5.getFloat("moneySpent");
                player.setAttribute("StatsMoneySpentValue", (Object)Float.valueOf(moneySpent));
                player.setAttribute("StatsMoneySpentFormatted", (Object)currencyFormatter.format(moneySpent));
            }
            if ((rs6 = OnlineMarket.OnlineDataBaseAccess1.executeQuery("SELECT SUM(TotalAmount) AS moneyEarned FROM MarketTransactions WHERE TransactionType = 'Purchase' AND SellerUID = '" + playerUID + "'")).next()) {
                float moneyEarned = rs6.getFloat("moneyEarned");
                player.setAttribute("StatsMoneyEarnedValue", (Object)Float.valueOf(moneyEarned));
                player.setAttribute("StatsMoneyEarnedFormatted", (Object)currencyFormatter.format(moneyEarned));
            }
            if ((rs7 = OnlineMarket.OnlineDataBaseAccess1.executeQuery("SELECT SUM(QuantitySold) AS totalSales FROM MarketTransactions WHERE (TransactionType = 'Purchase' AND PlayerUID = '" + playerUID + "') OR (TransactionType = 'Sale' AND PlayerUID = '" + playerUID + "')")).next()) {
                player.setAttribute("StatsTotalSalesValue", (Object)rs7.getInt("totalSales"));
            }
            if ((rs8 = OnlineMarket.OnlineDataBaseAccess1.executeQuery("SELECT ItemName, COUNT(*) as count FROM MarketTransactions WHERE (TransactionType = 'Purchase' AND PlayerUID = '" + playerUID + "') OR (TransactionType = 'Sale' AND PlayerUID = '" + playerUID + "') GROUP BY ItemName ORDER BY count DESC LIMIT 1")).next()) {
                player.setAttribute("StatsMostPopularItemValue", (Object)rs8.getString("ItemName"));
            }
            ResultSet rs9 = OnlineMarket.OnlineDataBaseAccess1.executeQuery("SELECT SellerUID, SUM(TotalAmount) as totalEarned FROM MarketTransactions WHERE TransactionType = 'Purchase' GROUP BY SellerUID ORDER BY totalEarned DESC LIMIT 3");
            StringBuilder topEarners = new StringBuilder();
            while (rs9.next()) {
                String sellerUID = rs9.getString("SellerUID");
                float earned = rs9.getFloat("totalEarned");
                String sellerName = this.getSellerNameFromMarketListings(sellerUID);
                if (sellerName == null || sellerName.isEmpty()) {
                    sellerName = this.getSellerNameFallback(sellerUID);
                }
                topEarners.append(sellerName).append(": ").append(currencyFormatter.format(earned)).append("\n");
            }
            player.setAttribute("StatsTopEarnersValue", (Object)topEarners.toString().trim());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updateStatsUI(UILabel statsPanel, Player player) {
        UILabel statsListingCount = (UILabel)player.getAttribute("StatsListingCount");
        UILabel statsWallet = (UILabel)player.getAttribute("StatsWallet");
        UILabel statsStock = (UILabel)player.getAttribute("StatsStock");
        UILabel statsItemsSold = (UILabel)player.getAttribute("StatsItemsSold");
        UILabel statsMoneySpent = (UILabel)player.getAttribute("StatsMoneySpent");
        UILabel statsMoneyEarned = (UILabel)player.getAttribute("StatsMoneyEarned");
        UILabel statsTotalSales = (UILabel)player.getAttribute("StatsTotalSales");
        UILabel statsMostPopularItem = (UILabel)player.getAttribute("StatsMostPopularItem");
        UILabel statsTopEarners = (UILabel)player.getAttribute("StatsTopEarners");
        if (statsListingCount != null) {
            Integer listingCount = (Integer)player.getAttribute("StatsListingCountValue");
            statsListingCount.setText("Total Listings: " + (listingCount != null ? listingCount : 0));
        }
        if (statsWallet != null) {
            Float walletValue = (Float)player.getAttribute("StatsWalletValue");
            statsWallet.setText("Wallet: $" + (walletValue != null ? walletValue.floatValue() : 0.0f));
        }
        if (statsStock != null) {
            Integer stockValue = (Integer)player.getAttribute("StatsStockValue");
            statsStock.setText("Current Stock: " + (stockValue != null ? stockValue : 0));
        }
        if (statsItemsSold != null) {
            Integer itemsSold = (Integer)player.getAttribute("StatsItemsSoldValue");
            statsItemsSold.setText("Total Items Sold: " + (itemsSold != null ? itemsSold : 0));
        }
        if (statsMoneySpent != null) {
            String moneySpentFormatted = (String)player.getAttribute("StatsMoneySpentFormatted");
            statsMoneySpent.setText("Money Spent: " + (moneySpentFormatted != null ? moneySpentFormatted : "$0.00"));
        }
        if (statsMoneyEarned != null) {
            String moneyEarnedFormatted = (String)player.getAttribute("StatsMoneyEarnedFormatted");
            statsMoneyEarned.setText("Money Earned: " + (moneyEarnedFormatted != null ? moneyEarnedFormatted : "$0.00"));
        }
        if (statsTotalSales != null) {
            Integer totalSales = (Integer)player.getAttribute("StatsTotalSalesValue");
            statsTotalSales.setText("Total Sales: " + String.valueOf(totalSales != null ? totalSales : "Loading..."));
        }
        if (statsMostPopularItem != null) {
            String mostPopularItem = (String)player.getAttribute("StatsMostPopularItemValue");
            statsMostPopularItem.setText("Most Popular Item: " + (mostPopularItem != null ? mostPopularItem : "Loading..."));
        }
        if (statsTopEarners != null) {
            String topEarners = (String)player.getAttribute("StatsTopEarnersValue");
            statsTopEarners.setText("Top Player Earners:\n" + (topEarners != null && !topEarners.isEmpty() ? topEarners : "Loading..."));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getSellerNameFromMarketListings(String sellerUID) {
        try (ResultSet rs = OnlineMarket.OnlineDataBaseAccess1.executeQuery("SELECT ItemOwnerName FROM MarketListings WHERE ItemOwnerUID = '" + sellerUID + "' LIMIT 1");){
            if (!rs.next()) return null;
            String string = rs.getString("ItemOwnerName");
            return string;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getSellerNameFallback(String sellerUID) {
        Player seller = Server.getPlayerByUID((String)sellerUID);
        if (seller != null) {
            return seller.getName();
        }
        try (ResultSet rs = OnlineMarket.OnlineDataBaseAccess1.executeQuery("SELECT PlayerName FROM PlayerMoney WHERE PlayerUID = '" + sellerUID + "' LIMIT 1");){
            if (!rs.next()) return sellerUID;
            String name = rs.getString("PlayerName");
            String string = name != null && !name.isEmpty() ? name : sellerUID;
            return string;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return sellerUID;
    }
}

