/*
 * Decompiled with CFR 0.152.
 */
package onlinemarket;

import java.sql.SQLException;
import net.risingworld.api.Plugin;
import net.risingworld.api.events.player.ui.PlayerUIElementClickEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UILabel;
import onlinemarket.MarketMenuControl;
import onlinemarket.OnlineMarket;

public class MarketStatsControl
extends OnlineMarket {
    private final Plugin plugin;
    private final MarketMenuControl menuControl;

    public MarketStatsControl(Plugin plugin, MarketMenuControl menuControl) {
        this.plugin = plugin;
        this.menuControl = menuControl;
    }

    public void handleStatsEvent(PlayerUIElementClickEvent event) throws SQLException {
        UILabel onlineMarketTextField;
        UILabel onlineMarketStatsPanel;
        Player player = event.getPlayer();
        int eventID = event.getUIElement().getID();
        int OnlineMarketStatsButtonID = (Integer)player.getAttribute("OnlineMarketStatsButtonID");
        int OnlineMarketStatsBackButtonID = (Integer)player.getAttribute("OnlineMarketStatsBackButtonID");
        int OnlineMarketStatsExitButtonID = (Integer)player.getAttribute("OnlineMarketStatsExitButtonID");
        if (eventID == OnlineMarketStatsButtonID) {
            onlineMarketStatsPanel = (UILabel)player.getAttribute("OnlineMarketStatsPanel");
            onlineMarketTextField = (UILabel)player.getAttribute("OnlineMarketTextField");
            if (onlineMarketStatsPanel != null && onlineMarketTextField != null) {
                boolean isVisible = (Boolean)player.getAttribute("StatsPanelVisible");
                onlineMarketStatsPanel.setVisible(!isVisible);
                onlineMarketTextField.setVisible(isVisible);
                player.setAttribute("StatsPanelVisible", (Object)(!isVisible ? 1 : 0));
                if (!isVisible) {
                    this.menuControl.getStats().loadPlayerStats(player);
                    this.menuControl.getStats().updateStatsUI(onlineMarketStatsPanel, player);
                } else {
                    this.resetStatsLabels(player);
                }
            } else {
                player.sendTextMessage("Stats Panel or Market Menu not found!");
            }
        }
        if (eventID == OnlineMarketStatsBackButtonID && (onlineMarketStatsPanel = (UILabel)player.getAttribute("OnlineMarketStatsPanel")) != null) {
            onlineMarketStatsPanel.setVisible(false);
            player.setAttribute("StatsPanelVisible", (Object)false);
            this.menuControl.getOpenOnlineMarket().OpenMenu(player);
        }
        if (eventID == OnlineMarketStatsExitButtonID) {
            onlineMarketStatsPanel = (UILabel)player.getAttribute("OnlineMarketStatsPanel");
            onlineMarketTextField = (UILabel)player.getAttribute("OnlineMarketTextField");
            if (onlineMarketStatsPanel != null) {
                onlineMarketStatsPanel.setVisible(false);
            }
            if (onlineMarketTextField != null) {
                onlineMarketTextField.setVisible(false);
            }
            player.setAttribute("StatsPanelVisible", (Object)false);
            player.setMouseCursorVisible(false);
        }
    }

    private void resetStatsLabels(Player player) {
        UILabel statsListingCount = (UILabel)player.getAttribute("StatsListingCount");
        UILabel statsSalesValue = (UILabel)player.getAttribute("StatsSalesValue");
        UILabel statsWallet = (UILabel)player.getAttribute("StatsWallet");
        UILabel statsPopularItem = (UILabel)player.getAttribute("StatsPopularItem");
        UILabel statsTopEarners = (UILabel)player.getAttribute("StatsTopEarners");
        if (statsListingCount != null) {
            statsListingCount.setText("Total Listings: Loading...");
        }
        if (statsSalesValue != null) {
            statsSalesValue.setText("Total Sales: Loading...");
        }
        if (statsWallet != null) {
            statsWallet.setText("Wallet: Loading...");
        }
        if (statsPopularItem != null) {
            statsPopularItem.setText("Most Popular Item: Loading...");
        }
        if (statsTopEarners != null) {
            statsTopEarners.setText("Top Player Earners: Loading...");
        }
    }
}

