/*
 * Decompiled with CFR 0.152.
 */
package onlinemarket;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import net.risingworld.api.Plugin;
import net.risingworld.api.assets.TextureAsset;
import net.risingworld.api.definitions.Clothing;
import net.risingworld.api.definitions.Constructions;
import net.risingworld.api.definitions.Definitions;
import net.risingworld.api.definitions.Items;
import net.risingworld.api.definitions.Objects;
import net.risingworld.api.events.player.ui.PlayerUIElementClickEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.ui.UILabel;
import net.risingworld.api.ui.UITextField;
import net.risingworld.api.ui.style.ScaleMode;
import net.risingworld.api.ui.style.TextAnchor;
import onlinemarket.MarketMenuControl;
import onlinemarket.OnlineMarket;

public class MarketNavigationControl
extends OnlineMarket {
    private final Plugin plugin;
    private final MarketMenuControl menuControl;

    public MarketNavigationControl(Plugin plugin, MarketMenuControl menuControl) {
        this.plugin = plugin;
        this.menuControl = menuControl;
    }

    public void handleNavigationEvent(PlayerUIElementClickEvent event) throws SQLException {
        int PageNumber;
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        int eventID = event.getUIElement().getID();
        int OnlineMarketSearchButtonID = (Integer)player.getAttribute("OnlineMarketSearchButtonID");
        int OnlineMarketNextButtonID = (Integer)player.getAttribute("OnlineMarketNextButtonID");
        int OnlineMarketBackButtonID = (Integer)player.getAttribute("OnlineMarketBackButtonID");
        int OnlineMarketMyListingsButtonID = (Integer)player.getAttribute("OnlineMarketMyListingsButtonID");
        int OnlineMarketMarketListingsButtonID = (Integer)player.getAttribute("OnlineMarketMarketListingsButtonID");
        int OnlineMarketAllListingsButtonID = (Integer)player.getAttribute("OnlineMarketAllListingsButtonID");
        UILabel OnlineMarketTextField = (UILabel)player.getAttribute("OnlineMarketTextField");
        ArrayList OnlineMarketSelectBottons = (ArrayList)player.getAttribute("OnlineMarketSelectBottons");
        ArrayList OnlineMarketSelected = (ArrayList)player.getAttribute("OnlineMarketSelected");
        ArrayList<UILabel> CopyOnlineMarketSelected = new ArrayList<UILabel>(OnlineMarketSelectBottons);
        UITextField OnlineMarketID = (UITextField)player.getAttribute("OnlineMarketID");
        if (eventID == OnlineMarketSearchButtonID) {
            OnlineMarketTextField.setText("");
            this.clearListingDisplay(CopyOnlineMarketSelected, OnlineMarketSelectBottons, OnlineMarketSelected);
            OnlineMarketID.getCurrentText(player, OnlineMarketIDText -> {
                player.setAttribute("OnlineMarketIDText", OnlineMarketIDText);
                String searchQuery = "SELECT count(*) FROM `MarketListings` WHERE ItemName LIKE '" + OnlineMarketIDText + "%' OR ItemName LIKE '%" + OnlineMarketIDText + "' OR ItemName LIKE '%" + OnlineMarketIDText + "%' OR ItemPrice LIKE '" + OnlineMarketIDText + "%' OR ItemPrice LIKE '%" + OnlineMarketIDText + "' OR ItemPrice LIKE '%" + OnlineMarketIDText + "%' OR ItemOwnerName LIKE '" + OnlineMarketIDText + "%' OR ItemOwnerName LIKE '%" + OnlineMarketIDText + "' OR ItemOwnerName LIKE '%" + OnlineMarketIDText + "%'";
                String searchResultQuery = "MarketListings WHERE ItemName LIKE '" + OnlineMarketIDText + "%' OR ItemName LIKE '%" + OnlineMarketIDText + "' OR ItemName LIKE '%" + OnlineMarketIDText + "%' OR ItemPrice LIKE '" + OnlineMarketIDText + "%' OR ItemPrice LIKE '%" + OnlineMarketIDText + "' OR ItemPrice LIKE '%" + OnlineMarketIDText + "%' OR ItemOwnerName LIKE '" + OnlineMarketIDText + "%' OR ItemOwnerName LIKE '%" + OnlineMarketIDText + "' OR ItemOwnerName LIKE '%" + OnlineMarketIDText + "%'";
                player.setAttribute("Search", (Object)searchQuery);
                player.setAttribute("SearchRsult", (Object)searchResultQuery);
                int PageNumber = 1;
                player.setAttribute("OnlineMarketPageNumber", (Object)PageNumber);
                this.displayListings(player, OnlineMarketTextField, OnlineMarketSelectBottons, OnlineMarketSelected);
            });
        }
        if (eventID == OnlineMarketNextButtonID) {
            OnlineMarketTextField.setText("");
            this.clearListingDisplay(CopyOnlineMarketSelected, OnlineMarketSelectBottons, OnlineMarketSelected);
            PageNumber = (Integer)player.getAttribute("OnlineMarketPageNumber") + 1;
            player.setAttribute("OnlineMarketPageNumber", (Object)PageNumber);
            this.displayListings(player, OnlineMarketTextField, OnlineMarketSelectBottons, OnlineMarketSelected);
        }
        if (eventID == OnlineMarketBackButtonID) {
            OnlineMarketTextField.setText("");
            this.clearListingDisplay(CopyOnlineMarketSelected, OnlineMarketSelectBottons, OnlineMarketSelected);
            PageNumber = Math.max(1, (Integer)player.getAttribute("OnlineMarketPageNumber") - 1);
            player.setAttribute("OnlineMarketPageNumber", (Object)PageNumber);
            this.displayListings(player, OnlineMarketTextField, OnlineMarketSelectBottons, OnlineMarketSelected);
        }
        if (eventID == OnlineMarketMyListingsButtonID) {
            player.setAttribute("Search", (Object)("SELECT count(*) FROM `MarketListings` WHERE ItemOwnerUID = '" + PlayerUID + "'"));
            player.setAttribute("SearchRsult", (Object)("MarketListings WHERE ItemOwnerUID = '" + PlayerUID + "'"));
            this.menuControl.getOpenOnlineMarket().OpenMenu(player);
        }
        if (eventID == OnlineMarketMarketListingsButtonID) {
            player.setAttribute("Search", (Object)"SELECT count(*) FROM `MarketListings` WHERE IsUnlimited = 1");
            player.setAttribute("SearchRsult", (Object)"MarketListings WHERE IsUnlimited = 1");
            this.menuControl.getOpenOnlineMarket().OpenMenu(player);
        }
        if (eventID == OnlineMarketAllListingsButtonID) {
            player.setAttribute("Search", (Object)"SELECT count(*) FROM `MarketListings`");
            player.setAttribute("SearchRsult", (Object)"MarketListings");
            this.menuControl.getOpenOnlineMarket().OpenMenu(player);
        }
        for (String selected : OnlineMarketSelected) {
            String[] parts;
            if (selected == null || (parts = selected.split(",", 2)).length != 2) continue;
            int buttonID = Integer.parseInt(parts[0]);
            String itemID = parts[1];
            if (eventID != buttonID) continue;
            try (ResultSet result = OnlineDataBaseAccess1.executeQuery("SELECT * FROM `MarketListings` WHERE ID = '" + itemID + "'");){
                if (result.next()) {
                    OnlineMarketTextField.setVisible(false);
                    UILabel buyPopup = (UILabel)player.getAttribute("BuyItemPopupPanel");
                    if (buyPopup == null) {
                        System.out.println("BuyItemPopupPanel is null!");
                        return;
                    }
                    buyPopup.setVisible(true);
                    UILabel buyInfo = (UILabel)player.getAttribute("BuyItemInfo");
                    if (buyInfo == null) {
                        System.out.println("BuyItemInfo is null!");
                        return;
                    }
                    String quantityText = result.getInt("IsUnlimited") == 1 ? "1" : Integer.toString(result.getInt("ItemQuantity"));
                    buyInfo.setText("<b>Item:</b> " + result.getString("ItemName") + "\n<b>Price:</b> $" + result.getInt("ItemPrice") + " | <b>Quantity:</b> " + quantityText + "\n<b>Seller:</b> " + result.getString("ItemOwnerName"));
                    player.setAttribute("SelectedItemID", (Object)result.getInt("ID"));
                    player.setAttribute("SelectedItemPrice", (Object)result.getInt("ItemPrice"));
                    player.setAttribute("SelectedItemQuantity", (Object)result.getInt("ItemQuantity"));
                    player.setAttribute("SelectedItemIsUnlimited", (Object)result.getInt("IsUnlimited"));
                    player.setAttribute("SelectedItemOwnerUID", (Object)result.getString("ItemOwnerUID"));
                    player.setAttribute("SelectedItemName", (Object)result.getString("ItemName"));
                    String category = result.getString("ItemCategory");
                    String itemName = result.getString("ItemName");
                    int variants = result.getInt("ItemVariants");
                    TextureAsset itemIcon = this.getItemIcon(category, itemName, variants);
                    if (itemIcon != null) {
                        ArrayList buyItemIcons = (ArrayList)player.getAttribute("buyItemIcons");
                        for (UILabel icon : buyItemIcons) {
                            icon.setVisible(false);
                            icon.removeFromParent();
                            player.removeUIElement((UIElement)icon);
                        }
                        buyItemIcons.clear();
                        UILabel buyItemIcon = new UILabel();
                        buyItemIcon.setPosition(10.0f, 10.0f, false);
                        buyItemIcon.setSize(50.0f, 50.0f, false);
                        buyItemIcon.style.backgroundImage.set(itemIcon);
                        buyItemIcon.style.backgroundImageScaleMode.set((Enum)ScaleMode.StretchToFill);
                        buyPopup.addChild((UIElement)buyItemIcon);
                        buyItemIcons.add(buyItemIcon);
                    }
                    player.setMouseCursorVisible(true);
                }
            }
            catch (SQLException e) {
                player.sendYellMessage("Error loading item: " + e.getMessage(), 3.0f, true);
                e.printStackTrace();
            }
            for (UILabel label : CopyOnlineMarketSelected) {
                if (label == null) continue;
                label.removeFromParent();
            }
            OnlineMarketTextField.setVisible(false);
        }
    }

    private void clearListingDisplay(ArrayList<UILabel> copyOnlineMarketSelected, ArrayList<UILabel> onlineMarketSelectBottons, ArrayList<String> onlineMarketSelected) {
        for (UILabel OnlineMarketsSeleted : copyOnlineMarketSelected) {
            if (OnlineMarketsSeleted == null) continue;
            onlineMarketSelectBottons.clear();
            onlineMarketSelected.clear();
            OnlineMarketsSeleted.setText("");
            OnlineMarketsSeleted.setVisible(false);
        }
    }

    private void displayListings(Player player, UILabel OnlineMarketTextField, ArrayList<UILabel> OnlineMarketSelectBottons, ArrayList<String> OnlineMarketSelected) {
        block17: {
            OnlineMarketTextField.setText("");
            player.setMouseCursorVisible(true);
            int setRowPosition = 0;
            int Row = 0;
            int limit = 8;
            String Search = (String)player.getAttribute("Search");
            String SearchRsult = (String)player.getAttribute("SearchRsult");
            int PageNumber = (Integer)player.getAttribute("OnlineMarketPageNumber");
            try (ResultSet Result = OnlineDataBaseAccess1.executeQuery(Search);){
                Result.next();
                int db_count = Result.getInt(1);
                int page_max = (db_count + limit - 1) / limit;
                int page_now = Math.min(PageNumber, page_max);
                if (page_now < 1) break block17;
                int start = (page_now - 1) * limit;
                OnlineMarketTextField.setText("  Page " + page_now + " / " + page_max + "\n");
                try (ResultSet Result2 = OnlineDataBaseAccess2.executeQuery("SELECT * FROM " + SearchRsult + " ORDER BY ID DESC LIMIT " + start + ", " + limit);){
                    NumberFormat priceFormatter = NumberFormat.getCurrencyInstance(Locale.US);
                    while (Result2.next()) {
                        setRowPosition = ++Row * 53 + 130;
                        UILabel OnlineMarketSelect = new UILabel();
                        OnlineMarketSelect.style.textAlign.set((Enum)TextAnchor.MiddleCenter);
                        OnlineMarketSelect.setFontColor(9.0f, 9.0f, 9.0f, 1.0f);
                        OnlineMarketSelect.setFontSize(12.0f);
                        OnlineMarketSelect.setBorder(2.0f);
                        OnlineMarketSelect.setBorderColor(999);
                        OnlineMarketSelect.style.borderBottomColor.set(0.0f, 0.0f, 0.2f, 0.9f);
                        OnlineMarketSelect.setBorderEdgeRadius(5.0f, false);
                        OnlineMarketSelect.setSize(250.0f, 50.0f, false);
                        OnlineMarketSelect.setBackgroundColor(0.1f, 0.1f, 0.1f, 0.9f);
                        OnlineMarketSelect.setPosition(24.5f, (float)setRowPosition, false);
                        OnlineMarketSelect.style.borderBottomWidth.set(5.0f);
                        OnlineMarketSelect.hoverStyle.backgroundColor.set(0.2f, 0.2f, 0.2f, 0.9f);
                        OnlineMarketSelect.hoverStyle.borderBottomWidth.set(5.0f);
                        OnlineMarketSelect.hoverStyle.borderBottomColor.set(0.1f, 0.1f, 0.9f, 0.9f);
                        OnlineMarketSelect.setClickable(true);
                        String category = Result2.getString("ItemCategory");
                        String itemName = Result2.getString("ItemName");
                        int variants = Result2.getInt("ItemVariants");
                        TextureAsset itemIcon = this.getItemIcon(category, itemName, variants);
                        if (itemIcon != null) {
                            UILabel iconLabel = new UILabel();
                            iconLabel.setSize(30.0f, 30.0f, false);
                            iconLabel.setPosition(5.0f, 10.0f, false);
                            iconLabel.style.backgroundImage.set(itemIcon);
                            iconLabel.style.backgroundImageScaleMode.set((Enum)ScaleMode.ScaleToFit);
                            OnlineMarketSelect.addChild((UIElement)iconLabel);
                        } else {
                            player.sendTextMessage("No icon available for " + itemName + ".");
                        }
                        String formattedPrice = priceFormatter.format(Result2.getInt("ItemPrice"));
                        OnlineMarketSelect.setText("<b>" + itemName + "</b>\n" + formattedPrice + " Quantity= " + Result2.getString("ItemQuantity"));
                        OnlineMarketTextField.addChild((UIElement)OnlineMarketSelect);
                        OnlineMarketSelectBottons.add(OnlineMarketSelect);
                        OnlineMarketSelected.add(OnlineMarketSelect.getID() + "," + Result2.getInt("ID"));
                    }
                }
            }
            catch (SQLException sQLException) {
                player.sendYellMessage("Navigation Error: " + sQLException.getMessage(), 3.0f, true);
                sQLException.printStackTrace();
            }
        }
    }

    private TextureAsset getItemIcon(String category, String itemName, int variants) {
        TextureAsset itemIcon = null;
        if ("construction".equals(category)) {
            Constructions.ConstructionDefinition def = Definitions.getConstructionDefinition((String)itemName);
            if (def != null) {
                itemIcon = def.getIcon(variants);
            }
        } else if ("clothing".equals(category)) {
            Clothing.ClothingDefinition def = Definitions.getClothingDefinition((String)itemName);
            if (def != null) {
                itemIcon = def.getIcon(variants);
            }
        } else if ("objectkit".equals(category)) {
            Objects.ObjectDefinition def = Definitions.getObjectDefinition((String)itemName);
            if (def != null) {
                itemIcon = def.getIcon(variants);
            }
        } else if ("blueprint".equals(category)) {
            Items.ItemDefinition def = Definitions.getItemDefinition((String)itemName);
            if (def != null) {
                itemIcon = def.getIcon(variants);
            }
        } else {
            Items.ItemDefinition def = Definitions.getItemDefinition((String)itemName);
            if (def != null) {
                itemIcon = def.getIcon(variants);
            }
        }
        return itemIcon;
    }
}

