/*
 * Decompiled with CFR 0.152.
 */
package landclaim;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import landclaim.AdminOnClickButtons;
import landclaim.AdminTools;
import landclaim.AdminUIMenu;
import landclaim.LandClaimDatabase;
import landclaim.OwnerEventHandler;
import landclaim.PlayerOnClickButtons;
import landclaim.PlayerTools;
import landclaim.PlayerUIMenu;
import net.risingworld.api.Plugin;
import net.risingworld.api.Timer;
import net.risingworld.api.World;
import net.risingworld.api.callbacks.Callback;
import net.risingworld.api.database.Database;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerDisconnectEvent;
import net.risingworld.api.events.player.PlayerEnterChunkEvent;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.objects.Area;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.ui.UILabel;
import net.risingworld.api.ui.UITextField;
import net.risingworld.api.ui.style.Font;
import net.risingworld.api.ui.style.TextAnchor;
import net.risingworld.api.utils.Key;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.utils.Vector3i;
import net.risingworld.api.worldelements.Area3D;
import net.risingworld.api.worldelements.GameObject;

public class LandClaim
extends Plugin
implements Listener {
    private LandClaimDatabase database;
    private AdminTools adminTools;
    private AdminUIMenu adminUIMenu;
    private AdminOnClickButtons adminClicks;
    private PlayerOnClickButtons playerClicks;
    private DatabaseTaskQueue taskQueue;
    private Database db;
    public HashMap<Player, PlayerUIMenu> playerMenus = new HashMap();
    private HashMap<Player, PlayerTools> playerTools = new HashMap();
    private HashMap<Player, Vector3i> playerChunks = new HashMap();
    public HashMap<Player, Long> playerLoginTimes = new HashMap();
    HashMap<Vector3i, ClaimedArea> claimedAreasByChunk = new HashMap();
    protected static ArrayList<Area3D> AllClaimedAreas = new ArrayList();
    protected static HashMap<String, ArrayList<Area3D>> UserClaimedAreas = new HashMap();
    private boolean areasLoaded = false;
    private HashMap<Player, Boolean> myAreasVisible = new HashMap();
    private HashMap<Player, Boolean> allAreasVisible = new HashMap();
    private HashMap<Player, Boolean> isShowingAreas = new HashMap();
    private HashMap<Player, List<TempClaim>> tempClaimVisuals = new HashMap();
    private Timer claimCleanupTimer;

    public HashMap<Player, PlayerTools> getPlayerTools() {
        return this.playerTools;
    }

    public DatabaseTaskQueue getTaskQueue() {
        return this.taskQueue;
    }

    public List<TempClaim> getTempClaims(Player player) {
        return this.tempClaimVisuals.get(player);
    }

    public void getCurrentText(Player player, UITextField textField, Callback<String> callback) {
        textField.getCurrentText(player, callback);
    }

    public void renameArea(Vector3i chunk, String newName) throws SQLException {
        ClaimedArea area = this.claimedAreasByChunk.get(chunk);
        if (area != null) {
            area.areaName = newName;
            this.database.getDb().executeUpdate("UPDATE `Areas` SET AreaName = '" + this.escapeSql(newName) + "' WHERE AreaX = " + chunk.x + " AND AreaY = " + chunk.y + " AND AreaZ = " + chunk.z + " AND PlayerUID = '" + this.escapeSql(area.playerUID) + "'");
            System.out.println("[LandClaim] Renamed area at " + String.valueOf(chunk) + " to " + newName);
        }
    }

    public void onEnable() {
        System.out.println("-- LandClaim PLUGIN ENABLED --");
        this.database = new LandClaimDatabase(this);
        this.database.initialize();
        this.adminTools = new AdminTools(this);
        this.adminUIMenu = new AdminUIMenu(this, this.adminTools);
        this.adminClicks = new AdminOnClickButtons(this, this.adminTools);
        this.playerClicks = new PlayerOnClickButtons(this);
        this.taskQueue = new DatabaseTaskQueue(this);
        String worldName = World.getName();
        this.db = this.getSQLiteConnection(this.getPath() + "/" + worldName + "/database.db");
        this.registerEventListener(this);
        this.registerEventListener(new OwnerEventHandler(this));
        this.adminClicks.register();
        this.playerClicks.register();
        this.claimedAreasByChunk.clear();
        AllClaimedAreas.clear();
        UserClaimedAreas.clear();
        this.areasLoaded = false;
        System.out.println("[LandClaim] Initialized and listeners registered.");
        System.out.println("[LandClaim] Points system initialized.");
        this.claimCleanupTimer = new Timer(1.0f, 0.0f, 0, () -> {
            long now = System.currentTimeMillis();
            for (Player player : this.tempClaimVisuals.keySet()) {
                List<TempClaim> claims = this.tempClaimVisuals.get(player);
                if (claims == null) continue;
                claims.removeIf(claim -> {
                    if (now - claim.creationTime >= 60000L) {
                        if (player.isConnected()) {
                            player.removeGameObject((GameObject)claim.visual);
                        }
                        claim.visual.setAlwaysVisible(false);
                        return true;
                    }
                    return false;
                });
                if (!claims.isEmpty()) continue;
                this.tempClaimVisuals.remove(player);
            }
        });
        this.claimCleanupTimer.start();
    }

    public void onDisable() {
        System.out.println("-- LandClaim PLUGIN DISABLED --");
        if (this.database != null) {
            this.database.close();
        }
        this.taskQueue.shutdown();
        for (Player player : this.tempClaimVisuals.keySet()) {
            List<TempClaim> claims = this.tempClaimVisuals.get(player);
            if (claims == null) continue;
            for (TempClaim claim : claims) {
                if (!player.isConnected()) continue;
                player.removeGameObject((GameObject)claim.visual);
            }
        }
        this.tempClaimVisuals.clear();
        if (this.claimCleanupTimer != null) {
            this.claimCleanupTimer.kill();
        }
    }

    @EventMethod
    public void onPlayerConnect(PlayerConnectEvent event) {
        Player player = event.getPlayer();
        player.registerKeys(new Key[]{Key.L, Key.LeftShift});
        this.playerLoginTimes.put(player, System.currentTimeMillis());
        PlayerUIMenu menu = new PlayerUIMenu(player, this);
        this.playerMenus.put(player, menu);
        PlayerTools tools = new PlayerTools(player);
        tools.initTools(menu);
        this.playerTools.put(player, tools);
        Vector3i initialChunk = player.getChunkPosition();
        this.playerChunks.put(player, initialChunk);
        if (this.adminTools.isAdmin(player)) {
            this.adminUIMenu.showAdminMenu(player);
        }
        this.taskQueue.queueTask(() -> {
            try {
                String uid = player.getUID();
                ResultSet rs = this.database.getDb().executeQuery("SELECT ID FROM `Points` WHERE PlayerUID = '" + this.escapeSql(uid) + "'");
                if (!rs.next()) {
                    System.out.println("[LandClaim] Initializing Points row for PlayerUID: " + uid);
                    String sql = "INSERT INTO `Points` (PlayerUID, UserName, Points, TotalPlaytimeHours) VALUES ('" + this.escapeSql(uid) + "', '" + this.escapeSql(player.getName()) + "', 0, 0.0)";
                    this.database.getDb().executeUpdate(sql);
                } else {
                    System.out.println("[LandClaim] Points row already exists for PlayerUID: " + uid);
                }
                int areaCount = this.getPlayerAreaCountFromDB(uid);
                if (areaCount == 0) {
                    this.database.setMaxAreaAllocation(uid, 2);
                }
                if (!this.areasLoaded) {
                    this.loadClaimedAreas();
                    this.areasLoaded = true;
                }
            }
            catch (SQLException e) {
                System.out.println("[LandClaim] Error in player connect DB task: " + e.getMessage());
            }
        }, () -> this.taskQueue.queueTask(() -> {}, () -> {
            this.addAreaInfoLabel(player);
            this.updateAreaInfoLabel(player, initialChunk);
            this.myAreasVisible.put(player, false);
            this.allAreasVisible.put(player, true);
            this.isShowingAreas.put(player, false);
            menu.updateVisibleAreas(initialChunk);
            menu.updateAreaVisibility();
            this.showAreasOnConnect(player);
            new Timer(60.0f, 0.0f, 0, () -> {
                PlayerUIMenu currentMenu = this.playerMenus.get(player);
                if (currentMenu != null) {
                    currentMenu.disableAllAreas();
                    this.allAreasVisible.put(player, false);
                }
            }).start();
        }));
    }

    @EventMethod
    public void onPlayerDisconnect(PlayerDisconnectEvent event) {
        Player player = event.getPlayer();
        Long loginTime = this.playerLoginTimes.remove(player);
        if (loginTime == null) {
            System.out.println("[LandClaim] No login time found for Player: " + player.getName());
            return;
        }
        long playtimeMs = System.currentTimeMillis() - loginTime;
        double sessionHours = (double)playtimeMs / 3600000.0;
        System.out.println("[LandClaim] Player " + player.getName() + " disconnected. Session time: " + playtimeMs + "ms (" + sessionHours + " hours)");
        this.taskQueue.queueTask(() -> {
            try {
                String uid = player.getUID();
                this.database.updatePlaytimeAndPoints(uid, sessionHours);
                int newPoints = this.database.getPoints(uid);
                double totalHours = this.database.getTotalPlaytimeHours(uid);
                int maxAreaAllocation = this.database.getMaxAreaAllocation(uid);
                int pointsEarnedAdjust = this.database.getPointsEarnedAdjust();
                int areaCostAdjust = this.database.getAreaCostAdjust();
                player.setAttribute("pointsEarned", (Object)newPoints);
                player.setAttribute("totalHours", (Object)totalHours);
                player.setAttribute("maxAreaAllocation", (Object)maxAreaAllocation);
                player.setAttribute("pointsEarnedAdjust", (Object)pointsEarnedAdjust);
                player.setAttribute("areaCostAdjust", (Object)areaCostAdjust);
            }
            catch (SQLException e) {
                System.out.println("[LandClaim] Error updating playtime/points on disconnect: " + e.getMessage());
            }
        }, () -> {
            int points = (Integer)player.getAttribute("pointsEarned");
            double totalHours = (Double)player.getAttribute("totalHours");
            int maxAreaAllocation = (Integer)player.getAttribute("maxAreaAllocation");
            int pointsEarnedAdjust = (Integer)player.getAttribute("pointsEarnedAdjust");
            int areaCostAdjust = (Integer)player.getAttribute("areaCostAdjust");
            this.showMessage(player, "Total playtime: " + String.format("%.3f", totalHours) + " hours, Points: " + points + ", Max Areas: " + maxAreaAllocation + ", Points/Hour: " + pointsEarnedAdjust + ", Area Cost: " + areaCostAdjust, 15.0f);
        });
        this.isShowingAreas.remove(player);
        List<TempClaim> claims = this.tempClaimVisuals.remove(player);
        if (claims != null) {
            for (TempClaim claim : claims) {
                if (!player.isConnected()) continue;
                player.removeGameObject((GameObject)claim.visual);
            }
        }
    }

    @EventMethod
    public void onPlayerKey(PlayerKeyEvent event) {
        PlayerUIMenu menu;
        Player player = event.getPlayer();
        if (event.isPressed() && event.getKey() == Key.L && player.isKeyPressed(Key.LeftShift) && (menu = this.playerMenus.get(player)) != null) {
            menu.toggleMenu();
        }
    }

    @EventMethod
    public void onPlayerEnterChunk(PlayerEnterChunkEvent event) {
        Player player = event.getPlayer();
        Vector3i chunk = event.getNewChunkCoordinates();
        this.playerChunks.put(player, chunk);
        this.updateAreaInfoLabel(player, chunk);
        PlayerUIMenu menu = this.playerMenus.get(player);
        if (menu != null) {
            menu.updateVisibleAreas(chunk);
            menu.updateAreaVisibility();
        }
        System.out.println("[LandClaim] Player " + player.getName() + " entered chunk " + String.valueOf(chunk));
    }

    @EventMethod
    public void onPlayerCommand(PlayerCommandEvent event) {
        Player player = event.getPlayer();
        if (!this.adminTools.isAdmin(player)) {
            return;
        }
        String[] args = event.getCommand().split(" ");
        if (args[0].equalsIgnoreCase("/showareas")) {
            boolean show;
            boolean bl = show = args.length > 1 ? Boolean.parseBoolean(args[1]) : true;
            if (show) {
                this.showAreas(player);
            } else {
                this.hideAreas(player);
            }
            this.showMessage(player, "Area visuals " + (show ? "shown" : "hidden") + ".", 60.0f);
            event.setCancelled(true);
        } else if (args[0].equalsIgnoreCase("/admin")) {
            if (args.length < 2) {
                this.showMessage(player, "Usage: /admin [points|cost|alloc] [+|-]", 15.0f);
                event.setCancelled(true);
                return;
            }
            this.taskQueue.queueTask(() -> {
                try {
                    if (args[1].equalsIgnoreCase("points")) {
                        int adjust;
                        int current = this.database.getPointsEarnedAdjust();
                        int n = args[2].equals("+") ? 1 : (adjust = args[2].equals("-") ? -1 : 0);
                        if (adjust == 0) {
                            player.setAttribute("adminResult", (Object)"Invalid argument: Use + or -");
                            return;
                        }
                        int newValue = current + adjust;
                        this.database.setPointsEarnedAdjust(newValue);
                        player.setAttribute("adminResult", (Object)("Points per hour set to " + newValue + ". All player points recalculated."));
                    } else if (args[1].equalsIgnoreCase("cost")) {
                        int adjust;
                        int current = this.database.getAreaCostAdjust();
                        int n = args[2].equals("+") ? 1 : (adjust = args[2].equals("-") ? -1 : 0);
                        if (adjust == 0) {
                            player.setAttribute("adminResult", (Object)"Invalid argument: Use + or -");
                            return;
                        }
                        int newValue = current + adjust;
                        this.database.setAreaCostAdjust(newValue);
                        player.setAttribute("adminResult", (Object)("Area cost set to " + newValue));
                    } else if (args[1].equalsIgnoreCase("alloc")) {
                        int adjust;
                        String uid = this.getAreaOwnerUIDFromPosition(player);
                        if (uid == null) {
                            player.setAttribute("adminResult", (Object)"Stand in a claimed area!");
                            return;
                        }
                        int current = this.database.getMaxAreaAllocation(uid);
                        int n = args[2].equals("+") ? 1 : (adjust = args[2].equals("-") ? -1 : 0);
                        if (adjust == 0) {
                            player.setAttribute("adminResult", (Object)"Invalid argument: Use + or -");
                            return;
                        }
                        int newMax = current + adjust;
                        if (newMax < 0) {
                            player.setAttribute("adminResult", (Object)"Cannot go below 0!");
                            return;
                        }
                        this.database.setMaxAreaAllocation(uid, newMax);
                        player.setAttribute("adminResult", (Object)("Max areas for UID " + uid + " set to " + newMax));
                    } else {
                        player.setAttribute("adminResult", (Object)("Unknown subcommand: " + args[1]));
                    }
                }
                catch (SQLException e) {
                    player.setAttribute("adminResult", (Object)("Error: " + e.getMessage()));
                }
            }, () -> this.showMessage(player, (String)player.getAttribute("adminResult"), 15.0f));
            event.setCancelled(true);
        }
    }

    public LandClaimDatabase getDatabase() {
        return this.database;
    }

    public void startClaimMode(Player player) {
        Vector3i chunk = this.playerChunks.get(player);
        if (chunk == null) {
            this.showMessage(player, "Error: No chunk data!", 15.0f);
            return;
        }
        this.taskQueue.queueTask(() -> {
            try {
                int max;
                ClaimedArea area = this.claimedAreasByChunk.get(chunk);
                if (area != null) {
                    player.setAttribute("claimResult", (Object)("Area already claimed as " + area.areaName + "!"));
                    return;
                }
                String uid = player.getUID();
                int count = this.getPlayerAreaCountFromDB(uid);
                if (count >= (max = this.database.getMaxAreaAllocation(uid))) {
                    player.setAttribute("claimResult", (Object)("You\u2019ve reached your limit of " + max + " areas! Buy more with points."));
                    return;
                }
                String name = count == 0 ? player.getName() + "'s Home" : player.getName() + "'s Area=" + (count + 1);
                ClaimedArea newArea = new ClaimedArea(this, uid, player.getName(), name, chunk.x, chunk.y, chunk.z);
                if (this.database.addClaimedArea(newArea)) {
                    player.setAttribute("claimResult", (Object)newArea);
                } else {
                    player.setAttribute("claimResult", (Object)"Failed to claim area!");
                }
            }
            catch (SQLException e) {
                player.setAttribute("claimResult", (Object)("Error: " + e.getMessage()));
            }
        }, () -> {
            Object result = player.getAttribute("claimResult");
            if (result instanceof ClaimedArea) {
                ClaimedArea area = (ClaimedArea)result;
                this.claimedAreasByChunk.put(chunk, area);
                Area3D newVisual = this.addAreaVisual(chunk.x, chunk.y, chunk.z, area.areaName, area.playerUID, true, player);
                newVisual.setAlwaysVisible(true);
                this.showMessage(player, "Claimed " + area.areaName + "!", 15.0f);
                this.updateAreaInfoLabel(player, chunk);
                if (this.isShowingAreas.getOrDefault(player, false).booleanValue()) {
                    this.showMessage(player, "Please wait before claiming again!", 15.0f);
                    player.removeGameObject((GameObject)newVisual);
                    newVisual.setAlwaysVisible(false);
                    return;
                }
                List claims = this.tempClaimVisuals.computeIfAbsent(player, k -> new ArrayList());
                TempClaim tempClaim = new TempClaim(this, newVisual, System.currentTimeMillis());
                claims.add(tempClaim);
                PlayerUIMenu menu = this.playerMenus.get(player);
                if (menu != null) {
                    menu.updateAreaVisibility();
                }
            } else {
                this.showMessage(player, (String)result, 15.0f);
            }
        });
    }

    public void unclaimArea(Player player) {
        Vector3i chunk = this.playerChunks.get(player);
        if (chunk == null) {
            this.showMessage(player, "Error: No chunk data!", 15.0f);
            return;
        }
        this.taskQueue.queueTask(() -> this.lambda$unclaimArea$14(chunk, player), () -> {
            Object result = player.getAttribute("unclaimResult");
            if (result instanceof ClaimedArea) {
                this.claimedAreasByChunk.remove(chunk);
                this.removeAreaVisual(chunk.x, chunk.y, chunk.z, player.getUID(), player);
                this.showMessage(player, "Area unclaimed!", 15.0f);
                this.updateAreaInfoLabel(player, chunk);
                PlayerUIMenu menu = this.playerMenus.get(player);
                if (menu != null) {
                    menu.updateAreaVisibility();
                }
            } else {
                this.showMessage(player, (String)result, 15.0f);
            }
        });
    }

    public void buyAreaAllocation(Player player) {
        this.taskQueue.queueTask(() -> {
            try {
                String uid = player.getUID();
                Long loginTime = this.playerLoginTimes.get(player);
                if (loginTime == null) {
                    player.setAttribute("buyResult", (Object)"Error: No login time recorded!");
                    return;
                }
                long sessionMs = System.currentTimeMillis() - loginTime;
                double sessionHours = (double)sessionMs / 3600000.0;
                System.out.println("[LandClaim] Buy clicked for " + player.getName() + ", session time: " + sessionHours + " hours");
                this.database.updatePlaytimeAndPoints(uid, sessionHours);
                int areaCost = this.database.getAreaCostAdjust();
                int currentPoints = this.database.getPoints(uid);
                double currentHours = this.database.getTotalPlaytimeHours(uid);
                int pointsEarnedAdjust = this.database.getPointsEarnedAdjust();
                if (currentPoints < areaCost) {
                    player.setAttribute("buyResult", (Object)("Not enough points! Need " + areaCost + ", have " + currentPoints));
                    this.playerLoginTimes.put(player, System.currentTimeMillis());
                    return;
                }
                double hoursToDeduct = (double)areaCost / (double)pointsEarnedAdjust;
                if (currentHours < hoursToDeduct) {
                    player.setAttribute("buyResult", (Object)("Not enough playtime hours! Need " + hoursToDeduct + ", have " + currentHours));
                    this.playerLoginTimes.put(player, System.currentTimeMillis());
                    return;
                }
                this.database.deductPoints(uid, areaCost);
                this.database.deductHours(uid, hoursToDeduct);
                int newMax = this.database.getMaxAreaAllocation(uid) + 1;
                this.database.setMaxAreaAllocation(uid, newMax);
                int newPoints = this.database.getPoints(uid);
                double newHours = this.database.getTotalPlaytimeHours(uid);
                player.setAttribute("buyResult", (Object)("Bought 1 extra area allocation for " + areaCost + " points! New max: " + newMax + ", Points left: " + newPoints + ", Hours left: " + String.format("%.3f", newHours)));
                this.playerLoginTimes.put(player, System.currentTimeMillis());
            }
            catch (SQLException e) {
                player.setAttribute("buyResult", (Object)("Error: " + e.getMessage()));
                this.playerLoginTimes.put(player, System.currentTimeMillis());
            }
        }, () -> {
            this.showMessage(player, (String)player.getAttribute("buyResult"), 15.0f);
            PlayerUIMenu menu = this.playerMenus.get(player);
            if (menu != null) {
                menu.updateBuyAreaButtonText();
            }
        });
    }

    public void loadClaimedAreas() throws SQLException {
        ResultSet rs = this.database.getAllClaimedAreas();
        this.claimedAreasByChunk.clear();
        while (rs.next()) {
            String uid = rs.getString("PlayerUID");
            String owner = rs.getString("AreaOwnerName");
            String name = rs.getString("AreaName");
            int x = rs.getInt("AreaX");
            int y = rs.getInt("AreaY");
            int z = rs.getInt("AreaZ");
            this.claimedAreasByChunk.put(new Vector3i(x, y, z), new ClaimedArea(this, uid, owner, name, x, y, z));
        }
        System.out.println("[LandClaim] Loaded " + this.claimedAreasByChunk.size() + " areas.");
    }

    public Area3D addAreaVisual(int x, int y, int z, String name, String uid, boolean isPlayer, Player player) {
        Vector3i chunk = new Vector3i(x, y, z);
        Vector3f start = this.getGlobalPosition(chunk, new Vector3i(0, 0, 0));
        Vector3f end = this.getGlobalPosition(chunk, new Vector3i(32, 64, 32));
        Area3D visual = new Area3D(new Area(start, end));
        visual.setAlwaysVisible(false);
        visual.setFrameVisible(true);
        if (isPlayer) {
            visual.setColor(0.0f, 0.2f, 0.0f, 0.3f);
            visual.setFrameColor(0.0f, 0.5f, 0.0f, 1.0f);
            UserClaimedAreas.computeIfAbsent(uid, k -> new ArrayList()).add(visual);
        } else {
            visual.setColor(0.0f, 0.0f, 1.0f, 0.3f);
            visual.setFrameColor(0.0f, 0.0f, 1.0f, 1.0f);
            AllClaimedAreas.add(visual);
        }
        player.addGameObject((GameObject)visual);
        return visual;
    }

    private void removeAreaVisual(int x, int y, int z, String uid, Player player) {
        Vector3i chunk = new Vector3i(x, y, z);
        ArrayList<Area3D> areas = UserClaimedAreas.get(uid);
        if (areas != null) {
            areas.removeIf(a -> {
                if (this.getChunkPosition(a.getArea().getStartPosition()).equals((Object)chunk)) {
                    player.removeGameObject((GameObject)a);
                    return true;
                }
                return false;
            });
        }
    }

    public void showAreasOnConnect(Player player) {
        Vector3i chunk = player.getChunkPosition();
        int radius = 5;
        String uid = player.getUID();
        for (ClaimedArea area : this.claimedAreasByChunk.values()) {
            Vector3i areaChunk = new Vector3i(area.areaX, area.areaY, area.areaZ);
            if (Math.abs(areaChunk.x - chunk.x) > radius || Math.abs(areaChunk.y - chunk.y) > radius || Math.abs(areaChunk.z - chunk.z) > radius) continue;
            this.showMessage(player, "Nearby: " + area.areaName + " by " + area.areaOwnerName, 15.0f);
        }
    }

    public void showAreas(Player player) {
        this.hideAreas(player);
        String uid = player.getUID();
        ArrayList<Area3D> userAreas = UserClaimedAreas.get(uid);
        if (userAreas != null) {
            userAreas.forEach(arg_0 -> ((Player)player).addGameObject(arg_0));
        }
        AllClaimedAreas.forEach(arg_0 -> ((Player)player).addGameObject(arg_0));
        this.myAreasVisible.put(player, true);
        this.allAreasVisible.put(player, true);
    }

    public void hideAreas(Player player) {
        String uid = player.getUID();
        ArrayList<Area3D> userAreas = UserClaimedAreas.get(uid);
        if (userAreas != null) {
            userAreas.forEach(arg_0 -> ((Player)player).removeGameObject(arg_0));
        }
        AllClaimedAreas.forEach(arg_0 -> ((Player)player).removeGameObject(arg_0));
        this.myAreasVisible.put(player, false);
        this.allAreasVisible.put(player, false);
    }

    public void showMyAreas(boolean visible, Player player) {
        if (this.myAreasVisible.getOrDefault(player, false) == visible) {
            return;
        }
        String uid = player.getUID();
        ArrayList<Area3D> areas = UserClaimedAreas.get(uid);
        if (areas != null) {
            if (visible) {
                areas.forEach(arg_0 -> ((Player)player).addGameObject(arg_0));
            } else {
                areas.forEach(arg_0 -> ((Player)player).removeGameObject(arg_0));
            }
        }
        this.myAreasVisible.put(player, visible);
    }

    public void showAllAreas(boolean visible, Player player) {
        if (this.allAreasVisible.getOrDefault(player, false) == visible) {
            return;
        }
        String uid = player.getUID();
        ArrayList<Area3D> userAreas = UserClaimedAreas.get(uid);
        if (visible) {
            AllClaimedAreas.forEach(arg_0 -> ((Player)player).addGameObject(arg_0));
            if (userAreas != null) {
                userAreas.forEach(arg_0 -> ((Player)player).addGameObject(arg_0));
            }
        } else {
            AllClaimedAreas.forEach(arg_0 -> ((Player)player).removeGameObject(arg_0));
            if (userAreas != null) {
                userAreas.forEach(arg_0 -> ((Player)player).removeGameObject(arg_0));
            }
        }
        this.allAreasVisible.put(player, visible);
    }

    private int getPlayerAreaCountFromDB(String uid) throws SQLException {
        ResultSet rs = this.database.getDb().executeQuery("SELECT COUNT(*) as count FROM `Areas` WHERE PlayerUID = '" + this.escapeSql(uid) + "'");
        return rs.next() ? rs.getInt("count") : 0;
    }

    private String escapeSql(String input) {
        return input == null ? "" : input.replace("'", "''");
    }

    private void addAreaInfoLabel(Player player) {
        UILabel areaInfoLabel = new UILabel();
        areaInfoLabel.setClickable(false);
        areaInfoLabel.setText("");
        areaInfoLabel.setFont(Font.Medieval);
        areaInfoLabel.style.textAlign.set((Enum)TextAnchor.MiddleCenter);
        areaInfoLabel.setFontColor(9.0f, 9.0f, 9.0f, 1.0f);
        areaInfoLabel.setFontSize(22.0f);
        areaInfoLabel.setSize(400.0f, 40.0f, false);
        areaInfoLabel.setBorder(2.0f);
        areaInfoLabel.setBorderColor(1.0f, 1.0f, 1.0f, 0.1f);
        areaInfoLabel.setBackgroundColor(1.0f, 1.0f, 1.0f, 0.05f);
        areaInfoLabel.setPosition(5.0f, 1.0f, true);
        player.addUIElement((UIElement)areaInfoLabel);
        player.setAttribute("areaInfoLabel", (Object)areaInfoLabel);
        UILabel messageLabel = new UILabel();
        messageLabel.setClickable(false);
        messageLabel.setText("");
        messageLabel.setFont(Font.Medieval);
        messageLabel.style.textAlign.set((Enum)TextAnchor.MiddleCenter);
        messageLabel.setFontColor(9.0f, 9.0f, 9.0f, 1.0f);
        messageLabel.setFontSize(22.0f);
        messageLabel.setSize(1000.0f, 40.0f, false);
        messageLabel.setBorder(2.0f);
        messageLabel.setBorderColor(1.0f, 1.0f, 1.0f, 0.1f);
        messageLabel.setBackgroundColor(1.0f, 1.0f, 1.0f, 0.05f);
        messageLabel.setPosition(30.0f, 1.0f, true);
        player.addUIElement((UIElement)messageLabel);
        player.setAttribute("messageLabel", (Object)messageLabel);
    }

    public void updateAreaInfoLabel(Player player, Vector3i chunk) {
        UILabel label = (UILabel)player.getAttribute("areaInfoLabel");
        if (label != null) {
            ClaimedArea area = this.claimedAreasByChunk.get(chunk);
            System.out.println("[LandClaim] Updating area info label for " + player.getName() + " at chunk " + String.valueOf(chunk) + ". Found area: " + (area != null ? area.areaName : "null") + ", Total areas loaded: " + this.claimedAreasByChunk.size());
            label.setText(area != null ? area.areaName : "Area Unclaimed");
        }
    }

    public void showMessage(Player player, String message, float duration) {
        UILabel messageLabel = (UILabel)player.getAttribute("messageLabel");
        if (messageLabel != null) {
            messageLabel.setText(message);
            new Timer(duration, 0.0f, 0, () -> {
                if (messageLabel.getText().equals(message)) {
                    messageLabel.setText("");
                }
            }).start();
        }
    }

    public String getAreaOwnerUIDFromPosition(Player player) throws SQLException {
        Vector3i chunk = player.getChunkPosition();
        ResultSet rs = this.database.getDb().executeQuery("SELECT PlayerUID FROM `Areas` WHERE AreaX = " + chunk.x + " AND AreaY = " + chunk.y + " AND AreaZ = " + chunk.z);
        return rs.next() ? rs.getString("PlayerUID") : null;
    }

    public ClaimedArea getClaimedAreaAt(Vector3i chunk) {
        return this.claimedAreasByChunk.get(chunk);
    }

    private Vector3f getGlobalPosition(Vector3i chunk, Vector3i block) {
        return new Vector3f((float)(chunk.x * 32 + block.x), (float)(chunk.y * 64 + block.y), (float)(chunk.z * 32 + block.z));
    }

    Vector3i getChunkPosition(Vector3f pos) {
        return new Vector3i((int)(pos.x / 32.0f), (int)(pos.y / 64.0f), (int)(pos.z / 32.0f));
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$unclaimArea$14(Vector3i chunk, Player player) {
        try {
            area = this.claimedAreasByChunk.get(chunk);
            if (area == null) {
                player.setAttribute("unclaimResult", (Object)"Area not claimed!");
                return;
            }
            if (!area.playerUID.equals(player.getUID()) && !player.isAdmin()) {
                player.setAttribute("unclaimResult", (Object)"You can only unclaim your own areas!");
                return;
            }
            if (player.isAdmin()) {
                rs = this.db.executeQuery("SELECT * FROM `Areas` WHERE AreaX = '" + chunk.x + "' AND AreaY = '" + chunk.y + "' AND AreaZ = '" + chunk.z + "'");
                try {
                    if (!rs.next()) ** GOTO lbl21
                    Owner = rs.getString("PlayerUID");
                    this.database.AdminRemoveClaimedArea(chunk.x, chunk.y, chunk.z, Owner);
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            } else {
                this.database.removeClaimedArea(chunk.x, chunk.y, chunk.z, player.getUID());
            }
lbl21:
            // 3 sources

            player.setAttribute("unclaimResult", (Object)area);
        }
        catch (SQLException e) {
            player.setAttribute("unclaimResult", (Object)("Error: " + e.getMessage()));
        }
    }

    class DatabaseTaskQueue {
        private final ExecutorService executor = Executors.newFixedThreadPool(2);

        DatabaseTaskQueue(LandClaim this$0) {
        }

        public void queueTask(Runnable task, Runnable callback) {
            this.executor.submit(() -> {
                task.run();
                new Timer(0.0f, 0.0f, 0, callback).start();
            });
        }

        public void shutdown() {
            this.executor.shutdown();
        }
    }

    class ClaimedArea {
        String playerUID;
        String areaOwnerName;
        String areaName;
        int areaX;
        int areaY;
        int areaZ;

        ClaimedArea(LandClaim this$0, String uid, String owner, String name, int x, int y, int z) {
            this.playerUID = uid;
            this.areaOwnerName = owner;
            this.areaName = name;
            this.areaX = x;
            this.areaY = y;
            this.areaZ = z;
        }
    }

    class TempClaim {
        Area3D visual;
        long creationTime;

        TempClaim(LandClaim this$0, Area3D visual, long creationTime) {
            this.visual = visual;
            this.creationTime = creationTime;
        }
    }
}

