/*
 * Decompiled with CFR 0.152.
 */
package landclaim;

import landclaim.AdminTools;
import landclaim.LandClaim;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.ui.UILabel;
import net.risingworld.api.ui.UITarget;
import net.risingworld.api.ui.style.Font;
import net.risingworld.api.ui.style.TextAnchor;

public class AdminUIMenu {
    private final LandClaim plugin;
    private final AdminTools adminTools;

    public AdminUIMenu(LandClaim plugin, AdminTools adminTools) {
        this.plugin = plugin;
        this.adminTools = adminTools;
    }

    public void showAdminMenu(Player player) {
        if (!this.adminTools.isAdmin(player)) {
            player.sendTextMessage("[#FF0000]No admin permission!");
            return;
        }
        UIElement menu = new UIElement();
        player.addUIElement(menu, UITarget.IngameMenu);
        menu.setSize(206.0f, 66.0f, false);
        menu.setClickable(false);
        menu.setPosition(44.0f, 70.0f, true);
        menu.setBorderEdgeRadius(5.0f, false);
        menu.setBorder(3.0f);
        menu.setBorderColor(888);
        menu.setBackgroundColor(0.1f, 0.1f, 0.1f, 0.95f);
        menu.setVisible(true);
        menu.style.borderBottomWidth.set(5.0f);
        UILabel button = this.createButton(menu, 10, 10, "<b>Admin Tools</b>", 180, 45);
        player.setAttribute("adminToolsButton", (Object)button);
    }

    public void showAdminToolsPopup(Player player) {
        UIElement popup = new UIElement();
        player.addUIElement(popup, UITarget.IngameMenu);
        popup.setSize(800.0f, 600.0f, false);
        popup.setClickable(false);
        popup.setPosition(30.0f, 20.0f, true);
        popup.setBorderEdgeRadius(5.0f, false);
        popup.setBorder(3.0f);
        popup.setBorderColor(888);
        popup.setBackgroundColor(0.9f, 0.9f, 0.9f, 0.9f);
        popup.setVisible(true);
        UILabel feedback = this.createLabel(popup, 10, 5, "Info", 730, 45, false);
        player.setAttribute("FeedBackinfoPanel", (Object)feedback);
        player.setAttribute("migrateButton", (Object)this.createButton(popup, 10, 60, "<b>Migrate old WP Database</b>", 250, 45));
        player.setAttribute("maxPlusButton", (Object)this.createButton(popup, 270, 60, "<b>+ MaxAreaAllocation</b>", 250, 45));
        player.setAttribute("maxMinusButton", (Object)this.createButton(popup, 530, 60, "<b>- MaxAreaAllocation</b>", 250, 45));
        player.setAttribute("pointsPlusButton", (Object)this.createButton(popup, 10, 115, "<b>+ Points/Hour</b>", 250, 45));
        player.setAttribute("pointsMinusButton", (Object)this.createButton(popup, 270, 115, "<b>- Points/Hour</b>", 250, 45));
        player.setAttribute("costPlusButton", (Object)this.createButton(popup, 10, 170, "<b>+ Area Cost</b>", 250, 45));
        player.setAttribute("costMinusButton", (Object)this.createButton(popup, 270, 170, "<b>- Area Cost</b>", 250, 45));
        player.setAttribute("adminPopupExitButton", (Object)this.createButton(popup, 745, 5, "<color=red><b>X</b></color>", 45, 45));
    }

    private UILabel createButton(UIElement parent, int x, int y, String text, int width, int height) {
        UILabel button = new UILabel();
        button.setClickable(true);
        button.setText(text);
        button.setFont(Font.Medieval);
        button.style.textAlign.set((Enum)TextAnchor.MiddleCenter);
        button.setFontColor(9.0f, 9.0f, 9.0f, 1.0f);
        button.setFontSize(16.0f);
        button.setSize((float)width, (float)height, false);
        button.setBorder(2.0f);
        button.setBorderColor(999);
        button.setBackgroundColor(500);
        button.setPosition((float)x, (float)y, false);
        button.style.borderBottomWidth.set(5.0f);
        button.hoverStyle.backgroundColor.set(0.2f, 0.2f, 0.2f, 0.9f);
        button.hoverStyle.borderBottomWidth.set(5.0f);
        button.hoverStyle.borderBottomColor.set(0.1f, 0.1f, 0.9f, 0.9f);
        parent.addChild((UIElement)button);
        return button;
    }

    private UILabel createLabel(UIElement parent, int x, int y, String text, int width, int height, boolean clickable) {
        UILabel label = new UILabel();
        label.setClickable(clickable);
        label.setText(text);
        label.setFont(Font.Medieval);
        label.style.textAlign.set((Enum)TextAnchor.MiddleCenter);
        label.setFontColor(9.0f, 9.0f, 9.0f, 1.0f);
        label.setFontSize(16.0f);
        label.setSize((float)width, (float)height, false);
        label.setBorder(2.0f);
        label.setBorderColor(999);
        label.setBackgroundColor(500);
        label.setPosition((float)x, (float)y, false);
        parent.addChild((UIElement)label);
        return label;
    }
}

