/*
 * Decompiled with CFR 0.152.
 */
package landclaim;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import landclaim.LandClaim;
import net.risingworld.api.Server;
import net.risingworld.api.callbacks.Callback;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.ui.UILabel;
import net.risingworld.api.ui.UITextField;
import net.risingworld.api.ui.style.Font;
import net.risingworld.api.ui.style.TextAnchor;
import net.risingworld.api.utils.Vector3i;
import net.risingworld.api.worldelements.GameObject;

public class PlayerUIMenu {
    private final Player player;
    private final LandClaim plugin;
    private UIElement menuBase;
    private UIElement settingsMenu;
    private UIElement renameMenu;
    private UILabel claimButton;
    private UILabel removeButton;
    private UILabel exitButton;
    private UILabel settingsButton;
    private UILabel settingsExitButton;
    private UILabel showMyAreasLabel;
    private UILabel showAllAreasLabel;
    private UILabel infoLabel;
    private UILabel nextPlayerButton;
    private UILabel backPlayerButton;
    private UILabel addGuestButton;
    private UILabel removeGuestButton;
    private UILabel changeAreaNameButton;
    private UILabel buyAreaButton;
    private UILabel renameButton;
    private UILabel cancelRenameButton;
    private boolean isVisible;
    private boolean showingMyAreas = false;
    private boolean showingAllAreas = true;
    private List<Player> worldPlayers = new ArrayList<Player>();
    private int currentPlayerIndex = -1;
    private int currentAreaId = -1;
    final Map<String, UILabel> permissionButtons = new HashMap<String, UILabel>();
    private Map<Vector3i, LandClaim.ClaimedArea> visibleAreas = new HashMap<Vector3i, LandClaim.ClaimedArea>();
    private UITextField renameTextField;

    public PlayerUIMenu(Player player, LandClaim plugin) {
        this.player = player;
        this.plugin = plugin;
        this.setupBaseMenu();
        this.setupSettingsMenu();
        this.updateVisibleAreas(player.getChunkPosition());
        this.updateLabels();
    }

    private void setupBaseMenu() {
        this.menuBase = new UIElement();
        this.player.addUIElement(this.menuBase);
        this.menuBase.setSize(276.0f, 370.0f, false);
        this.menuBase.setClickable(false);
        this.menuBase.setPosition(45.0f, 45.0f, true);
        this.menuBase.setBorderEdgeRadius(5.0f, false);
        this.menuBase.setBorder(3.0f);
        this.menuBase.setBorderColor(888);
        this.menuBase.setBackgroundColor(0.1f, 0.1f, 0.1f, 0.9f);
        this.menuBase.setVisible(false);
        this.claimButton = this.createButton(this.menuBase, 10, 10, "Claim Area", 250, 45);
        this.removeButton = this.createButton(this.menuBase, 10, 60, "Remove Area", 250, 45);
        this.showMyAreasLabel = this.createButton(this.menuBase, 10, 110, "Show My Areas\nOff", 250, 45);
        this.showAllAreasLabel = this.createButton(this.menuBase, 10, 160, "Show All Areas\nOn", 250, 45);
        this.exitButton = this.createButton(this.menuBase, 10, 310, "Exit", 250, 45);
        this.settingsButton = this.createButton(this.menuBase, 10, 260, "Settings", 250, 45);
        this.updateBuyAreaButtonText();
        this.buyAreaButton = this.createButton(this.menuBase, 10, 210, this.getBuyAreaButtonText(), 250, 45);
    }

    private void setupSettingsMenu() {
        this.settingsMenu = new UIElement();
        this.player.addUIElement(this.settingsMenu);
        this.settingsMenu.setSize(1566.0f, 850.0f, false);
        this.settingsMenu.setClickable(false);
        this.settingsMenu.setPosition(5.0f, 10.0f, true);
        this.settingsMenu.setBorderEdgeRadius(5.0f, false);
        this.settingsMenu.setBorder(3.0f);
        this.settingsMenu.setBorderColor(888);
        this.settingsMenu.setBackgroundColor(0.8f, 0.8f, 0.8f, 0.95f);
        this.settingsMenu.setVisible(false);
        this.infoLabel = this.createLabel(this.settingsMenu, 10, 5, "No Player Selected", 1466, 45, false);
        this.player.setAttribute("infoLabel", (Object)this.infoLabel);
        this.nextPlayerButton = this.createButton(this.settingsMenu, 10, 60, "Next Player", 300, 45);
        this.backPlayerButton = this.createButton(this.settingsMenu, 320, 60, "Back Player", 300, 45);
        this.addGuestButton = this.createButton(this.settingsMenu, 630, 60, "Add Guest", 300, 45);
        this.removeGuestButton = this.createButton(this.settingsMenu, 940, 60, "Remove Guest", 300, 45);
        this.changeAreaNameButton = this.createButton(this.settingsMenu, 1250, 60, "Change Area Name", 300, 45);
        this.settingsExitButton = this.createButton(this.settingsMenu, 1511, 5, "<color=red><b>X</b></color>", 45, 45);
        this.player.setAttribute("settingsExitButton", (Object)this.settingsExitButton);
        this.player.setAttribute("nextPlayerButton", (Object)this.nextPlayerButton);
        this.player.setAttribute("backPlayerButton", (Object)this.backPlayerButton);
        this.player.setAttribute("addGuestButton", (Object)this.addGuestButton);
        this.player.setAttribute("removeGuestButton", (Object)this.removeGuestButton);
        this.player.setAttribute("changeAreaNameButton", (Object)this.changeAreaNameButton);
        this.initPermissionButtons();
    }

    private void initPermissionButtons() {
        String[] permissions = new String[]{"PlayerShootingTargetUseObject", "PlayerSignUseObject", "PlayerSpinningWheelUseObject", "PlayerStorageUseObject", "PlayerTanningRackUseObject", "PlayerTechnicalUseObject", "PlayerTorchUseObject", "PlayerTrashcanUseObject", "PlayerWorkbenchUseObject", "PlayerHitAnimalNPC", "PlayerHitHumanNPC", "PlayerHitMountNPC", "PlayerRideMountNPC", "PlayerPlaceBluePrints", "PlayerNpcAddSaddle", "PlayerNpcRemoveSaddle", "PlayerNpcAddSaddleBag", "PlayerNpcRemoveSaddleBag", "PlayerNpcAddClothes", "PlayerNpcRemoveClothes", "PlayerChangeConstructionColor", "PlayerChangeObjectColor", "PlayerChangeObjectInfo", "PlayerCreativePlaceVegetation", "PlayerCreativeRemoveConstruction", "PlayerCreativeRemoveObject", "PlayerCreativeRemoveVegetation", "PlayerCreativeTerrainEdit", "PlayerDestroyConstruction", "PlayerDestroyObject", "PlayerDestroyTerrain", "PlayerEditConstruction", "PlayerHitConstruction", "PlayerHitObject", "PlayerHitVegetation", "PlayerHitWater", "PlayerPlaceConstruction", "PlayerPlaceGrass", "PlayerPlaceObject", "PlayerPlaceTerrain", "PlayerPlaceVegetation", "PlayerRemoveConstruction", "PlayerRemoveGrass", "PlayerRemoveObject", "PlayerRemoveVegetation", "PlayerRemoveWater", "PlayerWorldEdit", "PlayerClockUseObject", "PlayerDoorUseObject", "PlayerDryingRackUseObject", "PlayerFireUseObject", "PlayerFurnaceUseObject", "PlayerGrillUseObject", "PlayerGrinderUseObject", "PlayerGrindstoneUseObject", "PlayerLadderUseObject", "PlayerLampUseObject", "PlayerMusicPlayerUseObject", "PlayerOvenUseObject", "PlayerPaperPressUseObject", "PlayerPianoUseObject", "PlayerPosterUseObject", "PlayerScaffoldingUseObject", "PlayerSeatingUseObject"};
        int x = 10;
        int y = 115;
        int perRow = 5;
        int rowHeight = 55;
        for (int i = 0; i < permissions.length; ++i) {
            String perm = permissions[i];
            String name = perm.replace("Player", "").replace("UseObject", "").replace("NPC", "");
            UILabel button = this.createButton(this.settingsMenu, x + i % perRow * 310, y + i / perRow * rowHeight, name + ": Off", 300, 45);
            this.permissionButtons.put(perm, button);
        }
    }

    private UILabel createButton(UIElement parent, int x, int y, String text, int width, int height) {
        UILabel button = new UILabel();
        button.setClickable(true);
        button.setText("<b>" + text + "</b>");
        button.setFont(Font.Medieval);
        button.style.textAlign.set((Enum)TextAnchor.MiddleCenter);
        button.setFontColor(9.0f, 9.0f, 9.0f, 1.0f);
        button.setFontSize(16.0f);
        button.setSize((float)width, (float)height, false);
        button.setBorder(2.0f);
        button.setBorderColor(999);
        button.setBackgroundColor(500);
        button.setPosition((float)x, (float)y, false);
        button.style.borderBottomWidth.set(5.0f);
        button.hoverStyle.backgroundColor.set(0.2f, 0.2f, 0.2f, 0.9f);
        button.hoverStyle.borderBottomWidth.set(5.0f);
        button.hoverStyle.borderBottomColor.set(0.1f, 0.1f, 0.9f, 0.9f);
        parent.addChild((UIElement)button);
        return button;
    }

    private UILabel createLabel(UIElement parent, int x, int y, String text, int width, int height, boolean clickable) {
        UILabel label = new UILabel();
        label.setClickable(clickable);
        label.setText(text);
        label.setFont(Font.Medieval);
        label.style.textAlign.set((Enum)TextAnchor.MiddleCenter);
        label.setFontColor(9.0f, 9.0f, 9.0f, 1.0f);
        label.setFontSize(16.0f);
        label.setSize((float)width, (float)height, false);
        label.setBorder(2.0f);
        label.setBorderColor(999);
        label.setBackgroundColor(500);
        label.setPosition((float)x, (float)y, false);
        parent.addChild((UIElement)label);
        return label;
    }

    private UITextField createTextField(UIElement parent, int x, int y, String text, int width, int height) {
        UITextField textField = new UITextField(text);
        textField.style.textAlign.set((Enum)TextAnchor.MiddleCenter);
        textField.setFontColor(9.0f, 9.0f, 9.0f, 1.0f);
        textField.setFontSize(16.0f);
        textField.setSize((float)width, (float)height, false);
        textField.setBorder(2.0f);
        textField.setBorderColor(999);
        textField.setBackgroundColor(500);
        textField.setPosition((float)x, (float)y, false);
        textField.setMaxCharacters(50);
        parent.addChild((UIElement)textField);
        return textField;
    }

    private String getBuyAreaButtonText() {
        int areaCost = 1;
        int playerPoints = 0;
        try {
            areaCost = this.plugin.getDatabase().getAreaCostAdjust();
            playerPoints = this.plugin.getDatabase().getPoints(this.player.getUID());
        }
        catch (SQLException e) {
            System.out.println("[PlayerUIMenu] Error fetching area cost or points: " + e.getMessage());
        }
        return "<b>Buy 1 Area (" + areaCost + " Cost, You: " + playerPoints + ")</b>";
    }

    public void updateBuyAreaButtonText() {
        if (this.buyAreaButton != null) {
            String newText = this.getBuyAreaButtonText();
            this.buyAreaButton.setText(newText);
            System.out.println("[PlayerUIMenu] Updated buyAreaButton text for " + this.player.getName() + ": " + newText);
        }
    }

    public void showSettingsMenu() throws SQLException {
        Vector3i chunk = this.player.getChunkPosition();
        LandClaim.ClaimedArea area = this.plugin.getClaimedAreaAt(chunk);
        if (area == null) {
            this.plugin.showMessage(this.player, "Area not claimed!", 5.0f);
            return;
        }
        if (!area.playerUID.equals(this.player.getUID())) {
            this.plugin.showMessage(this.player, "Only edit your own areas!", 5.0f);
            return;
        }
        this.currentAreaId = this.plugin.getDatabase().getAreaIdFromCoords(chunk.x, chunk.y, chunk.z);
        if (this.currentAreaId == -1) {
            this.plugin.showMessage(this.player, "Error: Area ID not found!", 5.0f);
            return;
        }
        this.updatePermissionButtons();
        this.worldPlayers.clear();
        this.worldPlayers.addAll(Arrays.asList(Server.getAllPlayers()));
        this.currentPlayerIndex = -1;
        this.updateInfoLabel();
        this.menuBase.setVisible(false);
        this.settingsMenu.setVisible(true);
        this.player.setMouseCursorVisible(true);
    }

    private void updatePermissionButtons() throws SQLException {
        if (this.currentAreaId == -1) {
            return;
        }
        ResultSet rs = this.plugin.getDatabase().getDb().executeQuery("SELECT * FROM `GuestEventActions` WHERE AreaID = " + this.currentAreaId);
        if (rs.next()) {
            for (Map.Entry<String, UILabel> entry : this.permissionButtons.entrySet()) {
                String perm = entry.getKey();
                boolean state = rs.getBoolean(perm);
                String name = entry.getValue().getText().replace("<b>", "").replace(": Off", "").replace(": On", "").trim();
                entry.getValue().setText("<b>" + name + ": " + (state ? "On" : "Off") + "</b>");
            }
        }
    }

    public void togglePermission(String permission) {
        if (this.currentAreaId == -1 || !this.plugin.getClaimedAreaAt((Vector3i)this.player.getChunkPosition()).playerUID.equals(this.player.getUID())) {
            this.plugin.showMessage(this.player, "Invalid area or permissions!", 5.0f);
            return;
        }
        this.plugin.getTaskQueue().queueTask(() -> {
            try {
                boolean state = this.plugin.getDatabase().getGuestPermission(this.currentAreaId, permission);
                this.plugin.getDatabase().setGuestPermission(this.currentAreaId, permission, !state);
                this.player.setAttribute("permResult", (Object)(!state ? 1 : 0));
            }
            catch (SQLException e) {
                this.player.setAttribute("permResult", (Object)("Error: " + e.getMessage()));
            }
        }, () -> {
            Object result = this.player.getAttribute("permResult");
            if (result instanceof Boolean) {
                boolean newState = (Boolean)result;
                UILabel button = this.permissionButtons.get(permission);
                String name = button.getText().replace("<b>", "").replace(": Off", "").replace(": On", "").trim();
                button.setText("<b>" + name + ": " + (newState ? "On" : "Off") + "</b>");
                this.plugin.showMessage(this.player, name + " set to: " + (newState ? "On" : "Off"), 5.0f);
            } else {
                this.plugin.showMessage(this.player, (String)result, 5.0f);
            }
        });
    }

    public void closeSettingsMenu() {
        this.settingsMenu.setVisible(false);
        this.menuBase.setVisible(true);
        this.player.setMouseCursorVisible(true);
        System.out.println("[PlayerUIMenu] Closing settings menu for " + this.player.getName());
    }

    public void toggleMenu() {
        this.isVisible = !this.isVisible;
        this.menuBase.setVisible(this.isVisible);
        this.player.setMouseCursorVisible(this.isVisible);
        if (this.isVisible) {
            this.plugin.getTaskQueue().queueTask(() -> {
                try {
                    Long loginTime = this.plugin.playerLoginTimes.get(this.player);
                    if (loginTime != null) {
                        long sessionMs = System.currentTimeMillis() - loginTime;
                        double sessionHours = (double)sessionMs / 3600000.0;
                        this.plugin.getDatabase().updatePlaytimeAndPoints(this.player.getUID(), sessionHours);
                        this.plugin.playerLoginTimes.put(this.player, System.currentTimeMillis());
                        System.out.println("[PlayerUIMenu] Updated playtime on menu open for " + this.player.getName() + ": " + sessionHours + " hours");
                    }
                }
                catch (SQLException e) {
                    System.out.println("[PlayerUIMenu] Error updating playtime on menu open: " + e.getMessage());
                    e.printStackTrace();
                }
            }, () -> {
                this.updateBuyAreaButtonText();
                this.updateAreaVisibility();
            });
        }
    }

    public void closeMenu() {
        this.isVisible = false;
        this.menuBase.setVisible(false);
        this.player.setMouseCursorVisible(false);
    }

    public void toggleMyAreas() {
        boolean bl = this.showingMyAreas = !this.showingMyAreas;
        if (this.showingMyAreas) {
            this.showingAllAreas = false;
        }
        this.updateAreaVisibility();
        this.updateLabels();
        this.plugin.showMessage(this.player, "My Areas: " + (this.showingMyAreas ? "On" : "Off"), 5.0f);
        System.out.println("[PlayerUIMenu] Toggle My Areas: " + this.showingMyAreas + " for " + this.player.getName());
    }

    public void toggleAllAreas() {
        boolean bl = this.showingAllAreas = !this.showingAllAreas;
        if (this.showingAllAreas) {
            this.showingMyAreas = false;
        }
        this.updateAreaVisibility();
        this.updateLabels();
        this.plugin.showMessage(this.player, "All Areas: " + (this.showingAllAreas ? "On" : "Off"), 5.0f);
        System.out.println("[PlayerUIMenu] Toggle All Areas: " + this.showingAllAreas + " for " + this.player.getName());
    }

    public void disableAllAreas() {
        this.showingAllAreas = false;
        this.updateAreaVisibility();
        this.updateLabels();
        this.plugin.showMessage(this.player, "All Areas: Off (auto-disabled after 60s)", 5.0f);
        System.out.println("[PlayerUIMenu] Auto-disabled All Areas for " + this.player.getName());
    }

    private void updateLabels() {
        this.showMyAreasLabel.setText("<b>Show My Areas\n" + (this.showingMyAreas ? "On" : "Off") + "</b>");
        this.showAllAreasLabel.setText("<b>Show All Areas\n" + (this.showingAllAreas ? "On" : "Off") + "</b>");
    }

    private void updateInfoLabel() {
        if (this.worldPlayers.isEmpty()) {
            this.infoLabel.setText("No Players in World");
        } else if (this.currentPlayerIndex == -1) {
            this.infoLabel.setText("Select a Player");
        } else {
            Player p = this.worldPlayers.get(this.currentPlayerIndex);
            String status = this.currentAreaId != -1 && this.isGuest(p) ? " (Guest)" : " (Not Guest)";
            this.infoLabel.setText("Player: " + p.getName() + " (UID: " + p.getUID() + ")" + status);
        }
    }

    private boolean isGuest(Player p) {
        try {
            ResultSet rs = this.plugin.getDatabase().getDb().executeQuery("SELECT ID FROM `Guests` WHERE AreaID = " + this.currentAreaId + " AND PlayerUID = '" + p.getUID() + "'");
            return rs.next();
        }
        catch (SQLException e) {
            return false;
        }
    }

    public void updateVisibleAreas(Vector3i currentChunk) {
        this.visibleAreas.clear();
        int radius = 5;
        String uid = this.player.getUID();
        for (Map.Entry<Vector3i, LandClaim.ClaimedArea> entry : this.plugin.claimedAreasByChunk.entrySet()) {
            Vector3i areaChunk = entry.getKey();
            if (Math.abs(areaChunk.x - currentChunk.x) > radius || Math.abs(areaChunk.y - currentChunk.y) > radius || Math.abs(areaChunk.z - currentChunk.z) > radius) continue;
            this.visibleAreas.put(areaChunk, entry.getValue());
        }
        System.out.println("[PlayerUIMenu] Updated visible areas for " + this.player.getName() + " at chunk " + String.valueOf(currentChunk) + ": " + this.visibleAreas.size() + " areas found.");
    }

    public void updateAreaVisibility() {
        this.plugin.hideAreas(this.player);
        String uid = this.player.getUID();
        if (this.showingMyAreas) {
            this.visibleAreas.entrySet().stream().filter(e -> ((LandClaim.ClaimedArea)e.getValue()).playerUID.equals(uid)).forEach(e -> this.plugin.addAreaVisual(((LandClaim.ClaimedArea)e.getValue()).areaX, ((LandClaim.ClaimedArea)e.getValue()).areaY, ((LandClaim.ClaimedArea)e.getValue()).areaZ, ((LandClaim.ClaimedArea)e.getValue()).areaName, uid, true, this.player));
        } else if (this.showingAllAreas) {
            this.visibleAreas.forEach((chunk, area) -> this.plugin.addAreaVisual(area.areaX, area.areaY, area.areaZ, area.areaName, area.playerUID, area.playerUID.equals(uid), this.player));
        }
        List<LandClaim.TempClaim> tempClaims = this.plugin.getTempClaims(this.player);
        if (tempClaims != null) {
            long now = System.currentTimeMillis();
            for (LandClaim.TempClaim tempClaim : tempClaims) {
                if (now - tempClaim.creationTime >= 60000L) continue;
                this.player.addGameObject((GameObject)tempClaim.visual);
            }
        }
        System.out.println("[PlayerUIMenu] Updated visibility for " + this.player.getName() + ": My Areas=" + this.showingMyAreas + ", All Areas=" + this.showingAllAreas);
    }

    public void nextPlayer() {
        if (this.worldPlayers.isEmpty()) {
            return;
        }
        this.currentPlayerIndex = (this.currentPlayerIndex + 1) % this.worldPlayers.size();
        this.updateInfoLabel();
    }

    public void backPlayer() {
        if (this.worldPlayers.isEmpty()) {
            return;
        }
        this.currentPlayerIndex = (this.currentPlayerIndex - 1 + this.worldPlayers.size()) % this.worldPlayers.size();
        this.updateInfoLabel();
    }

    public void addGuest() {
        Vector3i chunk = this.player.getChunkPosition();
        LandClaim.ClaimedArea area = this.plugin.getClaimedAreaAt(chunk);
        if (!this.validateGuestAction(area)) {
            return;
        }
        Player guest = this.worldPlayers.get(this.currentPlayerIndex);
        this.plugin.getTaskQueue().queueTask(() -> {
            try {
                ResultSet rs = this.plugin.getDatabase().getDb().executeQuery("SELECT ID FROM `Guests` WHERE AreaID = " + this.currentAreaId + " AND PlayerUID = '" + guest.getUID() + "'");
                if (rs.next()) {
                    this.player.setAttribute("guestResult", (Object)(guest.getName() + " already a guest!"));
                } else {
                    this.plugin.getDatabase().getDb().executeUpdate("INSERT INTO `Guests` (AreaID, GuestName, PlayerUID) VALUES (" + this.currentAreaId + ", '" + guest.getName() + "', '" + guest.getUID() + "')");
                    this.player.setAttribute("guestResult", (Object)(guest.getName() + " added as guest!"));
                }
            }
            catch (SQLException e) {
                this.player.setAttribute("guestResult", (Object)("Error: " + e.getMessage()));
            }
        }, () -> {
            this.plugin.showMessage(this.player, (String)this.player.getAttribute("guestResult"), 5.0f);
            this.updateInfoLabel();
        });
    }

    public void removeGuest() {
        Vector3i chunk = this.player.getChunkPosition();
        LandClaim.ClaimedArea area = this.plugin.getClaimedAreaAt(chunk);
        if (!this.validateGuestAction(area)) {
            return;
        }
        Player guest = this.worldPlayers.get(this.currentPlayerIndex);
        this.plugin.getTaskQueue().queueTask(() -> {
            try {
                ResultSet rs = this.plugin.getDatabase().getDb().executeQuery("SELECT ID FROM `Guests` WHERE AreaID = " + this.currentAreaId + " AND PlayerUID = '" + guest.getUID() + "'");
                if (!rs.next()) {
                    this.player.setAttribute("guestResult", (Object)(guest.getName() + " not a guest!"));
                } else {
                    this.plugin.getDatabase().getDb().executeUpdate("DELETE FROM `Guests` WHERE AreaID = " + this.currentAreaId + " AND PlayerUID = '" + guest.getUID() + "'");
                    this.player.setAttribute("guestResult", (Object)("Removed " + guest.getName() + " as guest!"));
                }
            }
            catch (SQLException e) {
                this.player.setAttribute("guestResult", (Object)("Error: " + e.getMessage()));
            }
        }, () -> {
            this.plugin.showMessage(this.player, (String)this.player.getAttribute("guestResult"), 5.0f);
            this.updateInfoLabel();
        });
    }

    private boolean validateGuestAction(LandClaim.ClaimedArea area) {
        if (area == null || !area.playerUID.equals(this.player.getUID()) || this.currentPlayerIndex == -1 || this.worldPlayers.isEmpty()) {
            this.plugin.showMessage(this.player, "Invalid area or no player selected!", 5.0f);
            return false;
        }
        return true;
    }

    public void changeAreaName() {
        Vector3i chunk = this.player.getChunkPosition();
        LandClaim.ClaimedArea area = this.plugin.getClaimedAreaAt(chunk);
        if (area == null) {
            this.plugin.showMessage(this.player, "Area not claimed!", 5.0f);
            return;
        }
        if (!area.playerUID.equals(this.player.getUID())) {
            this.plugin.showMessage(this.player, "Only edit your own areas!", 5.0f);
            return;
        }
        if (this.renameMenu == null) {
            this.renameMenu = new UIElement();
            this.player.addUIElement(this.renameMenu);
            this.renameMenu.setSize(400.0f, 150.0f, false);
            this.renameMenu.setClickable(false);
            this.renameMenu.setPosition(36.0f, 40.0f, true);
            this.renameMenu.setBorderEdgeRadius(5.0f, false);
            this.renameMenu.setBorder(3.0f);
            this.renameMenu.setBorderColor(888);
            this.renameMenu.setBackgroundColor(0.9f, 0.9f, 0.9f, 0.9f);
            this.renameMenu.setVisible(false);
            this.renameTextField = this.createTextField(this.renameMenu, 50, 30, area.areaName, 300, 40);
            this.renameButton = this.createButton(this.renameMenu, 90, 90, "Rename", 100, 45);
            this.player.setAttribute("renameButton", (Object)this.renameButton);
            this.cancelRenameButton = this.createButton(this.renameMenu, 210, 90, "Cancel", 100, 45);
            this.player.setAttribute("cancelRenameButton", (Object)this.cancelRenameButton);
        } else {
            this.renameTextField.setText(area.areaName);
        }
        System.out.println("[PlayerUIMenu] Opening rename menu for " + this.player.getName());
        this.renameMenu.setVisible(true);
        this.player.setMouseCursorVisible(true);
    }

    public void cancelRename() {
        System.out.println("[PlayerUIMenu] Canceling rename for " + this.player.getName());
        this.renameMenu.setVisible(false);
        this.player.setMouseCursorVisible(true);
    }

    public void performRename() {
        this.plugin.getCurrentText(this.player, this.renameTextField, (Callback<String>)((Callback)newName -> {
            String trimmedName = newName.trim();
            if (trimmedName.isEmpty()) {
                this.plugin.showMessage(this.player, "Name cannot be empty!", 5.0f);
                return;
            }
            Vector3i chunk = this.player.getChunkPosition();
            this.plugin.getTaskQueue().queueTask(() -> {
                try {
                    LandClaim.ClaimedArea area = this.plugin.getClaimedAreaAt(chunk);
                    if (area != null && area.playerUID.equals(this.player.getUID())) {
                        this.plugin.renameArea(chunk, trimmedName);
                        this.player.setAttribute("renameResult", (Object)("Area renamed to " + trimmedName + "!"));
                    } else {
                        this.player.setAttribute("renameResult", (Object)"Error: Cannot rename this area!");
                    }
                }
                catch (SQLException e) {
                    this.player.setAttribute("renameResult", (Object)("Error: " + e.getMessage()));
                }
            }, () -> {
                this.plugin.showMessage(this.player, (String)this.player.getAttribute("renameResult"), 5.0f);
                this.renameMenu.setVisible(false);
                this.updateInfoLabel();
                this.updateAreaVisibility();
                this.plugin.updateAreaInfoLabel(this.player, chunk);
                System.out.println("[PlayerUIMenu] Updated area info label after renaming for " + this.player.getName() + " at chunk " + String.valueOf(chunk));
            });
        }));
    }

    public UILabel getClaimButton() {
        return this.claimButton;
    }

    public UILabel getUnclaimButton() {
        return this.removeButton;
    }

    public UILabel getExitButton() {
        return this.exitButton;
    }

    public UILabel getSettingsButton() {
        return this.settingsButton;
    }

    public UILabel getShowMyAreasLabel() {
        return this.showMyAreasLabel;
    }

    public UILabel getShowAllAreasLabel() {
        return this.showAllAreasLabel;
    }

    public UILabel getSettingsExitButton() {
        return this.settingsExitButton;
    }

    public UILabel getBuyAreaButton() {
        return this.buyAreaButton;
    }

    public UILabel getChangeAreaNameButton() {
        return this.changeAreaNameButton;
    }

    public UILabel getRenameButton() {
        return this.renameButton;
    }

    public UILabel getCancelRenameButton() {
        return this.cancelRenameButton;
    }
}

