/*
 * Decompiled with CFR 0.152.
 */
package landclaim;

import java.sql.SQLException;
import landclaim.AdminTools;
import landclaim.AdminUIMenu;
import landclaim.LandClaim;
import net.risingworld.api.Server;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.ui.PlayerUIElementClickEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UILabel;

public class AdminOnClickButtons
implements Listener {
    private final LandClaim plugin;
    private final AdminTools adminTools;
    private long lastClickTime = 0L;

    public AdminOnClickButtons(LandClaim plugin, AdminTools adminTools) {
        this.plugin = plugin;
        this.adminTools = adminTools;
    }

    @EventMethod
    public void onPlayerUIElementClick(PlayerUIElementClickEvent event) {
        if (event != null) {
            Player player = event.getPlayer();
            UILabel element = (UILabel)event.getUIElement();
            if (element == null || !this.adminTools.isAdmin(player)) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now - this.lastClickTime < 500L) {
                return;
            }
            this.lastClickTime = now;
            UILabel feedback = (UILabel)player.getAttribute("FeedBackinfoPanel");
            if (element.equals(player.getAttribute("adminToolsButton"))) {
                new AdminUIMenu(this.plugin, this.adminTools).showAdminToolsPopup(player);
                player.setMouseCursorVisible(true);
            } else if (element.equals(player.getAttribute("adminPopupExitButton"))) {
                element.getParent().setVisible(false);
                player.setMouseCursorVisible(false);
            } else if (element.equals(player.getAttribute("migrateButton"))) {
                if (feedback != null) {
                    feedback.setText("Migration started...");
                }
                this.plugin.getTaskQueue().queueTask(() -> this.adminTools.migrateDatabase(player), () -> {
                    if (feedback != null) {
                        feedback.setText(this.adminTools.getLastMigrationResult());
                    }
                });
            } else if (element.equals(player.getAttribute("maxPlusButton"))) {
                this.handleMaxAreaAdjustment(player, 1, feedback);
            } else if (element.equals(player.getAttribute("maxMinusButton"))) {
                this.handleMaxAreaAdjustment(player, -1, feedback);
            } else if (element.equals(player.getAttribute("pointsPlusButton"))) {
                this.handlePointsAdjustment(player, 1, feedback);
            } else if (element.equals(player.getAttribute("pointsMinusButton"))) {
                this.handlePointsAdjustment(player, -1, feedback);
            } else if (element.equals(player.getAttribute("costPlusButton"))) {
                this.handleCostAdjustment(player, 1, feedback);
            } else if (element.equals(player.getAttribute("costMinusButton"))) {
                this.handleCostAdjustment(player, -1, feedback);
            }
        }
    }

    private void handleMaxAreaAdjustment(Player player, int adjustment, UILabel feedback) {
        this.plugin.getTaskQueue().queueTask(() -> {
            try {
                Player[] allPlayers;
                String uid = this.plugin.getAreaOwnerUIDFromPosition(player);
                if (uid == null) {
                    player.setAttribute("adjustResult", (Object)"Stand in a claimed area!");
                    return;
                }
                int current = this.plugin.getDatabase().getMaxAreaAllocation(uid);
                int newMax = current + adjustment;
                if (newMax < 0) {
                    player.setAttribute("adjustResult", (Object)"Cannot go below 0!");
                    return;
                }
                this.plugin.getDatabase().setMaxAreaAllocation(uid, newMax);
                for (Player owner : allPlayers = Server.getAllPlayers()) {
                    if (!owner.getUID().equals(uid)) continue;
                    owner.sendTextMessage("Max areas updated to " + newMax + " by admin.");
                    break;
                }
                player.setAttribute("adjustResult", (Object)("Max areas for UID " + uid + " set to " + newMax));
            }
            catch (SQLException e) {
                player.setAttribute("adjustResult", (Object)("Error: " + e.getMessage()));
            }
        }, () -> {
            if (feedback != null) {
                String result = (String)player.getAttribute("adjustResult");
                feedback.setText(result != null ? result : "Adjustment failed!");
            }
        });
    }

    private void handlePointsAdjustment(Player player, int adjustment, UILabel feedback) {
        this.plugin.getTaskQueue().queueTask(() -> {
            try {
                int current = this.plugin.getDatabase().getPointsEarnedAdjust();
                int newValue = current + adjustment;
                if (newValue < 0) {
                    player.setAttribute("pointsResult", (Object)"Points per hour cannot go below 0!");
                    return;
                }
                this.plugin.getDatabase().setPointsEarnedAdjust(newValue);
                player.setAttribute("pointsResult", (Object)("Points per hour set to " + newValue));
            }
            catch (SQLException e) {
                player.setAttribute("pointsResult", (Object)("Error: " + e.getMessage()));
            }
        }, () -> {
            if (feedback != null) {
                String result = (String)player.getAttribute("pointsResult");
                feedback.setText(result != null ? result : "Points adjustment failed!");
            }
        });
    }

    private void handleCostAdjustment(Player player, int adjustment, UILabel feedback) {
        this.plugin.getTaskQueue().queueTask(() -> {
            try {
                int current = this.plugin.getDatabase().getAreaCostAdjust();
                int newValue = current + adjustment;
                if (newValue < 1) {
                    player.setAttribute("costResult", (Object)"Area cost cannot go below 1!");
                    return;
                }
                this.plugin.getDatabase().setAreaCostAdjust(newValue);
                player.setAttribute("costResult", (Object)("Area cost set to " + newValue));
            }
            catch (SQLException e) {
                player.setAttribute("costResult", (Object)("Error: " + e.getMessage()));
            }
        }, () -> {
            if (feedback != null) {
                String result = (String)player.getAttribute("costResult");
                feedback.setText(result != null ? result : "Cost adjustment failed!");
            }
        });
    }

    public void register() {
        this.plugin.registerEventListener(this);
    }
}

