/*
 * Decompiled with CFR 0.152.
 */
package landclaim;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import landclaim.LandClaim;
import landclaim.LandClaimDatabase;
import net.risingworld.api.Server;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UILabel;

public class AdminTools {
    private final LandClaim plugin;
    private volatile boolean isMigrating = false;
    private volatile String lastMigrationResult = "Migration queued...";

    public AdminTools(LandClaim plugin) {
        this.plugin = plugin;
    }

    public boolean isAdmin(Player player) {
        return player.isAdmin();
    }

    public String migrateDatabase(Player player) {
        if (!this.isAdmin(player)) {
            return "Only admins can migrate!";
        }
        if (this.isMigrating) {
            return "Migration in progress...";
        }
        UILabel feedback = (UILabel)player.getAttribute("FeedBackinfoPanel");
        if (feedback != null) {
            feedback.setText("Migration started...");
        }
        this.plugin.getTaskQueue().queueTask(() -> {
            this.isMigrating = true;
            try {
                LandClaimDatabase db = this.plugin.getDatabase();
                if (db == null) {
                    this.lastMigrationResult = "Database not initialized!";
                    return;
                }
                db.migrateAreasFromWorldProtection(player);
                HashMap<String, Integer> counts = new HashMap<String, Integer>();
                ResultSet rs = db.getDb().executeQuery("SELECT PlayerUID, COUNT(*) as count FROM `Areas` GROUP BY PlayerUID");
                while (rs.next()) {
                    counts.put(rs.getString("PlayerUID"), rs.getInt("count"));
                }
                block7: for (Map.Entry entry : counts.entrySet()) {
                    Player[] allPlayers;
                    String uid = (String)entry.getKey();
                    int count = (Integer)entry.getValue();
                    int max = count + 2;
                    ResultSet existingStats = db.getDb().executeQuery("SELECT PlayerUID FROM `PlayerAreaStats` WHERE PlayerUID = '" + uid + "'");
                    String sql = existingStats.next() ? "UPDATE `PlayerAreaStats` SET AreaCount = " + count + ", MaxAreaAllocation = " + max + " WHERE PlayerUID = '" + uid + "'" : "INSERT INTO `PlayerAreaStats` (PlayerUID, AreaCount, MaxAreaAllocation) VALUES ('" + uid + "', " + count + ", " + max + ")";
                    db.getDb().executeUpdate(sql);
                    ResultSet pointsRs = db.getDb().executeQuery("SELECT ID FROM `Points` WHERE PlayerUID = '" + uid + "'");
                    if (!pointsRs.next()) {
                        db.getDb().executeUpdate("INSERT INTO `Points` (PlayerUID, UserName, Points, TotalPlaytimeHours) VALUES ('" + uid + "', 'MigratedUser', 0, 0.0)");
                        System.out.println("[LandClaim] Initialized Points row for migrated PlayerUID: " + uid);
                    }
                    for (Player owner : allPlayers = Server.getAllPlayers()) {
                        if (!owner.getUID().equals(uid)) continue;
                        owner.sendTextMessage("Area limit updated to " + max + " due to migration.");
                        continue block7;
                    }
                }
                this.lastMigrationResult = "Migration successful! Migrated " + counts.size() + " players.";
            }
            catch (SQLException e) {
                this.lastMigrationResult = "Migration failed: " + e.getMessage();
                System.out.println("[LandClaim] Migration error: " + e.getMessage());
            }
            finally {
                this.isMigrating = false;
            }
        }, () -> {
            this.plugin.claimedAreasByChunk.clear();
            try {
                this.plugin.loadClaimedAreas();
            }
            catch (SQLException e) {
                this.lastMigrationResult = "Migration completed with errors: " + e.getMessage();
            }
            if (feedback != null) {
                feedback.setText(this.lastMigrationResult);
            }
        });
        return "Migration queued...";
    }

    public String getLastMigrationResult() {
        return this.lastMigrationResult;
    }
}

