/*
 * Decompiled with CFR 0.152.
 */
package landclaim;

import java.lang.invoke.CallSite;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import landclaim.LandClaim;
import net.risingworld.api.Plugin;
import net.risingworld.api.World;
import net.risingworld.api.database.Database;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UILabel;

public class LandClaimDatabase {
    private final Plugin plugin;
    private Database db;
    private Database oldDataBase;

    public LandClaimDatabase(Plugin plugin) {
        this.plugin = plugin;
    }

    public void initialize() {
        System.out.println("-- LandClaim Database Loaded --");
        String worldName = World.getName();
        this.oldDataBase = this.plugin.getSQLiteConnection("Plugins/WorldProtection/" + worldName + "/database.db");
        if (this.oldDataBase == null) {
            System.out.println("[LandClaim] Could not connect to WorldProtection database.");
        }
        this.db = this.plugin.getSQLiteConnection(this.plugin.getPath() + "/" + worldName + "/database.db");
        this.createTables();
        this.initializeAdminSettings();
    }

    private void createTables() {
        String[] tableScripts;
        for (String script : tableScripts = new String[]{"CREATE TABLE IF NOT EXISTS `Areas` (`ID` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `AreaOwnerName` VARCHAR(64), `AreaName` VARCHAR(64), `AreaX` INTEGER, `AreaY` INTEGER, `AreaZ` INTEGER, `PlayerUID` BIGINT, `AreaLocked` BOOLEAN DEFAULT 0, `PVPStatus` BOOLEAN DEFAULT 0, `CreationDate` DATE);", "CREATE TABLE IF NOT EXISTS `Guests` (`ID` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `AreaID` INTEGER, `GuestName` VARCHAR(64), `PlayerUID` BIGINT, FOREIGN KEY (AreaID) REFERENCES Areas(ID));", "CREATE TABLE IF NOT EXISTS `Points` (`ID` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `UserName` VARCHAR(64), `Points` INTEGER DEFAULT 0, `PlayerUID` BIGINT, `TotalPlaytimeHours` DOUBLE DEFAULT 0.0);", "CREATE TABLE IF NOT EXISTS `AdminSettings` (`ID` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `PointsEarnedAdjust` INTEGER, `AreaCostAdjust` INTEGER);", "CREATE TABLE IF NOT EXISTS `DataBaseVersion` (`ID` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `Version` INTEGER);", "CREATE TABLE IF NOT EXISTS `PlayerAreaStats` (`PlayerUID` BIGINT PRIMARY KEY NOT NULL, `AreaCount` INTEGER DEFAULT 0, `MaxAreaAllocation` INTEGER DEFAULT 2);", "CREATE TABLE IF NOT EXISTS `GuestEventActions` (`AreaID` INTEGER NOT NULL, " + String.join((CharSequence)", ", (CharSequence[])this.getGuestPermissions().stream().map(p -> "`" + p + "` BOOLEAN DEFAULT 1").toArray(String[]::new)) + ", FOREIGN KEY (AreaID) REFERENCES Areas(ID));"}) {
            this.db.execute(script);
        }
        try (ResultSet result = this.db.executeQuery("SELECT * FROM `DataBaseVersion` WHERE ID = '1'");){
            if (!result.next()) {
                this.db.executeUpdate("INSERT INTO `DataBaseVersion` (Version) VALUES ('0');");
            }
        }
        catch (SQLException e) {
            System.out.println("[LandClaim] Error initializing DataBaseVersion: " + e.getMessage());
        }
    }

    private void initializeAdminSettings() {
        try {
            ResultSet rs = this.db.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = 1");
            if (!rs.next()) {
                this.db.executeUpdate("INSERT INTO `AdminSettings` (ID, PointsEarnedAdjust, AreaCostAdjust) VALUES (1, 1, 1)");
                System.out.println("[LandClaim] Initialized AdminSettings with default values: PointsEarnedAdjust=1, AreaCostAdjust=1");
            }
        }
        catch (SQLException e) {
            System.out.println("[LandClaim] Error initializing AdminSettings: " + e.getMessage());
        }
    }

    public void migrateAreasFromWorldProtection(Player player) {
        UILabel feedbackPanel = (UILabel)player.getAttribute("FeedBackinfoPanel");
        if (feedbackPanel != null) {
            feedbackPanel.setText("Migration of Areas Started");
        }
        if (this.oldDataBase == null) {
            System.out.println("[LandClaim] WorldProtection database not initialized.");
            if (feedbackPanel != null) {
                feedbackPanel.setText("[LandClaim] WorldProtection database not initialized!!!");
            }
            return;
        }
        HashMap<CallSite, Integer> migratedAreas = new HashMap<CallSite, Integer>();
        int migratedGuests = 0;
        try {
            ResultSet columns = this.oldDataBase.executeQuery("PRAGMA table_info(`Areas`)");
            boolean hasCreationDate = false;
            boolean hasAreaLocked = false;
            boolean hasPVPStatus = false;
            boolean hasAreaGuest = false;
            while (columns.next()) {
                String columnName = columns.getString("name");
                if ("CreationDate".equals(columnName)) {
                    hasCreationDate = true;
                }
                if ("AreaLocked".equals(columnName)) {
                    hasAreaLocked = true;
                }
                if ("PVPStatus".equals(columnName)) {
                    hasPVPStatus = true;
                }
                if (!"AreaGuest".equals(columnName)) continue;
                hasAreaGuest = true;
            }
            String selectSql = "SELECT ID, AreaOwnerName, AreaName, AreaX, AreaY, AreaZ, PlayerUID" + (hasCreationDate ? ", CreationDate" : "") + (hasAreaLocked ? ", AreaLocked" : "") + (hasPVPStatus ? ", PVPStatus" : "") + (hasAreaGuest ? ", AreaGuest" : "") + " FROM `Areas`";
            ResultSet areasRs = this.oldDataBase.executeQuery(selectSql);
            while (areasRs.next()) {
                String updateSql;
                int id = areasRs.getInt("ID");
                String areaOwnerName = areasRs.getString("AreaOwnerName");
                String areaName = areasRs.getString("AreaName");
                int areaX = areasRs.getInt("AreaX");
                int areaY = areasRs.getInt("AreaY");
                int areaZ = areasRs.getInt("AreaZ");
                long playerUID = areasRs.getLong("PlayerUID");
                String areaGuest = hasAreaGuest ? areasRs.getString("AreaGuest") : null;
                String areaKey = areaX + "," + areaY + "," + areaZ;
                if (!migratedAreas.containsKey(areaKey)) {
                    ResultSet existing = this.db.executeQuery("SELECT ID FROM `Areas` WHERE AreaX = " + areaX + " AND AreaY = " + areaY + " AND AreaZ = " + areaZ);
                    if (!existing.next()) {
                        String insertSql = "INSERT INTO `Areas` (ID, AreaOwnerName, AreaName, AreaX, AreaY, AreaZ, PlayerUID, AreaLocked, PVPStatus, CreationDate) VALUES (" + id + ", '" + this.escapeSql(areaOwnerName) + "', '" + this.escapeSql(areaName) + "', " + areaX + ", " + areaY + ", " + areaZ + ", " + playerUID + ", 0, 0, NULL)";
                        this.db.executeUpdate(insertSql);
                        this.insertDefaultGuestPermissions(id);
                    }
                    migratedAreas.put((CallSite)((Object)areaKey), id);
                }
                if (hasAreaGuest && areaGuest != null && !areaGuest.trim().equalsIgnoreCase("AreaGuest")) {
                    try {
                        int areaId;
                        ResultSet existingGuest;
                        long guestUID = Long.parseLong(areaGuest.trim());
                        if (guestUID != 0L && guestUID != playerUID && !(existingGuest = this.db.executeQuery("SELECT ID FROM `Guests` WHERE AreaID = " + (areaId = ((Integer)migratedAreas.get(areaKey)).intValue()) + " AND PlayerUID = " + guestUID)).next()) {
                            this.db.executeUpdate("INSERT INTO `Guests` (AreaID, PlayerUID) VALUES (" + areaId + ", " + guestUID + ")");
                            ++migratedGuests;
                        }
                    }
                    catch (NumberFormatException e) {
                        System.out.println("[LandClaim] Skipping invalid AreaGuest: " + areaGuest);
                    }
                }
                if ((updateSql = this.buildUpdateSql(areasRs, (Integer)migratedAreas.get(areaKey), hasCreationDate, hasAreaLocked, hasPVPStatus)) == null) continue;
                this.db.executeUpdate(updateSql);
            }
            System.out.println("[LandClaim] Migration completed. Areas: " + migratedAreas.size() + ", Guests: " + migratedGuests);
            if (feedbackPanel != null) {
                feedbackPanel.setText("Migration of Areas from WorldProtection database completed");
            }
        }
        catch (SQLException e) {
            System.out.println("[LandClaim] Migration failed: " + e.getMessage());
            if (feedbackPanel != null) {
                feedbackPanel.setText("Areas and Guests migration failed!!!");
            }
            e.printStackTrace();
        }
    }

    private void insertDefaultGuestPermissions(int areaId) throws SQLException {
        StringBuilder insertSql = new StringBuilder("INSERT INTO `GuestEventActions` (AreaID, ");
        StringBuilder valuesSql = new StringBuilder("VALUES (" + areaId + ", ");
        List<String> permissions = this.getGuestPermissions();
        for (int i = 0; i < permissions.size(); ++i) {
            insertSql.append("`").append(permissions.get(i)).append("`");
            valuesSql.append("1");
            if (i >= permissions.size() - 1) continue;
            insertSql.append(", ");
            valuesSql.append(", ");
        }
        insertSql.append(") ").append((CharSequence)valuesSql).append(")");
        this.db.executeUpdate(insertSql.toString());
    }

    private String buildUpdateSql(ResultSet rs, int areaId, boolean hasCreationDate, boolean hasAreaLocked, boolean hasPVPStatus) throws SQLException {
        String creationDate;
        StringBuilder updateSql = new StringBuilder("UPDATE `Areas` SET ");
        boolean hasUpdates = false;
        if (hasCreationDate && (creationDate = rs.getString("CreationDate")) != null) {
            updateSql.append("CreationDate = '").append(creationDate).append("'");
            hasUpdates = true;
        }
        if (hasAreaLocked) {
            if (hasUpdates) {
                updateSql.append(", ");
            }
            updateSql.append("AreaLocked = ").append(rs.getInt("AreaLocked") != 0 ? 1 : 0);
            hasUpdates = true;
        }
        if (hasPVPStatus) {
            if (hasUpdates) {
                updateSql.append(", ");
            }
            updateSql.append("PVPStatus = ").append(rs.getInt("PVPStatus") != 0 ? 1 : 0);
            hasUpdates = true;
        }
        return hasUpdates ? updateSql.append(" WHERE ID = ").append(areaId).toString() : null;
    }

    public void close() {
        if (this.db != null) {
            this.db.close();
        }
        if (this.oldDataBase != null) {
            this.oldDataBase.close();
        }
    }

    public Database getDb() {
        return this.db;
    }

    public boolean addClaimedArea(LandClaim.ClaimedArea area) throws SQLException {
        boolean isNewPlayer;
        ResultSet rsCheck = this.db.executeQuery("SELECT ID FROM `Areas` WHERE AreaX = " + area.areaX + " AND AreaY = " + area.areaY + " AND AreaZ = " + area.areaZ);
        if (rsCheck.next()) {
            return false;
        }
        String uid = area.playerUID;
        ResultSet rsStats = this.db.executeQuery("SELECT AreaCount, MaxAreaAllocation FROM `PlayerAreaStats` WHERE PlayerUID = '" + uid + "'");
        int areaCount = 0;
        int maxAreaAllocation = 2;
        boolean bl = isNewPlayer = !rsStats.next();
        if (!isNewPlayer) {
            areaCount = rsStats.getInt("AreaCount");
            maxAreaAllocation = rsStats.getInt("MaxAreaAllocation");
        }
        if (areaCount >= maxAreaAllocation) {
            return false;
        }
        String sql = "INSERT INTO `Areas` (AreaOwnerName, AreaName, AreaX, AreaY, AreaZ, PlayerUID, AreaLocked, PVPStatus, CreationDate) VALUES ('" + this.escapeSql(area.areaOwnerName) + "', '" + this.escapeSql(area.areaName) + "', " + area.areaX + ", " + area.areaY + ", " + area.areaZ + ", '" + uid + "', 0, 0, CURRENT_TIMESTAMP)";
        this.db.executeUpdate(sql);
        ResultSet rsArea = this.db.executeQuery("SELECT ID FROM `Areas` WHERE AreaX = " + area.areaX + " AND AreaY = " + area.areaY + " AND AreaZ = " + area.areaZ);
        if (rsArea.next()) {
            int areaId = rsArea.getInt("ID");
            this.insertDefaultGuestPermissions(areaId);
            String statsSql = isNewPlayer ? "INSERT INTO `PlayerAreaStats` (PlayerUID, AreaCount, MaxAreaAllocation) VALUES ('" + uid + "', " + areaCount + ", 2)" : "UPDATE `PlayerAreaStats` SET AreaCount = " + ++areaCount + " WHERE PlayerUID = '" + uid + "'";
            this.db.executeUpdate(statsSql);
            return true;
        }
        return false;
    }

    public void removeClaimedArea(int areaX, int areaY, int areaZ, String playerUID) throws SQLException {
        ResultSet rs = this.db.executeQuery("SELECT ID FROM `Areas` WHERE AreaX = " + areaX + " AND AreaY = " + areaY + " AND AreaZ = " + areaZ + " AND PlayerUID = '" + playerUID + "'");
        if (rs.next()) {
            int areaId = rs.getInt("ID");
            this.db.executeUpdate("DELETE FROM `GuestEventActions` WHERE AreaID = " + areaId);
            this.db.executeUpdate("DELETE FROM `Guests` WHERE AreaID = " + areaId);
            this.db.executeUpdate("DELETE FROM `Areas` WHERE ID = " + areaId);
            ResultSet rsStats = this.db.executeQuery("SELECT AreaCount FROM `PlayerAreaStats` WHERE PlayerUID = '" + playerUID + "'");
            if (rsStats.next()) {
                int areaCount = rsStats.getInt("AreaCount") - 1;
                if (areaCount > 0) {
                    this.db.executeUpdate("UPDATE `PlayerAreaStats` SET AreaCount = " + areaCount + " WHERE PlayerUID = '" + playerUID + "'");
                } else {
                    this.db.executeUpdate("DELETE FROM `PlayerAreaStats` WHERE PlayerUID = '" + playerUID + "'");
                }
            }
        }
    }

    public void AdminRemoveClaimedArea(int areaX, int areaY, int areaZ, String playerUID) throws SQLException {
        ResultSet rs = this.db.executeQuery("SELECT ID FROM `Areas` WHERE AreaX = " + areaX + " AND AreaY = " + areaY + " AND AreaZ = " + areaZ + " AND PlayerUID = '" + playerUID + "'");
        if (rs.next()) {
            int areaId = rs.getInt("ID");
            this.db.executeUpdate("DELETE FROM `GuestEventActions` WHERE AreaID = " + areaId);
            this.db.executeUpdate("DELETE FROM `Guests` WHERE AreaID = " + areaId);
            this.db.executeUpdate("DELETE FROM `Areas` WHERE ID = " + areaId);
            ResultSet rsStats = this.db.executeQuery("SELECT AreaCount FROM `PlayerAreaStats` WHERE PlayerUID = '" + playerUID + "'");
            if (rsStats.next()) {
                int areaCount = rsStats.getInt("AreaCount") - 1;
                if (areaCount > 0) {
                    this.db.executeUpdate("UPDATE `PlayerAreaStats` SET AreaCount = " + areaCount + " WHERE PlayerUID = '" + playerUID + "'");
                } else {
                    this.db.executeUpdate("DELETE FROM `PlayerAreaStats` WHERE PlayerUID = '" + playerUID + "'");
                }
            }
        }
    }

    public ResultSet getAllClaimedAreas() throws SQLException {
        return this.db.executeQuery("SELECT PlayerUID, AreaOwnerName, AreaName, AreaX, AreaY, AreaZ FROM `Areas`");
    }

    public int getPlayerAreaCount(String playerUID) throws SQLException {
        ResultSet rs = this.db.executeQuery("SELECT AreaCount FROM `PlayerAreaStats` WHERE PlayerUID = '" + playerUID + "'");
        return rs.next() ? rs.getInt("AreaCount") : 0;
    }

    public int getMaxAreaAllocation(String playerUID) throws SQLException {
        ResultSet rs = this.db.executeQuery("SELECT MaxAreaAllocation FROM `PlayerAreaStats` WHERE PlayerUID = '" + playerUID + "'");
        return rs.next() ? rs.getInt("MaxAreaAllocation") : 2;
    }

    public void setMaxAreaAllocation(String playerUID, int maxAreas) throws SQLException {
        this.db.executeUpdate("INSERT OR REPLACE INTO `PlayerAreaStats` (PlayerUID, AreaCount, MaxAreaAllocation) VALUES ('" + playerUID + "', (SELECT AreaCount FROM `PlayerAreaStats` WHERE PlayerUID = '" + playerUID + "'), " + maxAreas + ")");
    }

    public void setGuestPermission(int areaId, String eventName, boolean value) throws SQLException {
        this.db.executeUpdate("UPDATE `GuestEventActions` SET `" + eventName + "` = " + (value ? 1 : 0) + " WHERE AreaID = " + areaId);
    }

    public boolean getGuestPermission(int areaId, String eventName) throws SQLException {
        ResultSet rs = this.db.executeQuery("SELECT `" + eventName + "` FROM `GuestEventActions` WHERE AreaID = " + areaId);
        return rs.next() && rs.getBoolean(eventName);
    }

    public int getAreaIdFromCoords(int x, int y, int z) throws SQLException {
        ResultSet rs = this.db.executeQuery("SELECT ID FROM `Areas` WHERE AreaX = " + x + " AND AreaY = " + y + " AND AreaZ = " + z);
        return rs.next() ? rs.getInt("ID") : -1;
    }

    public void addPoints(String playerUID, int points) throws SQLException {
        String sql = "UPDATE `Points` SET Points = Points + " + points + " WHERE PlayerUID = '" + this.escapeSql(playerUID) + "'";
        this.db.executeUpdate(sql);
    }

    public int getPoints(String playerUID) throws SQLException {
        ResultSet rs = this.db.executeQuery("SELECT Points FROM `Points` WHERE PlayerUID = '" + this.escapeSql(playerUID) + "'");
        return rs.next() ? rs.getInt("Points") : 0;
    }

    public void deductPoints(String playerUID, int points) throws SQLException {
        int currentPoints = this.getPoints(playerUID);
        if (currentPoints < points) {
            throw new SQLException("Points deduction failed: insufficient points! Need " + points + ", have " + currentPoints);
        }
        String sql = "UPDATE `Points` SET Points = Points - " + points + " WHERE PlayerUID = '" + this.escapeSql(playerUID) + "'";
        this.db.executeUpdate(sql);
        int newPoints = this.getPoints(playerUID);
        if (newPoints != currentPoints - points) {
            throw new SQLException("Points deduction failed: update did not apply correctly!");
        }
    }

    public void deductHours(String playerUID, double hours) throws SQLException {
        double currentHours = this.getTotalPlaytimeHours(playerUID);
        if (currentHours < hours) {
            throw new SQLException("Hours deduction failed: insufficient hours! Need " + hours + ", have " + currentHours);
        }
        String sql = "UPDATE `Points` SET TotalPlaytimeHours = TotalPlaytimeHours - " + hours + " WHERE PlayerUID = '" + this.escapeSql(playerUID) + "'";
        this.db.executeUpdate(sql);
        double newHours = this.getTotalPlaytimeHours(playerUID);
        if (Math.abs(newHours - (currentHours - hours)) > 0.001) {
            throw new SQLException("Hours deduction failed: update did not apply correctly! Expected " + (currentHours - hours) + ", got " + newHours);
        }
        System.out.println("[LandClaim] Deducted " + hours + " hours for PlayerUID: " + playerUID + ". New hours: " + newHours);
    }

    public boolean buyAreaAllocation(String playerUID, int areaCost) throws SQLException {
        int currentPoints = this.getPoints(playerUID);
        if (currentPoints < areaCost) {
            return false;
        }
        this.deductPoints(playerUID, areaCost);
        int currentMax = this.getMaxAreaAllocation(playerUID);
        this.setMaxAreaAllocation(playerUID, currentMax + 1);
        System.out.println("[LandClaim] PlayerUID: " + playerUID + " bought 1 area allocation for " + areaCost + " points. New MaxAreaAllocation: " + (currentMax + 1));
        return true;
    }

    public void updatePlaytimeAndPoints(String playerUID, double sessionHours) throws SQLException {
        if (sessionHours < 2.777777777777778E-4) {
            System.out.println("[LandClaim] Session time too short for PlayerUID: " + playerUID + " (" + sessionHours + " hours), skipping update.");
            return;
        }
        System.out.println("[LandClaim] Updating playtime for PlayerUID: " + playerUID + ", Session Hours: " + sessionHours);
        ResultSet rsBefore = this.db.executeQuery("SELECT TotalPlaytimeHours, Points FROM `Points` WHERE PlayerUID = '" + this.escapeSql(playerUID) + "'");
        double previousHours = 0.0;
        int previousPoints = 0;
        boolean playerExists = rsBefore.next();
        if (!playerExists) {
            System.out.println("[LandClaim] No Points row found for PlayerUID: " + playerUID + ", initializing...");
            this.db.executeUpdate("INSERT INTO `Points` (PlayerUID, UserName, Points, TotalPlaytimeHours) VALUES ('" + this.escapeSql(playerUID) + "', 'Unknown', 0, 0.0)");
            previousHours = 0.0;
            previousPoints = 0;
        } else {
            previousHours = rsBefore.getDouble("TotalPlaytimeHours");
            previousPoints = rsBefore.getInt("Points");
        }
        System.out.println("[LandClaim] Before update - PlayerUID: " + playerUID + ", TotalPlaytimeHours: " + previousHours + ", Points: " + previousPoints);
        String sql = "UPDATE `Points` SET TotalPlaytimeHours = TotalPlaytimeHours + " + sessionHours + " WHERE PlayerUID = '" + this.escapeSql(playerUID) + "'";
        this.db.executeUpdate(sql);
        System.out.println("[LandClaim] Playtime update executed for PlayerUID: " + playerUID);
        int pointsEarnedAdjust = this.getPointsEarnedAdjust();
        double newTotalHours = previousHours + sessionHours;
        int newPoints = (int)Math.floor(newTotalHours * (double)pointsEarnedAdjust);
        System.out.println("[LandClaim] Calculated new points for PlayerUID: " + playerUID + " - Total Hours: " + newTotalHours + ", PointsEarnedAdjust: " + pointsEarnedAdjust + ", New Points: " + newPoints);
        this.db.executeUpdate("UPDATE `Points` SET Points = " + newPoints + " WHERE PlayerUID = '" + this.escapeSql(playerUID) + "'");
        System.out.println("[LandClaim] Points set to " + newPoints + " for PlayerUID: " + playerUID + " (Previous: " + previousPoints + ")");
    }

    public void recalculateAllPlayerPoints() throws SQLException {
        int pointsEarnedAdjust = this.getPointsEarnedAdjust();
        ResultSet rs = this.db.executeQuery("SELECT PlayerUID, TotalPlaytimeHours FROM `Points`");
        int updatedRows = 0;
        while (rs.next()) {
            String playerUID = rs.getString("PlayerUID");
            double totalHours = rs.getDouble("TotalPlaytimeHours");
            int newPoints = (int)Math.floor(totalHours * (double)pointsEarnedAdjust);
            this.db.executeUpdate("UPDATE `Points` SET Points = " + newPoints + " WHERE PlayerUID = '" + this.escapeSql(playerUID) + "'");
            ++updatedRows;
            System.out.println("[LandClaim] Recalculated points for PlayerUID: " + playerUID + ", Hours: " + totalHours + ", New Points: " + newPoints);
        }
        System.out.println("[LandClaim] All player points recalculated with PointsEarnedAdjust: " + pointsEarnedAdjust + ". Updated " + updatedRows + " rows.");
    }

    public double getTotalPlaytimeHours(String playerUID) throws SQLException {
        ResultSet rs = this.db.executeQuery("SELECT TotalPlaytimeHours FROM `Points` WHERE PlayerUID = '" + this.escapeSql(playerUID) + "'");
        return rs.next() ? rs.getDouble("TotalPlaytimeHours") : 0.0;
    }

    public int getPointsEarnedAdjust() throws SQLException {
        ResultSet rs = this.db.executeQuery("SELECT PointsEarnedAdjust FROM `AdminSettings` WHERE ID = 1");
        return rs.next() ? rs.getInt("PointsEarnedAdjust") : 1;
    }

    public void setPointsEarnedAdjust(int value) throws SQLException {
        if (value < 0) {
            value = 0;
        }
        this.db.executeUpdate("UPDATE `AdminSettings` SET PointsEarnedAdjust = " + value + " WHERE ID = 1");
        System.out.println("[LandClaim] PointsEarnedAdjust set to " + value);
        this.recalculateAllPlayerPoints();
    }

    public int getAreaCostAdjust() throws SQLException {
        ResultSet rs = this.db.executeQuery("SELECT AreaCostAdjust FROM `AdminSettings` WHERE ID = 1");
        return rs.next() ? Math.max(rs.getInt("AreaCostAdjust"), 1) : 1;
    }

    public void setAreaCostAdjust(int value) throws SQLException {
        if (value < 1) {
            value = 1;
        }
        this.db.executeUpdate("UPDATE `AdminSettings` SET AreaCostAdjust = " + value + " WHERE ID = 1");
        System.out.println("[LandClaim] AreaCostAdjust set to " + value);
    }

    private String escapeSql(String input) {
        return input == null ? "" : input.replace("'", "''");
    }

    private List<String> getGuestPermissions() {
        return Arrays.asList("PlayerDoorObjectStatus", "PlayerDestroyTerrain", "PlayerHitTerrain", "PlayerBedUseObject", "PlayerCampfireUseObject", "PlayerStorageObjectStatus", "PlayerTreeDestroyVegetation", "PlayerPrivateStatus", "PlayerTrunkDestroyVegetation", "PlayerTreeHitVegetation", "PlayerTrunkHitVegetation", "PlayerTreeRemoveVegetation", "PlayerTrunkRemoveVegetation", "PlayerCropRemoveVegetation", "PlayerFruitTreeRemoveVegetation", "PlayerPlantRemoveVegetation", "PlayerRockDestroyVegetation", "PlayerRockHitVegetation", "PlayerRockRemoveVegetation", "PlayerAdminRights", "PlayerClockUseObject", "PlayerDoorUseObject", "PlayerDryingRackUseObject", "PlayerFireUseObject", "PlayerFurnaceUseObject", "PlayerGrillUseObject", "PlayerGrinderUseObject", "PlayerGrindstoneUseObject", "PlayerLadderUseObject", "PlayerLampUseObject", "PlayerMusicPlayerUseObject", "PlayerOvenUseObject", "PlayerPaperPressUseObject", "PlayerPianoUseObject", "PlayerPosterUseObject", "PlayerScaffoldingUseObject", "PlayerSeatingUseObject", "PlayerShootingTargetUseObject", "PlayerSignUseObject", "PlayerSpinningWheelUseObject", "PlayerStorageUseObject", "PlayerTanningRackUseObject", "PlayerTechnicalUseObject", "PlayerTorchUseObject", "PlayerTrashcanUseObject", "PlayerWorkbenchUseObject", "PlayerHitAnimalNPC", "PlayerHitHumanNPC", "PlayerHitMountNPC", "PlayerRideMountNPC", "PlayerPlaceBluePrints", "PlayerNpcAddSaddle", "PlayerNpcRemoveSaddle", "PlayerNpcAddSaddleBag", "PlayerNpcRemoveSaddleBag", "PlayerNpcAddClothes", "PlayerNpcRemoveClothes", "PlayerChangeConstructionColor", "PlayerChangeObjectColor", "PlayerChangeObjectInfo", "PlayerCreativePlaceVegetation", "PlayerCreativeRemoveConstruction", "PlayerCreativeRemoveObject", "PlayerCreativeRemoveVegetation", "PlayerCreativeTerrainEdit", "PlayerDestroyConstruction", "PlayerDestroyObject", "PlayerEditConstruction", "PlayerHitConstruction", "PlayerHitObject", "PlayerHitVegetation", "PlayerHitWater", "PlayerPlaceConstruction", "PlayerPlaceGrass", "PlayerPlaceObject", "PlayerPlaceTerrain", "PlayerPlaceVegetation", "PlayerRemoveConstruction", "PlayerRemoveGrass", "PlayerRemoveObject", "PlayerRemoveVegetation", "PlayerRemoveWater", "PlayerWorldEdit");
    }
}

