/*
 * Decompiled with CFR 0.152.
 */
package onlinemarket;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.Locale;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.events.player.ui.PlayerUIElementClickEvent;
import net.risingworld.api.objects.Inventory;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UILabel;
import onlinemarket.MarketMenuControl;
import onlinemarket.OnlineMarket;

public class MarketResourceControl
extends OnlineMarket {
    private final Plugin plugin;
    private final MarketMenuControl menuControl;
    private static final String[] STONE_TYPES = new String[]{"stone", "gravel", "dirt", "mud", "forestground", "volcanicrock", "obsidianrock", "sand", "sandstone", "redclay", "hellstone", "cobble", "underwaterrock"};
    private static final String[] TREELOG_TYPES = new String[]{"treelog", "treeloghickory", "treelogacacia", "treelogaraucaria", "treelogbirch", "treeloglondonplane", "treelogcypress", "treelogcactus", "treelogpalm", "treelogredmaple", "treelogspruce", "treelogweepingbeech", "treelogwillowoak", "treelogapple", "treelogmesquite", "treelogaleppo"};

    public MarketResourceControl(Plugin plugin, MarketMenuControl menuControl) {
        this.plugin = plugin;
        this.menuControl = menuControl;
    }

    public void handleResourceEvent(PlayerUIElementClickEvent event) throws SQLException {
        String sql;
        String formattedWallet;
        NumberFormat walletFormatter;
        float totalPaid;
        float sellPrice;
        int stack;
        String itemName;
        Item equippedItem;
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        String PlayerName = player.getName();
        int eventID = event.getUIElement().getID();
        int onlineMarketSellStoneButtonID = (Integer)player.getAttribute("OnlineMarketSellStoneButtonID");
        int onlineMarketSellLumberButtonID = (Integer)player.getAttribute("OnlineMarketSellLumberButtonID");
        if (eventID == onlineMarketSellStoneButtonID) {
            equippedItem = player.getEquippedItem();
            player.setAttribute("itemRemoved", (Object)false);
            if (equippedItem == null) {
                player.sendYellMessage("You need to be holding Stone to sell it!!", 1.0f, false);
                return;
            }
            try {
                float wallet = this.getPlayerMoney(PlayerUID, PlayerName);
                itemName = equippedItem.getDefinition().name;
                if (this.isStone(itemName)) {
                    stack = equippedItem.getStack();
                    if (stack >= 1) {
                        sellPrice = 5.0f;
                        totalPaid = sellPrice * (float)stack;
                        this.menuControl.updatePlayerMoney(player, totalPaid);
                        this.removeItemFromInventory(player, itemName, stack);
                        walletFormatter = NumberFormat.getCurrencyInstance(Locale.US);
                        formattedWallet = walletFormatter.format(wallet += totalPaid);
                        player.setAttribute("Wallet", (Object)formattedWallet);
                        this.updatePointsInfo(player, formattedWallet);
                        sql = "INSERT INTO `MarketTransactions` (PlayerUID, ItemName, QuantitySold, Price, TotalAmount, TransactionType, SellerUID) VALUES ('" + PlayerUID + "', '" + itemName + "', " + stack + ", " + sellPrice + ", " + totalPaid + ", 'Sale', 'SERVER_UID')";
                        OnlineDataBaseAccess1.executeUpdate(sql);
                        player.sendYellMessage("Sold " + stack + " " + this.formatStoneName(itemName) + " for " + walletFormatter.format(totalPaid) + "! New balance: " + formattedWallet + ".", 3.0f, true);
                        this.menuControl.updateWalletDisplay(player);
                        this.menuControl.refreshStatsUI(player);
                    }
                } else {
                    player.sendYellMessage("You need to be holding Stone to sell it!!", 1.0f, false);
                }
            }
            catch (SQLException e) {
                player.sendYellMessage("Error selling stones or logging transaction: " + e.getMessage(), 3.0f, true);
                e.printStackTrace();
            }
        }
        if (eventID == onlineMarketSellLumberButtonID) {
            equippedItem = player.getEquippedItem();
            player.setAttribute("itemRemoved", (Object)false);
            if (equippedItem == null) {
                player.sendYellMessage("You need to be holding Logs to sell them!!", 1.0f, false);
                return;
            }
            try {
                float wallet = this.getPlayerMoney(PlayerUID, PlayerName);
                itemName = equippedItem.getDefinition().name;
                if (this.isTreeLog(itemName)) {
                    stack = equippedItem.getStack();
                    if (stack >= 1) {
                        sellPrice = 10.0f;
                        totalPaid = sellPrice * (float)stack;
                        this.menuControl.updatePlayerMoney(player, totalPaid);
                        this.removeItemFromInventory(player, itemName, stack);
                        walletFormatter = NumberFormat.getCurrencyInstance(Locale.US);
                        formattedWallet = walletFormatter.format(wallet += totalPaid);
                        player.setAttribute("Wallet", (Object)formattedWallet);
                        this.updatePointsInfo(player, formattedWallet);
                        sql = "INSERT INTO `MarketTransactions` (PlayerUID, ItemName, QuantitySold, Price, TotalAmount, TransactionType, SellerUID) VALUES ('" + PlayerUID + "', '" + itemName + "', " + stack + ", " + sellPrice + ", " + totalPaid + ", 'Sale', 'SERVER_UID')";
                        OnlineDataBaseAccess1.executeUpdate(sql);
                        player.sendYellMessage("Sold " + stack + " " + this.formatTreeLogName(itemName) + " for " + walletFormatter.format(totalPaid) + "! New balance: " + formattedWallet + ".", 3.0f, true);
                        this.menuControl.updateWalletDisplay(player);
                        this.menuControl.refreshStatsUI(player);
                    }
                } else {
                    player.sendYellMessage("You need to be holding Logs to sell them!!", 1.0f, false);
                }
            }
            catch (SQLException e) {
                player.sendYellMessage("Error selling logs or logging transaction: " + e.getMessage(), 3.0f, true);
                e.printStackTrace();
            }
        }
    }

    private float getPlayerMoney(String playerUID, String playerName) throws SQLException {
        try (ResultSet result = OnlineDataBaseAccess1.executeQuery("SELECT Money FROM `PlayerMoney` WHERE `PlayerUID` = '" + playerUID + "'");){
            if (!result.next()) {
                OnlineDataBaseAccess1.executeUpdate("INSERT INTO `PlayerMoney` (PlayerUID, PlayerName, Money) VALUES ('" + playerUID + "', '" + playerName + "', 0)");
                Player player = Server.getPlayerByUID((String)playerUID);
                if (player != null) {
                    player.sendYellMessage("Created a new money account for you with $0!", 3.0f, true);
                }
                float f = 0.0f;
                return f;
            }
            float f = result.getFloat("Money");
            return f;
        }
    }

    public boolean isStone(String itemName) {
        for (String stone : STONE_TYPES) {
            if (!stone.equals(itemName)) continue;
            return true;
        }
        return false;
    }

    public boolean isTreeLog(String itemName) {
        for (String treeLog : TREELOG_TYPES) {
            if (!treeLog.equals(itemName)) continue;
            return true;
        }
        return false;
    }

    private String formatStoneName(String itemName) {
        return itemName.substring(0, 1).toUpperCase() + itemName.substring(1);
    }

    private String formatTreeLogName(String itemName) {
        if (itemName.startsWith("treelog")) {
            String type = itemName.substring(7);
            if (type.isEmpty()) {
                return "Tree Log";
            }
            return type.substring(0, 1).toUpperCase() + type.substring(1) + " Tree Log";
        }
        return itemName;
    }

    private void removeItemFromInventory(Player player, String itemName, int stack) {
        for (int i = 0; i < 36; ++i) {
            Item slotItem = player.getInventory().getItem(i, Inventory.SlotType.Inventory);
            if (slotItem == null || !slotItem.getDefinition().name.equals(itemName) || slotItem.getStack() != stack) continue;
            player.getInventory().removeItem(i, Inventory.SlotType.Inventory, stack);
            player.setAttribute("itemRemoved", (Object)true);
            return;
        }
        if (Boolean.FALSE.equals(player.getAttribute("itemRemoved"))) {
            int quickslotFocus = player.getInventory().getQuickslotFocus();
            Item quickslotItem = player.getInventory().getItem(quickslotFocus, Inventory.SlotType.Quickslot);
            if (quickslotItem != null && quickslotItem.getDefinition().name.equals(itemName) && quickslotItem.getStack() == stack) {
                player.getInventory().removeItem(quickslotFocus, Inventory.SlotType.Quickslot, stack);
                player.setAttribute("itemRemoved", (Object)true);
            }
        }
    }

    private void updatePointsInfo(Player player, String formattedWallet) {
        UILabel pointsInfo = (UILabel)player.getAttribute("PointsInfo");
        if (pointsInfo != null) {
            pointsInfo.setText("Wallet Cash=" + formattedWallet);
        }
    }
}

