/*
 * Decompiled with CFR 0.152.
 */
package onlinemarket;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.Locale;
import net.risingworld.api.Plugin;
import net.risingworld.api.events.player.ui.PlayerUIElementClickEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UILabel;
import onlinemarket.MarketEditControl;
import onlinemarket.MarketListingControl;
import onlinemarket.MarketNavigationControl;
import onlinemarket.MarketPurchaseControl;
import onlinemarket.MarketResourceControl;
import onlinemarket.MarketStatsControl;
import onlinemarket.OnlineMarket;
import onlinemarket.OpenOnlineMarket;
import onlinemarket.Stats;

public class MarketMenuControl
extends OnlineMarket {
    private final Plugin plugin;
    private final MarketListingControl listingControl;
    private final MarketPurchaseControl purchaseControl;
    private final MarketResourceControl resourceControl;
    private final MarketEditControl editControl;
    private final MarketNavigationControl navigationControl;
    private final MarketStatsControl statsControl;
    private final OpenOnlineMarket openOnlineMarket;
    private final Stats stats;

    public MarketMenuControl(Plugin plugin) {
        this.plugin = plugin;
        this.openOnlineMarket = new OpenOnlineMarket(plugin);
        this.stats = new Stats(plugin);
        this.listingControl = new MarketListingControl(plugin, this);
        this.purchaseControl = new MarketPurchaseControl(plugin, this);
        this.resourceControl = new MarketResourceControl(plugin, this);
        this.editControl = new MarketEditControl(plugin, this);
        this.navigationControl = new MarketNavigationControl(plugin, this);
        this.statsControl = new MarketStatsControl(plugin, this);
    }

    public void MenuControl(PlayerUIElementClickEvent event) throws SQLException {
        Player player = event.getPlayer();
        int eventID = event.getUIElement() != null ? event.getUIElement().getID() : 0;
        int OpenOnlineMarketMenuID = (Integer)player.getAttribute("OpenOnlineMarketMenuID");
        int OnlineMarketExitButtonID = (Integer)player.getAttribute("OnlineMarketExitButtonID");
        if (eventID == OpenOnlineMarketMenuID) {
            player.hideInventory();
            player.setAttribute("Search", (Object)"SELECT count(*) FROM `MarketListings`");
            player.setAttribute("SearchRsult", (Object)"MarketListings");
            this.openOnlineMarket.OpenMenu(player);
            this.updateWalletDisplay(player);
            return;
        }
        if (eventID == OnlineMarketExitButtonID) {
            UILabel OnlineMarketTextField = (UILabel)player.getAttribute("OnlineMarketTextField");
            OnlineMarketTextField.setVisible(false);
            player.setMouseCursorVisible(false);
            return;
        }
        this.listingControl.handleListingEvent(event);
        this.purchaseControl.handlePurchaseEvent(event);
        this.resourceControl.handleResourceEvent(event);
        this.editControl.handleEditEvent(event);
        this.navigationControl.handleNavigationEvent(event);
        this.statsControl.handleStatsEvent(event);
    }

    public void updateWalletDisplay(Player player) {
        try (ResultSet result = OnlineDataBaseAccess1.executeQuery("SELECT Money FROM `PlayerMoney` WHERE PlayerUID = '" + player.getUID() + "'");){
            float wallet = result.next() ? result.getFloat("Money") : 0.0f;
            NumberFormat walletFormatter = NumberFormat.getCurrencyInstance(Locale.US);
            String formattedWallet = walletFormatter.format(wallet);
            UILabel playerMoneyLabel = (UILabel)player.getAttribute("PlayerMoneyLabel");
            if (playerMoneyLabel != null) {
                playerMoneyLabel.setText("<b>Cash:</b> " + formattedWallet);
            }
            player.setAttribute("Wallet", (Object)formattedWallet);
        }
        catch (SQLException e) {
            player.sendYellMessage("Error fetching wallet: " + e.getMessage(), 3.0f, true);
            e.printStackTrace();
        }
    }

    public void updatePlayerMoney(Player player, float amount) throws SQLException {
        String playerUID = player.getUID();
        ResultSet rs = OnlineDataBaseAccess1.executeQuery("SELECT Money FROM `PlayerMoney` WHERE PlayerUID = '" + playerUID + "'");
        float currentMoney = rs.next() ? rs.getFloat("Money") : 0.0f;
        float newMoney = currentMoney + amount;
        OnlineDataBaseAccess1.executeUpdate("UPDATE `PlayerMoney` SET Money = " + newMoney + " WHERE PlayerUID = '" + playerUID + "'");
        player.setAttribute("StatsWalletValue", (Object)Float.valueOf(newMoney));
    }

    public void refreshStatsUI(Player player) {
        Boolean statsPanelVisible = (Boolean)player.getAttribute("StatsPanelVisible");
        if (statsPanelVisible != null && statsPanelVisible.booleanValue()) {
            this.stats.loadPlayerStats(player);
            UILabel statsPanel = (UILabel)player.getAttribute("OnlineMarketStatsPanel");
            if (statsPanel != null) {
                this.stats.updateStatsUI(statsPanel, player);
            }
        }
    }

    public OpenOnlineMarket getOpenOnlineMarket() {
        return this.openOnlineMarket;
    }

    public Stats getStats() {
        return this.stats;
    }
}

