/*
 * Decompiled with CFR 0.152.
 */
package onlinemarket;

import java.sql.ResultSet;
import java.sql.SQLException;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.events.player.ui.PlayerUIElementClickEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UILabel;
import net.risingworld.api.ui.UITextField;
import onlinemarket.MarketMenuControl;
import onlinemarket.OnlineMarket;

public class MarketEditControl
extends OnlineMarket {
    private final Plugin plugin;
    private final MarketMenuControl menuControl;

    public MarketEditControl(Plugin plugin, MarketMenuControl menuControl) {
        this.plugin = plugin;
        this.menuControl = menuControl;
    }

    public void handleEditEvent(PlayerUIElementClickEvent event) throws SQLException {
        block41: {
            UILabel editPopup;
            Player player = event.getPlayer();
            String PlayerUID = player.getUID();
            String PlayerName = player.getName();
            int eventID = event.getUIElement().getID();
            int editUnlimitedToggleID = (Integer)player.getAttribute("EditItemUnlimitedToggleID");
            int editConfirmButtonID = (Integer)player.getAttribute("EditConfirmButtonID");
            int editRemoveButtonID = (Integer)player.getAttribute("EditRemoveButtonID");
            int editCancelButtonID = (Integer)player.getAttribute("EditCancelButtonID");
            int editExitButtonID = (Integer)player.getAttribute("EditExitButtonID");
            int editFeatureButtonID = (Integer)player.getAttribute("EditFeatureButtonID");
            if (eventID == editUnlimitedToggleID && player.isAdmin()) {
                UILabel editUnlimitedToggle = (UILabel)player.getAttribute("EditItemUnlimitedToggle");
                int currentState = (Integer)player.getAttribute("SelectedItemIsUnlimited");
                int newState = currentState == 1 ? 0 : 1;
                player.setAttribute("SelectedItemIsUnlimited", (Object)newState);
                editUnlimitedToggle.setText("<b>Unlimited Stock: " + (newState == 1 ? "ON" : "OFF") + "</b>");
                editUnlimitedToggle.setBackgroundColor(newState == 1 ? 0.0f : 0.5f, newState == 1 ? 0.5f : 0.0f, 0.0f, 0.9f);
            }
            if (eventID == editConfirmButtonID) {
                int itemID = (Integer)player.getAttribute("SelectedItemID");
                String ownerUID = (String)player.getAttribute("SelectedItemOwnerUID");
                if (!PlayerUID.equals(ownerUID) && !player.isAdmin()) {
                    player.sendYellMessage("You can only edit your own items!", 3.0f, true);
                    return;
                }
                UITextField editPriceField = (UITextField)player.getAttribute("EditItemPriceField");
                editPriceField.getCurrentText(player, priceText -> {
                    try {
                        int newPrice = Integer.parseInt(priceText);
                        int isUnlimited = (Integer)player.getAttribute("SelectedItemIsUnlimited");
                        String newOwnerName = isUnlimited == 1 ? "Server" : PlayerName;
                        String newOwnerUID = isUnlimited == 1 ? "SERVER_UID" : PlayerUID;
                        OnlineDataBaseAccess2.executeUpdate("UPDATE `MarketListings` SET ItemPrice = " + newPrice + ", IsUnlimited = " + isUnlimited + ", ItemOwnerName = '" + newOwnerName + "', ItemOwnerUID = '" + newOwnerUID + "' WHERE ID = " + itemID);
                        player.sendYellMessage("Item updated! New price: $" + newPrice + (isUnlimited == 1 ? " (Unlimited)" : ""), 3.0f, true);
                        UILabel editPopup = (UILabel)player.getAttribute("EditItemPopupPanel");
                        editPopup.setVisible(false);
                        this.menuControl.getOpenOnlineMarket().OpenMenu(player);
                        this.menuControl.refreshStatsUI(player);
                    }
                    catch (NumberFormatException e) {
                        player.sendYellMessage("Invalid price \u2014 use whole numbers!", 3.0f, true);
                    }
                });
            }
            if (eventID == editRemoveButtonID) {
                int itemID = (Integer)player.getAttribute("SelectedItemID");
                String ownerUID = (String)player.getAttribute("SelectedItemOwnerUID");
                String itemName = (String)player.getAttribute("SelectedItemName");
                int itemQuantity = (Integer)player.getAttribute("SelectedItemQuantity");
                if (!PlayerUID.equals(ownerUID) && !player.isAdmin()) {
                    player.sendYellMessage("You can only remove your own items!", 3.0f, true);
                    return;
                }
                try (ResultSet itemResult = OnlineDataBaseAccess1.executeQuery("SELECT * FROM `MarketListings` WHERE ID = " + itemID);){
                    if (itemResult.next()) {
                        Player target;
                        String category = itemResult.getString("ItemCategory");
                        short itemId = itemResult.getShort("ItemID");
                        int variants = itemResult.getInt("ItemVariants");
                        int quantity = itemResult.getInt("ItemQuantity");
                        byte constructionID = itemResult.getByte("ItemID");
                        Player player2 = target = PlayerUID.equals(ownerUID) ? player : Server.getPlayerByUID((String)ownerUID);
                        if (target != null && !ownerUID.equals("SERVER_UID")) {
                            this.returnItemToInventory(target, category, itemId, variants, quantity, constructionID);
                            target.sendYellMessage("Your item " + itemName + " was returned!", 3.0f, true);
                        }
                        OnlineDataBaseAccess2.executeUpdate("DELETE FROM `MarketListings` WHERE ID = " + itemID);
                        player.sendYellMessage("Item removed from market!", 3.0f, true);
                        String sql = "INSERT INTO `MarketTransactions` (PlayerUID, ItemName, QuantitySold, Price, TotalAmount, TransactionType, SellerUID) VALUES ('" + PlayerUID + "', '" + itemName + "', " + itemQuantity + ", 0, 0, 'Removal', '" + ownerUID + "')";
                        OnlineDataBaseAccess1.executeUpdate(sql);
                        UILabel editPopup2 = (UILabel)player.getAttribute("EditItemPopupPanel");
                        editPopup2.setVisible(false);
                        this.menuControl.getOpenOnlineMarket().OpenMenu(player);
                        this.menuControl.refreshStatsUI(player);
                    }
                }
                catch (SQLException e) {
                    player.sendYellMessage("Error removing item or logging transaction: " + e.getMessage(), 3.0f, true);
                    e.printStackTrace();
                }
            }
            if (eventID == editCancelButtonID) {
                editPopup = (UILabel)player.getAttribute("EditItemPopupPanel");
                editPopup.setVisible(false);
                UILabel buyPopup = (UILabel)player.getAttribute("BuyItemPopupPanel");
                buyPopup.setVisible(true);
            }
            if (eventID == editExitButtonID) {
                editPopup = (UILabel)player.getAttribute("EditItemPopupPanel");
                editPopup.setVisible(false);
                this.menuControl.getOpenOnlineMarket().OpenMenu(player);
            }
            if (eventID == editFeatureButtonID) {
                int itemID = (Integer)player.getAttribute("SelectedItemID");
                String ownerUID = (String)player.getAttribute("SelectedItemOwnerUID");
                String itemName = (String)player.getAttribute("SelectedItemName");
                if (!PlayerUID.equals(ownerUID) && !player.isAdmin()) {
                    player.sendYellMessage("You can only bump your own items!", 3.0f, true);
                    return;
                }
                try (ResultSet moneyResult = OnlineDataBaseAccess1.executeQuery("SELECT Money FROM `PlayerMoney` WHERE PlayerUID = '" + PlayerUID + "'");){
                    float playerMoney = moneyResult.next() ? moneyResult.getFloat("Money") : 0.0f;
                    float bumpFee = 1.0f;
                    if (playerMoney >= bumpFee) {
                        try (ResultSet itemResult = OnlineDataBaseAccess1.executeQuery("SELECT * FROM `MarketListings` WHERE ID = " + itemID);){
                            if (!itemResult.next()) break block41;
                            String itemPrice = itemResult.getString("ItemPrice");
                            String itemOwnerName = itemResult.getString("ItemOwnerName");
                            String itemOwnerUID = itemResult.getString("ItemOwnerUID");
                            String itemIDValue = itemResult.getString("ItemID");
                            String itemCategory = itemResult.getString("ItemCategory");
                            int itemVariants = itemResult.getInt("ItemVariants");
                            int itemQuantity = itemResult.getInt("ItemQuantity");
                            int isUnlimited = itemResult.getInt("IsUnlimited");
                            OnlineDataBaseAccess2.executeUpdate("DELETE FROM `MarketListings` WHERE ID = " + itemID);
                            OnlineDataBaseAccess2.executeUpdate("INSERT INTO `MarketListings` (ItemName, ItemPrice, ItemOwnerName, ItemOwnerUID, ItemID, ItemCategory, ItemVariants, ItemQuantity, IsUnlimited) VALUES ('" + itemName + "', '" + itemPrice + "', '" + itemOwnerName + "', '" + itemOwnerUID + "', '" + itemIDValue + "', '" + itemCategory + "', '" + itemVariants + "', '" + itemQuantity + "', '" + isUnlimited + "')");
                            try (ResultSet newIDResult = OnlineDataBaseAccess2.executeQuery("SELECT last_insert_rowid() AS NewID");){
                                newIDResult.next();
                                int newID = newIDResult.getInt("NewID");
                                player.setAttribute("BumpedItemID", (Object)newID);
                            }
                            this.menuControl.updatePlayerMoney(player, -bumpFee);
                            player.sendYellMessage("Item bumped to top for $1!", 3.0f, true);
                            String sql = "INSERT INTO `MarketTransactions` (PlayerUID, ItemName, QuantitySold, Price, TotalAmount, TransactionType, SellerUID) VALUES ('" + PlayerUID + "', '" + itemName + "', 1, " + bumpFee + ", " + bumpFee + ", 'BumpFee', 'SERVER_UID')";
                            OnlineDataBaseAccess1.executeUpdate(sql);
                            this.menuControl.updateWalletDisplay(player);
                            UILabel editPopup3 = (UILabel)player.getAttribute("EditItemPopupPanel");
                            editPopup3.setVisible(false);
                            this.menuControl.getOpenOnlineMarket().OpenMenu(player);
                            this.menuControl.refreshStatsUI(player);
                            break block41;
                        }
                    }
                    player.sendYellMessage("You need $1 to bump this item!", 3.0f, true);
                }
                catch (SQLException e) {
                    player.sendYellMessage("Error bumping item or logging transaction: " + e.getMessage(), 3.0f, true);
                    e.printStackTrace();
                }
            }
        }
    }

    private void returnItemToInventory(Player player, String category, short itemId, int variants, int quantity, byte constructionID) {
        if ("construction".equals(category)) {
            player.getInventory().addConstructionItem(constructionID, variants, quantity, 0);
        } else if ("clothing".equals(category)) {
            player.getInventory().addClothingItem(itemId, variants, quantity, 0, 0L);
        } else if ("objectkit".equals(category)) {
            player.getInventory().addObjectItem(itemId, variants, quantity);
        } else {
            player.getInventory().addItem(itemId, variants, quantity);
        }
    }
}

