/*
 * Decompiled with CFR 0.152.
 */
package onlinemarket;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import net.risingworld.api.Plugin;
import net.risingworld.api.assets.TextureAsset;
import net.risingworld.api.definitions.Definitions;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.ui.UILabel;
import net.risingworld.api.ui.style.ScaleMode;
import net.risingworld.api.ui.style.TextAnchor;
import net.risingworld.api.utils.Vector3f;
import onlinemarket.OnlineMarket;

public class OpenOnlineMarket
extends OnlineMarket {
    public OpenOnlineMarket(Plugin plugin) {
        OpenOnlineMarket.plugin = plugin;
    }

    public void OpenMenu(Player player) {
        block31: {
            String playerName = player.getName();
            String playerUID = player.getUID();
            Vector3f playerPosition = player.getPosition();
            UILabel onlineMarketTextField = (UILabel)player.getAttribute("OnlineMarketTextField");
            ArrayList onlineMarketSelectButtons = (ArrayList)player.getAttribute("OnlineMarketSelectBottons");
            ArrayList onlineMarketSelected = (ArrayList)player.getAttribute("OnlineMarketSelected");
            ArrayList copyOnlineMarketSelected = new ArrayList(onlineMarketSelectButtons);
            player.setMouseCursorVisible(true);
            onlineMarketTextField.setVisible(true);
            for (UILabel selected : copyOnlineMarketSelected) {
                if (selected == null) continue;
                onlineMarketSelectButtons.clear();
                onlineMarketSelected.clear();
                selected.setText("");
                selected.setVisible(false);
            }
            onlineMarketTextField.setText("");
            player.setAttribute("OnlineMarketPageNumber", (Object)1);
            int setRowPosition = 0;
            int row = 0;
            int limit = 8;
            String search = (String)player.getAttribute("Search");
            String searchResult = (String)player.getAttribute("SearchRsult");
            try (ResultSet result = OnlineDataBaseAccess1.executeQuery(search);){
                result.next();
                int dbCount = result.getInt(1);
                int pageMax = (dbCount + limit - 1) / limit;
                int pageNow = 1;
                if (pageNow > pageMax) break block31;
                int start = (pageNow - 1) * limit;
                onlineMarketTextField.setText("  Page " + pageNow + " / " + pageMax + "\n");
                try (ResultSet result2 = OnlineDataBaseAccess2.executeQuery("SELECT * FROM " + searchResult + " ORDER BY ID DESC LIMIT " + start + ", " + limit);){
                    NumberFormat priceFormatter = NumberFormat.getCurrencyInstance(Locale.US);
                    while (result2.next()) {
                        setRowPosition = ++row * 53 + 130;
                        UILabel onlineMarketSelect = new UILabel();
                        onlineMarketSelect.style.textAlign.set((Enum)TextAnchor.MiddleCenter);
                        onlineMarketSelect.setFontColor(9.0f, 9.0f, 9.0f, 1.0f);
                        onlineMarketSelect.setFontSize(12.0f);
                        onlineMarketSelect.setBorder(2.0f);
                        onlineMarketSelect.setBorderColor(999);
                        onlineMarketSelect.style.borderBottomColor.set(0.0f, 0.0f, 0.2f, 0.9f);
                        onlineMarketSelect.setBorderEdgeRadius(5.0f, false);
                        onlineMarketSelect.setSize(250.0f, 50.0f, false);
                        onlineMarketSelect.style.borderBottomWidth.set(5.0f);
                        onlineMarketSelect.setBackgroundColor(0.1f, 0.1f, 0.1f, 0.9f);
                        onlineMarketSelect.setPosition(24.5f, (float)setRowPosition, false);
                        onlineMarketSelect.hoverStyle.backgroundColor.set(0.2f, 0.2f, 0.2f, 0.9f);
                        onlineMarketSelect.hoverStyle.borderBottomWidth.set(5.0f);
                        onlineMarketSelect.hoverStyle.borderBottomColor.set(0.1f, 0.1f, 0.9f, 0.9f);
                        onlineMarketSelect.setClickable(true);
                        String category = result2.getString("ItemCategory");
                        String itemName = result2.getString("ItemName");
                        int variants = result2.getInt("ItemVariants");
                        TextureAsset itemIcon = null;
                        if ("construction".equals(category)) {
                            def = Definitions.getConstructionDefinition((String)itemName);
                            if (def != null) {
                                itemIcon = def.getIcon(variants);
                            }
                        } else if ("clothing".equals(category)) {
                            def = Definitions.getClothingDefinition((String)itemName);
                            if (def != null) {
                                itemIcon = def.getIcon(variants);
                            }
                        } else if ("objectkit".equals(category)) {
                            def = Definitions.getObjectDefinition((String)itemName);
                            if (def != null) {
                                itemIcon = def.getIcon(variants);
                            }
                        } else if ("blueprint".equals(category)) {
                            def = Definitions.getItemDefinition((String)itemName);
                            if (def != null) {
                                itemIcon = def.getIcon(variants);
                            }
                        } else {
                            def = Definitions.getItemDefinition((String)itemName);
                            if (def != null) {
                                itemIcon = def.getIcon(variants);
                            }
                        }
                        if (itemIcon != null) {
                            UILabel iconLabel = new UILabel();
                            iconLabel.setSize(30.0f, 30.0f, false);
                            iconLabel.setPosition(5.0f, 10.0f, false);
                            iconLabel.style.backgroundImage.set(itemIcon);
                            iconLabel.style.backgroundImageScaleMode.set((Enum)ScaleMode.ScaleToFit);
                            onlineMarketSelect.addChild((UIElement)iconLabel);
                        } else {
                            player.sendTextMessage("No icon available for " + itemName + ".");
                        }
                        String formattedPrice = priceFormatter.format(result2.getInt("ItemPrice"));
                        onlineMarketSelect.setText("<b>" + result2.getString("ItemName") + "</b>\n" + formattedPrice + " Quantity= " + result2.getInt("ItemQuantity"));
                        onlineMarketTextField.addChild((UIElement)onlineMarketSelect);
                        onlineMarketSelectButtons.add(onlineMarketSelect);
                        onlineMarketSelected.add(onlineMarketSelect.getID() + "," + result2.getInt("ID"));
                    }
                }
            }
            catch (SQLException e) {
                player.sendTextMessage("Database error loading market: " + e.getMessage());
            }
        }
    }
}

