/*
 * Decompiled with CFR 0.152.
 */
package es.composit.radio;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.risingworld.api.Plugin;
import net.risingworld.api.assets.SoundAsset;
import net.risingworld.api.assets.TextureAsset;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.sounds.Sound;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.ui.UILabel;
import net.risingworld.api.ui.style.Pivot;

public class RadioUI
extends UIElement {
    private Player player;
    private Plugin plugin;
    private List<String> playlist = new ArrayList<String>();
    private int musicIndex = 0;
    private Sound sound;
    private String songName = "";
    private String musicDir = ".";
    private UILabel songLabel;
    private UILabel indexLabel;
    private TextureAsset radioBG;

    public RadioUI(Plugin plugin, String string) {
        this.plugin = plugin;
        this.musicDir = string;
        System.out.println("Music directory: " + plugin.getPath() + string);
    }

    public void init(Player player) {
        System.out.println("Init radio for player: " + player.getName());
        this.player = player;
        File file = new File(this.plugin.getPath() + this.musicDir);
        UILabel uILabel = file.listFiles();
        Arrays.sort(uILabel, Comparator.comparing(File::getName));
        for (File file2 : uILabel) {
            if (!file2.isFile() || !file2.getName().endsWith(".ogg") && !file2.getName().endsWith(".mp3")) continue;
            this.playlist.add(file2.getName());
        }
        this.setPosition(50.0f, 84.0f, true);
        this.setSize(24.0f, 10.0f, true);
        this.setPivot(Pivot.MiddleCenter);
        this.style.backgroundImage.set(TextureAsset.loadFromFile((String)(this.plugin.getPath() + "/radio.jpg")));
        this.style.backgroundImageTintColor.set(1.0f, 1.0f, 1.0f, 0.8f);
        this.setBackgroundColor(0.2f, 0.2f, 0.2f, 0.8f);
        this.setBorder(4.0f);
        this.setBorderColor(0.0f, 0.0f, 0.0f, 0.9f);
        this.setBorderEdgeRadius(5.0f, false);
        UILabel uILabel2 = new UILabel("Radio " + player.getName());
        uILabel2.setPosition(50.0f, 25.0f, true);
        uILabel2.setFontSize(45.0f);
        uILabel2.setPivot(Pivot.MiddleCenter);
        this.addChild((UIElement)uILabel2);
        this.songLabel = new UILabel(this.songName);
        this.songLabel.setPosition(50.0f, 80.0f, true);
        this.songLabel.setFontSize(20.0f);
        this.songLabel.setPivot(Pivot.MiddleCenter);
        this.addChild((UIElement)this.songLabel);
        this.indexLabel = new UILabel("-/" + String.valueOf(this.playlist.size()));
        this.indexLabel.setPosition(6.0f, 80.0f, true);
        this.indexLabel.setFontSize(20.0f);
        this.indexLabel.setPivot(Pivot.MiddleCenter);
        this.addChild((UIElement)this.indexLabel);
    }

    public void onClick(PlayerCommandEvent playerCommandEvent) {
        this.player.sendTextMessage("You've clicked on a radio !");
    }

    public void list() {
        this.player.sendTextMessage("Playlist: ");
        for (String string : this.playlist) {
            this.player.sendTextMessage("-> " + string);
        }
    }

    public void play() {
        this.player.disableGameMusic();
        if (this.sound != null) {
            this.sound.stop(true);
        } else {
            this.player.playSound(SoundAsset.loadFromPlugin((Plugin)this.plugin, (String)"/resources/radio.ogg"));
        }
        this.songLabel.setText(this.playlist.get(this.musicIndex));
        this.indexLabel.setText(String.valueOf(this.musicIndex + 1) + "/" + String.valueOf(this.playlist.size()));
        this.sound = this.player.playSound(SoundAsset.loadFromFile((String)(this.plugin.getPath() + this.musicDir + "/" + this.playlist.get(this.musicIndex)), (boolean)true));
    }

    public void next() {
        this.musicIndex = this.musicIndex < this.playlist.size() - 1 ? ++this.musicIndex : 0;
        this.play();
    }

    public void previous() {
        this.musicIndex = this.musicIndex > 0 ? --this.musicIndex : this.playlist.size();
        this.play();
    }

    public void tune(String string) {
        this.player.disableGameMusic();
        if (this.sound != null) {
            this.sound.stop(true);
        } else {
            this.player.playSound(SoundAsset.loadFromPlugin((Plugin)this.plugin, (String)"/resources/radio2.ogg"));
        }
        File file = new File(this.plugin.getPath() + this.musicDir + "/" + string);
        if (file.exists()) {
            this.sound = this.player.playSound(SoundAsset.loadFromFile((String)(this.plugin.getPath() + this.musicDir + "/" + string)));
            this.songName = string;
            this.songLabel.setText(string);
            this.player.sendTextMessage("<color=green>Tunned.</color>");
        } else {
            this.player.sendTextMessage("<color=red>Radio '" + string + "' not found.</color>");
        }
    }

    public void stop() {
        if (this.sound != null) {
            this.sound.stop(false);
        }
        this.player.enableGameMusic();
    }

    public void untune() {
        this.stop();
        this.player.removeUIElement((UIElement)this);
    }
}

