/*
 * Decompiled with CFR 0.152.
 */
package es.composit.radio;

import es.composit.radio.RadioUI;
import net.risingworld.api.Plugin;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.utils.Key;

public class Radio
extends Plugin
implements Listener {
    public RadioUI UIRadio = new RadioUI(this, "/../../../../music/Rising World Soundtrack");
    private boolean isVisible = false;

    public void onEnable() {
        this.registerEventListener(this);
        System.out.println("Enabled " + this.getName() + " plugin");
    }

    public void onDisable() {
        System.out.println("Disabled " + this.getName() + " plugin");
    }

    @EventMethod
    public void onPlayerSpawn(PlayerSpawnEvent playerSpawnEvent) {
        Player player = playerSpawnEvent.getPlayer();
        player.registerKeys(new Key[]{Key.R, Key.NumpadMultiply, Key.NumpadDivide});
        player.setListenForKeyInput(true);
        this.UIRadio.init(player);
    }

    @EventMethod
    public void onKeyInput(PlayerKeyEvent playerKeyEvent) {
        Player player = playerKeyEvent.getPlayer();
        if (playerKeyEvent.isPressed()) {
            if (playerKeyEvent.getKey() == Key.R) {
                if (!this.isVisible) {
                    player.addUIElement((UIElement)this.UIRadio);
                    this.isVisible = true;
                } else {
                    this.UIRadio.untune();
                    this.isVisible = false;
                }
            } else if (playerKeyEvent.getKey() == Key.NumpadMultiply) {
                this.UIRadio.next();
            } else if (playerKeyEvent.getKey() == Key.NumpadDivide) {
                this.UIRadio.previous();
            }
        }
    }

    @EventMethod
    public void onPlayerCommandEvent(PlayerCommandEvent playerCommandEvent) {
        Player player = playerCommandEvent.getPlayer();
        String string = playerCommandEvent.getCommand();
        String[] stringArray = string.split(" ");
        if (stringArray[0].equals("/radio")) {
            if (stringArray.length > 1) {
                String string2 = string.substring(7);
                player.sendTextMessage("Radio " + player.getName() + ": <color=green>" + string2 + "</color>");
                switch (string2) {
                    case "on": {
                        player.addUIElement((UIElement)this.UIRadio);
                        break;
                    }
                    case "off": {
                        this.UIRadio.untune();
                        break;
                    }
                    case "list": {
                        this.UIRadio.list();
                        break;
                    }
                    case "play": {
                        this.UIRadio.play();
                        break;
                    }
                    case "stop": {
                        this.UIRadio.stop();
                        break;
                    }
                    case "next": {
                        this.UIRadio.next();
                        break;
                    }
                    case "previous": {
                        this.UIRadio.previous();
                        break;
                    }
                    default: {
                        this.UIRadio.tune(string2);
                        break;
                    }
                }
            } else {
                player.sendTextMessage("<color=red>You have to provide a file name</color>");
                player.sendTextMessage("USAGE /radio on/off/list/play/stop/next/previous or a file name");
            }
        }
    }
}

