/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.ui;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import net.jiw.unity.runtime.PluginUIManager;
import net.jiw.unity.runtime.utils.InternalUtils;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector2f;

public class UIPainter2D
extends UIElement {
    private static final int TYPE = 3;
    ArrayList<byte[]> commands = new ArrayList();
    int size = 0;

    public void arc(Vector2f center, float radius, int startAngle, int endAngle, ArcDirection direction) {
        ByteBuffer buffer = ByteBuffer.allocate(22);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)1);
        InternalUtils.ByteBufferUtils.putVector2f((ByteBuffer)buffer, (Vector2f)center);
        buffer.putFloat(radius);
        buffer.putInt(startAngle);
        buffer.putInt(endAngle);
        buffer.put((byte)direction.ordinal());
        this.size += buffer.capacity();
        this.commands.add(buffer.array());
    }

    public void arcTo(Vector2f p1, Vector2f p2, float radius) {
        ByteBuffer buffer = ByteBuffer.allocate(21);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)2);
        InternalUtils.ByteBufferUtils.putVector2f((ByteBuffer)buffer, (Vector2f)p1);
        InternalUtils.ByteBufferUtils.putVector2f((ByteBuffer)buffer, (Vector2f)p2);
        buffer.putFloat(radius);
        this.size += buffer.capacity();
        this.commands.add(buffer.array());
    }

    public void bezierCurveTo(Vector2f p1, Vector2f p2, Vector2f p3) {
        ByteBuffer buffer = ByteBuffer.allocate(25);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)3);
        InternalUtils.ByteBufferUtils.putVector2f((ByteBuffer)buffer, (Vector2f)p1);
        InternalUtils.ByteBufferUtils.putVector2f((ByteBuffer)buffer, (Vector2f)p2);
        InternalUtils.ByteBufferUtils.putVector2f((ByteBuffer)buffer, (Vector2f)p3);
        this.size += buffer.capacity();
        this.commands.add(buffer.array());
    }

    public void beginPath() {
        ByteBuffer buffer = ByteBuffer.allocate(1);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)4);
        this.size += buffer.capacity();
        this.commands.add(buffer.array());
    }

    public void closePath() {
        ByteBuffer buffer = ByteBuffer.allocate(1);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)5);
        this.size += buffer.capacity();
        this.commands.add(buffer.array());
    }

    public void fill(FillRule fillRule) {
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)6);
        buffer.put((byte)fillRule.ordinal());
        this.size += buffer.capacity();
        this.commands.add(buffer.array());
    }

    public void lineTo(Vector2f pos) {
        ByteBuffer buffer = ByteBuffer.allocate(9);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)7);
        InternalUtils.ByteBufferUtils.putVector2f((ByteBuffer)buffer, (Vector2f)pos);
        this.size += buffer.capacity();
        this.commands.add(buffer.array());
    }

    public void moveTo(Vector2f pos) {
        ByteBuffer buffer = ByteBuffer.allocate(9);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)8);
        InternalUtils.ByteBufferUtils.putVector2f((ByteBuffer)buffer, (Vector2f)pos);
        this.size += buffer.capacity();
        this.commands.add(buffer.array());
    }

    public void quadraticCurveTo(Vector2f p1, Vector2f p2) {
        ByteBuffer buffer = ByteBuffer.allocate(17);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)9);
        InternalUtils.ByteBufferUtils.putVector2f((ByteBuffer)buffer, (Vector2f)p1);
        InternalUtils.ByteBufferUtils.putVector2f((ByteBuffer)buffer, (Vector2f)p2);
        this.size += buffer.capacity();
        this.commands.add(buffer.array());
    }

    public void stroke() {
        ByteBuffer buffer = ByteBuffer.allocate(1);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)10);
        this.size += buffer.capacity();
        this.commands.add(buffer.array());
    }

    public void setFillColor(float r, float g, float b, float a) {
        ByteBuffer buffer = ByteBuffer.allocate(5);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)11);
        buffer.putInt(Utils.GeneralUtils.colorRGBAToInt(r, g, b, a));
        this.size += buffer.capacity();
        this.commands.add(buffer.array());
    }

    public void setLineCap(LineCap lineCap) {
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)12);
        buffer.put((byte)lineCap.ordinal());
        this.size += buffer.capacity();
        this.commands.add(buffer.array());
    }

    public void setLineJoin(LineJoin lineJoin) {
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)13);
        buffer.put((byte)lineJoin.ordinal());
        this.size += buffer.capacity();
        this.commands.add(buffer.array());
    }

    public void setLineWith(float lineWidth) {
        ByteBuffer buffer = ByteBuffer.allocate(5);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)14);
        buffer.putFloat(lineWidth);
        this.size += buffer.capacity();
        this.commands.add(buffer.array());
    }

    public void setMiterLimit(float miterLimit) {
        ByteBuffer buffer = ByteBuffer.allocate(5);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)15);
        buffer.putFloat(miterLimit);
        this.size += buffer.capacity();
        this.commands.add(buffer.array());
    }

    public void setStrokeColor(float r, float g, float b, float a) {
        ByteBuffer buffer = ByteBuffer.allocate(5);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)16);
        buffer.putInt(Utils.GeneralUtils.colorRGBAToInt(r, g, b, a));
        this.size += buffer.capacity();
        this.commands.add(buffer.array());
    }

    private void setStrokeGradient(int[] colors, float[] alphas) {
        if (colors.length != alphas.length) {
            throw new IllegalArgumentException();
        }
        ByteBuffer buffer = ByteBuffer.allocate(5 + colors.length * 4 + alphas.length * 4);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)17);
        buffer.putInt(colors.length);
        int len = colors.length;
        for (int i = 0; i < len; ++i) {
            buffer.putInt(colors[i]);
            buffer.putFloat(alphas[i]);
        }
        this.size += buffer.capacity();
        this.commands.add(buffer.array());
    }

    public void clear() {
        this.size = 0;
        this.commands.clear();
    }

    public void update() {
        this.updatePainter();
    }

    private byte[] serialize() {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(this.size + 4);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(this.commands.size());
            for (byte[] command : this.commands) {
                buffer.put(command);
            }
            byte[] array = new byte[buffer.position()];
            buffer.flip();
            buffer.get(array);
            return array;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    int getType() {
        return 3;
    }

    private void updatePainter() {
        PluginUIManager.updateUIPainter2D((UIPainter2D)this, (int)this.id);
    }

    public static enum ArcDirection {
        Clockwise,
        CounterClockwise;

    }

    public static enum FillRule {
        NonZero,
        OddEven;

    }

    public static enum LineCap {
        Butt,
        Round;

    }

    public static enum LineJoin {
        Miter,
        Bevel,
        Round;

    }
}

