/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.objects;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.utils.Vector3i;

public final class Area {
    private long handle;
    private ConcurrentHashMap<String, Object> attributes = null;
    public static final Area INFINITE = null;

    private Area(long globalID) {
        this.handle = globalID;
    }

    public Area() {
        this(Vector3f.ZERO, Vector3f.ZERO);
    }

    public Area(Area area) {
        if (area == null) {
            throw new NullPointerException("Area parameter must not be null!");
        }
        this.handle = Area.createAreaFromOther(area.handle);
    }

    private static native long createAreaFromOther(long var0);

    public Area(Vector3f startPosition, Vector3f endPosition) {
        if (startPosition == null || endPosition == null) {
            throw new NullPointerException("Start or end position of an area must not be null!");
        }
        this.handle = Area.createArea(startPosition.x, startPosition.y, startPosition.z, endPosition.x, endPosition.y, endPosition.z);
    }

    private static native long createArea(float var0, float var1, float var2, float var3, float var4, float var5);

    public long getID() {
        return this.handle;
    }

    public boolean isValid() {
        return this.handle != 0L && this.isValid(this.handle);
    }

    private native boolean isValid(long var1);

    public void setPlayerPermission(Player player, String areaPermission) {
        if (player == null) {
            return;
        }
        this.setPlayerPermission(this.handle, player.getDbID(), areaPermission);
    }

    public void setPlayerPermission(int playerDbID, String areaPermission) {
        this.setPlayerPermission(this.handle, playerDbID, areaPermission);
    }

    private native void setPlayerPermission(long var1, int var3, String var4);

    public void removePlayerPermission(Player player) {
        if (player == null) {
            return;
        }
        this.removePlayerPermission(this.handle, player.getDbID());
    }

    public void removePlayerPermission(int playerDbID) {
        this.removePlayerPermission(this.handle, playerDbID);
    }

    private native void removePlayerPermission(long var1, int var3);

    public String getPlayerPermission(Player player) {
        if (player == null) {
            return null;
        }
        return this.getPlayerPermission(this.handle, player.getDbID());
    }

    public String getPlayerPermission(int playerDbID) {
        return this.getPlayerPermission(this.handle, playerDbID);
    }

    private native String getPlayerPermission(long var1, int var3);

    public Map<Integer, String> getAllPlayerPermissions() {
        return this.getAllPlayerPermissions(this.handle);
    }

    private native HashMap getAllPlayerPermissions(long var1);

    public String getDefaultPermission() {
        return this.getDefaultPermission(this.handle);
    }

    private native String getDefaultPermission(long var1);

    public void setDefaultPermission(String areaPermission) {
        this.setDefaultPermission(this.handle, areaPermission);
    }

    private native void setDefaultPermission(long var1, String var3);

    public int getPriority() {
        return this.getPriority(this.handle);
    }

    private native int getPriority(long var1);

    public void setPriority(int priority) {
        this.setPriority(this.handle, priority);
    }

    private native void setPriority(long var1, int var3);

    public String getName() {
        return this.getName(this.handle);
    }

    private native String getName(long var1);

    public void setName(String name) {
        this.setName(this.handle, name);
    }

    private native void setName(long var1, String var3);

    public boolean isNameVisible() {
        return this.isNameVisible(this.handle);
    }

    private native boolean isNameVisible(long var1);

    public void setNameVisible(boolean set) {
        this.setNameVisible(this.handle, set);
    }

    private native void setNameVisible(long var1, boolean var3);

    public Vector3f getStartPosition() {
        return this.getStartPosition(this.handle);
    }

    private native Vector3f getStartPosition(long var1);

    public Vector3f getEndPosition() {
        return this.getEndPosition(this.handle);
    }

    private native Vector3f getEndPosition(long var1);

    public Vector3i getStartChunkPosition() {
        Vector3f pos = this.getStartPosition(this.handle);
        return Utils.ChunkUtils.getChunkPosition(pos);
    }

    public Vector3i getStartBlockPosition() {
        Vector3f pos = this.getStartPosition(this.handle);
        Vector3i blockPos = new Vector3i();
        blockPos.x = Utils.ChunkUtils.getBlockPositionX(pos.x, Utils.ChunkUtils.getChunkPositionX(pos.x));
        blockPos.y = Utils.ChunkUtils.getBlockPositionY(pos.y, Utils.ChunkUtils.getChunkPositionY(pos.y));
        blockPos.z = Utils.ChunkUtils.getBlockPositionZ(pos.z, Utils.ChunkUtils.getChunkPositionZ(pos.z));
        return blockPos;
    }

    public Vector3i getEndChunkPosition() {
        Vector3f pos = this.getEndPosition(this.handle);
        return Utils.ChunkUtils.getChunkPosition(pos);
    }

    public Vector3i getEndBlockPosition() {
        Vector3f pos = this.getStartPosition(this.handle);
        Vector3i blockPos = new Vector3i();
        blockPos.x = Utils.ChunkUtils.getBlockPositionX(pos.x, Utils.ChunkUtils.getChunkPositionX(pos.x));
        blockPos.y = Utils.ChunkUtils.getBlockPositionY(pos.y, Utils.ChunkUtils.getChunkPositionY(pos.y));
        blockPos.z = Utils.ChunkUtils.getBlockPositionZ(pos.z, Utils.ChunkUtils.getChunkPositionZ(pos.z));
        return blockPos;
    }

    public void setStartPosition(Vector3f startPosition) {
        if (this.handle == Area.INFINITE.handle) {
            throw new IllegalAccessError("It's not allowed to modify an immutable object!");
        }
        this.setStartPosition(this.handle, startPosition);
    }

    private native void setStartPosition(long var1, Vector3f var3);

    public void setEndPosition(Vector3f endPosition) {
        if (this.handle == Area.INFINITE.handle) {
            throw new IllegalAccessError("It's not allowed to modify an immutable object!");
        }
        this.setEndPosition(this.handle, endPosition);
    }

    private native void setEndPosition(long var1, Vector3f var3);

    public void set(Vector3f startPosition, Vector3f endPosition) {
        if (this.handle == Area.INFINITE.handle) {
            throw new IllegalAccessError("It's not allowed to modify an immutable object!");
        }
        this.set(this.handle, startPosition, endPosition);
    }

    private native void set(long var1, Vector3f var3, Vector3f var4);

    public Vector3f getSize() {
        return this.getSize(this.handle);
    }

    private native Vector3f getSize(long var1);

    public boolean rearrange() {
        if (this.handle == Area.INFINITE.handle) {
            throw new IllegalAccessError("It's not allowed to modify an immutable object!");
        }
        return this.rearrange(this.handle);
    }

    private native boolean rearrange(long var1);

    public boolean isPointInArea(Vector3f point) {
        if (point == null) {
            return false;
        }
        return this.isPointInArea(point.x, point.y, point.z);
    }

    public boolean isPointInArea(float x, float y, float z) {
        return this.isPointInArea(this.handle, x, y, z);
    }

    private native boolean isPointInArea(long var1, float var3, float var4, float var5);

    public boolean intersects(Area area) {
        if (area == null) {
            return false;
        }
        return this.intersects(this.handle, area.handle);
    }

    private native boolean intersects(long var1, long var3);

    public void destroy() {
        if (this.handle == Area.INFINITE.handle) {
            throw new IllegalAccessError("It's not allowed to destroy an immutable object!");
        }
        this.destroyArea(this.handle);
        this.attributes.clear();
        this.handle = 0L;
    }

    private native void destroyArea(long var1);

    public void setAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new ConcurrentHashMap(10, 0.9f, 1);
        }
        if (value == null) {
            this.deleteAttribute(key);
        } else {
            this.attributes.put(key, value);
        }
    }

    public Object getAttribute(String key) {
        if (this.attributes == null || key == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    public boolean hasAttribute(String key) {
        return this.attributes != null && key != null && this.attributes.containsKey(key);
    }

    public void deleteAttribute(String key) {
        if (this.attributes != null && key != null) {
            this.attributes.remove(key);
        }
    }

    public String toString() {
        return "(ID: " + this.handle + ", " + String.valueOf(this.getStartPosition()) + ", " + String.valueOf(this.getEndPosition()) + ")";
    }

    public boolean equals(Object o) {
        if (o instanceof Area) {
            Area area = (Area)o;
            return this.handle == area.handle;
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + (int)(this.handle ^ this.handle >>> 32);
        return hash;
    }
}

