/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.worldelements;

import net.risingworld.api.utils.Vector3f;

abstract class _Interaction {
    private _Interaction() {
    }

    public abstract Type getType();

    public abstract int getData(int var1);

    public abstract int getData();

    public static _Interaction createChairPreset(Vector3f sittingPosition) {
        return new ChairPreset(sittingPosition);
    }

    public static class ChairPreset
    extends _Interaction {
        private Vector3f sittingPosition;

        private ChairPreset(Vector3f sittingPosition) {
            this.sittingPosition = sittingPosition;
        }

        public Vector3f getSittingPosition() {
            return this.sittingPosition;
        }

        @Override
        public Type getType() {
            return Type.Chair;
        }

        @Override
        public int getData() {
            return this.sittingPosition == null ? 0 : 3;
        }

        @Override
        public int getData(int data) {
            if (data == 0) {
                return Float.floatToIntBits(this.sittingPosition.x);
            }
            if (data == 1) {
                return Float.floatToIntBits(this.sittingPosition.y);
            }
            if (data == 2) {
                return Float.floatToIntBits(this.sittingPosition.z);
            }
            throw new IllegalStateException("Illegal data access " + data);
        }
    }

    public static class ChestPreset
    extends _Interaction {
        private int slots;
        private boolean isTransient = false;

        private ChestPreset(int slots) {
            this.slots = slots;
        }

        public int getSlots() {
            return this.slots;
        }

        @Override
        public Type getType() {
            return Type.Chest;
        }

        @Override
        public int getData() {
            return 2;
        }

        @Override
        public int getData(int data) {
            if (data == 0) {
                return this.slots;
            }
            if (data == 1) {
                return this.isTransient ? 1 : 0;
            }
            throw new IllegalStateException("Illegal data access " + data);
        }
    }

    public static class TentPreset
    extends _Interaction {
        private Vector3f layingPosition;

        private TentPreset(Vector3f layingPosition) {
            this.layingPosition = layingPosition;
        }

        public Vector3f getLayingPosition() {
            return this.layingPosition;
        }

        @Override
        public Type getType() {
            return Type.Tent;
        }

        @Override
        public int getData() {
            return this.layingPosition == null ? 0 : 3;
        }

        @Override
        public int getData(int data) {
            if (data == 0) {
                return Float.floatToIntBits(this.layingPosition.x);
            }
            if (data == 1) {
                return Float.floatToIntBits(this.layingPosition.y);
            }
            if (data == 2) {
                return Float.floatToIntBits(this.layingPosition.z);
            }
            throw new IllegalStateException("Illegal data access " + data);
        }
    }

    public static class BedPreset
    extends _Interaction {
        private Vector3f lyingPosition;

        private BedPreset(Vector3f lyingPosition) {
            this.lyingPosition = lyingPosition;
        }

        public Vector3f getLyingPosition() {
            return this.lyingPosition;
        }

        @Override
        public Type getType() {
            return Type.Bed;
        }

        @Override
        public int getData() {
            return this.lyingPosition == null ? 0 : 3;
        }

        @Override
        public int getData(int data) {
            if (data == 0) {
                return Float.floatToIntBits(this.lyingPosition.x);
            }
            if (data == 1) {
                return Float.floatToIntBits(this.lyingPosition.y);
            }
            if (data == 2) {
                return Float.floatToIntBits(this.lyingPosition.z);
            }
            throw new IllegalStateException("Illegal data access " + data);
        }
    }

    public static enum Type {
        Chair,
        Bed,
        Tent,
        Chest;

    }
}

